/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pdf;

import com.itextpdf.kernel.pdf.PdfAConformanceLevel;
import com.itextpdf.kernel.pdf.PdfDate;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfDocumentInfo;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfOutputIntent;
import com.itextpdf.kernel.pdf.PdfReader;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.kernel.pdf.PdfViewerPreferences;
import com.itextpdf.kernel.pdf.PdfWriter;
import com.itextpdf.kernel.pdf.WriterProperties;
import com.itextpdf.kernel.pdf.filespec.PdfFileSpec;
import com.itextpdf.kernel.utils.PdfMerger;
import com.itextpdf.pdfa.PdfADocument;
import io.konik.harness.AppendParameter;
import io.konik.harness.FileAppender;
import io.konik.harness.exception.InvoiceAppendError;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Locale;
import javax.inject.Named;
import javax.inject.Singleton;
import org.compiere.Adempiere;
import org.compiere.util.Language;

@Named
@Singleton
public class IText7Document
implements FileAppender {
    private static final String ICC_URL = "images/sRGBColorSpaceProfile.icm";
    private static final String DEFAULT_TITLE = "PDF/A-3 by klst.com";
    private boolean debugMode = false;

    public static void mergePdf(List<File> pdfList, File outFile) throws IOException, FileNotFoundException {
        try {
            PdfWriter writer = new PdfWriter(outFile);
            PdfDocument pdftarget = new PdfDocument(writer);
            PdfMerger merger = new PdfMerger(pdftarget);
            for (File f : pdfList) {
                PdfReader reader = new PdfReader(f);
                PdfDocument pdforigin = new PdfDocument(reader);
                int fromPage = 1;
                merger.merge(pdforigin, fromPage, pdforigin.getNumberOfPages());
                pdforigin.close();
            }
            pdftarget.close();
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
    }

    public void setDebugMode(boolean debugMode) {
        this.debugMode = debugMode;
    }

    private PdfADocument merge7(OutputStream result, InputStream origin, String title) throws IOException {
        WriterProperties props = new WriterProperties();
        if (this.debugMode) {
            props.useDebugMode();
        }
        PdfWriter writer = new PdfWriter(result, props);
        PdfOutputIntent intent = new PdfOutputIntent("Custom", "", "http://www.color.org", "sRGB IEC61966-2.1", Adempiere.class.getResource(ICC_URL).openStream());
        PdfADocument pdf = new PdfADocument(writer, PdfAConformanceLevel.PDF_A_3B, intent);
        pdf.setTagged();
        Locale locale = Language.getLoginLanguage().getLocale();
        pdf.getCatalog().setLang(new PdfString(locale.toString()));
        pdf.getCatalog().setViewerPreferences(new PdfViewerPreferences().setDisplayDocTitle(true));
        PdfDocumentInfo info = pdf.getDocumentInfo();
        info.setTitle(title);
        PdfMerger merger = new PdfMerger((PdfDocument)pdf);
        PdfDocument pdforigin = new PdfDocument(new PdfReader(origin));
        int fromPage = 1;
        merger.merge(pdforigin, fromPage, pdforigin.getNumberOfPages());
        pdforigin.close();
        return pdf;
    }

    public void merge(OutputStream result, InputStream origin, String title) {
        try {
            PdfADocument pdf = this.merge7(result, origin, title == null ? DEFAULT_TITLE : title);
            pdf.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void appendInvoiceIntern(AppendParameter appendable, String description, String fileName, PdfName mimeType, PdfName aFRelationship) throws IOException {
        byte[] attachmentFile = IText7Document.convertToByteArray(appendable.attachmentFile());
        PdfADocument pdf = this.merge7(appendable.resultingPdf(), appendable.inputPdf(), DEFAULT_TITLE);
        PdfDictionary parameters = new PdfDictionary();
        parameters.put(PdfName.ModDate, new PdfDate().getPdfObject());
        PdfFileSpec fileSpec = PdfFileSpec.createEmbeddedFileSpec((PdfDocument)pdf, (byte[])attachmentFile, (String)description, (String)fileName, (PdfName)mimeType, (PdfDictionary)parameters, (PdfName)aFRelationship);
        pdf.addAssociatedFile(description, fileSpec);
        pdf.close();
    }

    private void appendInvoiceIntern(AppendParameter appendable, String description, String fileName) throws IOException {
        this.appendInvoiceIntern(appendable, description, fileName, null, null);
    }

    private static byte[] convertToByteArray(InputStream is) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[65536];
        try {
            int length;
            while ((length = is.read(buffer)) != -1) {
                baos.write(buffer, 0, length);
            }
            is.close();
            baos.close();
        }
        catch (IOException e) {
            throw new InvoiceAppendError("Was not possible to read Invoice Content stream", (Throwable)e);
        }
        return baos.toByteArray();
    }

    public void appendXml(AppendParameter appendable, String description, String fileName, PdfName mimeType, PdfName aFRelationship) {
        try {
            this.appendInvoiceIntern(appendable, description, fileName, PdfName.ApplicationXml, new PdfName("Data"));
        }
        catch (IOException e) {
            throw new InvoiceAppendError("PDF IO Error", (Throwable)e);
        }
    }

    public void append(AppendParameter appendable) {
        try {
            this.appendInvoiceIntern(appendable, appendable.zugferdVersion(), appendable.zugferdConformanceLevel());
        }
        catch (IOException e) {
            throw new InvoiceAppendError("PDF IO Error", (Throwable)e);
        }
    }

    public int getPriority() {
        return 0;
    }
}

