/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.model;

import java.sql.ResultSet;
import java.util.Properties;
import org.adempiere.model.MViewDefinition;
import org.adempiere.model.X_AD_View_Column;
import org.compiere.model.MColumn;
import org.compiere.model.Query;
import org.compiere.util.CCache;
import org.compiere.util.DB;

public class MViewColumn
extends X_AD_View_Column {
    private static final long serialVersionUID = 1829379740863651306L;
    private MColumn m_column = null;
    private static CCache<Integer, MViewColumn> viewColumnCacheIds = new CCache("AD_View_Column", 30);

    public static MViewColumn get(MViewDefinition viewDefinition, MColumn column) {
        String whereClause = "AD_View_Definition_ID=? AND AD_Column_ID=?";
        return (MViewColumn)new Query(column.getCtx(), "AD_View_Column", whereClause, column.get_TrxName()).setOnlyActiveRecords(true).setParameters(viewDefinition.getAD_View_Definition_ID(), column.getAD_Column_ID()).first();
    }

    public MViewColumn(Properties ctx, int AD_ViewColumn_ID, String trxName) {
        super(ctx, AD_ViewColumn_ID, trxName);
        if (AD_ViewColumn_ID == 0) {
            // empty if block
        }
    }

    public MViewColumn(Properties ctx, int AD_ViewColumn_ID) {
        this(ctx, AD_ViewColumn_ID, null);
    }

    public MViewColumn(MColumn column) {
        super(column.getCtx(), 0, column.get_TrxName());
        this.setAD_Column_ID(column.getAD_Column_ID());
        this.setName(column.getName());
        this.setDescription(column.getDescription());
        this.setHelp(column.getHelp());
        this.setIsActive(true);
        this.setEntityType(column.getEntityType());
    }

    public MViewColumn(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MViewColumn[").append(this.get_ID()).append("-").append(this.getName()).append("]");
        return sb.toString();
    }

    @Override
    public MColumn getAD_Column() {
        if (this.m_column == null) {
            this.m_column = new MColumn(this.getCtx(), this.getAD_Column_ID(), this.get_TrxName());
        }
        return this.m_column;
    }

    public boolean isKey() {
        return this.getAD_Column().isKey();
    }

    public boolean isIdentifier() {
        return this.getAD_Column().isIdentifier();
    }

    public int getAD_Element_ID() {
        MColumn column = this.getAD_Column();
        if (column != null) {
            return column.getAD_Element_ID();
        }
        return 0;
    }

    public int getAD_Reference_ID() {
        return this.getAD_Column().getAD_Reference_ID();
    }

    @Override
    protected boolean beforeDelete() {
        DB.executeUpdate("DELETE FROM AD_View_Column_Trl WHERE AD_View_Column_ID=? ", this.getAD_View_Column_ID(), this.get_TrxName());
        return true;
    }

    public static MViewColumn getById(Properties ctx, int viewColumnId, String trxName) {
        if (viewColumnId <= 0) {
            return null;
        }
        MViewColumn viewColumn = viewColumnCacheIds.get(viewColumnId);
        if (viewColumn != null && viewColumn.get_ID() > 0) {
            return viewColumn;
        }
        viewColumn = (MViewColumn)new Query(ctx, "AD_View_Column", "AD_View_Column_ID=?", trxName).setParameters(viewColumnId).first();
        if (viewColumn != null && viewColumn.get_ID() > 0) {
            viewColumnCacheIds.put(viewColumn.get_ID(), viewColumn);
        }
        return viewColumn;
    }
}

