/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.model;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.math.BigDecimal;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.model.InterfaceWrapperHelper;
import org.adempiere.model.POWrapper;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Util;

public class GridTabWrapper
implements InvocationHandler {
    private static final CLogger log = CLogger.getCLogger(GridTabWrapper.class);
    private final GridTab m_gridTab;
    private boolean failOnColumnNotFound = false;

    public static <T> T create(Object model, Class<T> cl) {
        if (model == null) {
            return null;
        }
        GridTab gridTab = null;
        if (model instanceof GridTab) {
            gridTab = (GridTab)model;
        }
        if (gridTab == null) {
            gridTab = GridTabWrapper.getGridTab(model);
        }
        if (gridTab == null) {
            throw new AdempiereException("Cannot wrap " + model + " (class:" + model.getClass());
        }
        String interfaceTableName = InterfaceWrapperHelper.getTableNameOrNull(cl);
        if (interfaceTableName != null && !interfaceTableName.equals(gridTab.getTableName())) {
            throw new AdempiereException("Interface " + cl + " (tableName=" + interfaceTableName + ") is not compatible with " + gridTab + " (tableName=" + gridTab.getTableName() + ")");
        }
        Object result = Proxy.newProxyInstance(cl.getClassLoader(), new Class[]{cl}, (InvocationHandler)new GridTabWrapper(gridTab));
        return (T)result;
    }

    public static GridTab getGridTab(Object model) {
        InvocationHandler ih;
        if (model == null) {
            return null;
        }
        if (model instanceof GridTab) {
            return (GridTab)model;
        }
        if (Proxy.isProxyClass(model.getClass()) && (ih = Proxy.getInvocationHandler(model)) instanceof GridTabWrapper) {
            GridTabWrapper wrapper = (GridTabWrapper)ih;
            return wrapper.getGridTab();
        }
        return null;
    }

    public static void refresh(Object model) {
        GridTab gridTab = GridTabWrapper.getGridTab(model);
        if (gridTab != null) {
            gridTab.dataRefresh();
        } else {
            log.fine("Wrapped object is not a GridTab [SKIP]");
        }
    }

    private GridTabWrapper(GridTab gridTab) {
        this.m_gridTab = gridTab;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        if (methodName.startsWith("set") && args.length == 1) {
            Object value;
            String propertyName;
            Class<?> paramType = method.getParameterTypes()[0];
            if (this.isModelInterface(paramType)) {
                propertyName = methodName.substring(3) + "_ID";
                value = InterfaceWrapperHelper.getId(args[0]);
            } else {
                propertyName = methodName.substring(3);
                value = POWrapper.checkZeroIdValue(propertyName, args[0]);
            }
            String errorMsg = this.m_gridTab.setValue(propertyName, value);
            if (!Util.isEmpty(errorMsg)) {
                String msg = "Attempt to set field " + propertyName + " of grid tab " + this.m_gridTab + " to value '" + value + " (original: " + args[0] + ")' returned an error message: " + errorMsg;
                if (this.failOnColumnNotFound) {
                    throw new AdempiereException(msg);
                }
                log.severe(msg);
            }
            return null;
        }
        if (methodName.startsWith("get") && (args == null || args.length == 0) && !methodName.startsWith("get_")) {
            String propertyName = methodName.substring(3);
            Object value = this.m_gridTab.getValue(propertyName);
            if (value != null) {
                return value;
            }
            if (method.getReturnType() == Integer.TYPE) {
                value = 0;
            } else if (method.getReturnType() == BigDecimal.class) {
                value = BigDecimal.ZERO;
            } else if (this.isModelInterface(method.getReturnType())) {
                value = this.getReferencedObject(propertyName, method);
            } else if (PO.class.isAssignableFrom(method.getReturnType())) {
                throw new IllegalArgumentException("Method not supported - " + methodName);
            }
            return value;
        }
        if (methodName.startsWith("is") && (args == null || args.length == 0)) {
            String propertyName = methodName.substring(2);
            GridField field = this.m_gridTab.getField(propertyName);
            if (field != null) {
                Object value = field.getValue();
                return value instanceof Boolean ? value : Boolean.valueOf("Y".equals(value));
            }
            field = this.m_gridTab.getField("Is" + propertyName);
            if (field != null) {
                Object value = field.getValue();
                return value instanceof Boolean ? value : Boolean.valueOf("Y".equals(value));
            }
            throw new IllegalArgumentException("Method not supported - " + methodName);
        }
        if (method.getName().equals("get_TableName")) {
            return this.m_gridTab.get_TableName();
        }
        return method.invoke((Object)this.m_gridTab, args);
    }

    public GridTab getGridTab() {
        return this.m_gridTab;
    }

    private final Properties getCtx() {
        return Env.getCtx();
    }

    private final String getTrxName() {
        return null;
    }

    private final Object getReferencedObject(String propertyName, Method method) {
        String tableName;
        GridField idField = this.m_gridTab.getField(propertyName + "_ID");
        if (idField == null) {
            return null;
        }
        Integer record_id = (Integer)this.m_gridTab.getValue(idField);
        if (record_id == null || record_id <= 0) {
            return null;
        }
        Class<?> cl = method.getReturnType();
        try {
            tableName = (String)cl.getField("Table_Name").get(null);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getLocalizedMessage(), e);
            return null;
        }
        PO po = MTable.get(this.getCtx(), tableName).getPO(record_id, this.getTrxName());
        return po;
    }

    private boolean isModelInterface(Class<?> cl) {
        try {
            String tableName = (String)cl.getField("Table_Name").get(null);
            return tableName != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isHandled(Object model) {
        return GridTabWrapper.getGridTab(model) != null;
    }

    public static void save(Object model) {
        boolean manualCmd;
        GridTab gridTab = GridTabWrapper.getGridTab(model);
        boolean ok = gridTab.dataSave(manualCmd = false);
        if (!ok) {
            throw new AdempiereException("Error saving " + model);
        }
    }

    public static boolean isNull(Object model, String columnName) {
        GridTab gridTab = GridTabWrapper.getGridTab(model);
        if (gridTab == null) {
            return true;
        }
        Object value = gridTab.getValue(columnName);
        return value == null;
    }
}

