/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.exceptions;

import java.math.BigDecimal;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MProduct;
import org.compiere.util.Env;

public class CostInsufficientQtyException
extends AdempiereException {
    private static final long serialVersionUID = -8516844627809849649L;

    public CostInsufficientQtyException(int product_id, int asi_id, BigDecimal qty, BigDecimal remainingQty) {
        super(CostInsufficientQtyException.createMessage(product_id, asi_id, qty, remainingQty));
    }

    private static String createMessage(int product_id, int asi_id, BigDecimal qty, BigDecimal remainingQty) {
        MProduct product = MProduct.get(Env.getCtx(), product_id);
        String productValue = product != null ? product.getValue() : "?";
        String productName = product != null ? product.getName() : "?";
        return "@M_Product_ID@ : " + productValue + " - " + productName + ", @Qty@ : " + qty + ", @RemainingQty@ : " + remainingQty + " (ASI:" + asi_id + ")";
    }
}

