/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.engine;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.adempiere.engine.AverageInvoiceCostingMethod;
import org.adempiere.engine.AveragePOCostingMethod;
import org.adempiere.engine.FifoLifoCostingMethod;
import org.adempiere.engine.ICostingMethod;
import org.adempiere.engine.LastInvoiceCostingMethod;
import org.adempiere.engine.LastPOPriceCostingMethod;
import org.adempiere.engine.StandardCostingMethod;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.compiere.util.Util;

public class CostingMethodFactory {
    private static final CostingMethodFactory s_instance = new CostingMethodFactory();
    private Map<String, Class<? extends ICostingMethod>> s_map = new HashMap<String, Class<? extends ICostingMethod>>();

    public static CostingMethodFactory get() {
        return s_instance;
    }

    private CostingMethodFactory() {
        this.s_map.put("F", FifoLifoCostingMethod.class);
        this.s_map.put("L", FifoLifoCostingMethod.class);
        this.s_map.put("I", AverageInvoiceCostingMethod.class);
        this.s_map.put("A", AveragePOCostingMethod.class);
        this.s_map.put("i", LastInvoiceCostingMethod.class);
        this.s_map.put("p", LastPOPriceCostingMethod.class);
        this.s_map.put("S", StandardCostingMethod.class);
        new Query(Env.getCtx(), "M_CostType", "", null).setOnlyActiveRecords(true).setClient_ID().list().forEach(costType -> {
            Optional<Object> maybeClassName = Optional.ofNullable(costType.get_Value("ClassName"));
            maybeClassName.ifPresent(className -> {
                if (!Util.isEmpty(className.toString())) {
                    try {
                        this.s_map.put(costType.getCostingMethod(), Class.forName(className.toString()));
                    }
                    catch (ClassNotFoundException e) {
                        throw new AdempiereException("No implementation found for costing method " + costType.getCostingMethod() + " - " + className.toString());
                    }
                }
            });
        });
    }

    public ICostingMethod getCostingMethod(String costingMethod) {
        ICostingMethod cm;
        Class<? extends ICostingMethod> cl = this.s_map.get(costingMethod);
        if (cl == null) {
            throw new AdempiereException("No implementation found for costing method " + costingMethod);
        }
        try {
            cm = cl.newInstance();
        }
        catch (Exception e) {
            throw new AdempiereException(e);
        }
        return cm;
    }
}

