/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.engine;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.adempiere.engine.CostComponent;
import org.adempiere.engine.CostEngineFactory;
import org.adempiere.engine.ICostingMethod;
import org.adempiere.engine.IDocumentLine;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.I_C_OrderLine;
import org.compiere.model.I_M_InOutLine;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MCost;
import org.compiere.model.MCostDetail;
import org.compiere.model.MCostElement;
import org.compiere.model.MCostType;
import org.compiere.model.MDocType;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInventoryLine;
import org.compiere.model.MMatchInv;
import org.compiere.model.MMatchPO;
import org.compiere.model.MMovementLine;
import org.compiere.model.MOrderLine;
import org.compiere.model.MPeriod;
import org.compiere.model.MTransaction;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.eevolution.model.MPPCostCollector;

public abstract class AbstractCostingMethod
implements ICostingMethod {
    protected final CLogger log = CLogger.getCLogger(this.getClass());
    protected MAcctSchema accountSchema;
    protected Timestamp dateAccounting;
    protected Boolean isOpenPeriod = null;
    protected BigDecimal movementQuantity = Env.ZERO;
    protected IDocumentLine model;
    protected MTransaction transaction;
    protected MCost dimension;
    protected Boolean isSalesTransaction;
    protected BigDecimal costThisLevel;
    protected BigDecimal costLowLevel;
    protected MCostDetail costDetail = null;
    protected BigDecimal accumulatedAmount = Env.ZERO;
    protected BigDecimal accumulatedAmountLowerLevel = Env.ZERO;
    protected BigDecimal accumulatedQuantity = Env.ZERO;
    protected BigDecimal currentCostPrice = Env.ZERO;
    protected BigDecimal currentCostPriceLowerLevel = Env.ZERO;
    protected BigDecimal amount = Env.ZERO;
    protected BigDecimal amountLowerLevel = Env.ZERO;
    protected BigDecimal adjustCost = Env.ZERO;
    protected BigDecimal adjustCostLowerLevel = Env.ZERO;
    protected MCostDetail lastCostDetail = null;
    protected String costingLevel;

    protected List<MCostDetail> createCostDetails() {
        String idColumnName = this.model instanceof MMatchPO ? "C_OrderLine_ID" : (this.model instanceof MMatchInv ? "C_InvoiceLine_ID" : this.model.get_TableName() + "_ID");
        ArrayList<MCostDetail> list = new ArrayList<MCostDetail>();
        if (this.model.isSOTrx() || this.model instanceof MInventoryLine || this.model instanceof MMovementLine) {
            List<CostComponent> costComponents = this.getCalculatedCosts();
            for (CostComponent costComponent : costComponents) {
                MCostDetail cost = new MCostDetail(this.transaction, this.accountSchema.getC_AcctSchema_ID(), this.dimension.getM_CostType_ID(), this.dimension.getM_CostElement_ID(), costComponent.getAmount(), Env.ZERO, costComponent.getQty(), this.model.get_TrxName());
                if (!cost.set_ValueOfColumnReturningBoolean(idColumnName, (Object)this.model.get_ID())) {
                    throw new AdempiereException("Cannot set " + idColumnName);
                }
                StringBuilder description = new StringBuilder();
                if (!Util.isEmpty(this.model.getDescription(), true)) {
                    description.append(this.model.getDescription());
                }
                if (this.model.isSOTrx()) {
                    description.append(this.model.isSOTrx() ? "(|->)" : "(|<-)");
                }
                if (this.model.isSOTrx()) {
                    cost.setIsSOTrx(this.model.isSOTrx());
                } else {
                    cost.setIsSOTrx(this.model.isSOTrx());
                }
                cost.setM_Transaction_ID(this.transaction.get_ID());
                cost.setDescription(description.toString());
                cost.saveEx();
                list.add(cost);
            }
        } else {
            int id;
            MCostDetail cost = new MCostDetail(this.transaction, this.accountSchema.getC_AcctSchema_ID(), this.dimension.getM_CostType_ID(), this.dimension.getM_CostElement_ID(), this.costThisLevel.multiply(this.model.getMovementQty()), Env.ZERO, this.model.getMovementQty(), this.model.get_TrxName());
            if (this.model instanceof MMatchPO) {
                I_M_InOutLine inOutLine = this.transaction.getM_InOutLine();
                I_C_OrderLine orderLine = inOutLine.getC_OrderLine();
                id = orderLine.getC_OrderLine_ID();
            } else {
                id = this.model.get_ID();
            }
            if (!cost.set_ValueOfColumnReturningBoolean(idColumnName, (Object)id)) {
                throw new AdempiereException("Cannot set " + idColumnName);
            }
            if (this.model.isSOTrx()) {
                cost.setIsSOTrx(this.model.isSOTrx());
            } else {
                cost.setIsSOTrx(this.model.isSOTrx());
            }
            cost.setM_Transaction_ID(this.transaction.get_ID());
            cost.saveEx();
            list.add(cost);
        }
        return list;
    }

    protected abstract List<CostComponent> getCalculatedCosts();

    protected void updateInventoryValue() {
    }

    public void createReversalCostDetail() {
        String description = "";
        if (this.model instanceof MMatchInv) {
            MMatchInv original = new MMatchInv(this.model.getCtx(), ((MMatchInv)this.model).getReversal_ID(), this.model.get_TrxName());
            if (original == null) {
                return;
            }
            StringBuffer whereClause = new StringBuffer();
            whereClause.append(" M_CostType_ID=" + this.dimension.getM_CostType_ID());
            whereClause.append(" AND M_CostElement_ID=" + this.dimension.getM_CostElement_ID());
            whereClause.append(" AND M_MatchInv_ID=?");
            this.lastCostDetail = MCostDetail.get(original.getCtx(), whereClause.toString(), original.getM_MatchInv_ID(), original.getM_AttributeSetInstance_ID(), this.dimension.getC_AcctSchema_ID(), original.get_TrxName());
            if (this.lastCostDetail == null) {
                whereClause = new StringBuffer();
                whereClause.append(" M_CostType_ID=" + this.dimension.getM_CostType_ID());
                whereClause.append(" AND M_CostElement_ID=" + this.dimension.getM_CostElement_ID());
                whereClause.append(" AND C_Invoiceline_ID=" + original.getC_InvoiceLine_ID());
                whereClause.append(" AND M_InoutLine_ID=?");
                this.lastCostDetail = MCostDetail.get(original.getCtx(), whereClause.toString(), original.getM_InOutLine_ID(), original.getM_AttributeSetInstance_ID(), this.dimension.getC_AcctSchema_ID(), original.get_TrxName());
                if (this.lastCostDetail == null) {
                    return;
                }
            }
            description = "Reversal MatchInv " + original.getDocumentNo();
        } else if (this.model instanceof MMatchPO) {
            MMatchPO original = new MMatchPO(this.model.getCtx(), ((MMatchInv)this.model).getReversal_ID(), this.model.get_TrxName());
            StringBuffer whereClause = new StringBuffer();
            whereClause.append(" M_CostType_ID=" + this.dimension.getM_CostType_ID());
            whereClause.append(" AND M_CostElement_ID=" + this.dimension.getM_CostElement_ID());
            whereClause.append(" AND M_MatchPO_ID=?");
            this.lastCostDetail = MCostDetail.get(original.getCtx(), whereClause.toString(), original.getM_MatchPO_ID(), original.getM_AttributeSetInstance_ID(), this.dimension.getC_AcctSchema_ID(), original.get_TrxName());
            if (this.lastCostDetail == null) {
                return;
            }
            description = "Reversal MatchPO " + original.getDocumentNo();
        } else {
            MTransaction originalTransaction = MTransaction.getByDocumentLine(this.transaction);
            if (originalTransaction == null) {
                this.log.info("Transaction not found :" + this.transaction);
                return;
            }
            this.lastCostDetail = MCostDetail.getByTransaction(originalTransaction.getDocumentLine(), originalTransaction, this.accountSchema.getC_AcctSchema_ID(), this.dimension.getM_CostType_ID(), this.dimension.getM_CostElement_ID());
            if (this.lastCostDetail == null) {
                this.log.info("Detail Cost not found :" + originalTransaction);
                return;
            }
            description = "Reversal " + originalTransaction.getM_Transaction_ID();
        }
        this.costDetail = new MCostDetail(this.model.getCtx(), 0, this.transaction.get_TrxName());
        MCostDetail.copyValues(this.lastCostDetail, this.costDetail);
        this.costDetail.setAD_Org_ID(this.lastCostDetail.getAD_Org_ID());
        this.costDetail.setM_Warehouse_ID(this.lastCostDetail.getM_Warehouse_ID());
        this.setReversalCostDetail();
        this.costDetail.setM_AttributeSetInstance_ID(this.transaction.getM_AttributeSetInstance_ID());
        this.costDetail.setDateAcct(this.model.getDateAcct());
        this.costDetail.setDescription(description);
        this.costDetail.setIsReversal(true);
        this.costDetail.saveEx();
        this.lastCostDetail.setDescription(this.lastCostDetail.getDescription() != null ? this.lastCostDetail.getDescription() : "|Reversal " + this.costDetail.getM_Transaction_ID());
        this.lastCostDetail.setIsReversal(true);
        this.lastCostDetail.saveEx(this.transaction.get_TrxName());
        if (this.model.getDateAcct().compareTo(this.lastCostDetail.getDateAcct()) != 0) {
            this.lastCostDetail = MCostDetail.getLastTransaction(this.model, this.transaction, this.accountSchema.getC_AcctSchema_ID(), this.dimension.getM_CostType_ID(), this.dimension.getM_CostElement_ID(), this.dateAccounting, this.costingLevel);
            this.costDetail.setSeqNo(this.lastCostDetail.getSeqNo() + 10);
            this.costDetail.setCumulatedQty(this.getNewAccumulatedQuantity(this.lastCostDetail));
            this.costDetail.setCumulatedAmt(this.getNewAccumulatedAmount(this.lastCostDetail));
            this.costDetail.setCumulatedAmtLL(this.getNewAccumulatedAmountLowerLevel(this.lastCostDetail));
            this.updateAmountCost();
            this.updateInventoryValue();
        }
    }

    protected void setReversalCostDetail() {
        MCostDetail lastTrxCostDetail;
        this.costDetail.setCurrentCostPrice(this.getNewCurrentCostPrice(this.lastCostDetail, this.accountSchema.getCostingPrecision(), 4));
        this.costDetail.setCurrentCostPriceLL(this.getNewCurrentCostPriceLowerLevel(this.lastCostDetail, this.accountSchema.getCostingPrecision(), 4));
        this.costDetail.setCurrentQty(Env.ZERO);
        this.costDetail.setQty(Env.ZERO);
        this.costDetail.setAmt(Env.ZERO);
        this.costDetail.setCostAmt(Env.ZERO);
        this.costDetail.setCostAdjustment(Env.ZERO);
        this.costDetail.setAmtLL(Env.ZERO);
        this.costDetail.setCostAmtLL(Env.ZERO);
        this.costDetail.setCostAdjustmentLL(Env.ZERO);
        this.costDetail.setCumulatedAmt(Env.ZERO);
        this.costDetail.setCumulatedAmtLL(Env.ZERO);
        this.costDetail.setCumulatedQty(Env.ZERO);
        this.costDetail.setM_Transaction_ID(this.transaction.getM_Transaction_ID());
        this.costDetail.setSeqNo(this.lastCostDetail.getSeqNo() + 10);
        this.costDetail.setQty(this.lastCostDetail.getQty().negate());
        this.costDetail.setAmt(this.lastCostDetail.getAmt());
        this.costDetail.setCostAmt(this.lastCostDetail.getCostAmt());
        this.costDetail.setCostAdjustment(this.lastCostDetail.getCostAdjustment());
        this.costDetail.setAmtLL(this.lastCostDetail.getAmtLL());
        this.costDetail.setCostAmtLL(this.lastCostDetail.getCostAmtLL());
        this.costDetail.setCostAdjustmentLL(this.lastCostDetail.getCostAdjustmentLL());
        this.costDetail.setCostAdjustmentDate(this.lastCostDetail.getCostAdjustmentDate());
        this.currentCostPrice = this.lastCostDetail.getCurrentCostPrice();
        this.currentCostPriceLowerLevel = this.lastCostDetail.getCurrentCostPriceLL();
        if (this.model instanceof MMatchInv) {
            this.costDetail.setAmt(this.lastCostDetail.getAmt().negate());
            this.costDetail.setCostAmt(this.lastCostDetail.getCostAmt().negate());
            this.costDetail.setCostAdjustment(this.lastCostDetail.getCostAdjustment().negate());
            this.costDetail.setAmtLL(this.lastCostDetail.getAmtLL().negate());
            this.costDetail.setCostAmtLL(this.lastCostDetail.getCostAmtLL().negate());
            this.costDetail.setCostAdjustmentLL(this.lastCostDetail.getCostAdjustmentLL().negate());
            this.costDetail.setCostAdjustmentDate(this.lastCostDetail.getCostAdjustmentDate());
            this.currentCostPrice = this.lastCostDetail.getCurrentCostPrice().negate();
            this.currentCostPriceLowerLevel = this.lastCostDetail.getCurrentCostPriceLL().negate();
        }
        if (this.lastCostDetail != (lastTrxCostDetail = MCostDetail.getLastTransaction(this.model, this.transaction, this.accountSchema.getC_AcctSchema_ID(), this.dimension.getM_CostType_ID(), this.dimension.getM_CostElement_ID(), this.dateAccounting, this.costingLevel))) {
            MCostDetail tmp = this.lastCostDetail;
            this.lastCostDetail = lastTrxCostDetail;
            this.updateAmountCost();
            this.costDetail.setSeqNo(this.lastCostDetail.getSeqNo() + 10);
            this.lastCostDetail = tmp;
        }
        this.accumulatedQuantity = this.getNewAccumulatedQuantity(this.costDetail);
        this.accumulatedAmount = this.getNewAccumulatedAmount(this.costDetail);
        this.accumulatedAmountLowerLevel = this.getNewAccumulatedAmountLowerLevel(this.costDetail);
        this.currentCostPrice = this.getNewCurrentCostPrice(this.costDetail, this.accountSchema.getCostingPrecision(), 4);
    }

    public abstract void updateAmountCost();

    public abstract BigDecimal getNewCurrentCostPrice(MCostDetail var1, int var2, int var3);

    public abstract BigDecimal getNewAccumulatedAmount(MCostDetail var1);

    public abstract BigDecimal getNewCurrentCostPriceLowerLevel(MCostDetail var1, int var2, int var3);

    public abstract BigDecimal getNewAccumulatedAmountLowerLevel(MCostDetail var1);

    public abstract BigDecimal getNewAccumulatedQuantity(MCostDetail var1);

    public void adjustCostDetail(MCostDetail cost) {
        MCostType costType = (MCostType)cost.getM_CostType();
        MCostElement costElement = (MCostElement)cost.getM_CostElement();
        MTransaction transaction = new MTransaction(cost.getCtx(), cost.getM_Transaction_ID(), cost.get_TrxName());
        IDocumentLine docLine = transaction.getDocumentLine();
        CostEngineFactory.getCostEngine(cost.getAD_Client_ID()).createCostDetail((MAcctSchema)cost.getC_AcctSchema(), costType, costElement, transaction, docLine, true);
    }

    public void clearAccounting(MCostDetail cost) {
        PO line;
        MTransaction trx = new MTransaction(cost.getCtx(), cost.getM_Transaction_ID(), cost.get_TrxName());
        IDocumentLine documentLine = trx.getDocumentLine();
        MDocType docType = MDocType.get(cost.getCtx(), documentLine.getC_DocType_ID());
        Boolean openPeriod = MPeriod.isOpen(cost.getCtx(), cost.getDateAcct(), docType.getDocBaseType(), cost.getAD_Org_ID());
        if (!openPeriod.booleanValue()) {
            return;
        }
        String sqldelete = "DELETE FROM Fact_Acct WHERE Record_ID =? AND AD_Table_ID=?";
        int tableId = 0;
        int recordId = 0;
        if (cost.getC_OrderLine_ID() != 0) {
            line = (MOrderLine)cost.getC_OrderLine();
            ((MOrderLine)line).getParent().setPosted(false);
            ((MOrderLine)line).getParent().saveEx();
            recordId = ((MOrderLine)line).getParent().get_ID();
            tableId = ((MOrderLine)line).getParent().get_Table_ID();
        }
        if (cost.getM_InOutLine_ID() != 0) {
            line = (MInOutLine)cost.getM_InOutLine();
            ((MInOutLine)line).getParent().setPosted(false);
            ((MInOutLine)line).getParent().saveEx();
            recordId = ((MInOutLine)line).getParent().get_ID();
            tableId = ((MInOutLine)line).getParent().get_Table_ID();
        }
        if (cost.getM_InventoryLine_ID() != 0) {
            line = (MInventoryLine)cost.getM_InventoryLine();
            ((MInventoryLine)line).getParent().setPosted(false);
            ((MInventoryLine)line).getParent().saveEx();
            recordId = ((MInventoryLine)line).getParent().get_ID();
            tableId = ((MInventoryLine)line).getParent().get_Table_ID();
        }
        if (cost.getM_MovementLine_ID() != 0) {
            line = (MMovementLine)cost.getM_MovementLine();
            ((MMovementLine)line).getParent().setPosted(false);
            ((MMovementLine)line).getParent().saveEx();
            recordId = ((MMovementLine)line).getParent().get_ID();
            tableId = ((MMovementLine)line).getParent().get_Table_ID();
        }
        if (cost.getM_ProductionLine_ID() != 0) {
            // empty if block
        }
        if (cost.getPP_Cost_Collector_ID() != 0) {
            MPPCostCollector costCollector = (MPPCostCollector)cost.getPP_Cost_Collector();
            costCollector.setPosted(false);
            costCollector.saveEx();
            recordId = costCollector.get_ID();
            tableId = costCollector.get_Table_ID();
        }
        int no = DB.executeUpdateEx(sqldelete, new Object[]{recordId, tableId}, cost.get_TrxName());
    }
}

