/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.controller.ed;

import org.adempiere.controller.ed.CEditorController;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.Lookup;
import org.compiere.model.MQuery;
import org.compiere.swing.CEditor;

public abstract class CAbstractEditorController
implements CEditorController {
    protected GridTab gridTab;
    protected GridField gridField;
    protected int windowNo;
    protected Lookup lookup;
    protected boolean readOnly = false;
    protected boolean isUpdateable = true;
    protected boolean mandatory = false;
    private Object value = new Object();
    protected Object oldValue = 0;
    protected int ad_column_id = 0;
    protected String columnName;
    protected CEditor editor;
    protected boolean isButtonEnabled = false;
    protected boolean isDisplayEnabled = false;
    MQuery zoomQuery = null;
    String zoomKeyTableName;
    String zoomKeyColumnName;
    int zoomAD_Window_ID;
    protected String lastDisplay;

    public CAbstractEditorController() {
        this.gridTab = null;
        this.setGridField(null);
        this.setLookup(null);
        this.windowNo = 0;
    }

    public CAbstractEditorController(CEditor editor, GridTab tab, boolean mandatory, boolean isReadOnly, boolean isUpdateable, int windowNo, Lookup lookup) {
        this.gridTab = tab;
        this.gridField = null;
        this.editor = editor;
        this.setMandatory(mandatory);
        this.setReadOnly(isReadOnly);
        this.setUpdateable(isUpdateable);
        this.windowNo = windowNo;
        this.setLookup(lookup);
    }

    public CAbstractEditorController(CEditor editor, GridTab tab, GridField field) {
        this(tab, field);
        this.editor = editor;
    }

    private CAbstractEditorController(GridTab tab, GridField field) {
        this.gridTab = tab;
        this.setGridField(field);
        if (this.gridTab != null) {
            this.windowNo = this.gridTab.getWindowNo();
        }
        if (this.gridField != null) {
            this.setLookup(this.gridField.getLookup());
        }
    }

    @Override
    public void init() {
        this.set_oldValue();
        this.editor.setReadWrite(!this.readOnly && this.isUpdateable);
    }

    @Override
    public void dispose() {
        this.gridTab = null;
        this.gridField = null;
        this.lookup.dispose();
        this.setLookup(null);
    }

    @Override
    public String getColumnName() {
        return this.columnName;
    }

    @Override
    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    @Override
    public void setGridField(GridField field) {
        this.gridField = field;
        if (this.gridField != null) {
            this.columnName = this.gridField.getColumnName();
            this.ad_column_id = this.gridField.getAD_Column_ID();
            this.mandatory = this.gridField.isMandatory(false);
            this.readOnly = this.gridField.isReadOnly();
            this.setLookup(field.getLookup());
        } else {
            this.columnName = "";
            this.ad_column_id = 0;
            this.mandatory = false;
            this.readOnly = false;
            this.lookup = null;
        }
    }

    @Override
    public GridField getGridField() {
        return this.gridField;
    }

    public Object get_oldValue() {
        return this.oldValue;
    }

    @Override
    public void set_oldValue() {
        this.oldValue = this.getValue();
    }

    @Override
    public boolean hasChanged() {
        if (this.getValue() != null) {
            if (this.oldValue != null) {
                return !this.oldValue.equals(this.getValue());
            }
            return true;
        }
        return this.oldValue != null;
    }

    @Override
    public void setMandatory(boolean mandatory) {
        this.mandatory = mandatory;
    }

    @Override
    public boolean isMandatory() {
        return this.mandatory;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public Object getValue() {
        return this.value;
    }

    @Override
    public void setValue(Object value) {
        this.value = value;
    }

    public abstract void setError();

    public String getLastDisplay() {
        return this.lastDisplay;
    }

    @Override
    public void setLastDisplay(String lastDisplay) {
        this.lastDisplay = lastDisplay;
    }

    @Override
    public void generateZoomQuery() {
        if (this.zoomKeyTableName == null || this.zoomKeyTableName.isEmpty() || this.zoomKeyColumnName == null || this.zoomKeyColumnName.isEmpty()) {
            throw new AdempiereException("Can't zoom. Unknown zoom table and key column");
        }
        this.zoomQuery = new MQuery();
        Object value = this.getValue();
        if (value == null) {
            value = 0;
        }
        this.zoomQuery.addRestriction(this.zoomKeyColumnName, "=", value);
        this.zoomQuery.setZoomColumnName(this.zoomKeyColumnName);
        this.zoomQuery.setZoomTableName(this.zoomKeyTableName);
        this.zoomQuery.setZoomValue(value);
        this.zoomQuery.setRecordCount(1);
        this.zoomAD_Window_ID = this.lookup.getZoom(this.zoomQuery);
    }

    protected String getZoomKeyTableName() {
        return this.zoomKeyTableName;
    }

    protected void setZoomKeyTableName(String zoomKeyTableName) {
        this.zoomKeyTableName = zoomKeyTableName;
    }

    protected String getZoomKeyColumnName() {
        return this.zoomKeyColumnName;
    }

    protected void setZoomKeyColumnName(String zoomKeyColumnName) {
        this.zoomKeyColumnName = zoomKeyColumnName;
    }

    @Override
    public int getZoomAD_Window_ID() {
        return this.zoomAD_Window_ID;
    }

    protected void setZoomAD_Window_ID(int zoomAD_Window_ID) {
        this.zoomAD_Window_ID = zoomAD_Window_ID;
    }

    @Override
    public MQuery getZoomQuery() {
        if (this.zoomQuery == null) {
            throw new AdempiereException("Zoom Query not initialized.");
        }
        return this.zoomQuery;
    }

    protected void setZoomQuery(MQuery zoomQuery) {
        this.zoomQuery = zoomQuery;
    }

    @Override
    public int getWindowNo() {
        return this.windowNo;
    }

    protected void setWindowNo(int windowNo) {
        this.windowNo = windowNo;
    }

    public boolean isUpdateable() {
        return this.isUpdateable;
    }

    protected void setUpdateable(boolean isUpdateable) {
        this.isUpdateable = isUpdateable;
    }

    @Override
    public Lookup getLookup() {
        return this.lookup;
    }

    protected void setLookup(Lookup lookup) {
        this.lookup = lookup;
    }
}

