/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.apps.form;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.logging.Level;
import org.adempiere.process.InvoiceGenerateFromShipmentAbstract;
import org.compiere.apps.IStatusBar;
import org.compiere.apps.form.GenForm;
import org.compiere.minigrid.IDColumn;
import org.compiere.minigrid.IMiniTable;
import org.compiere.model.MInOut;
import org.compiere.model.MPInstance;
import org.compiere.model.MPInstancePara;
import org.compiere.model.MPrivateAccess;
import org.compiere.process.ProcessInfo;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.Trx;

public class InvoiceGenFromShipment
extends GenForm {
    private static CLogger log = CLogger.getCLogger(InvoiceGenFromShipment.class);
    public Object m_AD_Org_ID = null;
    public Object m_C_BPartner_ID = null;

    @Override
    public void dynInit() throws Exception {
        this.setTitle("InvGenerateInfo");
        this.setReportEngineType(2);
        this.setAskPrintMsg("PrintInvoices");
    }

    @Override
    public void configureMiniTable(IMiniTable miniTable) {
        miniTable.addColumn("M_InOut_ID");
        miniTable.addColumn("DocumentNo");
        miniTable.addColumn("C_BPartner_ID");
        miniTable.addColumn("DateDelivered");
        miniTable.addColumn("Description");
        miniTable.setMultiSelection(true);
        int i = 0;
        miniTable.setColumnClass(i++, IDColumn.class, false, " ");
        miniTable.setColumnClass(i++, String.class, true, Msg.translate(Env.getCtx(), "DocumentNo"));
        miniTable.setColumnClass(i++, String.class, true, Msg.translate(Env.getCtx(), "C_BPartner_ID"));
        miniTable.setColumnClass(i++, Timestamp.class, true, Msg.translate(Env.getCtx(), "DateDelivered"));
        miniTable.setColumnClass(i++, String.class, true, Msg.translate(Env.getCtx(), "Description"));
        miniTable.autoSize();
    }

    private String getInOutSQL() {
        int AD_User_ID;
        String lockedIDs;
        StringBuffer sql = new StringBuffer("SELECT ic.M_InOut_ID, o.Name, dt.Name, ic.DocumentNo, bp.Name, ic.MovementDate, ic.QtyToInvoice, ic.Description FROM C_Invoice_Candidate_Ship_v ic, AD_Org o, C_BPartner bp, C_DocType dt WHERE ic.AD_Org_ID=o.AD_Org_ID AND ic.C_BPartner_ID=bp.C_BPartner_ID AND ic.C_DocType_ID=dt.C_DocType_ID AND ic.AD_Client_ID=?");
        if (this.m_AD_Org_ID != null) {
            sql.append(" AND ic.AD_Org_ID=").append(this.m_AD_Org_ID);
        }
        if (this.m_C_BPartner_ID != null) {
            sql.append(" AND ic.C_BPartner_ID=").append(this.m_C_BPartner_ID);
        }
        if ((lockedIDs = MPrivateAccess.getLockedRecordWhere(MInOut.Table_ID, AD_User_ID = Env.getContextAsInt(Env.getCtx(), "#AD_User_ID"))) != null) {
            if (sql.length() > 0) {
                sql.append(" AND ");
            }
            sql.append("M_InOut_ID").append(lockedIDs);
        }
        sql.append(" ORDER BY o.Name, bp.Name, MovementDate");
        return sql.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeQuery(KeyNamePair docTypeKNPair, IMiniTable miniTable) {
        log.info("");
        int AD_Client_ID = Env.getAD_Client_ID(Env.getCtx());
        String sql = "";
        if (docTypeKNPair.getKey() == MInOut.Table_ID) {
            sql = this.getInOutSQL();
        }
        int row = 0;
        miniTable.setRowCount(row);
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql.toString(), null);
            pstmt.setInt(1, AD_Client_ID);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                miniTable.setRowCount(row + 1);
                int i = 0;
                miniTable.setValueAt(new IDColumn(rs.getInt(1)), row, i++);
                miniTable.setValueAt(rs.getString(4), row, i++);
                miniTable.setValueAt(rs.getString(5), row, i++);
                miniTable.setValueAt(rs.getTimestamp(6), row, i++);
                miniTable.setValueAt(rs.getString(8), row, i++);
                ++row;
            }
        }
        catch (SQLException e) {
            try {
                log.log(Level.SEVERE, sql.toString(), e);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                throw throwable;
            }
            DB.close(rs, pstmt);
        }
        DB.close(rs, pstmt);
        miniTable.autoSize();
    }

    @Override
    public void saveSelection(IMiniTable miniTable) {
        log.info("");
        ArrayList<Integer> results = new ArrayList<Integer>();
        this.setSelection(null);
        int rows = miniTable.getRowCount();
        for (int i = 0; i < rows; ++i) {
            IDColumn id = (IDColumn)miniTable.getValueAt(i, 0);
            if (id == null || !id.isSelected()) continue;
            results.add(id.getRecord_ID());
        }
        if (results.size() == 0) {
            return;
        }
        log.config("Selected #" + results.size());
        this.setSelection(results);
    }

    public String generate(IStatusBar statusBar, KeyNamePair docTypeKNPair, String docActionSelected) {
        MPInstance instance;
        log.info("docTypeKNPair " + docTypeKNPair.toStringX() + " , docActionSelected=" + docActionSelected);
        String info = "";
        String trxName = Trx.createTrxName("IVG");
        Trx trx = Trx.get(trxName, true);
        this.setSelectionActive(false);
        statusBar.setStatusLine(Msg.getMsg(Env.getCtx(), "InvGenerateGen"));
        statusBar.setStatusDB(String.valueOf(this.getSelection().size()));
        int AD_Process_ID = 0;
        if (docTypeKNPair.getKey() == MInOut.Table_ID) {
            AD_Process_ID = InvoiceGenerateFromShipmentAbstract.getProcessId();
        }
        if (!(instance = new MPInstance(Env.getCtx(), AD_Process_ID, 0)).save()) {
            info = Msg.getMsg(Env.getCtx(), "ProcessNoInstance");
            return info;
        }
        StringBuffer insert = new StringBuffer();
        insert.append("INSERT INTO T_SELECTION(AD_PINSTANCE_ID, T_SELECTION_ID) ");
        int counter = 0;
        for (Integer selectedId : this.getSelection()) {
            if (++counter > 1) {
                insert.append(" UNION ");
            }
            insert.append("SELECT ");
            insert.append(instance.getAD_PInstance_ID());
            insert.append(", ");
            insert.append(selectedId);
            insert.append(" FROM DUAL ");
            if (counter != 1000) continue;
            if (DB.executeUpdate(insert.toString(), trxName) < 0) {
                String msg;
                info = msg = "No Invoices";
                log.config(msg);
                trx.rollback();
                return info;
            }
            insert = new StringBuffer();
            insert.append("INSERT INTO T_SELECTION(AD_PINSTANCE_ID, T_SELECTION_ID) ");
            counter = 0;
        }
        if (counter > 0 && DB.executeUpdate(insert.toString(), trxName) < 0) {
            String msg;
            info = msg = "No Invoices";
            log.config(msg);
            trx.rollback();
            return info;
        }
        ProcessInfo pi = new ProcessInfo("", AD_Process_ID);
        pi.setAD_PInstance_ID(instance.getAD_PInstance_ID());
        MPInstancePara para = new MPInstancePara(instance, 10);
        pi.setIsSelection(true);
        para = new MPInstancePara(instance, 20);
        para.setParameter("DocAction", docActionSelected);
        if (!para.save()) {
            String msg;
            info = msg = Msg.getMsg(Env.getCtx(), "ParameterMissing") + " DocAction";
            log.log(Level.SEVERE, msg);
            return info;
        }
        if (this.m_AD_Org_ID == null) {
            String msg;
            info = msg = Msg.getMsg(Env.getCtx(), "ParameterMissing") + " AD_Org_ID";
            log.log(Level.SEVERE, msg);
            return info;
        }
        para = new MPInstancePara(instance, 30);
        para.setParameter("AD_Org_ID", (Integer)this.m_AD_Org_ID);
        if (!para.save()) {
            String msg;
            info = msg = Msg.getMsg(Env.getCtx(), "ParameterMissing") + " AD_Org_ID";
            log.log(Level.SEVERE, msg);
            return info;
        }
        if (this.m_C_BPartner_ID != null) {
            para = new MPInstancePara(instance, 40);
            para.setParameter("C_BPartner_ID", (Integer)this.m_C_BPartner_ID);
            if (!para.save()) {
                String msg;
                info = msg = Msg.getMsg(Env.getCtx(), "ParameterMissing") + " C_BPartner_ID";
                log.log(Level.SEVERE, msg);
                return info;
            }
        }
        this.setTrx(trx);
        this.setProcessInfo(pi);
        return info;
    }
}

