/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.ad.service.impl;

import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.ad.service.IDeveloperModeBL;
import org.adempiere.util.Check;
import org.compiere.model.MEntityType;
import org.compiere.model.MMessage;
import org.compiere.model.MSysConfig;
import org.compiere.model.M_Element;
import org.compiere.model.PO;
import org.compiere.model.X_AD_EntityType;
import org.compiere.util.CLogger;
import org.compiere.util.CacheMgt;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.Language;

public class DeveloperModeBL
implements IDeveloperModeBL {
    public static final DeveloperModeBL instance = new DeveloperModeBL();
    public static final String SYSCONFIG_DeveloperMode = "de.metas.adempiere.debug";
    public static final String CTX_SysContextMarker = DeveloperModeBL.class.getName() + ".SysContext";
    public static final String CTX_ParentContext = DeveloperModeBL.class.getName() + ".ParentContext";
    private final CLogger logger = CLogger.getCLogger(this.getClass());

    protected DeveloperModeBL() {
    }

    @Override
    public boolean isEnabled() {
        return MSysConfig.getBooleanValue(SYSCONFIG_DeveloperMode, false);
    }

    @Override
    public boolean createMessageOrElement(final String adLanguage, final String text, final boolean checkMessage, final boolean checkElement) {
        final boolean[] retValue = new boolean[]{false};
        try {
            this.executeAsSystem(new IDeveloperModeBL.ContextRunnable(){

                @Override
                public void run(Properties sysCtx) {
                    retValue[0] = DeveloperModeBL.this.createMessageOrElement0(sysCtx, adLanguage, text, checkMessage, checkElement);
                }
            });
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
            return false;
        }
        return retValue[0];
    }

    private boolean createMessageOrElement0(Properties ctx, String adLanguage, String text, boolean checkMessage, boolean checkElement) {
        boolean createElement;
        M_Element element;
        MMessage message;
        String trxName = null;
        MMessage mMessage = message = checkMessage ? MMessage.get(ctx, text) : null;
        if (message != null) {
            return this.checkInsertTrl(message, adLanguage);
        }
        M_Element m_Element = element = checkElement ? M_Element.get(ctx, text) : null;
        if (element != null) {
            return this.checkInsertTrl(element, adLanguage);
        }
        boolean createMessage = checkMessage && this.isValidMessageValue(text);
        boolean bl = createElement = checkElement && this.isValidColumnName(text);
        if (!createElement && !createMessage) {
            return false;
        }
        if (createElement && createMessage) {
            createMessage = true;
            createElement = false;
        }
        if (createMessage) {
            MMessage messageNew = new MMessage(ctx, 0, trxName);
            messageNew.setValue(text);
            messageNew.setMsgType("I");
            messageNew.setMsgText(text);
            messageNew.setEntityType(this.getEntityType(ctx));
            messageNew.saveEx();
            this.logger.log(Level.WARNING, "Created: " + messageNew + ", Value=" + messageNew.getValue() + ", EntityType=" + messageNew.getEntityType(), new Exception());
        }
        if (createElement) {
            M_Element elementNew = new M_Element(ctx, 0, trxName);
            elementNew.setColumnName(text);
            elementNew.setName(text);
            elementNew.setPrintName(text);
            elementNew.setEntityType(this.getEntityType(ctx));
            elementNew.saveEx();
            this.logger.log(Level.WARNING, "Created: " + element + ", ColumnName=" + elementNew.getColumnName() + ", EntityType=" + elementNew.getEntityType(), new Exception());
        }
        return createMessage || createElement;
    }

    private boolean checkInsertTrl(PO po, String adLanguage) {
        if (this.hasTranslation(po, adLanguage)) {
            return true;
        }
        boolean changed = po.insertTranslations();
        if (changed) {
            CacheMgt.get().reset("AD_Message");
        }
        return changed;
    }

    private boolean isValidColumnName(String columnName) {
        return !Check.isEmpty(columnName, true) && columnName.indexOf(" ") == -1 && columnName.indexOf(".") == -1 && columnName.indexOf("?") == -1 && columnName.indexOf("{") == -1 && columnName.indexOf("}") == -1;
    }

    private boolean isValidMessageValue(String adMessage) {
        return !Check.isEmpty(adMessage, true) && adMessage.indexOf(" ") == -1;
    }

    @Override
    public boolean isJailedSysContext(Properties ctx) {
        return ctx != null && "Y".equals(ctx.getProperty(CTX_SysContextMarker));
    }

    private Properties createSysContext() {
        Properties ctx = Env.getCtx();
        Properties sysCtx = new Properties(ctx);
        sysCtx.setProperty(CTX_SysContextMarker, "Y");
        sysCtx.put(CTX_ParentContext, ctx);
        Env.setContext(sysCtx, "#AD_Client_ID", 0);
        Env.setContext(sysCtx, "#AD_Org_ID", 0);
        Env.setContext(sysCtx, "#AD_Role_ID", 0);
        Env.setContext(sysCtx, "#AD_User_ID", 0);
        return sysCtx;
    }

    private String getEntityType(Properties ctx) {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        boolean skipStackTraceElement = true;
        for (StackTraceElement ste : stackTrace) {
            int idx;
            String classnameFQ = ste.getClassName();
            if (classnameFQ == null) continue;
            if (classnameFQ.startsWith(this.getClass().getName())) {
                skipStackTraceElement = false;
                continue;
            }
            if (skipStackTraceElement || classnameFQ.startsWith("java.lang.") || classnameFQ.startsWith("sun.") || (idx = classnameFQ.lastIndexOf(".")) <= 0) continue;
            String packageName = classnameFQ.substring(0, idx);
            MEntityType[] entityTypes = MEntityType.getEntityTypes(Env.getCtx());
            X_AD_EntityType entityType = null;
            for (MEntityType et : entityTypes) {
                String modelPackage = et.getModelPackage();
                if (Check.isEmpty(modelPackage, true) || "org.compiere.model".equals(modelPackage) || "org.adempiere.model".equals(modelPackage)) continue;
                if (modelPackage.endsWith(".model")) {
                    modelPackage = modelPackage.substring(0, modelPackage.length() - ".model".length());
                }
                if (!packageName.equals(modelPackage) && !packageName.startsWith(modelPackage + ".")) continue;
                entityType = et;
                break;
            }
            if (entityType == null) continue;
            return entityType.getEntityType();
        }
        String entityType = Env.getContext(ctx, "#EntityType");
        if (Check.isEmpty(entityType)) {
            entityType = "U";
        }
        return entityType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeAsSystem(IDeveloperModeBL.ContextRunnable runnable) {
        Properties sysCtx = this.createSysContext();
        String logMigrationScriptsOld = Ini.getProperty("LogMigrationScript");
        try {
            Ini.setProperty("LogMigrationScript", true);
            runnable.run(sysCtx);
        }
        finally {
            Ini.setProperty("LogMigrationScript", logMigrationScriptsOld);
        }
    }

    private boolean hasTranslation(PO po, String adLanguage) {
        if (Language.isBaseLanguage(adLanguage)) {
            return true;
        }
        String trxName = null;
        String tableName = po.get_TableName();
        int recordId = po.get_ID();
        String sql = "SELECT COUNT(*) FROM " + tableName + "_Trl WHERE " + tableName + "_ID=? AND AD_Language=?";
        int count = DB.getSQLValueEx(trxName, sql, recordId, adLanguage);
        return count == 1;
    }
}

