/*
 * Decompiled with CFR 0.152.
 */
package org.spin.queue.notification.util;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.util.CLogger;
import org.compiere.util.Util;
import org.spin.queue.notification.model.MADNotificationQueue;
import org.spin.queue.notification.model.MADNotificationUpdates;
import org.spin.queue.notification.support.IUpdateHandler;

public class UpdateHandlerUtil {
    private static UpdateHandlerUtil appSupportHandler = null;
    private Map<String, IUpdateHandler> updateHandlerGeneratorMap = new HashMap<String, IUpdateHandler>();
    private static final CLogger logger = CLogger.getCLogger(UpdateHandlerUtil.class);

    public static UpdateHandlerUtil getInstance() {
        if (appSupportHandler == null) {
            appSupportHandler = new UpdateHandlerUtil();
        }
        return appSupportHandler;
    }

    private UpdateHandlerUtil() {
    }

    public void runHandler(MADNotificationUpdates update) {
        if (update == null) {
            return;
        }
        MADNotificationQueue queue = (MADNotificationQueue)update.getAD_NotificationQueue();
        IUpdateHandler handler = this.getHandler(queue.getResponseHandler());
        if (handler != null) {
            handler.run(update);
        }
    }

    private IUpdateHandler getHandler(String handler) {
        if (handler == null) {
            return null;
        }
        if (!this.updateHandlerGeneratorMap.containsKey(handler)) {
            this.loadClass(handler);
            return this.updateHandlerGeneratorMap.get(handler);
        }
        IUpdateHandler supportedApplication = this.updateHandlerGeneratorMap.get(handler);
        return supportedApplication;
    }

    private Class<?> getHandlerClass(String handler) {
        if (Util.isEmpty((String)handler)) {
            return null;
        }
        try {
            Class<?> clazz = Class.forName(handler);
            if (IUpdateHandler.class.isAssignableFrom(clazz)) {
                return clazz;
            }
            for (Class<?> superClazz = clazz.getSuperclass(); superClazz != null; superClazz = superClazz.getSuperclass()) {
                if (superClazz != IUpdateHandler.class) continue;
                logger.log(Level.SEVERE, "Error loading class, Use: " + handler);
                return clazz;
            }
        }
        catch (Exception e) {
            logger.severe("Loading class Error" + e.getMessage());
        }
        logger.log(Level.SEVERE, "Not found Class: " + handler);
        return null;
    }

    private void loadClass(String handler) {
        try {
            Class<?> clazz = this.getHandlerClass(handler);
            IUpdateHandler generator = null;
            if (clazz == null) {
                logger.log(Level.SEVERE, "Class not found, Using Standard Class");
                generator = null;
                return;
            }
            Constructor<?> constructor = clazz.getDeclaredConstructor(new Class[0]);
            generator = (IUpdateHandler)constructor.newInstance(new Object[0]);
            this.updateHandlerGeneratorMap.put(handler, generator);
        }
        catch (Exception e) {
            throw new AdempiereException(e.getLocalizedMessage());
        }
    }
}

