/*
 * Decompiled with CFR 0.152.
 */
package org.spin.queue.notification.support;

import java.util.Arrays;
import java.util.Optional;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MAttachment;
import org.compiere.model.MNote;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.spin.queue.model.MADQueue;
import org.spin.queue.notification.model.MADNotificationQueue;
import org.spin.queue.notification.support.INotification;

public class NoteSender
implements INotification {
    private int registrationId = 0;
    private CLogger log = CLogger.getCLogger(NoteSender.class);

    public int getAppRegistrationId() {
        return this.registrationId;
    }

    public void setAppRegistrationId(int registrationId) {
        this.registrationId = registrationId;
        this.log.fine("set Registration: " + registrationId);
    }

    public String testConnection() {
        this.log.fine("Test connection");
        return "Ok";
    }

    @Override
    public void sendNotification(MADNotificationQueue notification) {
        StringBuffer errorMessage = new StringBuffer();
        notification.getRecipients().forEach(recipient -> {
            try {
                MADQueue queue;
                MNote note = new MNote(notification.getCtx(), 0, notification.get_TrxName());
                if (recipient.getAD_User_ID() > 0) {
                    note.setAD_User_ID(recipient.getAD_User_ID());
                }
                if ((queue = new MADQueue(notification.getCtx(), notification.getAD_Queue_ID(), notification.get_TrxName())).getAD_Table_ID() > 0) {
                    note.setRecord(queue.getAD_Table_ID(), queue.getRecord_ID());
                }
                if (!Util.isEmpty((String)notification.getDescription())) {
                    note.setDescription(notification.getDescription());
                }
                if (!Util.isEmpty((String)notification.getText())) {
                    note.setTextMsg(notification.getText());
                }
                note.setAD_Message_ID(52244);
                note.saveEx();
                MAttachment attachment = notification.getAttachment();
                if (attachment != null && attachment.getAD_Attachment_ID() > 0) {
                    MAttachment noteAttchment = note.createAttachment();
                    Arrays.asList(attachment.getEntries()).forEach(entry -> noteAttchment.addEntry(entry));
                    Optional.ofNullable(attachment.getTextMsg()).ifPresent(comment -> noteAttchment.addTextMsg(comment));
                    noteAttchment.saveEx(note.get_TrxName());
                }
                recipient.setProcessed(true);
                recipient.saveEx();
                this.log.fine("Note sent: " + note);
            }
            catch (Exception e) {
                this.log.severe(e.getLocalizedMessage());
                recipient.setErrorMsg(e.getLocalizedMessage());
                recipient.saveEx();
                if (errorMessage.length() > 0) {
                    errorMessage.append(Env.NL);
                }
                errorMessage.append("Error: Sending to: " + recipient.getAccountName() + ": " + e.getLocalizedMessage());
            }
        });
        if (errorMessage.length() > 0) {
            throw new AdempiereException(errorMessage.toString());
        }
    }
}

