/*
 * Decompiled with CFR 0.152.
 */
package org.spin.queue.notification.telegram.util;

import java.util.HashMap;
import java.util.Map;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.util.Util;
import org.spin.queue.notification.telegram.util.BaseMessage;
import org.spin.queue.notification.telegram.util.ConfirmationMessage;
import org.spin.queue.notification.telegram.util.ITelegramMessage;

public class MessageFactory {
    private Map<String, ITelegramMessage> messagesHandler = new HashMap<String, ITelegramMessage>();
    private static MessageFactory instance = new MessageFactory();

    public static MessageFactory getInstance() {
        return instance;
    }

    public ITelegramMessage getHandler(String messageType) {
        if (Util.isEmpty((String)messageType)) {
            throw new AdempiereException("@MessageType@ @IsMandatory@");
        }
        ITelegramMessage messageHandler = this.messagesHandler.get(messageType);
        if (messageHandler == null) {
            messageHandler = this.getStaticHandler(messageType);
            this.messagesHandler.put(messageType, messageHandler);
        }
        return messageHandler;
    }

    private ITelegramMessage getStaticHandler(String messageType) {
        BaseMessage handler = null;
        switch (messageType) {
            case "CFM": {
                handler = new ConfirmationMessage();
                break;
            }
            case "PRM": {
                handler = new BaseMessage();
                break;
            }
            case "SRV": {
                handler = new BaseMessage();
                break;
            }
            default: {
                handler = new BaseMessage();
            }
        }
        return handler;
    }
}

