/*
 * Decompiled with CFR 0.152.
 */
package org.spin.util.support.k8;

import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.ListVisitFromServerGetDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.utils.ReplaceValueStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BinaryOperator;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class KubeHandler {
    private KubernetesClient kubeCtl = null;
    private String nameSpace;
    private static String DEFAULT_NAMESPACE = "default";
    private List<InputStream> files = new ArrayList<InputStream>();
    private BinaryOperator<String> concat = (previous, concatValue) -> previous.toString() + concatValue.toString();
    private Logger log = Logger.getLogger(KubeHandler.class.getName());
    private LinkedHashMap<String, String> variables = new LinkedHashMap();

    public KubeHandler() {
        this.nameSpace = DEFAULT_NAMESPACE;
    }

    public KubeHandler(KubernetesClient kubeCtl) {
        this();
        this.kubeCtl = kubeCtl;
    }

    public KubeHandler withAPI(KubernetesClient kubeCtl) {
        this.kubeCtl = kubeCtl;
        return this;
    }

    public KubeHandler withNamespace(String nameSpace) {
        this.nameSpace = nameSpace;
        return this;
    }

    public KubeHandler withFiles(List<InputStream> files) {
        this.files = files;
        return this;
    }

    public KubeHandler withVariables(LinkedHashMap<String, String> variables) {
        this.variables = variables;
        return this;
    }

    public KubeHandler addVariable(String param, String value) {
        this.variables.put(param, value);
        return this;
    }

    public KubeHandler addFile(InputStream file) {
        this.files.add(file);
        return this;
    }

    public String apply() {
        return this.apply(false);
    }

    public String delete() {
        return this.apply(true);
    }

    private String apply(boolean delete) {
        AtomicReference<String> result = new AtomicReference<String>();
        result.set("");
        this.files.forEach(file -> {
            if (delete) {
                result.getAndAccumulate(this.deleteYaml((InputStream)file), this.concat);
            } else {
                result.getAndAccumulate(this.applyYaml((InputStream)file), this.concat);
            }
        });
        return (String)result.get();
    }

    private String applyYaml(InputStream yamlFile) {
        AtomicReference<String> result = new AtomicReference<String>();
        result.set("");
        try {
            if (this.kubeCtl != null) {
                yamlFile = this.replaceVariables(yamlFile);
                List resourcesDef = (List)this.kubeCtl.load(yamlFile).get();
                Optional.ofNullable((List)((ListVisitFromServerGetDeleteRecreateWaitApplicable)this.kubeCtl.resourceList((Collection)resourcesDef).inNamespace(this.nameSpace)).createOrReplace()).ifPresent(resources -> {
                    result.set("@Created@ -> ");
                    result.getAndAccumulate(resources.stream().map(resource -> resource.getKind() + " -> " + resource.getMetadata().getName()).collect(Collectors.joining(", ", " [ ", " ] ")), this.concat);
                });
                this.log.fine((String)result.get());
            } else {
                result.set("@NotFound@ @KubeConfig@");
            }
        }
        catch (Exception e) {
            result.set(e.getMessage());
            this.log.severe(e.getMessage());
        }
        return (String)result.get();
    }

    private InputStream replaceVariables(InputStream file) {
        AtomicReference result = new AtomicReference();
        Optional.ofNullable(file).ifPresent(yamlFiletoReplace -> {
            try {
                Map<String, String> mapVar = this.variables.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                result.set(ReplaceValueStream.replaceValues((InputStream)yamlFiletoReplace, mapVar));
            }
            catch (IOException e) {
                this.log.severe(e.getMessage());
            }
        });
        return (InputStream)result.get();
    }

    public String deleteNamespace() {
        AtomicReference result = new AtomicReference();
        Optional.ofNullable(this.kubeCtl).ifPresent(api -> result.set(((Resource)api.namespaces().withName(this.nameSpace)).delete() != false ? "@OK@" : "@Error@"));
        return (String)result.get();
    }

    private String deleteYaml(InputStream yamlFile) {
        AtomicReference<String> result = new AtomicReference<String>();
        result.set("");
        try {
            if (this.kubeCtl != null) {
                yamlFile = this.replaceVariables(yamlFile);
                List resourcesDef = (List)this.kubeCtl.load(yamlFile).get();
                Optional.ofNullable(((ListVisitFromServerGetDeleteRecreateWaitApplicable)this.kubeCtl.resourceList((Collection)resourcesDef).inNamespace(this.nameSpace)).delete()).ifPresent(isDeleted -> {
                    if (isDeleted.booleanValue()) {
                        result.set("@Deleted@ -> ");
                        result.getAndAccumulate(resourcesDef.stream().map(resource -> resource.getKind() + " -> " + resource.getMetadata().getName()).collect(Collectors.joining(", ", " [ ", " ] ")), this.concat);
                    } else {
                        result.set("@Failed@ -> ");
                        result.getAndAccumulate(resourcesDef.stream().map(resource -> resource.getKind() + " -> " + resource.getMetadata().getName()).collect(Collectors.joining(", ", " [ ", " ] ")), this.concat);
                    }
                });
                this.log.fine((String)result.get());
            }
        }
        catch (Exception e) {
            result.set(e.getMessage());
            this.log.severe(e.getMessage());
        }
        return (String)result.get();
    }
}

