/*
 * Decompiled with CFR 0.152.
 */
package org.spin.util.support.k8;

import io.fabric8.kubernetes.client.utils.IOHelpers;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;

public class FileHandler {
    private LinkedHashMap<String, String> parameters = new LinkedHashMap();
    private Logger log = Logger.getLogger(FileHandler.class.getName());
    private URL url;
    private URLConnection urlConn;
    private InputStream fileImputStream;
    private File file;

    public FileHandler(String URL2, boolean isURL) {
        if (isURL) {
            try {
                this.url = new URL(URL2);
            }
            catch (MalformedURLException e) {
                this.log.severe(e.getMessage());
            }
        } else {
            this.file = new File(URL2);
        }
    }

    public FileHandler(InputStream fileImputStream) {
        this.fileImputStream = fileImputStream;
    }

    public FileHandler withParameter(String key, String value) {
        this.parameters.put(key, value);
        return this;
    }

    private void callURL() {
        if (!Optional.ofNullable(this.urlConn).isPresent()) {
            Optional.ofNullable(this.url).ifPresent(url -> {
                try {
                    this.urlConn = url.openConnection();
                    Optional.ofNullable(this.parameters).ifPresent(item -> item.entrySet().forEach(headerItem -> this.urlConn.setRequestProperty((String)headerItem.getKey(), (String)headerItem.getValue())));
                }
                catch (IOException e) {
                    this.log.severe(e.getMessage());
                }
            });
        }
    }

    public InputStream getFileStream() {
        if (!Optional.ofNullable(this.fileImputStream).isPresent()) {
            Optional.ofNullable(this.url).ifPresent(url -> {
                this.callURL();
                try {
                    this.fileImputStream = this.urlConn.getInputStream();
                }
                catch (IOException e) {
                    this.log.severe(e.getMessage());
                    e.printStackTrace();
                }
            });
            Optional.ofNullable(this.file).ifPresent(file -> {
                try {
                    this.fileImputStream = new DataInputStream(new FileInputStream((File)file));
                }
                catch (FileNotFoundException e) {
                    this.log.severe(e.getMessage());
                    e.printStackTrace();
                }
            });
        }
        return this.fileImputStream;
    }

    public String getTextContent() {
        AtomicReference<String> result = new AtomicReference<String>("");
        Optional.ofNullable(this.getFileStream()).ifPresent(file -> {
            try {
                result.set(IOHelpers.readFully((InputStream)file));
            }
            catch (IOException e) {
                this.log.severe(e.getMessage());
            }
        });
        return result.get();
    }
}

