/*
 * Decompiled with CFR 0.152.
 */
package org.spin.tcs.util;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Optional;
import java.util.Properties;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProduct;
import org.compiere.model.MResource;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.compiere.util.Util;

public class TimeControlChanges {
    public static final String COLUMNNAME_ECA45_SurchargeProduct_ID = "ECA45_SurchargeProduct_ID";
    public static final String COLUMNNAME_ECA45_SurchargeMaxQuantity = "ECA45_SurchargeMaxQuantity";
    public static final String COLUMNNAME_ECA45_FractionQuantity = "ECA45_FractionQuantity";
    public static final String COLUMNNAME_ECA45_SourceOrderLine_ID = "ECA45_SourceOrderLine_ID";
    public static final BigDecimal MINUTES = new BigDecimal(60);

    public static void validateHoursFromResource(MOrderLine orderLine) {
        if (orderLine.get_ValueAsInt(COLUMNNAME_ECA45_SourceOrderLine_ID) > 0) {
            return;
        }
        if (orderLine.getS_ResourceAssignment_ID() <= 0) {
            return;
        }
        if (orderLine.getM_Product_ID() <= 0) {
            return;
        }
        MProduct product = MProduct.get((Properties)orderLine.getCtx(), (int)orderLine.getM_Product_ID());
        if (product.getS_Resource_ID() <= 0) {
            return;
        }
        MResource resource = MResource.get((Properties)orderLine.getCtx(), (int)product.getS_Resource_ID());
        if (resource.get_ValueAsInt(COLUMNNAME_ECA45_SurchargeProduct_ID) <= 0) {
            return;
        }
        BigDecimal surchargeMaximumQuantity = Optional.ofNullable((BigDecimal)resource.get_Value(COLUMNNAME_ECA45_SurchargeMaxQuantity)).orElse(Env.ZERO);
        BigDecimal surchargeFractionQuantity = Optional.ofNullable((BigDecimal)resource.get_Value(COLUMNNAME_ECA45_FractionQuantity)).orElse(Env.ZERO);
        if (surchargeMaximumQuantity.compareTo(Env.ZERO) <= 0) {
            return;
        }
        if (surchargeFractionQuantity.compareTo(Env.ZERO) <= 0) {
            return;
        }
        BigDecimal quantityEntered = Optional.ofNullable(orderLine.getQtyOrdered()).orElse(Env.ZERO);
        BigDecimal fractionalPart = quantityEntered.remainder(Env.ONE);
        if (fractionalPart.compareTo(Env.ZERO) > 0) {
            quantityEntered = quantityEntered.subtract(fractionalPart);
            BigDecimal surchargeQuantity = TimeControlChanges.getSurchargeQuantity(fractionalPart = fractionalPart.multiply(MINUTES), surchargeFractionQuantity, surchargeMaximumQuantity);
            if (surchargeQuantity.compareTo(Env.ZERO) > 0) {
                quantityEntered = quantityEntered.add(surchargeQuantity);
                fractionalPart = Env.ZERO;
            }
            orderLine.setQty(quantityEntered);
            orderLine.saveEx();
            MOrderLine fractionOrderLine = TimeControlChanges.getFractionReferenceOrderLine(orderLine);
            if (fractionalPart.compareTo(Env.ZERO) > 0) {
                if (fractionOrderLine == null) {
                    fractionOrderLine = new MOrderLine(orderLine.getCtx(), 0, orderLine.get_TrxName());
                }
                fractionOrderLine.setC_Order_ID(orderLine.getC_Order_ID());
                fractionOrderLine.setM_Product_ID(resource.get_ValueAsInt(COLUMNNAME_ECA45_SurchargeProduct_ID));
                fractionOrderLine.setQty(TimeControlChanges.getSurchargeFractionQuantity(fractionalPart, surchargeFractionQuantity, surchargeMaximumQuantity));
                fractionOrderLine.set_ValueOfColumn(COLUMNNAME_ECA45_SourceOrderLine_ID, (Object)orderLine.getC_OrderLine_ID());
                if (!Util.isEmpty((String)orderLine.getDescription())) {
                    fractionOrderLine.setDescription(orderLine.getDescription());
                }
                fractionOrderLine.saveEx();
            } else if (fractionOrderLine != null) {
                fractionOrderLine.deleteEx(true);
            }
        }
    }

    private static BigDecimal getSurchargeFractionQuantity(BigDecimal fractionalPart, BigDecimal surchargeFractionQuantity, BigDecimal surchargeMaximumQuantity) {
        if (fractionalPart.compareTo(surchargeFractionQuantity) <= 0) {
            return Env.ONE;
        }
        if (fractionalPart.compareTo(surchargeMaximumQuantity) > 0) {
            return Env.ZERO;
        }
        return fractionalPart.divide(surchargeFractionQuantity, 0, RoundingMode.UP);
    }

    private static BigDecimal getSurchargeQuantity(BigDecimal fractionalPart, BigDecimal surchargeFractionQuantity, BigDecimal surchargeMaximumQuantity) {
        if (fractionalPart.compareTo(surchargeMaximumQuantity) > 0) {
            return Env.ONE;
        }
        return Env.ZERO;
    }

    public static void deleteFractionReference(MOrderLine orderLine) {
        if (orderLine.get_ValueAsInt(COLUMNNAME_ECA45_SourceOrderLine_ID) > 0) {
            return;
        }
        if (orderLine.getS_ResourceAssignment_ID() <= 0) {
            return;
        }
        if (orderLine.getM_Product_ID() <= 0) {
            return;
        }
        MProduct product = MProduct.get((Properties)orderLine.getCtx(), (int)orderLine.getM_Product_ID());
        if (product.getS_Resource_ID() <= 0) {
            return;
        }
        MResource resource = MResource.get((Properties)orderLine.getCtx(), (int)product.getS_Resource_ID());
        if (resource.get_ValueAsInt(COLUMNNAME_ECA45_SurchargeProduct_ID) <= 0) {
            return;
        }
        MOrderLine fractionReference = TimeControlChanges.getFractionReferenceOrderLine(orderLine);
        if (fractionReference != null) {
            fractionReference.deleteEx(true);
        }
    }

    public static MOrderLine getFractionReferenceOrderLine(MOrderLine orderLine) {
        return (MOrderLine)new Query(orderLine.getCtx(), "C_OrderLine", "ECA45_SourceOrderLine_ID = ?", orderLine.get_TrxName()).setParameters(new Object[]{orderLine.getC_OrderLine_ID()}).setClient_ID().first();
    }
}

