/*
 * Decompiled with CFR 0.152.
 */
package org.spin.rmr.model.validator;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.exceptions.DocTypeNotFoundException;
import org.compiere.model.MClient;
import org.compiere.model.MDocType;
import org.compiere.model.MLocator;
import org.compiere.model.MMovement;
import org.compiere.model.MMovementLine;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProduct;
import org.compiere.model.MStorage;
import org.compiere.model.MWarehouse;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.eevolution.model.MDDFreight;
import org.eevolution.model.MDDOrder;
import org.eevolution.model.MDDOrderLine;
import org.eevolution.model.MWMInOutBound;
import org.eevolution.model.MWMInOutBoundLine;
import org.spin.rw.model.MDDRecordWeight;

public class RawMaterialManagement
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(RawMaterialManagement.class);
    private int clientId = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.clientId = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addDocValidate("DD_RecordWeight", (ModelValidator)this);
        engine.addDocValidate("WM_InOutBound", (ModelValidator)this);
        engine.addDocValidate("M_Movement", (ModelValidator)this);
        engine.addModelChange("DD_RecordWeight", (ModelValidator)this);
        engine.addModelChange("RM_QualityAnalysis", (ModelValidator)this);
    }

    public int getAD_Client_ID() {
        return this.clientId;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    public String docValidate(PO po, int timing) {
        String error = null;
        if (po.get_TableName().equals("DD_RecordWeight")) {
            MDDRecordWeight recordWeight = (MDDRecordWeight)po;
            if (timing == 8) {
                if (recordWeight.getC_Order_ID() != 0) {
                    MOrder order = new MOrder(recordWeight.getCtx(), recordWeight.getC_Order_ID(), recordWeight.get_TrxName());
                    if (!order.getDocStatus().equals("CO")) {
                        throw new AdempiereException("@C_Order_ID@ @CreateShipment.OrderNotCompleted@");
                    }
                    if (!recordWeight.isSOTrx()) {
                        if (recordWeight.getC_OrderLine_ID() != 0) {
                            MOrderLine orderLine = new MOrderLine(recordWeight.getCtx(), recordWeight.getC_OrderLine_ID(), recordWeight.get_TrxName());
                            this.createExpressReceipt(recordWeight, orderLine);
                        } else {
                            for (MOrderLine orderLine : order.getLines()) {
                                this.createExpressReceipt(recordWeight, orderLine);
                            }
                        }
                    }
                }
            } else if (timing == 9) {
                if (recordWeight.getC_Order_ID() != 0) {
                    List<MOrderLine> orderLines;
                    MOrder order = new MOrder(recordWeight.getCtx(), recordWeight.getC_Order_ID(), recordWeight.get_TrxName());
                    if (!order.getDocStatus().equals("CO")) {
                        throw new AdempiereException("@C_Order_ID@ @CreateShipment.OrderNotCompleted@");
                    }
                    int orderLineId = 0;
                    if (recordWeight.getC_OrderLine_ID() != 0) {
                        orderLineId = recordWeight.getC_OrderLine_ID();
                    } else if (recordWeight.getC_Order_ID() != 0 && (orderLines = Arrays.asList(order.getLines())).size() == 1) {
                        orderLineId = ((MOrderLine)orderLines.stream().findFirst().get()).getC_OrderLine_ID();
                    }
                    if (orderLineId != 0) {
                        MOrderLine orderLine = new MOrderLine(recordWeight.getCtx(), orderLineId, recordWeight.get_TrxName());
                        if (!recordWeight.isSOTrx()) {
                            MProduct product;
                            MWMInOutBoundLine inboundLine2 = (MWMInOutBoundLine)new Query(recordWeight.getCtx(), "WM_InOutBoundLine", "C_OrderLine_ID = ? AND EXISTS(SELECT 1 FROM WM_InOutBound ob WHERE ob.Processed = 'N' AND ob.WM_InOutBound_ID = WM_InOutBoundLine.WM_InOutBound_ID AND ob.DD_RecordWeight_ID = ?)", recordWeight.get_TrxName()).setParameters(new Object[]{orderLineId, recordWeight.getDD_RecordWeight_ID()}).setClient_ID().first();
                            if (inboundLine2 != null && inboundLine2.getWM_InOutBoundLine_ID() != 0 && (product = MProduct.get((Properties)recordWeight.getCtx(), (int)orderLine.getM_Product_ID())).get_ValueAsBoolean("IsBulkProduct")) {
                                inboundLine2.setMovementQty(recordWeight.getConvertedWeight(product.getM_Product_ID()));
                                inboundLine2.saveEx();
                            }
                        } else {
                            MProduct product;
                            MWMInOutBoundLine inboundLine3 = (MWMInOutBoundLine)new Query(recordWeight.getCtx(), "WM_InOutBoundLine", "C_OrderLine_ID = ? AND EXISTS(SELECT 1 FROM WM_InOutBound ob WHERE ob.WM_InOutBound_ID = WM_InOutBoundLine.WM_InOutBound_ID)", recordWeight.get_TrxName()).setParameters(new Object[]{orderLineId}).setClient_ID().first();
                            if (inboundLine3 != null && inboundLine3.getWM_InOutBoundLine_ID() != 0 && (product = MProduct.get((Properties)recordWeight.getCtx(), (int)orderLine.getM_Product_ID())).get_ValueAsBoolean("IsBulkProduct")) {
                                inboundLine3.setPickedQty(recordWeight.getConvertedWeight(product.getM_Product_ID()));
                                inboundLine3.saveEx();
                            }
                        }
                    }
                } else if (recordWeight.getDD_Freight_ID() != 0) {
                    MDDFreight freightOrder;
                    if (recordWeight.isSOTrx() && (freightOrder = (MDDFreight)recordWeight.getDD_Freight()).getWM_InOutBound_ID() != 0) {
                        MWMInOutBound outBound = (MWMInOutBound)freightOrder.getWM_InOutBound();
                        outBound.getLines(true, "Line").stream().filter(outBoundLine -> outBoundLine.getM_Product_ID() != 0 && MProduct.get((Properties)recordWeight.getCtx(), (int)outBoundLine.getM_Product_ID()).get_ValueAsBoolean("IsBulkProduct")).forEach(outBoundLine -> {
                            outBoundLine.setPickedQty(recordWeight.getConvertedWeight(outBoundLine.getM_Product_ID()));
                            outBoundLine.saveEx();
                        });
                    }
                    this.createInventoryMovement(recordWeight);
                }
            } else if (timing == 10 || timing == 12 || timing == 13) {
                this.reversedInventoryMovement(recordWeight);
            }
        } else if (po.get_TableName().equals("WM_InOutBound") && timing == 1) {
            MWMInOutBound inbound = (MWMInOutBound)po;
            if (inbound.get_ValueAsInt("DD_RecordWeight_ID") != 0 && !inbound.isSOTrx()) {
                List inboundLines;
                MDDRecordWeight recordWeight = new MDDRecordWeight(inbound.getCtx(), inbound.get_ValueAsInt("DD_RecordWeight_ID"), inbound.get_TrxName());
                if (!recordWeight.getDocStatus().equals("CO")) {
                    throw new AdempiereException("@RecordWeight.UnComplete@");
                }
                if (!recordWeight.getWeightStatus().equals("C")) {
                    throw new AdempiereException("@IncompleteRecordWeight@");
                }
                int orderLineId = 0;
                if (recordWeight.getC_OrderLine_ID() != 0) {
                    orderLineId = recordWeight.getC_OrderLine_ID();
                } else if (recordWeight.getC_Order_ID() != 0) {
                    MOrder order = (MOrder)recordWeight.getC_Order();
                    List<MOrderLine> orderLines = Arrays.asList(order.getLines());
                    if (orderLines.size() == 1) {
                        orderLineId = ((MOrderLine)orderLines.stream().findFirst().get()).getC_OrderLine_ID();
                    } else if (orderLines.size() == 0 && (inboundLines = inbound.getLines(true, null)).size() == 0) {
                        throw new AdempiereException("@NoLines@");
                    }
                } else {
                    List inboundLines2 = inbound.getLines(true, null);
                    if (inboundLines2.size() == 0) {
                        throw new AdempiereException("@NoLines@");
                    }
                }
                if (orderLineId != 0) {
                    MOrderLine orderLine = new MOrderLine(recordWeight.getCtx(), orderLineId, recordWeight.get_TrxName());
                    MProduct product = MProduct.get((Properties)recordWeight.getCtx(), (int)orderLine.getM_Product_ID());
                    if (product.get_ValueAsBoolean("IsBulkProduct")) {
                        inboundLines = inbound.getLines(true, null);
                        if (inboundLines.size() > 1) {
                            inboundLines.stream().filter(inboundLine -> inboundLine.getC_OrderLine_ID() != orderLine.getC_OrderLine_ID()).forEach(inboundLine -> inboundLine.deleteEx(true));
                        }
                        Optional<MWMInOutBoundLine> optional = inboundLines.stream().filter(inboundLine -> inboundLine.getC_OrderLine_ID() == orderLine.getC_OrderLine_ID()).findFirst();
                        MWMInOutBoundLine lineToUpdate = null;
                        if (optional.isPresent()) {
                            lineToUpdate = optional.get();
                        }
                        if (lineToUpdate == null) {
                            lineToUpdate = new MWMInOutBoundLine(inbound, orderLine);
                            lineToUpdate.setMovementQty(lineToUpdate.getQtyToDeliver());
                        }
                        lineToUpdate.setLine(10);
                        lineToUpdate.setDescription(Msg.parseTranslation((Properties)recordWeight.getCtx(), (String)("@DD_RecordWeight_ID@: " + recordWeight.getDocumentNo())));
                        lineToUpdate.setMovementQty(recordWeight.getConvertedWeight(product.getM_Product_ID()));
                        lineToUpdate.saveEx();
                    }
                }
            }
            if (inbound.isSOTrx()) {
                inbound.getLines(true, "Line").stream().filter(outboundLine -> outboundLine.getM_Locator_ID() == 0 || outboundLine.getM_LocatorTo_ID() == 0).forEach(outboundLine -> {
                    int locatorId;
                    if (outboundLine.getM_LocatorTo_ID() == 0 && (locatorId = MStorage.getM_Locator_ID((int)outboundLine.getM_Warehouse_ID(), (int)outboundLine.getM_Product_ID(), (int)outboundLine.getM_AttributeSetInstance_ID(), (BigDecimal)outboundLine.getMovementQty(), (String)inbound.get_TrxName())) > 0) {
                        outboundLine.setM_LocatorTo_ID(locatorId);
                    }
                    outboundLine.saveEx();
                });
            }
        }
        if (po.get_TableName().equals("M_Movement") && (timing == 2 || timing == 5)) {
            Optional.ofNullable(po).ifPresent(document -> {
                MDDRecordWeight recordWeight;
                if (document.get_ValueAsInt("DD_RecordWeight_ID") > 0 && ((recordWeight = new MDDRecordWeight(document.getCtx(), document.get_ValueAsInt("DD_RecordWeight_ID"), document.get_TrxName())).getDocStatus().compareTo("CO") == 0 || recordWeight.getDocStatus().compareTo("CL") == 0)) {
                    throw new AdempiereException("@SQLErrorReferenced@ -> @DD_RecordWeight_ID@: ".concat(recordWeight.getDocumentNo()));
                }
            });
        }
        return error;
    }

    private void createExpressReceipt(MDDRecordWeight recordWeight, MOrderLine orderLine) {
        MWMInOutBound inbound = (MWMInOutBound)new Query(recordWeight.getCtx(), "WM_InOutBound", "DD_RecordWeight_ID = ? AND Processed = 'N'", recordWeight.get_TrxName()).setParameters(new Object[]{recordWeight.getDD_RecordWeight_ID()}).setClient_ID().first();
        if (inbound != null && inbound.getWM_InOutBound_ID() != 0) {
            MOrder order;
            List<MOrderLine> orderLines;
            int orderLineId = 0;
            if (recordWeight.getC_OrderLine_ID() != 0) {
                orderLineId = recordWeight.getC_OrderLine_ID();
            } else if (recordWeight.getC_Order_ID() != 0 && (orderLines = Arrays.asList((order = (MOrder)recordWeight.getC_Order()).getLines())).size() == 1) {
                orderLineId = ((MOrderLine)orderLines.stream().findFirst().get()).getC_OrderLine_ID();
            }
            MWMInOutBoundLine inboundLine = (MWMInOutBoundLine)new Query(recordWeight.getCtx(), "WM_InOutBoundLine", "WM_InOutBound_ID = ? AND C_OrderLine_ID = ?", recordWeight.get_TrxName()).setParameters(new Object[]{inbound.getWM_InOutBound_ID(), orderLineId}).setClient_ID().first();
            if (inboundLine == null || inboundLine.getWM_InOutBoundLine_ID() == 0) {
                MLocator locator = null;
                if (recordWeight.get_ValueAsInt("M_Locator_ID") > 0) {
                    locator = MLocator.get((Properties)recordWeight.getCtx(), (int)recordWeight.get_ValueAsInt("M_Locator_ID"));
                }
                inboundLine = new MWMInOutBoundLine(inbound);
                inboundLine = new MWMInOutBoundLine(inbound, orderLine);
                inboundLine.setMovementQty(inboundLine.getQtyToDeliver());
                inboundLine.setLine(10);
                inboundLine.setDescription(Msg.parseTranslation((Properties)recordWeight.getCtx(), (String)("@DD_RecordWeight_ID@: " + recordWeight.getDocumentNo())));
                if (locator != null) {
                    inboundLine.setM_Locator_ID(locator.get_ID());
                }
                inboundLine.saveEx();
            }
        } else {
            Optional<MDocType> defaultDocumentType;
            inbound = new MWMInOutBound(recordWeight.getCtx(), 0, recordWeight.get_TrxName());
            inbound.setShipDate(recordWeight.getDateDoc());
            inbound.setPickDate(recordWeight.getDateDoc());
            inbound.setDateTrx(recordWeight.getDateDoc());
            if (!Util.isEmpty((String)orderLine.getParent().getDocumentNo())) {
                inbound.setPOReference(orderLine.getParent().getDocumentNo());
            }
            if (!(defaultDocumentType = Arrays.asList(MDocType.getOfDocBaseType((Properties)Env.getCtx(), (String)"WMO")).stream().filter(documentType -> !documentType.isSOTrx()).findFirst()).isPresent()) {
                throw new DocTypeNotFoundException("WMO", "");
            }
            inbound.setC_DocType_ID(defaultDocumentType.get().getC_DocType_ID());
            inbound.setDocAction("PR");
            inbound.setDocStatus("DR");
            if (recordWeight.getM_Warehouse_ID() == 0) {
                throw new AdempiereException("@FillMandatory@ @M_Warehouse_ID@");
            }
            inbound.setM_Warehouse_ID(recordWeight.getM_Warehouse_ID());
            MLocator locator = null;
            locator = recordWeight.get_ValueAsInt("M_Locator_ID") > 0 ? MLocator.get((Properties)recordWeight.getCtx(), (int)recordWeight.get_ValueAsInt("M_Locator_ID")) : MWarehouse.get((Properties)recordWeight.getCtx(), (int)recordWeight.getM_Warehouse_ID()).getDefaultLocator();
            if (locator != null) {
                inbound.setM_Locator_ID(locator.getM_Locator_ID());
            }
            inbound.setIsSOTrx(false);
            inbound.set_ValueOfColumn("DD_RecordWeight_ID", (Object)recordWeight.getDD_RecordWeight_ID());
            inbound.saveEx();
            MWMInOutBoundLine inboundLine = new MWMInOutBoundLine(inbound);
            inboundLine = new MWMInOutBoundLine(inbound, orderLine);
            if (locator != null) {
                inboundLine.setM_Locator_ID(locator.get_ID());
            }
            inboundLine.setMovementQty(inboundLine.getQtyToDeliver());
            inboundLine.setLine(10);
            inboundLine.setDescription(Msg.parseTranslation((Properties)recordWeight.getCtx(), (String)("@DD_RecordWeight_ID@: " + recordWeight.getDocumentNo())));
            inboundLine.saveEx();
        }
    }

    public String modelChange(PO entity, int type) throws Exception {
        AtomicReference<Object> returnValue = new AtomicReference<Object>(null);
        Optional.ofNullable(entity).ifPresent(document -> {
            MDDFreight freightOrder;
            if ((type == 1 || type == 2) && (document.get_TableName().equals("DD_RecordWeight") || document.get_TableName().equals("RM_QualityAnalysis")) && (document.is_ValueChanged("DD_Freight_ID") || document.is_new()) && (freightOrder = new MDDFreight(entity.getCtx(), entity.get_ValueAsInt("DD_Freight_ID"), entity.get_TrxName())).getDD_Order_ID() > 0) {
                MDDOrder ddOrder = new MDDOrder(entity.getCtx(), freightOrder.getDD_Order_ID(), entity.get_TrxName());
                if (ddOrder.getDocStatus().compareTo("CO") == 0) {
                    entity.set_ValueOfColumn("C_Order_ID", (Object)0);
                    entity.set_ValueOfColumn("C_OrderLine_ID", (Object)0);
                    entity.set_ValueOfColumn("DD_Order_ID", (Object)freightOrder.getDD_Order_ID());
                    String whereClause = "DD_Order_ID = ? AND EXISTS(SELECT 1 FROM DD_FreightLine fl WHERE fl.DD_Freight_ID = ? AND fl.M_Product_ID = DD_OrderLine.M_Product_ID)";
                    Optional.ofNullable(new Query(entity.getCtx(), "DD_OrderLine", whereClause, entity.get_TrxName()).setParameters(new Object[]{freightOrder.getDD_Order_ID(), freightOrder.getDD_Freight_ID()}).first()).ifPresent(ddOrderLine -> entity.set_ValueOfColumn("DD_OrderLine_ID", (Object)ddOrderLine.get_ID()));
                } else {
                    returnValue.set("@DD_Order_ID@ <> ".concat("CO"));
                }
            }
        });
        return returnValue.get();
    }

    private void createInventoryMovement(MDDRecordWeight recordWeight) {
        if (recordWeight.get_ValueAsInt("DD_Order_ID") > 0 && recordWeight.get_ValueAsInt("DD_OrderLine_ID") > 0) {
            MDDOrder ddOrder = new MDDOrder(recordWeight.getCtx(), recordWeight.get_ValueAsInt("DD_Order_ID"), recordWeight.get_TrxName());
            if (ddOrder.getDocStatus().compareTo("CO") == 0) {
                MLocator locatorTo;
                MDDOrderLine ddOrderLine = new MDDOrderLine(recordWeight.getCtx(), recordWeight.get_ValueAsInt("DD_OrderLine_ID"), recordWeight.get_TrxName());
                MMovement movement = new MMovement(ddOrder, recordWeight.getOutDate());
                movement.set_ValueOfColumn("DD_RecordWeight_ID", (Object)recordWeight.get_ID());
                movement.saveEx();
                MMovementLine movementLine = new MMovementLine(movement);
                movementLine.setOrderLine(ddOrderLine, recordWeight.getConvertedWeight(ddOrderLine.getM_Product_ID()), !recordWeight.isSOTrx());
                movementLine.set_ValueOfColumn("DD_RecordWeight_ID", (Object)recordWeight.get_ID());
                if (recordWeight.getM_Warehouse_ID() > 0 && (locatorTo = Optional.ofNullable(MLocator.get((Properties)recordWeight.getCtx(), (int)recordWeight.get_ValueAsInt("M_Locator_ID"))).orElse(MLocator.getDefault((MWarehouse)MWarehouse.get((Properties)recordWeight.getCtx(), (int)recordWeight.getM_Warehouse_ID())))) != null) {
                    movementLine.setM_LocatorTo_ID(locatorTo.get_ID());
                }
                movementLine.saveEx();
                movement.processIt("CO");
                movement.saveEx();
            } else {
                throw new AdempiereException("@DD_Order_ID@ @DocStatus@ != ".concat("CO"));
            }
        }
    }

    private void reversedInventoryMovement(MDDRecordWeight recordWeight) {
        if (recordWeight.get_ValueAsInt("DD_Order_ID") > 0) {
            String whereClause = "DD_RecordWeight_ID".concat("=? AND ").concat("DocStatus").concat(" NOT IN (?,?,?)");
            new Query(recordWeight.getCtx(), "M_Movement", whereClause, recordWeight.get_TrxName()).setParameters(new Object[]{recordWeight.get_ID(), "CL", "RE", "VO"}).list().forEach(movement -> {
                movement.set_ValueOfColumn("DD_RecordWeight_ID", (Object)0);
                movement.processIt("RC");
                movement.saveEx();
            });
        }
    }
}

