/*
 * Decompiled with CFR 0.152.
 */
package org.spin.rmr.model;

import java.io.File;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.compiere.model.MAttributeInstance;
import org.compiere.model.MAttributeSet;
import org.compiere.model.MAttributeSetInstance;
import org.compiere.model.MDocType;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MPeriod;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.process.DocAction;
import org.compiere.process.DocOptions;
import org.compiere.process.DocumentEngine;
import org.compiere.util.DB;
import org.compiere.util.Msg;
import org.eevolution.model.MDDOrder;
import org.eevolution.model.MDDOrderLine;
import org.spin.rmr.model.MRMAnalysisAttributes;
import org.spin.rmr.model.X_RM_QualityAnalysis;

public class MRMQualityAnalysis
extends X_RM_QualityAnalysis
implements DocAction,
DocOptions {
    private static final long serialVersionUID = 20190709L;
    private List<MRMAnalysisAttributes> attributesList = null;
    private String m_processMsg = null;
    private boolean m_justPrepared = false;

    public MRMQualityAnalysis(Properties ctx, int RM_QualityAnalysis_ID, String trxName) {
        super(ctx, RM_QualityAnalysis_ID, trxName);
    }

    public MRMQualityAnalysis(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public String getDocumentInfo() {
        MDocType dt = MDocType.get((Properties)this.getCtx(), (int)this.getC_DocType_ID());
        return dt.getName() + " " + this.getDocumentNo();
    }

    public File createPDF() {
        try {
            File temp = File.createTempFile(this.get_TableName() + this.get_ID() + "_", ".pdf");
            return this.createPDF(temp);
        }
        catch (Exception e) {
            this.log.severe("Could not create PDF - " + e.getMessage());
            return null;
        }
    }

    public File createPDF(File file) {
        return null;
    }

    public boolean processIt(String processAction) {
        this.m_processMsg = null;
        DocumentEngine engine = new DocumentEngine((DocAction)this, this.getDocStatus());
        return engine.processIt(processAction, this.getDocAction());
    }

    public boolean unlockIt() {
        this.log.info("unlockIt - " + this.toString());
        return true;
    }

    public boolean invalidateIt() {
        this.log.info("invalidateIt - " + this.toString());
        this.setDocAction("PR");
        return true;
    }

    public String prepareIt() {
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 1);
        if (this.m_processMsg != null) {
            return "IN";
        }
        this.m_processMsg = this.validateProduct();
        if (this.m_processMsg != null) {
            return "IN";
        }
        MDocType dt = MDocType.get((Properties)this.getCtx(), (int)this.getC_DocType_ID());
        if (!MPeriod.isOpen((Properties)this.getCtx(), (Timestamp)this.getDateDoc(), (String)dt.getDocBaseType(), (int)this.getAD_Org_ID())) {
            this.m_processMsg = "@PeriodClosed@";
            return "IN";
        }
        if (this.getQualityAnalysis_ID() == 0) {
            this.m_processMsg = "@QualityAnalysis_ID@ @NotFound@";
            return "IN";
        }
        this.processAttributes();
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 8);
        if (this.m_processMsg != null) {
            return "IN";
        }
        this.m_justPrepared = true;
        if (!"CO".equals(this.getDocAction())) {
            this.setDocAction("CO");
        }
        return "IP";
    }

    public List<MRMAnalysisAttributes> getAnalysisAttributes(boolean requery) {
        if (this.attributesList == null || requery) {
            this.attributesList = new Query(this.getCtx(), "RM_AnalysisAttributes", "RM_QualityAnalysis_ID = ?", this.get_TrxName()).setParameters(new Object[]{this.getRM_QualityAnalysis_ID()}).list();
        }
        return this.attributesList;
    }

    private void processAttributes() {
        this.getAnalysisAttributes(true).forEach(attribute -> attribute.deleteEx(true));
        if (this.getQualityAnalysis_ID() > 0) {
            MAttributeSetInstance instanceSet = new MAttributeSetInstance(this.getCtx(), this.getQualityAnalysis_ID(), this.get_TrxName());
            MAttributeSet attributeSet = instanceSet.getMAttributeSet();
            Arrays.asList(attributeSet.getMAttributes(true)).forEach(attribute -> {
                MAttributeInstance instance = attribute.getMAttributeInstance(this.getQualityAnalysis_ID());
                if (instance != null) {
                    MRMAnalysisAttributes analysisAttribute = new MRMAnalysisAttributes(this.getCtx(), 0, this.get_TrxName());
                    analysisAttribute.setRM_QualityAnalysis_ID(this.getRM_QualityAnalysis_ID());
                    analysisAttribute.setCode(attribute.get_ValueAsString("Value"));
                    if (attribute.getAttributeValueType().equals("N")) {
                        analysisAttribute.setValueNumber(instance.getValueNumber());
                    } else {
                        analysisAttribute.setValueString(instance.getValue());
                    }
                    analysisAttribute.saveEx();
                }
            });
        }
    }

    public boolean approveIt() {
        this.log.info("approveIt - " + this.toString());
        this.setIsApproved(true);
        return true;
    }

    public boolean rejectIt() {
        this.log.info("rejectIt - " + this.toString());
        this.setIsApproved(false);
        return true;
    }

    public int customizeValidActions(String docStatus, Object processing, String orderType, String isSOTrx, int AD_Table_ID, String[] docAction, String[] options, int index) {
        if (AD_Table_ID == Table_ID) {
            if (docStatus.equals("DR") || docStatus.equals("IP") || docStatus.equals("IN")) {
                options[index++] = "PR";
            } else if (docStatus.equals("CO")) {
                options[index++] = "VO";
                options[index++] = "RE";
                options[index++] = "CL";
            } else if (docStatus.equals("CL")) {
                options[index++] = "--";
            }
        }
        return index;
    }

    public String completeIt() {
        String status;
        if (!this.m_justPrepared && !"IP".equals(status = this.prepareIt())) {
            return status;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 7);
        if (this.m_processMsg != null) {
            return "IN";
        }
        if (!this.isApproved()) {
            this.approveIt();
        }
        this.log.info(this.toString());
        String valid = ModelValidationEngine.get().fireDocValidate((PO)this, 9);
        if (valid != null) {
            this.m_processMsg = valid;
            return "IN";
        }
        this.setDefiniteDocumentNo();
        this.setProcessed(true);
        this.setDocAction("CL");
        return "CO";
    }

    private void setDefiniteDocumentNo() {
        MDocType dt = MDocType.get((Properties)this.getCtx(), (int)this.getC_DocType_ID());
        if (dt.isOverwriteDateOnComplete()) {
            this.setDateDoc(new Timestamp(System.currentTimeMillis()));
        }
        if (dt.isOverwriteSeqOnComplete()) {
            String value = null;
            int index = this.p_info.getColumnIndex("C_DocType_ID");
            if (index == -1) {
                index = this.p_info.getColumnIndex("C_DocTypeTarget_ID");
            }
            if (index != -1) {
                value = DB.getDocumentNo((int)this.get_ValueAsInt(index), (String)this.get_TrxName(), (boolean)true);
            }
            if (value != null) {
                this.setDocumentNo(value);
            }
        }
    }

    public boolean voidIt() {
        this.log.info("voidIt - " + this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 2);
        if (this.m_processMsg != null) {
            return false;
        }
        this.addDescription(Msg.getMsg((Properties)this.getCtx(), (String)"Voided"));
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 10);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setProcessed(true);
        this.setDocAction("--");
        return true;
    }

    public void addDescription(String description) {
        String desc = this.getDescription();
        if (desc == null) {
            this.setDescription(description);
        } else {
            this.setDescription(desc + " | " + description);
        }
    }

    public boolean closeIt() {
        this.log.info("closeIt - " + this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 3);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setProcessed(true);
        this.setDocAction("--");
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 11);
        return this.m_processMsg == null;
    }

    public boolean reverseCorrectIt() {
        this.log.info("reverseCorrectIt - " + this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 5);
        if (this.m_processMsg != null) {
            return false;
        }
        this.voidIt();
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 13);
        if (this.m_processMsg != null) {
            return false;
        }
        return false;
    }

    public boolean reverseAccrualIt() {
        this.log.info("reverseAccrualIt - " + this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 6);
        if (this.m_processMsg != null) {
            return false;
        }
        this.voidIt();
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 14);
        if (this.m_processMsg != null) {
            return false;
        }
        return false;
    }

    public boolean reActivateIt() {
        this.log.info("reActivateIt - " + this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 4);
        if (this.m_processMsg != null) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 12);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setDocAction("CO");
        this.setProcessed(false);
        return true;
    }

    public String getProcessMsg() {
        return this.m_processMsg;
    }

    public int getDoc_User_ID() {
        return 0;
    }

    public BigDecimal getApprovalAmt() {
        return null;
    }

    public int getC_Currency_ID() {
        return 0;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MRMQualityAnalysis[").append(this.getSummary()).append("]");
        return sb.toString();
    }

    public String getSummary() {
        return null;
    }

    private String validateProduct() {
        MDDOrder ddorder;
        MDDOrderLine ddOrderLine;
        MOrder order;
        MOrderLine orderLine;
        if (this.getC_OrderLine_ID() > 0 ? (orderLine = (MOrderLine)this.getC_OrderLine()).getM_Product_ID() != this.getM_Product_ID() : (this.getC_Order_ID() > 0 ? (order = (MOrder)this.getC_Order()).getLines(" AND M_Product_ID = " + this.getM_Product_ID(), "").length == 0 : (this.get_ValueAsInt("DD_OrderLine_ID") > 0 ? (ddOrderLine = new MDDOrderLine(this.getCtx(), this.get_ValueAsInt("DD_OrderLine_ID"), this.get_TrxName())).getM_Product_ID() != this.getM_Product_ID() : this.get_ValueAsInt("DD_Order_ID") > 0 && (ddorder = new MDDOrder(this.getCtx(), this.get_ValueAsInt("DD_Order_ID"), this.get_TrxName())).getLines(" AND M_Product_ID = " + this.getM_Product_ID(), "").size() == 0))) {
            return "@Invalid@ @M_Product_ID@";
        }
        return null;
    }
}

