/*
 * Decompiled with CFR 0.152.
 */
package org.spoin.tools.migration;

import java.util.logging.Level;
import org.compiere.Adempiere;
import org.compiere.model.MMigration;
import org.compiere.model.MMigrationStep;
import org.compiere.model.Query;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Ini;

public class MigrationReApply {
    private static CLogger log = CLogger.getCLogger(MigrationReApply.class);

    public static void main(String[] args) {
        Adempiere.startupEnvironment((boolean)false);
        CLogMgt.setLevel((Level)Level.INFO);
        if (!DB.isConnected()) {
            log.warning("No DB Connection");
            System.exit(1);
        }
        Ini.setProperty((String)"LogMigrationScript", (boolean)false);
        new Query(Env.getCtx(), "AD_Migration", "StatusCode IN(?, ?, ?)", null).setOnlyActiveRecords(true).setParameters(new Object[]{"F", "P", "U"}).setOrderBy("SeqNo").getIDsAsList().forEach(migrationId -> {
            MMigration migration = new MMigration(Env.getCtx(), migrationId.intValue(), null);
            new Query(Env.getCtx(), "AD_MigrationStep", "AD_Migration_ID = ? AND StatusCode IN(?, ?, ?)", null).setOnlyActiveRecords(true).setParameters(new Object[]{migrationId, "F", "P", "U"}).setOrderBy("SeqNo").getIDsAsList().forEach(migrationStepId -> {
                try {
                    MMigrationStep migrationStep = new MMigrationStep(Env.getCtx(), migrationStepId.intValue(), null);
                    String result = migrationStep.apply();
                    log.info("Migration = " + migration.getSeqNo() + " " + migration.getName() + "n/ " + result);
                }
                catch (Exception e) {
                    log.severe("Migration = " + migration.getSeqNo() + " " + migration.getName() + "n/ " + e.getLocalizedMessage());
                }
            });
        });
    }
}

