/*
 * Decompiled with CFR 0.152.
 */
package org.spoin.tools.migration;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.Adempiere;
import org.compiere.model.Query;
import org.compiere.process.GardenWorldCleanUp;
import org.compiere.process.MigrationFromXML;
import org.compiere.process.ProcessInfo;
import org.compiere.process.RoleAccessUpdate;
import org.compiere.process.SequenceCheck;
import org.compiere.process.SynchronizeTerminology;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.Util;
import org.eevolution.service.dsl.ProcessBuilder;

public class MigrationLoader {
    private static CLogger log = CLogger.getCLogger(MigrationLoader.class);

    public static void main(String[] args) {
        boolean isClean = false;
        boolean isForce = false;
        Optional<Object> subPath = Optional.empty();
        List<String> arguments = Arrays.asList(args);
        isClean = arguments.stream().filter(arg -> !Util.isEmpty((String)arg) && arg.matches(".*[/\n\r\t\u0000\f`?*\\<>|\":].*") && arg.equals("clean")).findFirst().isPresent();
        isForce = arguments.stream().filter(arg -> !Util.isEmpty((String)arg) && arg.matches(".*[/\n\r\t\u0000\f`?*\\<>|\":].*") && arg.equals("force")).findFirst().isPresent();
        subPath = Optional.ofNullable(arguments.size() == 4 ? arguments.get(3) : null);
        Optional<String> optionalPath = arguments.stream().filter(arg -> !Util.isEmpty((String)arg) && !arg.equals("force") && !arg.equals("clean")).findFirst();
        String fileName = null;
        if (optionalPath.isPresent() && new File(optionalPath.get()).exists()) {
            fileName = optionalPath.get();
        }
        Adempiere.startupEnvironment((boolean)false);
        CLogMgt.setLevel((Level)Level.INFO);
        if (!DB.isConnected()) {
            log.warning("No DB Connection");
            System.exit(1);
        }
        Ini.setProperty((String)"LogMigrationScript", (boolean)false);
        if (Util.isEmpty((String)fileName)) {
            fileName = Adempiere.getAdempiereHome() + File.separator + "migration";
        }
        boolean apply = true;
        boolean failOnError = true;
        Properties context = Env.getCtx();
        try {
            File root = new File(fileName);
            ProcessInfo processInfo = null;
            if (root.exists() && root.isDirectory() && subPath.isPresent()) {
                String subFolder = (String)subPath.get();
                List<File> filesList = Arrays.asList(root.listFiles());
                filesList.forEach(file -> {
                    Optional<File> maybeXml = Arrays.asList(file.listFiles()).stream().filter(fileTofind -> fileTofind.getName().equals(subFolder)).findFirst();
                    if (maybeXml.isPresent()) {
                        Arrays.asList(maybeXml.get().listFiles()).forEach(migrationPath -> ProcessBuilder.create((Properties)context).process(MigrationFromXML.class).withTitle("Import Migration from XML").withParameter("FailOnError", (Object)failOnError).withParameter("FilePathOrName", (Object)migrationPath.getAbsolutePath()).withParameter("FileName", (Object)migrationPath.getAbsolutePath()).withParameter("Apply", (Object)apply).withParameter("IsForce", (Object)true).withParameter("Clean", (Object)true).execute());
                    }
                });
            } else {
                processInfo = ProcessBuilder.create((Properties)context).process(MigrationFromXML.class).withTitle("Import Migration from XML").withParameter("FailOnError", (Object)failOnError).withParameter("FilePathOrName", (Object)fileName).withParameter("FileName", (Object)fileName).withParameter("Apply", (Object)apply).withParameter("IsForce", (Object)isForce).withParameter("Clean", (Object)isClean).execute();
            }
            log.log(Level.INFO, "Process=" + processInfo.getTitle() + " Error=" + processInfo.isError() + " Summary=" + processInfo.getSummary());
            if (failOnError && processInfo.isError()) {
                throw new AdempiereException(processInfo.getSummary());
            }
            processInfo = ProcessBuilder.create((Properties)context).process(SequenceCheck.class).withTitle("Sequence Check").execute();
            log.log(Level.INFO, "Process=" + processInfo.getTitle() + " Error=" + processInfo.isError() + " Summary=" + processInfo.getSummary());
            processInfo = ProcessBuilder.create((Properties)context).process(SynchronizeTerminology.class).withTitle("Synchronize Terminology").withParameter("IsCreateElement", (Object)false).withParameter("IsDeletingUnusedElement", (Object)false).execute();
            log.log(Level.INFO, "Process=" + processInfo.getTitle() + " Error=" + processInfo.isError() + " Summary=" + processInfo.getSummary());
            new Query(context, "AD_Client", null, null).setOrderBy("AD_Client_ID").list().forEach(client -> {
                ProcessInfo processInfoRoleAccessUpdate = ProcessBuilder.create((Properties)context).process(RoleAccessUpdate.class).withTitle("Role Access Update").withParameter("AD_Client_ID", (Object)client.getAD_Client_ID()).executeUsingSystemRole();
                log.log(Level.INFO, "Process=" + processInfoRoleAccessUpdate.getTitle() + " Client=(" + client.getValue() + " - " + client.getName() + ") Error=" + processInfoRoleAccessUpdate.isError() + " Summary=" + processInfoRoleAccessUpdate.getSummary());
            });
            processInfo = ProcessBuilder.create((Properties)context).process(GardenWorldCleanUp.class).withTitle("Updating Garden World").executeUsingSystemRole();
            log.log(Level.INFO, "Process=" + processInfo.getTitle() + " Error=" + processInfo.isError() + " Summary=" + processInfo.getSummary());
        }
        catch (AdempiereException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

