/*
 * Decompiled with CFR 0.152.
 */
package org.spin.tools.util;

import java.util.List;
import java.util.Properties;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.DB;
import org.compiere.util.Util;
import org.eevolution.service.dsl.ProcessBuilder;

public class CopyUtil {
    private Properties context;
    private String transactionName;
    private int templateClientId;
    private int targetClientId;

    public static CopyUtil newInstance() {
        return new CopyUtil();
    }

    public void runCopyProcess(Class<?> clazz) {
        ProcessBuilder.create((Properties)this.getContext()).process(clazz).withParameter("ECA25_TemplateClient_ID", (Object)this.getTemplateClientId()).withParameter("ECA25_TargetClient_ID", (Object)this.getTargetClientId()).withBatchMode().withoutTransactionClose().execute(this.getTransactionName());
    }

    public int getReferenceId(String tableName, int oldId) {
        return DB.getSQLValueEx((String)this.getTransactionName(), (String)"SELECT ECA25_Target_ID FROM T_ECA25_CopyReference WHERE ECA25_TemplateClient_ID = ? AND ECA25_TargetClient_ID = ? AND TableName = ? AND ECA25_Template_ID = ?", (Object[])new Object[]{this.getTemplateClientId(), this.getTargetClientId(), tableName, oldId});
    }

    public CopyUtil putReferenceId(String tableName, int oldId, int newId) {
        if (Util.isEmpty((String)tableName) || oldId <= 0 || newId <= 0) {
            return this;
        }
        DB.executeUpdateEx((String)"INSERT INTO T_ECA25_CopyReference(ECA25_TemplateClient_ID, ECA25_TargetClient_ID, TableName, ECA25_Template_ID, ECA25_Target_ID) VALUES(?, ?, ?, ?, ?)", (Object[])new Object[]{this.getTemplateClientId(), this.getTargetClientId(), tableName, oldId, newId}, (String)this.getTransactionName());
        return this;
    }

    public void copyCurrentValues(PO source, PO target) {
        PO.copyValues((PO)source, (PO)target);
        target.setIsActive(source.isActive());
    }

    public void saveReference(PO source, PO target) {
        target.set_ValueOfColumn("UUID", (Object)String.valueOf(source.get_ID()));
        target.setIsDirectLoad(true);
        target.saveEx();
        this.putReferenceId(source.get_TableName(), source.get_ID(), target.get_ID());
    }

    public List<Integer> getTemplateReferencesOnlyNewIds(String tableName) {
        String keyColumn = MTable.get((Properties)this.getContext(), (String)tableName).getKeyColumns()[0];
        return new Query(this.getContext(), tableName, "AD_Client_ID = ? AND NOT EXISTS(SELECT 1 FROM T_ECA25_CopyReference r WHERE r.ECA25_TemplateClient_ID = ? AND r.ECA25_TargetClient_ID = ? AND r.TableName = ? AND r.ECA25_Template_ID = " + tableName + "." + keyColumn + ")", this.getTransactionName()).setParameters(new Object[]{this.getTemplateClientId(), this.getTemplateClientId(), this.getTargetClientId(), tableName}).getIDsAsList();
    }

    public List<Integer> getTemplateReferencesIds(String tableName) {
        return new Query(this.getContext(), tableName, "AD_Client_ID = ?", this.getTransactionName()).setParameters(new Object[]{this.getTemplateClientId()}).getIDsAsList();
    }

    public void copyTranslation(PO source, PO target) {
        String tableName = source.get_TableName() + "_Trl";
        MTable.get((Properties)this.getContext(), (int)source.get_Table_ID()).getColumnsAsList().stream().filter(column -> column.isTranslated()).findAny().ifPresent(column -> new Query(this.getContext(), tableName, source.get_KeyColumns()[0] + " = ?", this.getTransactionName()).setParameters(new Object[]{source.get_ID()}).list().forEach(sourceTranslation -> new Query(this.getContext(), tableName, target.get_KeyColumns()[0] + " = ? AND AD_Language = ?", this.getTransactionName()).setParameters(new Object[]{target.get_ID(), sourceTranslation.get_ValueAsString("AD_Language")}).list().forEach(targetTranslation -> {
            MTable.get((Properties)this.getContext(), (int)source.get_Table_ID()).getColumnsAsList().stream().filter(translatedColumn -> translatedColumn.isTranslated()).forEach(translatedColumn -> targetTranslation.set_ValueOfColumn(translatedColumn.getColumnName(), sourceTranslation.get_Value(translatedColumn.getColumnName())));
            targetTranslation.saveEx();
        })));
    }

    public Properties getContext() {
        return this.context;
    }

    public CopyUtil withContext(Properties context) {
        this.context = context;
        return this;
    }

    public String getTransactionName() {
        return this.transactionName;
    }

    public CopyUtil withTransactionName(String transactionName) {
        this.transactionName = transactionName;
        return this;
    }

    public int getTemplateClientId() {
        return this.templateClientId;
    }

    public int getTargetClientId() {
        return this.targetClientId;
    }

    public CopyUtil withTeplateClientId(int teplateClientId) {
        this.templateClientId = teplateClientId;
        return this;
    }

    public CopyUtil withTargetClientId(int targetClientId) {
        this.targetClientId = targetClientId;
        return this;
    }
}

