/*
 * Decompiled with CFR 0.152.
 */
package org.spin.tools.process;

import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import org.adempiere.exceptions.DBException;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MClient;
import org.compiere.model.MDocType;
import org.compiere.model.MLocator;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProduct;
import org.compiere.model.MStorage;
import org.compiere.model.MTransaction;
import org.compiere.model.MWarehouse;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.spin.tools.process.StorageMaintainingAbstract;

public class StorageMaintaining
extends StorageMaintainingAbstract {
    boolean autoPeriod = false;

    protected String doIt() throws Exception {
        MAcctSchema as = MClient.get((Properties)this.getCtx(), (int)this.getAD_Client_ID()).getAcctSchema();
        this.autoPeriod = as != null && as.isAutoPeriodControl();
        StringBuffer deleteSQL = new StringBuffer("DELETE FROM M_Storage WHERE QtyReserved <> 0 AND AD_Client_ID = ").append(this.getAD_Client_ID()).append(" ");
        if (this.getOrgId() != 0) {
            deleteSQL.append("AND AD_Org_ID = ").append(this.getOrgId()).append(" ");
        }
        if (this.getWarehouseId() != 0) {
            deleteSQL.append("AND EXISTS(SELECT 1 FROM M_Locator l WHERE l.M_Locator_ID = M_Storage.M_Locator_ID AND l.M_Warehouse_ID = ").append(this.getWarehouseId()).append(") ");
        }
        if (this.getProductId() != 0) {
            deleteSQL.append("AND M_Product_ID = ").append(this.getProductId()).append(" ");
        }
        if (this.getProductCategoryId() != 0) {
            deleteSQL.append("AND EXISTS (SELECT 1 FROM M_Product WHERE M_Product.M_Product_Category_ID= ").append(this.getProductCategoryId()).append(" AND M_Product.M_Product_ID = M_Storage.M_Product_ID ) ");
        }
        this.log.fine("deleteSQL=" + deleteSQL.toString());
        int storageUpdated = DB.executeUpdate((String)deleteSQL.toString(), (String)this.get_TrxName());
        this.log.fine("Storage Updated=" + storageUpdated);
        int transactionDeleted = 0;
        if (this.isDeleteTransactions()) {
            StringBuffer deleteTSQL = new StringBuffer("DELETE FROM M_Transaction WHERE M_Transaction.M_InOutLine_ID IS NOT NULL  AND M_Transaction.MovementDate BETWEEN ? AND ?  AND ( \t\tEXISTS(SELECT 1 \t\tFROM M_InOut io \t\tINNER JOIN M_InOutLine iol ON(iol.M_InOut_ID = io.M_InOut_ID) \t\tINNER JOIN M_Product p ON(iol.M_Product_ID = p.M_Product_ID) \t\tWHERE io.DocStatus NOT IN('CO', 'CL', 'RE', 'VO') \tAND io.MovementDate BETWEEN ? AND ? AND \t\tiol.M_InOutLine_ID = M_Transaction.M_InOutLine_ID AND p.IsStocked = 'Y' AND p.ProductType = 'I' ) \tOR ( \t\t\tM_Transaction.M_InOutLine_ID IN (SELECT iol.M_InOutLine_ID \t\t\tFROM M_InOut io  \t\t\tINNER JOIN M_InOutLine iol ON(iol.M_InOut_ID = io.M_InOut_ID) \t\t\tINNER JOIN M_Product p ON(iol.M_Product_ID = p.M_Product_ID) \t\t\tINNER JOIN M_Transaction t ON(t.M_InOutLine_ID = iol.M_InOutLine_ID) \t\t\tWHERE io.DocStatus IN('CO', 'CL', 'RE', 'VO') AND p.IsStocked = 'Y' AND io.MovementDate BETWEEN ? AND ? AND p.ProductType = 'I' \t\t\tGROUP BY iol.M_InOutLine_ID,io.MovementType \t\t\tHAVING iol.MovementQty * (CASE WHEN io.MovementType IN ('C-','V-') THEN -1 ELSE 1 END) <> SUM(t.MovementQty)) ");
            deleteTSQL.append(")");
            deleteTSQL.append(")");
            deleteTSQL.append("AND AD_Client_ID = ").append(this.getAD_Client_ID()).append(" ");
            if (this.getOrgId() != 0) {
                deleteTSQL.append("AND AD_Org_ID = ").append(this.getOrgId()).append(" ");
            }
            if (this.getWarehouseId() != 0) {
                deleteTSQL.append("AND EXISTS(SELECT 1 FROM M_Locator l WHERE l.M_Locator_ID = M_Transaction.M_Locator_ID AND l.M_Warehouse_ID = ").append(this.getWarehouseId()).append(") ");
            }
            if (this.getProductId() != 0) {
                deleteTSQL.append("AND M_Product_ID = ").append(this.getProductId()).append(" ");
            }
            if (this.getProductCategoryId() != 0) {
                deleteTSQL.append("AND EXISTS (SELECT 1 FROM M_Product WHERE M_Product.M_Product_Category_ID= ").append(this.getProductCategoryId()).append(" AND M_Product.M_Product_ID = M_Transaction.M_Product_ID ) ");
            }
            transactionDeleted = DB.executeUpdate((String)deleteTSQL.toString(), (Object[])new Object[]{this.getDateTrx(), this.getDateTrxTo(), this.getDateTrx(), this.getDateTrxTo(), this.getDateTrx(), this.getDateTrxTo()}, (boolean)false, (String)this.get_TrxName());
            this.log.fine("Transaction Deleted=" + transactionDeleted);
            this.recreateTransaction();
            this.log.fine("Recreate Transaction");
        }
        this.recreateQtyOnHand();
        this.log.fine("Recreate QtyOnHand");
        StringBuffer orderSQL = new StringBuffer("SELECT o.C_Order_ID FROM C_Order o INNER JOIN C_OrderLine ol ON(ol.C_Order_ID = o.C_Order_ID) INNER JOIN C_DocType dt ON(dt.C_DocType_ID = o.C_DocType_ID) WHERE o.DocStatus IN('IP', 'CO')  AND o.DateOrdered BETWEEN ? AND ?  AND o.AD_Client_ID = ").append(this.getAD_Client_ID()).append(" ");
        if (this.getOrgId() != 0) {
            orderSQL.append("AND o.AD_Org_ID = ").append(this.getOrgId()).append(" ");
        }
        if (this.getWarehouseId() != 0) {
            orderSQL.append("AND ol.M_Warehouse_ID = ").append(this.getWarehouseId()).append(" ");
        }
        if (this.getProductId() != 0) {
            orderSQL.append("AND ol.M_Product_ID = ").append(this.getProductId()).append(" ");
        }
        if (this.getProductCategoryId() != 0) {
            orderSQL.append("AND EXISTS (SELECT 1 FROM M_Product WHERE M_Product.M_Product_Category_ID= ").append(this.getProductCategoryId()).append(" AND M_Product.M_Product_ID = ol.M_Product_ID ) ");
        }
        orderSQL.append("GROUP BY o.C_Order_ID ");
        orderSQL.append("ORDER BY o.IsSOTrx, o.DateOrdered");
        this.log.fine("orderSQL=" + orderSQL.toString());
        CPreparedStatement ps = null;
        ResultSet rs = null;
        ps = DB.prepareStatement((String)orderSQL.toString(), (String)this.get_TrxName());
        ps.setTimestamp(1, this.getDateTrx());
        ps.setTimestamp(2, this.getDateTrxTo());
        rs = ps.executeQuery();
        while (rs.next()) {
            MOrder order = new MOrder(this.getCtx(), rs.getInt(1), this.get_TrxName());
            String message = null;
            try {
                this.reserveStock(order);
            }
            catch (Exception e) {
                message = e.getMessage();
            }
            this.addLog("@C_Order_ID@ " + order.getDocumentNo() + (message == null ? " @Processed@" : " @Error@" + message));
        }
        DB.close((ResultSet)rs, (Statement)ps);
        return "@Updated@=" + storageUpdated + " @M_Transaction_ID@ @Deleted@=" + transactionDeleted;
    }

    private void recreateTransaction() {
        StringBuilder sql = new StringBuilder();
        ArrayList<Comparable<Date>> parameters = new ArrayList<Comparable<Date>>();
        sql.append("SELECT iol.* ").append("FROM M_Product p ").append("INNER JOIN ( ").append("\tSELECT io.DocumentNo, iol.AD_Org_ID, M_InOutline_ID, iol.M_Product_ID, io.M_Warehouse_ID, io.MovementType, iol.M_Locator_ID, ").append("\t\tiol.M_AttributeSetInstance_ID, iol.MovementQty, io.MovementDate ").append("\tFROM M_InOut io ").append("\tINNER JOIN M_InOutline iol ON (io.M_InOut_ID = iol.M_InOut_ID) ").append("\tWHERE ").append("\t\tio.DocStatus IN('CO', 'CL', 'RE', 'VO') \t\tAND io.MovementDate BETWEEN ? AND ? \t\tAND NOT EXISTS ( \t\t\t\tSELECT 1 \t\t\t\tFROM M_Transaction tr \t\t\t\tWHERE \t\t\t\t\ttr.M_InOutLine_ID = iol.M_InOutLine_ID \t\t\t)").append(") iol ON (p.M_Product_ID = iol.M_Product_ID) ").append("WHERE ").append("\tp.ProductType ='I' ").append("\tAND p.IsStocked = 'Y'");
        parameters.add(this.getDateTrx());
        parameters.add(this.getDateTrxTo());
        if (this.getProductCategoryId() > 0) {
            sql.append("\tAND p.M_Product_Category_ID= ?");
            parameters.add(Integer.valueOf(this.getProductCategoryId()));
        }
        if (this.getOrgId() > 0) {
            sql.append("\tAND iol.AD_Org_ID= ?");
            parameters.add(Integer.valueOf(this.getOrgId()));
        }
        if (this.getWarehouseId() > 0) {
            sql.append("\tAND iol.M_Warehouse_ID= ?");
            parameters.add(Integer.valueOf(this.getWarehouseId()));
        }
        if (this.getProductId() > 0) {
            sql.append("\tAND p.M_Product_ID= ?");
            parameters.add(Integer.valueOf(this.getProductId()));
        }
        int transactionCreated = 0;
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
            DB.setParameters((PreparedStatement)pstmt, parameters);
            rs = pstmt.executeQuery();
            int m_AD_Org_ID = -1;
            String m_MovementType = null;
            int m_M_Locator_ID = -1;
            int m_M_Product_ID = -1;
            int m_M_AttributeSetInstance_ID = -1;
            int m_M_InOutline_ID = -1;
            BigDecimal m_MovementQty = Env.ZERO;
            Timestamp m_MovementDate = null;
            String m_DocumentNo = null;
            while (rs.next()) {
                m_M_InOutline_ID = rs.getInt("M_InOutline_ID");
                int exists = DB.getSQLValue((String)this.get_TrxName(), (String)"SELECT 1 FROM M_Transaction WHERE M_InOutline_ID = ?", (int)m_M_InOutline_ID);
                if (exists == 1) continue;
                m_AD_Org_ID = rs.getInt("AD_Org_ID");
                m_M_Product_ID = rs.getInt("M_Product_ID");
                m_MovementType = rs.getString("MovementType");
                m_M_Locator_ID = rs.getInt("M_Locator_ID");
                m_M_AttributeSetInstance_ID = rs.getInt("M_AttributeSetInstance_ID");
                m_MovementQty = rs.getBigDecimal("MovementQty");
                m_MovementDate = rs.getTimestamp("MovementDate");
                m_DocumentNo = rs.getString("DocumentNo");
                MTransaction mtrx = new MTransaction(this.getCtx(), m_AD_Org_ID, m_MovementType, m_M_Locator_ID, m_M_Product_ID, m_M_AttributeSetInstance_ID, m_MovementType.equals("V-") || m_MovementType.equals("C-") ? m_MovementQty.negate() : m_MovementQty, m_MovementDate, this.get_TrxName());
                mtrx.setM_InOutLine_ID(m_M_InOutline_ID);
                if (!mtrx.save()) {
                    this.addLog("@M_Transaction_ID@ @Error@ " + m_DocumentNo);
                    continue;
                }
                this.addLog("@M_Transaction_ID@ @Created@ " + m_DocumentNo);
                ++transactionCreated;
            }
        }
        catch (SQLException e) {
            try {
                throw new DBException((Exception)e, sql.toString());
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        this.log.fine("Transaction Created=" + transactionCreated);
    }

    private void recreateQtyOnHand() throws SQLException {
        StringBuffer deleteSQL = new StringBuffer("DELETE FROM M_Storage WHERE (QtyOnHand <> 0 OR (QtyOnHand=0 AND QtyReserved = 0)) AND AD_Client_ID = ").append(this.getAD_Client_ID()).append(" ");
        if (this.getOrgId() != 0) {
            deleteSQL.append("AND AD_Org_ID = ").append(this.getOrgId()).append(" ");
        }
        if (this.getWarehouseId() != 0) {
            deleteSQL.append("AND EXISTS(SELECT 1 FROM M_Locator l WHERE l.M_Locator_ID = M_Storage.M_Locator_ID AND l.M_Warehouse_ID = ").append(this.getWarehouseId()).append(") ");
        }
        if (this.getProductId() != 0) {
            deleteSQL.append("AND M_Product_ID = ").append(this.getProductId()).append(" ");
        }
        if (this.getProductCategoryId() != 0) {
            deleteSQL.append("AND EXISTS (SELECT 1 FROM M_Product WHERE M_Product.M_Product_Category_ID= ").append(this.getProductCategoryId()).append(" AND M_Product.M_Product_ID = M_Storage.M_Product_ID ) ");
        }
        this.log.fine("deleteSQL=" + deleteSQL.toString());
        int storageUpdated = DB.executeUpdate((String)deleteSQL.toString(), (String)this.get_TrxName());
        this.log.fine("Storage Updated=" + storageUpdated);
        StringBuffer transactionSQL = new StringBuffer("SELECT mt.AD_Client_ID,mw.AD_Org_ID,mt.M_Product_ID,mt.M_Locator_ID,mt.M_AttributeSetInstance_ID,Sum(mt.MovementQty) MovementQty FROM M_Transaction mt INNER JOIN M_Locator ml ON mt.M_Locator_ID = ml.M_Locator_ID INNER JOIN M_Warehouse mw ON mw.M_Warehouse_ID = ml.M_Warehouse_ID WHERE mt.AD_Client_ID = ").append(this.getAD_Client_ID()).append(" ");
        if (this.getOrgId() != 0) {
            transactionSQL.append("AND mw.AD_Org_ID = ").append(this.getOrgId()).append(" ");
        }
        if (this.getWarehouseId() != 0) {
            transactionSQL.append("AND mw.M_Warehouse_ID = ").append(this.getWarehouseId()).append(" ");
        }
        if (this.getProductId() != 0) {
            transactionSQL.append("AND mt.M_Product_ID = ").append(this.getProductId()).append(" ");
        }
        if (this.getProductCategoryId() != 0) {
            transactionSQL.append("AND EXISTS (SELECT 1 FROM M_Product WHERE M_Product.M_Product_Category_ID= ").append(this.getProductCategoryId()).append(" AND M_Product.M_Product_ID = mt.M_Product_ID ) ");
        }
        transactionSQL.append("GROUP BY mt.AD_Client_ID,mw.AD_Org_ID,mt.M_Product_ID,mt.M_Locator_ID,mt.M_AttributeSetInstance_ID ");
        transactionSQL.append("HAVING SUM(mt.MovementQty) <> 0 ");
        CPreparedStatement ps = null;
        ResultSet rs = null;
        ps = DB.prepareStatement((String)transactionSQL.toString(), (String)this.get_TrxName());
        rs = ps.executeQuery();
        while (rs.next()) {
            MStorage stg = new MStorage(this.getCtx(), 0, this.get_TrxName());
            stg.setAD_Org_ID(rs.getInt("AD_Org_ID"));
            stg.setM_Product_ID(rs.getInt("M_Product_ID"));
            stg.setM_Locator_ID(rs.getInt("M_Locator_ID"));
            stg.setM_AttributeSetInstance_ID(rs.getInt("M_AttributeSetInstance_ID"));
            stg.setQtyOnHand(rs.getBigDecimal("MovementQty"));
            stg.save(this.get_TrxName());
            this.addLog("@QtyOnHand@ " + stg.getQtyOnHand() + " @Processed@");
        }
        DB.close((ResultSet)rs, (Statement)ps);
    }

    private boolean reserveStock(MOrder order) throws Exception {
        boolean binding;
        if (order == null) {
            return false;
        }
        MDocType dt = MDocType.get((Properties)this.getCtx(), (int)order.getC_DocType_ID());
        boolean bl = binding = !dt.isProposal();
        if ("VO".equals(order.getDocStatus()) || "OB".equals(dt.getDocSubTypeSO()) && "CL".equals(order.getDocStatus())) {
            binding = false;
        }
        boolean isSOTrx = order.isSOTrx();
        this.log.fine("Binding=" + binding + " - IsSOTrx=" + isSOTrx);
        int header_M_Warehouse_ID = order.getM_Warehouse_ID();
        if ("SO".equals(dt.getDocSubTypeSO()) || "POO".equals(dt.getDocBaseType())) {
            header_M_Warehouse_ID = 0;
        }
        BigDecimal Volume = Env.ZERO;
        BigDecimal Weight = Env.ZERO;
        MOrderLine[] lines = order.getLines();
        for (int i = 0; i < lines.length; ++i) {
            MProduct product;
            BigDecimal target;
            BigDecimal difference;
            BigDecimal m_OldDeliveredQty;
            MOrderLine line = lines[i];
            BigDecimal m_DeliveredQty = DB.getSQLValueBD((String)this.get_TrxName(), (String)"SELECT SUM(iol.MovementQty) MovementQty FROM M_InOut io INNER JOIN M_InOutLine iol ON(iol.M_InOut_ID = io.M_InOut_ID) WHERE io.DocStatus IN('CO', 'CL') AND iol.C_OrderLine_ID = ?", (int)line.getC_OrderLine_ID());
            if (m_DeliveredQty == null) {
                m_DeliveredQty = Env.ZERO;
            }
            if ((m_OldDeliveredQty = line.getQtyDelivered()) == null) {
                m_OldDeliveredQty = Env.ZERO;
            }
            line.setQtyDelivered(m_DeliveredQty);
            line.setQtyReserved(Env.ZERO);
            if (header_M_Warehouse_ID != 0) {
                if (header_M_Warehouse_ID != line.getM_Warehouse_ID()) {
                    line.setM_Warehouse_ID(header_M_Warehouse_ID);
                }
                if (order.getAD_Org_ID() != line.getAD_Org_ID()) {
                    line.setAD_Org_ID(order.getAD_Org_ID());
                }
            }
            if ((difference = (target = binding ? line.getQtyOrdered() : Env.ZERO).subtract(line.getQtyReserved()).subtract(line.getQtyDelivered())).signum() <= 0) {
                product = line.getProduct();
                if (product == null) continue;
                Volume = Volume.add(product.getVolume().multiply(line.getQtyOrdered()));
                Weight = Weight.add(product.getWeight().multiply(line.getQtyOrdered()));
                if (m_DeliveredQty.equals(m_OldDeliveredQty)) continue;
                line.setQtyReserved(difference);
                line.saveEx(this.get_TrxName());
                continue;
            }
            this.log.fine("Line=" + line.getLine() + " - Target=" + target + ",Difference=" + difference + " - Ordered=" + line.getQtyOrdered() + ",Reserved=" + line.getQtyReserved() + ",Delivered=" + line.getQtyDelivered());
            product = line.getProduct();
            if (product == null) continue;
            if (product.isStocked()) {
                BigDecimal ordered = isSOTrx ? Env.ZERO : difference;
                BigDecimal reserved = isSOTrx ? difference : Env.ZERO;
                int M_Locator_ID = 0;
                if (line.getM_AttributeSetInstance_ID() != 0) {
                    M_Locator_ID = MStorage.getM_Locator_ID((int)line.getM_Warehouse_ID(), (int)line.getM_Product_ID(), (int)line.getM_AttributeSetInstance_ID(), (BigDecimal)ordered, (String)this.get_TrxName());
                }
                if (M_Locator_ID == 0) {
                    MWarehouse wh = MWarehouse.get((Properties)this.getCtx(), (int)line.getM_Warehouse_ID());
                    M_Locator_ID = product.getM_Locator_ID();
                    if (M_Locator_ID != 0) {
                        MLocator locator = new MLocator(this.getCtx(), product.getM_Locator_ID(), this.get_TrxName());
                        if (locator.getM_Warehouse_ID() != wh.get_ID()) {
                            M_Locator_ID = wh.getDefaultLocator().getM_Locator_ID();
                        }
                    } else {
                        M_Locator_ID = wh.getDefaultLocator().getM_Locator_ID();
                    }
                }
                if (!MStorage.add((Properties)this.getCtx(), (int)line.getM_Warehouse_ID(), (int)M_Locator_ID, (int)line.getM_Product_ID(), (int)line.getM_AttributeSetInstance_ID(), (int)line.getM_AttributeSetInstance_ID(), (BigDecimal)Env.ZERO, (BigDecimal)reserved, (BigDecimal)ordered, (String)this.get_TrxName())) {
                    return false;
                }
            }
            line.setQtyReserved(line.getQtyReserved().add(difference));
            line.saveEx(this.get_TrxName());
            Volume = Volume.add(product.getVolume().multiply(line.getQtyOrdered()));
            Weight = Weight.add(product.getWeight().multiply(line.getQtyOrdered()));
        }
        order.setVolume(Volume);
        order.setWeight(Weight);
        order.setIsDelivered(false);
        order.updateIsDelivered();
        order.saveEx();
        return true;
    }
}

