/*
 * Decompiled with CFR 0.152.
 */
package org.spin.tools.process;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.process.DocAction;
import org.compiere.util.Trx;
import org.compiere.util.TrxRunnable;
import org.spin.tools.process.ReleaseProcessingDocumentsAbstract;

public class ReleaseProcessingDocuments
extends ReleaseProcessingDocumentsAbstract {
    private AtomicInteger counter = new AtomicInteger();

    protected String doIt() throws Exception {
        this.getDocumentTablesList().forEach(table -> this.processTable((MTable)table));
        return "@Updated@: " + this.counter.get();
    }

    private void processTable(final MTable table) {
        Trx.run((TrxRunnable)new TrxRunnable(){

            public void run(String transactionName) {
                ReleaseProcessingDocuments.this.log.info("doIt - TableName=" + table.getTableName());
                new Query(ReleaseProcessingDocuments.this.getCtx(), table.getTableName(), "Processing = 'Y'", transactionName).setClient_ID().getIDsAsList().stream().filter(recordId -> recordId > 0).forEach(recordId -> {
                    try {
                        PO document = table.getPO(recordId.intValue(), transactionName);
                        if (document instanceof DocAction) {
                            document.set_ValueOfColumn("Processing", (Object)false);
                            document.saveEx();
                            ReleaseProcessingDocuments.this.counter.getAndIncrement();
                            ReleaseProcessingDocuments.this.addLog("@AD_Table_ID@: " + table.get_Translation("Name") + " @Updated@ " + ((DocAction)document).getDocumentInfo());
                        }
                    }
                    catch (Exception e) {
                        ReleaseProcessingDocuments.this.addLog("@AD_Table_ID@: " + table.get_Translation("Name") + " @Error@ " + e.getLocalizedMessage());
                    }
                });
            }
        });
    }

    private List<MTable> getDocumentTablesList() {
        return new Query(this.getCtx(), "AD_Table", "IsDocument = 'Y' AND EXISTS(SELECT 1 FROM AD_Column c WHERE c.AD_Table_ID = AD_Table.AD_Table_ID AND c.ColumnName = ? AND c.ColumnSQL IS NULL)", this.get_TrxName()).setParameters(new Object[]{"Processing"}).setOnlyActiveRecords(true).list();
    }
}

