/*
 * Decompiled with CFR 0.152.
 */
package org.spin.tools.process;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.spin.tools.process.ReCalculatePriceLimitOfInvoicesAbstract;

public class ReCalculatePriceLimitOfInvoices
extends ReCalculatePriceLimitOfInvoicesAbstract {
    private AtomicInteger updated = new AtomicInteger();

    protected String doIt() throws Exception {
        StringBuffer whereClause = new StringBuffer();
        ArrayList<Comparable<Integer>> parameters = new ArrayList<Comparable<Integer>>();
        if (this.getRecord_ID() > 0) {
            whereClause.append("C_Invoice_ID = ?");
            parameters.add(Integer.valueOf(this.getRecord_ID()));
        } else {
            whereClause.append("IsSOTrx = 'Y' AND DateInvoiced >= ? AND DateInvoiced <= ?");
            parameters.add(this.getDateInvoiced());
            parameters.add(this.getDateInvoicedTo());
            if (this.getOrgId() > 0) {
                whereClause.append(" AND AD_Org_ID = ?");
                parameters.add(Integer.valueOf(this.getOrgId()));
            }
            if (this.getDocTypeTargetId() > 0) {
                whereClause.append(" AND C_DocTypeTarget_ID = ?");
                parameters.add(Integer.valueOf(this.getDocTypeTargetId()));
            }
        }
        if (this.getProductId() > 0) {
            whereClause.append(" AND EXISTS(SELECT 1 FROM C_InvoiceLine il WHERE il.C_Invoice_ID = C_Invoice.C_Invoice_ID AND il.M_Product_ID = ?)");
            parameters.add(Integer.valueOf(this.getProductId()));
        }
        new Query(this.getCtx(), "C_Invoice", whereClause.toString(), this.get_TrxName()).setParameters(parameters).setOrderBy("DateInvoiced").getIDsAsList().forEach(invoiceId -> {
            MInvoice salesInvoice = new MInvoice(this.getCtx(), invoiceId.intValue(), this.get_TrxName());
            List<MInvoiceLine> salesInvoiceLines = Arrays.asList(salesInvoice.getLines());
            if (salesInvoiceLines != null && salesInvoiceLines.size() > 0) {
                salesInvoiceLines.stream().filter(invoiceLine -> {
                    if (invoiceLine.getM_Product_ID() <= 0) {
                        return false;
                    }
                    return this.getProductId() <= 0 || this.getProductId() == invoiceLine.getM_Product_ID();
                }).forEach(invoiceLine -> {
                    MOrder purchaseOrder = (MOrder)new Query(this.getCtx(), "C_Order", "IsSOTrx = 'N' AND DateOrdered <= ? AND DocStatus IN('CO', 'CL') AND EXISTS(SELECT 1 FROM C_OrderLine ol WHERE ol.C_Order_ID = C_Order.C_Order_ID AND ol.M_Product_ID = ?)", this.get_TrxName()).setParameters(new Object[]{salesInvoice.getDateInvoiced(), invoiceLine.getM_Product_ID()}).first();
                    if (purchaseOrder != null) {
                        MOrderLine purchaseOrderLine = Arrays.asList(purchaseOrder.getLines()).stream().filter(orderLine -> orderLine.getM_Product_ID() == invoiceLine.getM_Product_ID()).findFirst().get();
                        BigDecimal priceActual = purchaseOrderLine.getPriceActual();
                        invoiceLine.setPriceLimit(priceActual);
                        invoiceLine.saveEx();
                    } else {
                        invoiceLine.setPriceLimit(Env.ZERO);
                        invoiceLine.saveEx();
                    }
                    this.updated.incrementAndGet();
                });
            }
        });
        return "@Updated@: " + this.updated.get();
    }
}

