/*
 * Decompiled with CFR 0.152.
 */
package org.spin.tools.process;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import org.compiere.model.I_M_Product;
import org.compiere.model.MAttachment;
import org.compiere.model.MProduct;
import org.compiere.model.Query;
import org.spin.tools.process.ProductLoadAttachmentsAbstract;

public class ProductLoadAttachments
extends ProductLoadAttachmentsAbstract {
    private Map<String, Boolean> finded = new HashMap<String, Boolean>();

    @Override
    protected void prepare() {
        super.prepare();
    }

    protected String doIt() throws Exception {
        File folder = new File(this.getFilePathOrName());
        AtomicInteger matchedAllFiles = new AtomicInteger(0);
        new Query(this.getCtx(), "M_Product", null, this.get_TrxName()).setClient_ID().setOrderBy("LENGTH(M_Product.Value) DESC").getIDsAsList().forEach(productId -> {
            MProduct product = MProduct.get((Properties)this.getCtx(), (int)productId);
            AtomicInteger matchedFiles = new AtomicInteger(0);
            List<File> filesToAdd = Arrays.asList(folder.listFiles((d, s) -> {
                if (this.finded.containsKey(s.toLowerCase())) {
                    return false;
                }
                return s.toLowerCase().startsWith(product.getValue().toLowerCase()) || product.getSKU() != null && s.toLowerCase().startsWith(product.getSKU().toLowerCase()) || s.toLowerCase().contains(product.getValue().toLowerCase()) || product.getSKU() != null && s.toLowerCase().contains(product.getSKU().toLowerCase());
            }));
            if (filesToAdd.size() > 0) {
                try {
                    MAttachment attachmentToAdd = new MAttachment(this.getCtx(), I_M_Product.Table_ID, product.getM_Product_ID(), this.get_TrxName());
                    filesToAdd.stream().filter(file -> file.exists() && file.isFile() && !file.isHidden() && file.canRead()).forEach(file -> {
                        matchedFiles.incrementAndGet();
                        this.finded.put(file.getName().toLowerCase(), true);
                        System.out.println(file);
                        attachmentToAdd.addEntry(file);
                    });
                    attachmentToAdd.saveEx();
                    if (matchedFiles.get() > 0) {
                        this.addLog("@M_Product_ID@: " + product.getValue() + "-" + product.getName() + " (" + matchedFiles.get() + ")");
                    }
                    matchedAllFiles.addAndGet(matchedFiles.get());
                }
                catch (Exception e) {
                    this.log.severe(e.getLocalizedMessage());
                }
            }
        });
        return "@Matched@: " + matchedAllFiles.get();
    }
}

