/*
 * Decompiled with CFR 0.152.
 */
package org.spin.tools.process;

import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MInOut;
import org.compiere.util.Trx;
import org.spin.tools.process.InOutBatchProcessAbstract;

public class InOutBatchProcess
extends InOutBatchProcessAbstract {
    private int counter = 0;
    private int errCounter = 0;

    protected String doIt() throws Exception {
        this.getSelectionKeys().stream().forEach(orderId -> this.process((int)orderId));
        return "@Updated@=" + this.counter + ", @Errors@=" + this.errCounter;
    }

    private boolean process(int inOutId) {
        try {
            Trx.run(trxName -> {
                MInOut inOut = new MInOut(this.getCtx(), inOutId, trxName);
                this.log.info(inOut.toString());
                inOut.setDocAction(this.getDocAction());
                if (!inOut.processIt(this.getDocAction())) {
                    this.addLog(0, null, null, inOut.getDocumentNo() + ": @Error@ " + inOut.getProcessMsg());
                    throw new AdempiereException(inOut.getDocumentNo() + ": @Error@ " + inOut.getProcessMsg());
                }
                inOut.saveEx();
                this.addLog(0, null, null, inOut.getDocumentNo() + ": @OK@");
            });
            ++this.counter;
        }
        catch (Exception e) {
            ++this.errCounter;
            this.addLog(e.getMessage());
            this.log.warning(e.getLocalizedMessage());
            return false;
        }
        return true;
    }
}

