/*
 * Decompiled with CFR 0.152.
 */
package org.spin.tools.process;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import org.adempiere.model.GenericPO;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MAcctSchemaDefault;
import org.compiere.model.MAcctSchemaElement;
import org.compiere.model.MAcctSchemaGL;
import org.compiere.model.MClientInfo;
import org.compiere.model.MDistribution;
import org.compiere.model.MDistributionLine;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.model.POResultSet;
import org.compiere.model.Query;
import org.compiere.report.MReport;
import org.spin.tools.process.CreateFrom_AccountingSchemaAbstract;

public class CreateFrom_AccountingSchema
extends CreateFrom_AccountingSchemaAbstract {
    @Override
    protected void prepare() {
        super.prepare();
    }

    protected String doIt() throws Exception {
        AtomicReference<String> result = new AtomicReference<String>("@Error@");
        Optional<MAcctSchema> maybeTargetSchema = Optional.ofNullable(this.copyAccountingSchema());
        maybeTargetSchema.ifPresent(targetSchema -> {
            if (this.isDefault()) {
                Optional<MClientInfo> maybeClientInfo = Optional.ofNullable(MClientInfo.get((Properties)this.getCtx(), (int)this.getAD_Client_ID(), (String)this.get_TrxName()));
                maybeClientInfo.ifPresent(clientInfo -> {
                    clientInfo.setC_AcctSchema1_ID(targetSchema.get_ID());
                    clientInfo.saveEx();
                });
            }
            result.set("@OK@");
        });
        return result.get();
    }

    private MAcctSchema copyAccountingSchema() {
        Optional<MAcctSchema> maybeSourceSchema = Optional.ofNullable(MAcctSchema.get((Properties)this.getCtx(), (int)this.getAcctSchemaId()));
        AtomicReference<Object> newSchema = new AtomicReference<Object>(null);
        AtomicReference<Integer> countRecords = new AtomicReference<Integer>(0);
        maybeSourceSchema.ifPresent(sourceSchema -> {
            MAcctSchema targetSchema = new MAcctSchema(this.getCtx(), 0, this.get_TrxName());
            MAcctSchema.copyValues((PO)sourceSchema, (PO)targetSchema, (boolean)true);
            targetSchema.setName(this.getName());
            targetSchema.setC_Currency_ID(this.getCurrencyId());
            targetSchema.saveEx();
            this.addLog("@Created@ @C_AcctSchema_ID@ -> " + this.getName());
            this.log.fine("@Created@ @C_AcctSchema_ID@ -> " + this.getName());
            Arrays.asList(sourceSchema.getAcctSchemaElements()).stream().forEach(sourceElement -> {
                MAcctSchemaElement targetElement = new MAcctSchemaElement(this.getCtx(), 0, this.get_TrxName());
                MAcctSchemaElement.copyValues((PO)sourceElement, (PO)targetElement, (boolean)true);
                targetElement.setC_AcctSchema_ID(targetSchema.get_ID());
                targetElement.setIsDirectLoad(true);
                targetElement.saveEx();
                countRecords.set((Integer)countRecords.get() + 1);
                this.log.fine("@Created@ @C_AcctSchemaElement_ID@ -> " + targetElement.getName());
            });
            this.addLog("@Records@ @Inserted@ @C_AcctSchemaElement_ID@ -> " + countRecords.get());
            countRecords.set(0);
            new Query(this.getCtx(), "C_ValidCombination", "C_AcctSchema_ID = ? ", this.get_TrxName()).setParameters(new Object[]{sourceSchema.get_ID()}).getIDsAsList().forEach(sourceAccountID -> {
                MAccount sourceAccount = MAccount.getValidCombination((Properties)this.getCtx(), (int)sourceAccountID, (String)this.get_TrxName());
                MAccount newAccount = new MAccount(targetSchema);
                MAccount.copyValues((PO)sourceAccount, (PO)newAccount, (boolean)true);
                newAccount.setC_AcctSchema_ID(targetSchema.get_ID());
                newAccount.setIsDirectLoad(true);
                newAccount.saveEx();
                countRecords.set((Integer)countRecords.get() + 1);
                this.log.fine("@Created@ @C_ValidCombination_ID@ -> " + newAccount.getDescription());
            });
            this.addLog("@Records@ @Inserted@ @C_ValidCombination_ID@ -> " + countRecords.get());
            countRecords.set(0);
            MAcctSchemaGL targetGL = new MAcctSchemaGL(this.getCtx(), 0, this.get_TrxName());
            MAcctSchemaGL.copyValues((PO)sourceSchema.getAcctSchemaGL(), (PO)targetGL, (boolean)true);
            targetGL.setC_AcctSchema_ID(targetSchema.get_ID());
            this.setAccountToEntity((PO)targetGL, targetSchema.get_ID());
            targetGL.setIsDirectLoad(true);
            targetGL.saveEx();
            this.addLog("@Created@ @C_AcctSchema_ID@ GL -> " + targetSchema.getName());
            MAcctSchemaDefault targetDefault = new MAcctSchemaDefault(this.getCtx(), 0, this.get_TrxName());
            MAcctSchemaDefault.copyValues((PO)sourceSchema.getAcctSchemaDefault(), (PO)targetDefault, (boolean)true);
            targetDefault.setC_AcctSchema_ID(targetSchema.get_ID());
            this.setAccountToEntity((PO)targetDefault, targetSchema.get_ID());
            targetDefault.setIsDirectLoad(true);
            targetDefault.saveEx();
            this.addLog("@Created@ @C_AcctSchema_ID@ @default@ -> " + targetSchema.getName());
            this.copyAccountingValues((MAcctSchema)sourceSchema, targetSchema);
            this.copyAccountingDistribution((MAcctSchema)sourceSchema, targetSchema);
            this.copyFinancialReport((MAcctSchema)sourceSchema, targetSchema);
            newSchema.set(targetSchema);
        });
        return newSchema.get();
    }

    private void setAccountToEntity(PO entity, int targetSchemaID) {
        Optional<PO> maybeEntity = Optional.ofNullable(entity);
        maybeEntity.ifPresent(targetEntity -> {
            MTable table = MTable.get((Properties)this.getCtx(), (int)targetEntity.get_Table_ID());
            table.getColumnsAsList().forEach(column -> {
                if (column.getAD_Reference_ID() == 25) {
                    Optional<MAccount> maybesourceAccount = Optional.ofNullable(MAccount.getValidCombination((Properties)this.getCtx(), (int)targetEntity.get_ValueAsInt(column.getColumnName()), (String)this.get_TrxName()));
                    maybesourceAccount.ifPresent(sourceAccount -> {
                        Optional<MAccount> maybeTargetAccount = Optional.ofNullable(this.getAccountforSchema((MAccount)sourceAccount, targetSchemaID));
                        maybeTargetAccount.ifPresent(targetAccount -> targetEntity.set_ValueOfColumn(column.getColumnName(), (Object)targetAccount.get_ID()));
                    });
                }
            });
            targetEntity.save();
        });
    }

    private MAccount getAccountforSchema(MAccount sourceAccount, int acctSchemaId) {
        if (sourceAccount.getAccount_ID() == 0) {
            return sourceAccount;
        }
        return MAccount.get((Properties)this.getCtx(), (int)sourceAccount.getAD_Client_ID(), (int)sourceAccount.getAD_Org_ID(), (int)acctSchemaId, (int)sourceAccount.getAccount_ID(), (int)sourceAccount.getC_SubAcct_ID(), (int)sourceAccount.getM_Product_ID(), (int)sourceAccount.getC_BPartner_ID(), (int)sourceAccount.getAD_OrgTrx_ID(), (int)sourceAccount.getC_LocFrom_ID(), (int)sourceAccount.getC_LocTo_ID(), (int)sourceAccount.getC_SalesRegion_ID(), (int)sourceAccount.getC_Project_ID(), (int)sourceAccount.getC_Campaign_ID(), (int)sourceAccount.getC_Activity_ID(), (int)sourceAccount.getUser1_ID(), (int)sourceAccount.getUser2_ID(), (int)sourceAccount.getUser3_ID(), (int)sourceAccount.getUser4_ID(), (int)sourceAccount.getUserElement1_ID(), (int)sourceAccount.getUserElement2_ID(), (String)this.get_TrxName());
    }

    private void copyAccountingValues(MAcctSchema sourceSchema, MAcctSchema targetSchema) {
        String whereClause = "TableName LIKE '%Acct' AND IsView = 'N' AND EXISTS (SELECT 1 FROM AD_Column c WHERE c.ColumnName = ? AND c.AD_Table_ID = AD_Table.AD_Table_ID) AND EXISTS (SELECT 1 FROM AD_Column c WHERE c.AD_Reference_ID = ? AND c.AD_Table_ID = AD_Table.AD_Table_ID)";
        new Query(this.getCtx(), "AD_Table", whereClause, this.get_TrxName()).setParameters(new Object[]{"C_AcctSchema_ID", 25}).list().forEach(table -> {
            POResultSet dataTable = new Query(this.getCtx(), table.getTableName(), "C_AcctSchema_ID = ?", this.get_TrxName()).setParameters(new Object[]{sourceSchema.get_ID()}).scroll();
            int countRecords = 0;
            while (dataTable.hasNext()) {
                ++countRecords;
                PO sourceData = dataTable.next();
                GenericPO targetData = new GenericPO(table.getTableName(), this.getCtx(), 0, this.get_TrxName());
                PO.copyValues((PO)sourceData, (PO)targetData, (boolean)true);
                Arrays.asList(targetData.get_KeyColumns()).forEach(columnName -> targetData.set_ValueOfColumn(columnName, sourceData.get_Value(columnName)));
                targetData.set_ValueOfColumn("C_AcctSchema_ID", (Object)targetSchema.get_ID());
                this.setAccountToEntity((PO)targetData, targetSchema.get_ID());
                targetData.setIsDirectLoad(true);
                targetData.saveEx();
            }
            this.addLog("@Created@ " + table.getName() + " -> " + countRecords);
            this.log.fine("@Created@ " + table.getName() + " -> " + countRecords);
        });
    }

    private void copyAccountingDistribution(MAcctSchema sourceSchema, MAcctSchema targetSchema) {
        List distributionList = new Query(this.getCtx(), "GL_Distribution", "C_AcctSchema_ID = ?", this.get_TrxName()).setParameters(new Object[]{sourceSchema.get_ID()}).getIDsAsList();
        distributionList.forEach(sourceDistributionId -> {
            MDistribution sourceDistribution = new MDistribution(this.getCtx(), sourceDistributionId.intValue(), this.get_TrxName());
            MDistribution targetDistribution = new MDistribution(this.getCtx(), 0, this.get_TrxName());
            PO.copyValues((PO)sourceDistribution, (PO)targetDistribution, (boolean)true);
            targetDistribution.setC_AcctSchema_ID(targetSchema.get_ID());
            this.setAccountToEntity((PO)targetDistribution, targetSchema.get_ID());
            targetDistribution.setIsDirectLoad(true);
            targetDistribution.saveEx();
            List distributionLineList = new Query(this.getCtx(), "GL_DistributionLine", "GL_Distribution_ID = ?", this.get_TrxName()).setParameters(new Object[]{sourceDistribution.get_ID()}).getIDsAsList();
            distributionLineList.forEach(sourceDistributionLineId -> {
                MDistributionLine sourceDistributionLine = new MDistributionLine(this.getCtx(), sourceDistributionLineId.intValue(), this.get_TrxName());
                MDistributionLine targetDistributionLine = new MDistributionLine(this.getCtx(), 0, this.get_TrxName());
                PO.copyValues((PO)sourceDistributionLine, (PO)targetDistributionLine, (boolean)true);
                targetDistributionLine.setGL_Distribution_ID(targetDistribution.get_ID());
                this.setAccountToEntity((PO)targetDistributionLine, targetSchema.get_ID());
                targetDistributionLine.setIsDirectLoad(true);
                targetDistributionLine.saveEx();
            });
        });
        this.addLog("@Created@ @GL_Distribution_ID@ -> " + distributionList.size());
        this.log.fine("@Created@ @GL_Distribution_ID@ -> " + distributionList.size());
    }

    private void copyFinancialReport(MAcctSchema sourceSchema, MAcctSchema targetSchema) {
        List financialReports = new Query(this.getCtx(), "PA_Report", "C_AcctSchema_ID = ?", this.get_TrxName()).setParameters(new Object[]{sourceSchema.get_ID()}).list();
        financialReports.forEach(sourceReport -> {
            MReport targetreport = new MReport(this.getCtx(), 0, this.get_TrxName());
            PO.copyValues((PO)sourceReport, (PO)targetreport, (boolean)true);
            targetreport.setC_AcctSchema_ID(targetSchema.get_ID());
            targetreport.saveEx();
        });
        this.addLog("@Created@ @PA_Report_ID@ -> " + financialReports.size());
        this.log.fine("@Created@ @PA_Report_ID@ -> " + financialReports.size());
    }
}

