/*
 * Decompiled with CFR 0.152.
 */
package org.spin.tools.process;

import java.math.BigDecimal;
import java.math.MathContext;
import java.sql.Timestamp;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MConversionRate;
import org.compiere.model.MConversionType;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;
import org.spin.tools.process.CreateConversionRateAbstract;

public class CreateConversionRate
extends CreateConversionRateAbstract {
    private Timestamp validFrom = null;
    private Timestamp validTo = null;
    private BigDecimal timeTolerance = Env.ONEHUNDRED;
    private BigDecimal multiplyRate = null;
    private BigDecimal divideRate = null;
    private int countRecords = 0;

    @Override
    protected void prepare() {
        super.prepare();
    }

    protected String doIt() throws Exception {
        Timestamp today = Env.getContextAsDate((Properties)this.getCtx(), (String)"#Date");
        this.validFrom = Optional.ofNullable(this.getValidFrom()).orElseGet(() -> TimeUtil.addYears((Timestamp)today, (int)this.timeTolerance.negate().intValue()));
        this.validTo = Optional.ofNullable(this.getValidTo()).orElseGet(() -> TimeUtil.addYears((Timestamp)today, (int)this.timeTolerance.intValue()));
        this.multiplyRate = Optional.ofNullable(this.getMultiplyRate()).orElseGet(() -> Env.ONE);
        this.divideRate = Optional.ofNullable(this.getDivideRate()).orElseGet(() -> Env.ONE);
        if (this.multiplyRate.compareTo(Env.ZERO) == 0) {
            this.multiplyRate = Env.ONE;
        }
        if (this.divideRate.compareTo(Env.ZERO) == 0) {
            this.divideRate = Env.ONE;
        }
        if (this.multiplyRate.compareTo(this.divideRate) > 0) {
            this.divideRate = Env.ONE.divide(this.multiplyRate, MathContext.DECIMAL128);
            this.multiplyRate = Env.ONE.divide(this.divideRate, MathContext.DECIMAL128);
        } else {
            this.multiplyRate = Env.ONE.divide(this.divideRate, MathContext.DECIMAL128);
            this.divideRate = Env.ONE.divide(this.multiplyRate, MathContext.DECIMAL128);
        }
        if (this.validTo.before(this.validFrom)) {
            throw new AdempiereException("@ValidTo@  > @ValidFrom@");
        }
        String whereClause = "C_ConversionType_ID = ? OR ? = 0 ";
        List conversionTypes = new Query(this.getCtx(), "C_ConversionType", whereClause, this.get_TrxName()).setOnlyActiveRecords(false).setParameters(new Object[]{this.getConversionTypeId(), this.getConversionTypeId()}).list();
        conversionTypes.forEach(conversionType -> {
            if (this.createConversionRate((MConversionType)conversionType, this.getCurrencyId(), this.getCurrencyToId(), this.multiplyRate, this.divideRate, this.validFrom, this.validTo)) {
                ++this.countRecords;
            }
            if (this.isCreateReciprocalRate() && this.createConversionRate((MConversionType)conversionType, this.getCurrencyToId(), this.getCurrencyId(), this.divideRate, this.multiplyRate, this.validFrom, this.validTo)) {
                ++this.countRecords;
            }
            if (this.isAddCurrencyRateForCurrencyTo()) {
                new Query(this.getCtx(), "C_Conversion_Rate", "C_ConversionType_ID = ? AND C_Currency_ID = ? AND C_Currency_ID_To!=? ", this.get_TrxName()).setParameters(new Object[]{conversionType.get_ID(), this.getCurrencyId(), this.getCurrencyToId()}).list().forEach(conversionRate -> {
                    if (this.createConversionRate((MConversionType)conversionType, this.getCurrencyToId(), conversionRate.getC_Currency_ID_To(), conversionRate.getMultiplyRate().multiply(this.multiplyRate, MathContext.DECIMAL128), conversionRate.getDivideRate().divide(this.divideRate, MathContext.DECIMAL128), conversionRate.getValidFrom(), conversionRate.getValidTo())) {
                        ++this.countRecords;
                    }
                });
                new Query(this.getCtx(), "C_Conversion_Rate", "C_ConversionType_ID = ? AND C_Currency_ID_To = ?  AND C_Currency_ID!=? ", this.get_TrxName()).setParameters(new Object[]{conversionType.get_ID(), this.getCurrencyId(), this.getCurrencyToId()}).list().forEach(conversionRate -> {
                    if (this.createConversionRate((MConversionType)conversionType, conversionRate.getC_Currency_ID(), this.getCurrencyToId(), conversionRate.getMultiplyRate().multiply(this.multiplyRate, MathContext.DECIMAL128), conversionRate.getDivideRate().divide(this.divideRate, MathContext.DECIMAL128), conversionRate.getValidFrom(), conversionRate.getValidTo())) {
                        ++this.countRecords;
                    }
                });
            }
        });
        return "@Created@ -> " + this.countRecords;
    }

    boolean createConversionRate(MConversionType conversionType, int currencyId, int currencyIdTo, BigDecimal multiplyRate, BigDecimal divideRate, Timestamp validFrom, Timestamp validTo) {
        boolean result = false;
        if (MConversionRate.getConversionRateId((int)currencyId, (int)currencyIdTo, (Timestamp)validFrom, (int)conversionType.get_ID(), (int)Env.getAD_Client_ID((Properties)this.getCtx()), (int)Env.getAD_Org_ID((Properties)this.getCtx())) > 0) {
            this.addLog(MConversionRate.getErrorMessage((Properties)this.getCtx(), (String)"CurrencyRateAlreadyExists", (int)currencyId, (int)currencyIdTo, (int)conversionType.get_ID(), (Timestamp)validFrom, (String)this.get_TrxName()));
        } else if (MConversionRate.getConversionRateId((int)currencyId, (int)currencyIdTo, (Timestamp)validTo, (int)conversionType.get_ID(), (int)Env.getAD_Client_ID((Properties)this.getCtx()), (int)Env.getAD_Org_ID((Properties)this.getCtx())) > 0) {
            this.addLog(MConversionRate.getErrorMessage((Properties)this.getCtx(), (String)"CurrencyRateAlreadyExists", (int)currencyId, (int)currencyIdTo, (int)conversionType.get_ID(), (Timestamp)validTo, (String)this.get_TrxName()));
        } else {
            MConversionRate conversionRate = new MConversionRate(this.getCtx(), 0, this.get_TrxName());
            if (multiplyRate.compareTo(divideRate) > 0) {
                divideRate = Env.ONE.divide(multiplyRate, MathContext.DECIMAL128);
                multiplyRate = Env.ONE.divide(divideRate, MathContext.DECIMAL128);
            } else {
                multiplyRate = Env.ONE.divide(divideRate, MathContext.DECIMAL128);
                divideRate = Env.ONE.divide(multiplyRate, MathContext.DECIMAL128);
            }
            conversionRate.setC_Currency_ID(currencyId);
            conversionRate.setC_Currency_ID_To(currencyIdTo);
            conversionRate.setC_ConversionType_ID(conversionType.get_ID());
            conversionRate.setMultiplyRate(multiplyRate);
            conversionRate.setDivideRate(divideRate);
            conversionRate.setValidFrom(validFrom);
            conversionRate.setValidTo(validTo);
            result = conversionRate.save();
            if (result) {
                this.addLog("@C_Conversion_Rate_ID@ @Created@ -> ".concat(conversionType.getName()).concat(" @MultiplyRate@= ").concat(multiplyRate.toString()).concat(" @DivideRate@= ").concat(divideRate.toString()).concat(" @ValidFrom@: ").concat(validFrom.toString()).concat(" @ValidTo@: ").concat(validTo.toString()));
            }
        }
        return result;
    }
}

