/*
 * Decompiled with CFR 0.152.
 */
package org.spin.tools.process;

import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MBPGroup;
import org.compiere.model.MCharge;
import org.compiere.model.MCommission;
import org.compiere.model.MCommissionGroup;
import org.compiere.model.MCommissionLine;
import org.compiere.model.MCommissionType;
import org.compiere.model.MDunning;
import org.compiere.model.MDunningLevel;
import org.compiere.model.MInvoiceSchedule;
import org.compiere.model.MPaySchedule;
import org.compiere.model.MPaymentTerm;
import org.compiere.model.MTable;
import org.compiere.model.MTax;
import org.compiere.model.MTaxCategory;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_C_ChargeType;
import org.compiere.model.X_C_Greeting;
import org.compiere.model.X_M_RMAType;
import org.spin.tools.process.CopySODefinitionsAbstract;
import org.spin.tools.util.CopyContextUtil;
import org.spin.tools.util.CopyUtil;

public class CopySODefinitions
extends CopySODefinitionsAbstract {
    private CopyUtil copy;

    @Override
    protected void prepare() {
        super.prepare();
        if (this.getTemplateClientId() <= 0) {
            throw new AdempiereException("@ECA25_TemplateClient_ID@ @IsMandatory@");
        }
        int targetClientId = this.getTargetClientId();
        if (targetClientId == 0) {
            targetClientId = this.getAD_Client_ID();
        }
        if (targetClientId == 0) {
            throw new AdempiereException("@ECA25_TargetClient_ID@ @NotFound@");
        }
        this.copy = CopyUtil.newInstance().withTeplateClientId(this.getTemplateClientId()).withTargetClientId(targetClientId).withContext(this.getCtx()).withTransactionName(this.get_TrxName());
    }

    protected String doIt() throws Exception {
        try {
            CopyContextUtil.newInstance().updateContextToNewClient(this.getCtx(), this.copy.getTargetClientId(), this.getProcessInfo().isBatch());
            this.copy.getTemplateReferencesOnlyNewIds("C_BP_Group").forEach(currentBusinessPartnerGroupId -> {
                MBPGroup currentBusinessPartnerGroup = new MBPGroup(this.getCtx(), currentBusinessPartnerGroupId.intValue(), this.get_TrxName());
                MBPGroup newBusinessPartnerGroup = new MBPGroup(this.getCtx(), 0, this.get_TrxName());
                this.copy.copyCurrentValues((PO)currentBusinessPartnerGroup, (PO)newBusinessPartnerGroup);
                newBusinessPartnerGroup.setAD_Org_ID(0);
                newBusinessPartnerGroup.saveEx();
                this.copy.saveReference((PO)currentBusinessPartnerGroup, (PO)newBusinessPartnerGroup);
            });
            this.copy.getTemplateReferencesOnlyNewIds("C_Dunning").forEach(currentDunningId -> {
                MDunning currentDunning = new MDunning(this.getCtx(), currentDunningId.intValue(), this.get_TrxName());
                MDunning newDunning = new MDunning(this.getCtx(), 0, this.get_TrxName());
                this.copy.copyCurrentValues((PO)currentDunning, (PO)newDunning);
                newDunning.setAD_Org_ID(0);
                newDunning.saveEx();
                this.copy.saveReference((PO)currentDunning, (PO)newDunning);
                new Query(this.getCtx(), "C_DunningLevel", "C_Dunning_ID = ?", this.get_TrxName()).setParameters(new Object[]{currentDunning.getC_Dunning_ID()}).getIDsAsList().forEach(currentDunningLevelId -> {
                    MDunningLevel currentDunningLevel = new MDunningLevel(this.getCtx(), currentDunningLevelId.intValue(), this.get_TrxName());
                    MDunningLevel newDunningLevel = new MDunningLevel(this.getCtx(), 0, this.get_TrxName());
                    this.copy.copyCurrentValues((PO)currentDunningLevel, (PO)newDunningLevel);
                    newDunningLevel.setAD_Org_ID(0);
                    newDunningLevel.setC_Dunning_ID(newDunning.getC_Dunning_ID());
                    newDunningLevel.saveEx();
                    this.copy.saveReference((PO)currentDunningLevel, (PO)newDunningLevel);
                    this.copy.copyTranslation((PO)currentDunningLevel, (PO)newDunningLevel);
                });
            });
            this.copy.getTemplateReferencesOnlyNewIds("C_InvoiceSchedule").forEach(currentInvoiceScheduleId -> {
                MInvoiceSchedule currentInvoiceSchedule = new MInvoiceSchedule(this.getCtx(), currentInvoiceScheduleId.intValue(), this.get_TrxName());
                MInvoiceSchedule newInvoiceSchedule = new MInvoiceSchedule(this.getCtx(), 0, this.get_TrxName());
                this.copy.copyCurrentValues((PO)currentInvoiceSchedule, (PO)newInvoiceSchedule);
                newInvoiceSchedule.setAD_Org_ID(0);
                newInvoiceSchedule.saveEx();
                this.copy.saveReference((PO)currentInvoiceSchedule, (PO)newInvoiceSchedule);
            });
            this.copy.getTemplateReferencesOnlyNewIds("C_CommissionType").forEach(currentCommissionTypeId -> {
                MCommissionType currentCommissionType = new MCommissionType(this.getCtx(), currentCommissionTypeId.intValue(), this.get_TrxName());
                MCommissionType newCommissionType = new MCommissionType(this.getCtx(), 0, this.get_TrxName());
                this.copy.copyCurrentValues((PO)currentCommissionType, (PO)newCommissionType);
                newCommissionType.setAD_Org_ID(0);
                newCommissionType.saveEx();
                this.copy.saveReference((PO)currentCommissionType, (PO)newCommissionType);
            });
            this.copy.getTemplateReferencesOnlyNewIds("C_CommissionGroup").forEach(currentCommissionGroupId -> {
                MCommissionGroup currentommissionGroup = new MCommissionGroup(this.getCtx(), currentCommissionGroupId.intValue(), this.get_TrxName());
                MCommissionGroup newommissionGroup = new MCommissionGroup(this.getCtx(), 0, this.get_TrxName());
                this.copy.copyCurrentValues((PO)currentommissionGroup, (PO)newommissionGroup);
                newommissionGroup.setAD_Org_ID(0);
                newommissionGroup.saveEx();
                this.copy.saveReference((PO)currentommissionGroup, (PO)newommissionGroup);
            });
            this.copy.getTemplateReferencesOnlyNewIds("C_Commission").forEach(currentCommissionId -> {
                MCommission currentCommission = new MCommission(this.getCtx(), currentCommissionId.intValue(), this.get_TrxName());
                MCommission newCommission = new MCommission(this.getCtx(), 0, this.get_TrxName());
                this.copy.copyCurrentValues((PO)currentCommission, (PO)newCommission);
                newCommission.setAD_Org_ID(0);
                newCommission.saveEx();
                this.copy.saveReference((PO)currentCommission, (PO)newCommission);
                new Query(this.getCtx(), "C_CommissionLine", "C_Commission_ID = ?", this.get_TrxName()).setParameters(new Object[]{currentCommission.getC_Commission_ID()}).getIDsAsList().forEach(currentCommissionLineId -> {
                    MCommissionLine currentCommissionLine = new MCommissionLine(this.getCtx(), currentCommissionLineId.intValue(), this.get_TrxName());
                    MCommissionLine newCommissionLine = new MCommissionLine(this.getCtx(), 0, this.get_TrxName());
                    this.copy.copyCurrentValues((PO)currentCommissionLine, (PO)newCommissionLine);
                    newCommissionLine.setAD_Org_ID(0);
                    newCommissionLine.setC_Commission_ID(newCommission.getC_Commission_ID());
                    newCommissionLine.saveEx();
                    this.copy.saveReference((PO)currentCommissionLine, (PO)newCommissionLine);
                });
            });
            this.copy.getTemplateReferencesOnlyNewIds("C_PaymentTerm").forEach(currentPaymentTermId -> {
                MPaymentTerm currentPaymentTerm = new MPaymentTerm(this.getCtx(), currentPaymentTermId.intValue(), this.get_TrxName());
                MPaymentTerm newPaymentTerm = new MPaymentTerm(this.getCtx(), 0, this.get_TrxName());
                this.copy.copyCurrentValues((PO)currentPaymentTerm, (PO)newPaymentTerm);
                newPaymentTerm.setAD_Org_ID(0);
                newPaymentTerm.saveEx();
                this.copy.saveReference((PO)currentPaymentTerm, (PO)newPaymentTerm);
                this.copy.copyTranslation((PO)currentPaymentTerm, (PO)newPaymentTerm);
                new Query(this.getCtx(), "C_PaySchedule", "C_PaymentTerm_ID = ?", this.get_TrxName()).setParameters(new Object[]{currentPaymentTerm.getC_PaymentTerm_ID()}).getIDsAsList().forEach(currentPaymentScheduleId -> {
                    MPaySchedule currentPaymentSchedule = new MPaySchedule(this.getCtx(), currentPaymentScheduleId.intValue(), this.get_TrxName());
                    MPaySchedule newPaymentSchedule = new MPaySchedule(this.getCtx(), 0, this.get_TrxName());
                    this.copy.copyCurrentValues((PO)currentPaymentSchedule, (PO)newPaymentSchedule);
                    newPaymentSchedule.setAD_Org_ID(0);
                    newPaymentSchedule.setC_PaymentTerm_ID(newPaymentTerm.getC_PaymentTerm_ID());
                    newPaymentSchedule.saveEx();
                    this.copy.saveReference((PO)currentPaymentSchedule, (PO)newPaymentSchedule);
                });
            });
            this.copy.getTemplateReferencesOnlyNewIds("C_Greeting").forEach(currentGreetingId -> {
                X_C_Greeting currentGreeting = new X_C_Greeting(this.getCtx(), currentGreetingId.intValue(), this.get_TrxName());
                X_C_Greeting newGreeting = new X_C_Greeting(this.getCtx(), 0, this.get_TrxName());
                this.copy.copyCurrentValues((PO)currentGreeting, (PO)newGreeting);
                newGreeting.setAD_Org_ID(0);
                this.copy.saveReference((PO)currentGreeting, (PO)newGreeting);
                this.copy.copyTranslation((PO)currentGreeting, (PO)newGreeting);
            });
            this.copy.getTemplateReferencesOnlyNewIds("M_RMAType").forEach(currentReturnMaterialTypeId -> {
                X_M_RMAType currentReturnMaterialType = new X_M_RMAType(this.getCtx(), currentReturnMaterialTypeId.intValue(), this.get_TrxName());
                X_M_RMAType newReturnMaterialType = new X_M_RMAType(this.getCtx(), 0, this.get_TrxName());
                this.copy.copyCurrentValues((PO)currentReturnMaterialType, (PO)newReturnMaterialType);
                newReturnMaterialType.setAD_Org_ID(0);
                newReturnMaterialType.saveEx();
                this.copy.saveReference((PO)currentReturnMaterialType, (PO)newReturnMaterialType);
            });
            this.copy.getTemplateReferencesOnlyNewIds("C_TaxCategory").forEach(currentTaxCategoryId -> {
                MTaxCategory currentTaxCategory = new MTaxCategory(this.getCtx(), currentTaxCategoryId.intValue(), this.get_TrxName());
                MTaxCategory newTaxCategory = new MTaxCategory(this.getCtx(), 0, this.get_TrxName());
                this.copy.copyCurrentValues((PO)currentTaxCategory, (PO)newTaxCategory);
                newTaxCategory.setAD_Org_ID(0);
                newTaxCategory.saveEx();
                this.copy.saveReference((PO)currentTaxCategory, (PO)newTaxCategory);
                this.copy.copyTranslation((PO)currentTaxCategory, (PO)newTaxCategory);
                new Query(this.getCtx(), "C_Tax", "C_TaxCategory_ID = ?", this.get_TrxName()).setParameters(new Object[]{currentTaxCategory.getC_TaxCategory_ID()}).getIDsAsList().forEach(currentTaxId -> {
                    MTax currentTax = new MTax(this.getCtx(), currentTaxId.intValue(), this.get_TrxName());
                    MTax newTax = new MTax(this.getCtx(), 0, this.get_TrxName());
                    int newOrganizationId = this.copy.getReferenceId("AD_Org", currentTax.getAD_Org_ID());
                    if (newOrganizationId < 0) {
                        newOrganizationId = 0;
                    }
                    this.copy.copyCurrentValues((PO)currentTax, (PO)newTax);
                    newTax.setC_TaxCategory_ID(newTaxCategory.getC_TaxCategory_ID());
                    newTax.saveEx();
                    this.copy.copyTranslation((PO)currentTax, (PO)newTax);
                    this.copy.saveReference((PO)currentTax, (PO)newTax);
                });
            });
            this.copy.getTemplateReferencesOnlyNewIds("C_ChargeType").forEach(currentChargeTypeId -> {
                X_C_ChargeType currentChargeType = new X_C_ChargeType(this.getCtx(), currentChargeTypeId.intValue(), this.get_TrxName());
                X_C_ChargeType newChargeType = new X_C_ChargeType(this.getCtx(), 0, this.get_TrxName());
                this.copy.copyCurrentValues((PO)currentChargeType, (PO)newChargeType);
                newChargeType.setAD_Org_ID(0);
                newChargeType.saveEx();
                this.copy.saveReference((PO)currentChargeType, (PO)newChargeType);
                new Query(this.getCtx(), "C_ChargeType_DocType", "C_ChargeType_ID = ?", this.get_TrxName()).setParameters(new Object[]{currentChargeType.getC_ChargeType_ID()}).list().forEach(currentChargeTypeByDocument -> {
                    PO newChargeTypeByDocument = MTable.get((Properties)this.getCtx(), (String)"C_ChargeType_DocType").getPO(0, this.get_TrxName());
                    int newDocumentTypeId = this.copy.getReferenceId("C_DocType", currentChargeTypeByDocument.get_ValueAsInt("C_DocType_ID"));
                    if (newDocumentTypeId > 0) {
                        this.copy.copyCurrentValues((PO)currentChargeTypeByDocument, newChargeTypeByDocument);
                        newChargeTypeByDocument.setAD_Org_ID(0);
                        newChargeTypeByDocument.set_ValueOfColumn("C_ChargeType_ID", (Object)newChargeType.getC_ChargeType_ID());
                        newChargeTypeByDocument.set_ValueOfColumn("C_DocType_ID", (Object)newDocumentTypeId);
                        newChargeTypeByDocument.saveEx();
                        this.copy.saveReference((PO)currentChargeTypeByDocument, newChargeTypeByDocument);
                    }
                });
            });
            this.copy.getTemplateReferencesOnlyNewIds("C_Charge").forEach(currentChargeId -> {
                int newcCargeTypeId;
                MCharge currentCharge = new MCharge(this.getCtx(), currentChargeId.intValue(), this.get_TrxName());
                MCharge newCharge = new MCharge(this.getCtx(), 0, this.get_TrxName());
                this.copy.copyCurrentValues((PO)currentCharge, (PO)newCharge);
                newCharge.setAD_Org_ID(0);
                if (currentCharge.getC_ChargeType_ID() > 0 && (newcCargeTypeId = this.copy.getReferenceId("C_ChargeType", currentCharge.getC_ChargeType_ID())) > 0) {
                    newCharge.setC_ChargeType_ID(newcCargeTypeId);
                }
                newCharge.saveEx();
                this.copy.saveReference((PO)currentCharge, (PO)newCharge);
                this.copy.copyTranslation((PO)currentCharge, (PO)newCharge);
            });
        }
        catch (Exception e) {
            throw new AdempiereException((Throwable)e);
        }
        finally {
            CopyContextUtil.newInstance().revertContextToCurrentClient(this.getCtx(), this.getProcessInfo().isBatch());
        }
        return "Ok";
    }
}

