/*
 * Decompiled with CFR 0.152.
 */
package org.spin.tools.process;

import java.math.BigDecimal;
import java.util.ArrayList;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MClient;
import org.compiere.model.MRole;
import org.compiere.model.MRoleIncluded;
import org.compiere.model.MUserRoles;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.DB;
import org.spin.tools.process.CopyRoleDefinitionAbstract;
import org.spin.tools.util.CopyContextUtil;
import org.spin.tools.util.CopyUtil;

public class CopyRoleDefinition
extends CopyRoleDefinitionAbstract {
    private CopyUtil copy;
    private MClient currentClient;
    private MClient newClient;

    @Override
    protected void prepare() {
        super.prepare();
        if (this.getTemplateClientId() <= 0) {
            throw new AdempiereException("@ECA25_TemplateClient_ID@ @IsMandatory@");
        }
        int targetClientId = this.getTargetClientId();
        if (targetClientId == 0) {
            targetClientId = this.getAD_Client_ID();
        }
        this.setTargetClientId(targetClientId);
        if (targetClientId == 0) {
            throw new AdempiereException("@ECA25_TargetClient_ID@ @NotFound@");
        }
        this.currentClient = new MClient(this.getCtx(), this.getTemplateClientId(), this.get_TrxName());
        this.newClient = new MClient(this.getCtx(), this.getTargetClientId(), this.get_TrxName());
        this.copy = CopyUtil.newInstance().withTeplateClientId(this.getTemplateClientId()).withTargetClientId(targetClientId).withContext(this.getCtx()).withTransactionName(this.get_TrxName());
    }

    protected String doIt() throws Exception {
        try {
            CopyContextUtil.newInstance().updateContextToNewClient(this.getCtx(), this.copy.getTargetClientId(), this.getProcessInfo().isBatch());
            ArrayList copiedRolesIds = new ArrayList();
            this.copy.getTemplateReferencesOnlyNewIds("AD_Role").forEach(currentRoleId -> {
                MRole currentRole = new MRole(this.getCtx(), currentRoleId.intValue(), this.get_TrxName());
                this.copyRole(currentRole);
                copiedRolesIds.add(currentRoleId);
            });
            copiedRolesIds.forEach(currentRoleId -> new Query(this.getCtx(), "AD_Role_Included", "AD_Role_ID = ?", this.get_TrxName()).setParameters(new Object[]{currentRoleId}).list().forEach(currentIncludedRole -> {
                MRoleIncluded newIncludedRoleReference = new MRoleIncluded(this.getCtx(), 0, this.get_TrxName());
                newIncludedRoleReference.setAD_Role_ID(this.copy.getReferenceId("AD_Role", (int)currentRoleId));
                newIncludedRoleReference.setIncluded_Role_ID(this.copy.getReferenceId("AD_Role", currentIncludedRole.getIncluded_Role_ID()));
                newIncludedRoleReference.saveEx();
            }));
        }
        catch (Exception e) {
            throw new AdempiereException((Throwable)e);
        }
        finally {
            CopyContextUtil.newInstance().revertContextToCurrentClient(this.getCtx(), this.getProcessInfo().isBatch());
        }
        return "Ok";
    }

    private MRole copyRole(MRole sourceRole) {
        MRole newRole = new MRole(this.getCtx(), 0, this.get_TrxName());
        this.copy.copyCurrentValues((PO)sourceRole, (PO)newRole);
        String newName = this.newClient.getValue() + " > " + sourceRole.getName().replaceAll(this.currentClient.getValue() + " > ", "").replaceAll(this.currentClient.getName() + " > ", "").replaceAll(this.currentClient.getValue(), "").replaceAll(this.currentClient.getName(), "");
        newRole.setName(newName);
        newRole.setIsDirectLoad(true);
        newRole.saveEx();
        this.copy.saveReference((PO)sourceRole, (PO)newRole);
        new Query(this.getCtx(), "AD_User", "AD_Client_ID = 0 AND IsLoginUser = 'Y' AND IsInternalUser = 'Y'", this.get_TrxName()).setOnlyActiveRecords(true).getIDsAsList().forEach(userId -> {
            MUserRoles userRoles = new MUserRoles(this.getCtx(), userId.intValue(), newRole.getAD_Role_ID(), this.get_TrxName());
            userRoles.saveEx();
        });
        String[] tables = new String[]{"AD_Window_Access", "AD_Process_Access", "AD_Form_Access", "AD_Workflow_Access", "AD_Task_Access", "AD_Document_Action_Access", "AD_Browse_Access"};
        String[] keycolumns = new String[]{"AD_Window_ID", "AD_Process_ID", "AD_Form_ID", "AD_Workflow_ID", "AD_Task_ID", "C_DocType_ID, AD_Ref_List_ID", "AD_Browse_ID"};
        int action = 0;
        for (int i = 0; i < tables.length; ++i) {
            String table = tables[i];
            String keycolumn = keycolumns[i];
            String sql = "DELETE FROM " + table + " WHERE AD_Role_ID = " + newRole.getAD_Role_ID();
            int no = DB.executeUpdateEx((String)sql, (String)this.get_TrxName());
            this.addLog(action++, null, BigDecimal.valueOf(no), "Old records deleted from " + table);
            boolean isDocumentActionAccess = table.equals("AD_Document_Action_Access");
            if (!isDocumentActionAccess) {
                sql = "INSERT INTO " + table + " (AD_Client_ID, AD_Org_ID, Created, CreatedBy, Updated, UpdatedBy, AD_Role_ID, " + keycolumn + ", isActive";
                sql = sql + ", isReadWrite) ";
                sql = sql + "SELECT " + this.getTargetClientId() + ", " + 0 + ", getdate(), " + this.getAD_User_ID() + ", getdate(), " + this.getAD_User_ID() + ", " + newRole.getAD_Role_ID() + ", " + keycolumn + ", IsActive ";
                sql = sql + ", isReadWrite ";
                sql = sql + "FROM " + table + " WHERE AD_Role_ID = " + sourceRole.getAD_Role_ID();
            } else {
                sql = "INSERT INTO AD_Document_Action_Access (AD_Client_ID, AD_Org_ID, Created, CreatedBy, Updated, UpdatedBy, AD_Role_ID, C_DocType_ID, AD_Ref_List_ID, isActive) ";
                sql = sql + "SELECT " + this.getTargetClientId() + ", " + 0 + ", getdate(), " + this.getAD_User_ID() + ", getdate(), " + this.getAD_User_ID() + ", " + newRole.getAD_Role_ID() + ", r.ECA25_Target_ID, a.AD_Ref_List_ID, a.IsActive ";
                sql = sql + "FROM AD_Document_Action_Access a INNER JOIN T_ECA25_CopyReference r ON(r.ECA25_TemplateClient_ID = " + this.getTemplateClientId() + " AND r.ECA25_TargetClient_ID = " + this.getTargetClientId() + " AND r.TableName = 'C_DocType' AND r.ECA25_Template_ID = a.C_DocType_ID) WHERE a.AD_Role_ID = " + sourceRole.getAD_Role_ID();
            }
            no = DB.executeUpdateEx((String)sql, (String)this.get_TrxName());
        }
        this.addLog("@AD_Role_ID@: " + newRole.getName());
        return newRole;
    }
}

