/*
 * Decompiled with CFR 0.152.
 */
package org.spin.tools.process;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.compiere.model.MColumn;
import org.compiere.model.MCurrency;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.print.MPrintFormat;
import org.compiere.print.MPrintFormatItem;
import org.spin.tools.process.CopyPrintFormatWithConversionAbstract;

public class CopyPrintFormatWithConversion
extends CopyPrintFormatWithConversionAbstract {
    private AtomicInteger created = new AtomicInteger();
    private final String DEFAULT_WHERE_CLAUSE = "UUID IS NOT NULL AND LENGTH(UUID) > 7";

    protected String doIt() throws Exception {
        Query query = null;
        query = this.getRecord_ID() > 0 ? new Query(this.getCtx(), "AD_PrintFormat", "AD_PrintFormat_ID = ?", this.get_TrxName()).setParameters(new Object[]{this.getRecord_ID()}) : new Query(this.getCtx(), "AD_PrintFormat", "UUID IS NOT NULL AND LENGTH(UUID) > 7  AND EXISTS(SELECT 1     FROM AD_PrintFormatItem pfi    INNER JOIN AD_Column c ON(pfi.AD_Column_ID = c.AD_Column_ID)     WHERE EXISTS(SELECT 1 FROM AD_Table t     INNER JOIN AD_Column rc ON(rc.AD_Table_ID = t.AD_Table_ID)     WHERE length(c.ColumnName) > 3 AND substr(c.ColumnName, 1, length(c.ColumnName) - 3) = t.TableName     AND rc.ColumnName IN('C_Currency_ID', 'DateAcct', 'C_ConversionType_ID')     AND COALESCE(rc.ColumnSQL,'')='')     AND pfi.AD_PrintFormat_ID = AD_PrintFormat.AD_PrintFormat_ID) AND IsForm = 'N' ", this.get_TrxName());
        query.setOnlyActiveRecords(true).setClient_ID().list().forEach(sourcePrintFormat -> this.copyPrintFormat((MPrintFormat)sourcePrintFormat));
        return "@Created@ " + this.created;
    }

    private void copyPrintFormat(MPrintFormat sourcePrintFormat) {
        List sourceReferencedItems = Arrays.asList(sourcePrintFormat.getItems()).stream().filter(printFormatItem -> {
            if (printFormatItem.getAD_Column_ID() <= 0) {
                return false;
            }
            MColumn column = MColumn.get((Properties)this.getCtx(), (int)printFormatItem.getAD_Column_ID());
            MTable referencedTable = MTable.get((Properties)this.getCtx(), (String)column.getColumnName().replaceAll("_ID", ""));
            if (referencedTable == null || referencedTable.getAD_Table_ID() <= 0) {
                return false;
            }
            if (!referencedTable.isDocument()) {
                return false;
            }
            return referencedTable.getColumnsAsList().stream().filter(columnToFind -> columnToFind.getColumnName().equals("C_Currency_ID") || columnToFind.getColumnName().equals("C_ConversionType_ID")).findFirst().isPresent();
        }).collect(Collectors.toList());
        Optional<Object> maybeReferencedItem = sourceReferencedItems.stream().filter(printFormatItem -> MColumn.get((Properties)this.getCtx(), (int)printFormatItem.getAD_Column_ID()).getColumnName().equals("C_Payment_ID")).findFirst();
        if (!maybeReferencedItem.isPresent()) {
            maybeReferencedItem = sourceReferencedItems.stream().filter(printFormatItem -> MColumn.get((Properties)this.getCtx(), (int)printFormatItem.getAD_Column_ID()).getColumnName().equals("C_Invoice_ID")).findFirst();
        }
        if (!maybeReferencedItem.isPresent()) {
            maybeReferencedItem = sourceReferencedItems.stream().filter(printFormatItem -> MColumn.get((Properties)this.getCtx(), (int)printFormatItem.getAD_Column_ID()).getColumnName().equals("C_Order_ID")).findFirst();
        }
        if (!maybeReferencedItem.isPresent()) {
            maybeReferencedItem = sourceReferencedItems.stream().findFirst();
        }
        if (maybeReferencedItem.isPresent()) {
            MColumn sourceReferencedColumn = MColumn.get((Properties)this.getCtx(), (int)((MPrintFormatItem)maybeReferencedItem.get()).getAD_Column_ID());
            MTable referencedTable = MTable.get((Properties)this.getCtx(), (int)sourceReferencedColumn.getAD_Table_ID());
            AtomicReference<MColumn> sourceDateColumn = new AtomicReference<MColumn>();
            Optional<MColumn> maybeDateColumn = referencedTable.getColumnsAsList().stream().filter(column -> column.getColumnName().equals("DateAcct")).findFirst();
            if (!maybeDateColumn.isPresent()) {
                maybeDateColumn = referencedTable.getColumnsAsList().stream().filter(column -> column.getAD_Reference_ID() == 15 && !column.getColumnName().equals("Created") && !column.getColumnName().equals("Updated")).findFirst();
                maybeDateColumn.ifPresent(date -> sourceDateColumn.set((MColumn)date));
            } else {
                sourceDateColumn.set(maybeDateColumn.get());
            }
            if (maybeDateColumn.isPresent()) {
                MPrintFormat targetPrintFormat = new MPrintFormat(this.getCtx(), 0, this.get_TrxName());
                PO.copyValues((PO)sourcePrintFormat, (PO)targetPrintFormat);
                targetPrintFormat.setName(sourcePrintFormat.getName() + this.getSuffix());
                targetPrintFormat.saveEx(this.get_TrxName());
                targetPrintFormat.setUUID(String.valueOf(sourcePrintFormat.getAD_PrintFormat_ID()));
                targetPrintFormat.setIsDirectLoad(true);
                targetPrintFormat.saveEx();
                Arrays.asList(sourcePrintFormat.getItems()).forEach(sourcePrintFormatItem -> {
                    MColumn column;
                    MPrintFormatItem targetPrintFormatItem = new MPrintFormatItem(this.getCtx(), 0, this.get_TrxName());
                    PO.copyValues((PO)sourcePrintFormatItem, (PO)targetPrintFormatItem);
                    targetPrintFormatItem.setAD_PrintFormat_ID(targetPrintFormat.getAD_PrintFormat_ID());
                    targetPrintFormatItem.saveEx(this.get_TrxName());
                    targetPrintFormatItem.setUUID(String.valueOf(sourcePrintFormatItem.getAD_PrintFormatItem_ID()));
                    targetPrintFormatItem.setIsDirectLoad(true);
                    targetPrintFormatItem.saveEx();
                    this.copyTranslation((PO)sourcePrintFormatItem, (PO)targetPrintFormatItem);
                    if (sourcePrintFormatItem.getAD_Column_ID() > 0 && ((column = MColumn.get((Properties)this.getCtx(), (int)sourcePrintFormatItem.getAD_Column_ID())).getColumnName().equals("TotalLines") || column.getColumnName().equals("GrandTotal") || column.getColumnName().equals("LineNetAmt") || column.getColumnName().equals("PayAmt") || column.getColumnName().equals("OpenAmt") || column.getColumnName().equals("PaidAmt"))) {
                        targetPrintFormatItem.set_ValueOfColumn("IsConvertedColumn", (Object)true);
                        targetPrintFormatItem.set_ValueOfColumn("C_Currency_ID", (Object)this.getCurrencyId());
                        if (this.getConversionTypeId() > 0) {
                            targetPrintFormatItem.set_ValueOfColumn("C_ConversionType_ID", (Object)this.getConversionTypeId());
                        }
                        targetPrintFormatItem.set_ValueOfColumn("SourceColumnDocument_ID", (Object)sourceReferencedColumn.getAD_Column_ID());
                        targetPrintFormatItem.set_ValueOfColumn("SourceColumnDate_ID", (Object)((MColumn)sourceDateColumn.get()).getAD_Column_ID());
                        MCurrency currency = MCurrency.get((Properties)this.getCtx(), (int)this.getCurrencyId());
                        targetPrintFormatItem.setPrintName(targetPrintFormatItem.getPrintName() + " (" + currency.getISO_Code() + ")");
                        targetPrintFormatItem.setIsDirectLoad(true);
                        targetPrintFormatItem.saveEx();
                        if (targetPrintFormatItem.isCentrallyMaintained()) {
                            this.copyTranslation((PO)sourcePrintFormatItem, (PO)targetPrintFormatItem);
                            new Query(this.getCtx(), "AD_PrintFormatItem_Trl", "AD_PrintFormatItem_ID = ?", this.get_TrxName()).setParameters(new Object[]{targetPrintFormatItem.getAD_PrintFormatItem_ID()}).list().stream().forEach(translation -> {
                                translation.set_ValueOfColumn("PrintName", (Object)(translation.get_ValueAsString("PrintName") + " (" + currency.getISO_Code() + ")"));
                                translation.saveEx();
                            });
                        }
                    }
                });
                this.created.incrementAndGet();
                this.addLog("@AD_PrintFormat_ID@ " + targetPrintFormat.getName() + " @Added@");
            }
        }
    }

    private void copyTranslation(PO source, PO target) {
        String tableName = source.get_TableName() + "_Trl";
        MTable.get((Properties)this.getCtx(), (int)source.get_Table_ID()).getColumnsAsList().stream().filter(column -> column.isTranslated()).findAny().ifPresent(column -> new Query(this.getCtx(), tableName, source.get_KeyColumns()[0] + " = ?", this.get_TrxName()).setParameters(new Object[]{source.get_ID()}).list().forEach(sourceTranslation -> new Query(this.getCtx(), tableName, target.get_KeyColumns()[0] + " = ? AND AD_Language = ?", this.get_TrxName()).setParameters(new Object[]{target.get_ID(), sourceTranslation.get_ValueAsString("AD_Language")}).list().forEach(targetTranslation -> {
            MTable.get((Properties)this.getCtx(), (int)source.get_Table_ID()).getColumnsAsList().stream().filter(translatedColumn -> translatedColumn.isTranslated()).forEach(translatedColumn -> targetTranslation.set_ValueOfColumn(translatedColumn.getColumnName(), sourceTranslation.get_Value(translatedColumn.getColumnName())));
            targetTranslation.saveEx();
        })));
    }
}

