/*
 * Decompiled with CFR 0.152.
 */
package org.spin.tools.process;

import java.sql.Timestamp;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MConversionType;
import org.compiere.model.MDiscountSchema;
import org.compiere.model.MDiscountSchemaBreak;
import org.compiere.model.MDiscountSchemaLine;
import org.compiere.model.MPriceList;
import org.compiere.model.MPriceListVersion;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.spin.tools.process.CopyPODefinitionsAbstract;
import org.spin.tools.util.CopyContextUtil;
import org.spin.tools.util.CopyUtil;

public class CopyPODefinitions
extends CopyPODefinitionsAbstract {
    private CopyUtil copy;

    @Override
    protected void prepare() {
        super.prepare();
        if (this.getTemplateClientId() <= 0) {
            throw new AdempiereException("@ECA25_TemplateClient_ID@ @IsMandatory@");
        }
        int targetClientId = this.getTargetClientId();
        if (targetClientId == 0) {
            targetClientId = this.getAD_Client_ID();
        }
        if (targetClientId == 0) {
            throw new AdempiereException("@ECA25_TargetClient_ID@ @NotFound@");
        }
        this.copy = CopyUtil.newInstance().withTeplateClientId(this.getTemplateClientId()).withTargetClientId(targetClientId).withContext(this.getCtx()).withTransactionName(this.get_TrxName());
    }

    protected String doIt() throws Exception {
        try {
            CopyContextUtil.newInstance().updateContextToNewClient(this.getCtx(), this.copy.getTargetClientId(), this.getProcessInfo().isBatch());
            this.copy.getTemplateReferencesOnlyNewIds("M_DiscountSchema").forEach(currentDiscountSchematId -> {
                MDiscountSchema currentDiscountSchema = new MDiscountSchema(this.getCtx(), currentDiscountSchematId.intValue(), this.get_TrxName());
                MDiscountSchema newDiscountSchema = new MDiscountSchema(this.getCtx(), 0, this.get_TrxName());
                this.copy.copyCurrentValues((PO)currentDiscountSchema, (PO)newDiscountSchema);
                int newOrganizationId = this.copy.getReferenceId("AD_Org", currentDiscountSchema.getAD_Org_ID());
                if (newOrganizationId < 0) {
                    newOrganizationId = 0;
                }
                newDiscountSchema.setAD_Org_ID(newOrganizationId);
                newDiscountSchema.saveEx();
                this.copy.saveReference((PO)currentDiscountSchema, (PO)newDiscountSchema);
                new Query(this.getCtx(), "M_DiscountSchemaLine", "M_DiscountSchema_ID = ?", this.get_TrxName()).setParameters(new Object[]{currentDiscountSchema.getM_DiscountSchema_ID()}).getIDsAsList().forEach(currentDiscountSchemaLineId -> {
                    MDiscountSchemaLine currentDiscountSchemaLine = new MDiscountSchemaLine(this.getCtx(), currentDiscountSchemaLineId.intValue(), this.get_TrxName());
                    MDiscountSchemaLine newDiscountSchemaLine = new MDiscountSchemaLine(this.getCtx(), 0, this.get_TrxName());
                    this.copy.copyCurrentValues((PO)currentDiscountSchemaLine, (PO)newDiscountSchemaLine);
                    newDiscountSchemaLine.setAD_Org_ID(0);
                    newDiscountSchemaLine.setM_DiscountSchema_ID(newDiscountSchema.getM_DiscountSchema_ID());
                    int newReferenceId = this.copy.getReferenceId("M_Product", currentDiscountSchemaLine.getM_Product_ID());
                    newDiscountSchemaLine.setM_Product_ID(newReferenceId);
                    newReferenceId = this.copy.getReferenceId("M_Product_Category", currentDiscountSchemaLine.getM_Product_Category_ID());
                    newDiscountSchemaLine.setM_Product_Category_ID(newReferenceId);
                    newReferenceId = this.copy.getReferenceId("M_Product_Group", currentDiscountSchemaLine.getM_Product_Group_ID());
                    newDiscountSchemaLine.setM_Product_Group_ID(newReferenceId);
                    newReferenceId = this.copy.getReferenceId("M_Product_Class", currentDiscountSchemaLine.getM_Product_Class_ID());
                    newDiscountSchemaLine.setM_Product_Class_ID(newReferenceId);
                    newReferenceId = this.copy.getReferenceId("M_Product_Classification", currentDiscountSchemaLine.getM_Product_Classification_ID());
                    newDiscountSchemaLine.setM_Product_Classification_ID(newReferenceId);
                    newReferenceId = this.copy.getReferenceId("C_BPartner", currentDiscountSchemaLine.getC_BPartner_ID());
                    newDiscountSchemaLine.setC_BPartner_ID(newReferenceId);
                    newReferenceId = this.copy.getReferenceId("C_ConversionType", currentDiscountSchemaLine.getC_ConversionType_ID());
                    if (newReferenceId <= 0) {
                        MConversionType currentConversionType = new MConversionType(this.getCtx(), currentDiscountSchemaLine.getC_ConversionType_ID(), this.get_TrxName());
                        MConversionType newConversionType = new MConversionType(this.getCtx(), 0, this.get_TrxName());
                        this.copy.copyCurrentValues((PO)currentConversionType, (PO)newConversionType);
                        newConversionType.setAD_Org_ID(0);
                        newConversionType.saveEx();
                        this.copy.saveReference((PO)currentConversionType, (PO)newConversionType);
                        newReferenceId = newConversionType.getC_ConversionType_ID();
                    }
                    newDiscountSchemaLine.setC_ConversionType_ID(newReferenceId);
                    newDiscountSchemaLine.saveEx();
                    this.copy.saveReference((PO)currentDiscountSchemaLine, (PO)newDiscountSchemaLine);
                });
                new Query(this.getCtx(), "M_DiscountSchemaBreak", "M_DiscountSchema_ID = ?", this.get_TrxName()).setParameters(new Object[]{currentDiscountSchema.getM_DiscountSchema_ID()}).getIDsAsList().forEach(currentDiscountSchemaBreakId -> {
                    MDiscountSchemaBreak currentDiscountSchemaBreak = new MDiscountSchemaBreak(this.getCtx(), currentDiscountSchemaBreakId.intValue(), this.get_TrxName());
                    MDiscountSchemaBreak newDiscountSchemaBreak = new MDiscountSchemaBreak(this.getCtx(), 0, this.get_TrxName());
                    this.copy.copyCurrentValues((PO)currentDiscountSchemaBreak, (PO)newDiscountSchemaBreak);
                    newDiscountSchemaBreak.setAD_Org_ID(0);
                    newDiscountSchemaBreak.setM_DiscountSchema_ID(newDiscountSchema.getM_DiscountSchema_ID());
                    int newProductCategoryId = this.copy.getReferenceId("M_Product_Category", currentDiscountSchemaBreak.getM_Product_Category_ID());
                    newDiscountSchemaBreak.setM_Product_Category_ID(newProductCategoryId);
                    int newProductId = this.copy.getReferenceId("M_Product", currentDiscountSchemaBreak.getM_Product_ID());
                    newDiscountSchemaBreak.setM_Product_ID(newProductId);
                    newDiscountSchemaBreak.saveEx();
                    this.copy.saveReference((PO)currentDiscountSchemaBreak, (PO)newDiscountSchemaBreak);
                });
            });
            this.copy.getTemplateReferencesOnlyNewIds("M_PriceList").forEach(currentPriceListId -> {
                MPriceList currentPriceList = new MPriceList(this.getCtx(), currentPriceListId.intValue(), this.get_TrxName());
                MPriceList newPriceList = new MPriceList(this.getCtx(), 0, this.get_TrxName());
                this.copy.copyCurrentValues((PO)currentPriceList, (PO)newPriceList);
                int newOrganizationId = this.copy.getReferenceId("AD_Org", currentPriceList.getAD_Org_ID());
                if (newOrganizationId < 0) {
                    newOrganizationId = 0;
                }
                newPriceList.setAD_Org_ID(newOrganizationId);
                newPriceList.saveEx();
                this.copy.saveReference((PO)currentPriceList, (PO)newPriceList);
                this.copy.copyTranslation((PO)currentPriceList, (PO)newPriceList);
                MPriceListVersion currentVersion = currentPriceList.getPriceListVersion(new Timestamp(System.currentTimeMillis()));
                if (currentVersion != null && currentVersion.getM_DiscountSchema_ID() > 0) {
                    MPriceListVersion newVersion = new MPriceListVersion(newPriceList);
                    newVersion.setName(newPriceList.getName());
                    int newReferenceId = this.copy.getReferenceId("M_DiscountSchema", currentVersion.getM_DiscountSchema_ID());
                    newVersion.setM_DiscountSchema_ID(newReferenceId);
                    newVersion.saveEx(this.get_TrxName());
                    this.copy.saveReference((PO)currentVersion, (PO)newVersion);
                }
            });
        }
        catch (Exception e) {
            throw new AdempiereException((Throwable)e);
        }
        finally {
            CopyContextUtil.newInstance().revertContextToCurrentClient(this.getCtx(), this.getProcessInfo().isBatch());
        }
        return "Ok";
    }
}

