/*
 * Decompiled with CFR 0.152.
 */
package org.spin.tools.process;

import java.util.Arrays;
import java.util.Optional;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MBank;
import org.compiere.model.MBankAccount;
import org.compiere.model.MCity;
import org.compiere.model.MDocType;
import org.compiere.model.MLocation;
import org.compiere.model.MLocator;
import org.compiere.model.MOrg;
import org.compiere.model.MOrgInfo;
import org.compiere.model.MRecordAccess;
import org.compiere.model.MRegion;
import org.compiere.model.MRole;
import org.compiere.model.MRoleOrgAccess;
import org.compiere.model.MSequence;
import org.compiere.model.MUserOrgAccess;
import org.compiere.model.MWarehouse;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_AD_Document_Action_Access;
import org.compiere.model.X_C_BankAccountDoc;
import org.compiere.util.Env;
import org.spin.model.MWHDefinitionLine;
import org.spin.tools.process.CopyOrganizationDefinitionAbstract;
import org.spin.tools.util.CopyContextUtil;
import org.spin.tools.util.CopyUtil;

public class CopyOrganizationDefinition
extends CopyOrganizationDefinitionAbstract {
    public static final int WINDOW_THIS_PROCESS = 9999;
    private MOrg currentOrganization;
    private MOrg newOrganization;
    private MOrgInfo newOrganizationInfo;
    private CopyUtil copy;
    private int organizationId;
    private int organizationWithWindowId;

    @Override
    protected void prepare() {
        super.prepare();
        if (this.getTemplateClientId() <= 0) {
            throw new AdempiereException("@ECA25_TemplateClient_ID@ @IsMandatory@");
        }
        int targetClientId = this.getTargetClientId();
        if (targetClientId == 0) {
            targetClientId = this.getAD_Client_ID();
        }
        if (targetClientId == 0) {
            throw new AdempiereException("@ECA25_TargetClient_ID@ @NotFound@");
        }
        this.copy = CopyUtil.newInstance().withTeplateClientId(this.getTemplateClientId()).withTargetClientId(targetClientId).withContext(this.getCtx()).withTransactionName(this.get_TrxName());
        this.organizationWithWindowId = Env.getContextAsInt((Properties)this.getCtx(), (int)9999, (String)"#AD_Org_ID");
        this.organizationId = Env.getContextAsInt((Properties)this.getCtx(), (String)"#AD_Org_ID");
        this.currentOrganization = MOrg.get((Properties)this.getCtx(), (int)this.getOrgId());
    }

    protected String doIt() throws Exception {
        try {
            CopyContextUtil.newInstance().updateContextToNewClient(this.getCtx(), this.copy.getTargetClientId(), this.getProcessInfo().isBatch());
            this.copyOrganization();
            this.copyAccesses();
            this.copyLinkedBusinessPartner();
            this.copyDocumentTypes();
            this.copyWarehouses();
            this.copyPointOfSales();
            this.copyBanks();
            this.copyCashAccounts();
        }
        catch (Exception e) {
            throw new AdempiereException((Throwable)e);
        }
        finally {
            Env.setContext((Properties)this.getCtx(), (int)9999, (String)"AD_Org_ID", (int)this.organizationWithWindowId);
            Env.setContext((Properties)this.getCtx(), (String)"#AD_Org_ID", (int)this.organizationId);
            CopyContextUtil.newInstance().revertContextToCurrentClient(this.getCtx(), this.getProcessInfo().isBatch());
        }
        return this.newOrganization.getValue() + " - " + this.newOrganization.getName();
    }

    private void copyBanks() {
        this.copy.getTemplateReferencesOnlyNewIds("C_Bank").forEach(currentBankId -> {
            MBank currentBank = new MBank(this.getCtx(), currentBankId.intValue(), this.get_TrxName());
            MBank newBank = new MBank(this.getCtx(), 0, this.get_TrxName());
            this.copy.copyCurrentValues((PO)currentBank, (PO)newBank);
            newBank.setAD_Org_ID(0);
            newBank.saveEx();
            this.copy.saveReference((PO)currentBank, (PO)newBank);
        });
    }

    private void copyOrganization() {
        this.newOrganization = new MOrg(this.getCtx(), 0, this.get_TrxName());
        PO.copyValues((PO)this.currentOrganization, (PO)this.newOrganization);
        this.newOrganization.setValue(this.getValue());
        this.newOrganization.setName(this.getName());
        this.newOrganization.saveEx(this.get_TrxName());
        this.copy.withTargetClientId(this.newOrganization.getAD_Client_ID());
        Env.setContext((Properties)this.getCtx(), (int)9999, (String)"AD_Org_ID", (int)this.newOrganization.getAD_Org_ID());
        Env.setContext((Properties)this.getCtx(), (String)"#AD_Org_ID", (int)this.newOrganization.getAD_Org_ID());
        this.newOrganizationInfo = MOrgInfo.get((Properties)this.getCtx(), (int)this.newOrganization.getAD_Org_ID(), (String)this.get_TrxName());
        int currentCountryId = MRegion.get((Properties)this.getCtx(), (int)this.getRegionId()).getC_Country_ID();
        MCity city = MCity.get((Properties)this.getCtx(), (int)this.getCityId());
        MLocation newLocation = new MLocation(this.getCtx(), currentCountryId, this.getRegionId(), city.getName(), this.get_TrxName());
        newLocation.setC_City_ID(this.getCityId());
        Optional.ofNullable(this.getAddress1()).ifPresent(address -> newLocation.setAddress1(address));
        Optional.ofNullable(this.getAddress2()).ifPresent(address -> newLocation.setAddress2(address));
        Optional.ofNullable(this.getAddress3()).ifPresent(address -> newLocation.setAddress3(address));
        Optional.ofNullable(this.getAddress4()).ifPresent(address -> newLocation.setAddress4(address));
        newLocation.saveEx(this.get_TrxName());
        this.newOrganizationInfo.setTaxID(this.getTaxID());
        this.newOrganizationInfo.setC_Location_ID(newLocation.getC_Location_ID());
        this.newOrganizationInfo.saveEx(this.get_TrxName());
        this.addLog("@AD_Org_ID@: " + this.newOrganization.getValue() + " - " + this.newOrganization.getName());
    }

    private void copyDocumentTypes() {
        new Query(this.getCtx(), "C_DocType", "AD_Org_ID = ?", this.get_TrxName()).setParameters(new Object[]{this.getOrgId()}).getIDsAsList().forEach(currentDocumentTypeId -> this.createAndGetDocumentTypeId((int)currentDocumentTypeId));
    }

    private void copyLinkedBusinessPartner() {
        MBPartner currentLinkedBusinessPartner = (MBPartner)new Query(this.getCtx(), "C_BPartner", "AD_OrgBP_ID = ?", this.get_TrxName()).setParameters(new Object[]{this.getOrgId()}).first();
        if (currentLinkedBusinessPartner != null && currentLinkedBusinessPartner.getC_BPartner_ID() > 0) {
            MBPartner newLinkedBusinessPartner = new MBPartner(this.getCtx(), 0, this.get_TrxName());
            PO.copyValues((PO)currentLinkedBusinessPartner, (PO)newLinkedBusinessPartner);
            newLinkedBusinessPartner.setAD_Org_ID(this.newOrganization.getAD_Org_ID());
            newLinkedBusinessPartner.setAD_OrgBP_ID(this.newOrganization.getAD_Org_ID());
            newLinkedBusinessPartner.setValue(this.newOrganization.getValue());
            newLinkedBusinessPartner.setName(this.newOrganization.getName());
            newLinkedBusinessPartner.setDescription(this.newOrganization.getDescription());
            newLinkedBusinessPartner.saveEx(this.get_TrxName());
            int currentCountryId = MRegion.get((Properties)this.getCtx(), (int)this.getRegionId()).getC_Country_ID();
            MCity city = MCity.get((Properties)this.getCtx(), (int)this.getCityId());
            MLocation newLocation = new MLocation(this.getCtx(), currentCountryId, this.getRegionId(), city.getName(), this.get_TrxName());
            newLocation.setC_City_ID(this.getCityId());
            Optional.ofNullable(this.getAddress1()).ifPresent(address -> newLocation.setAddress1(address));
            Optional.ofNullable(this.getAddress2()).ifPresent(address -> newLocation.setAddress2(address));
            Optional.ofNullable(this.getAddress3()).ifPresent(address -> newLocation.setAddress3(address));
            Optional.ofNullable(this.getAddress4()).ifPresent(address -> newLocation.setAddress4(address));
            newLocation.saveEx(this.get_TrxName());
            MBPartnerLocation newLinkedBusinessPartnerLocation = new MBPartnerLocation(newLinkedBusinessPartner);
            newLinkedBusinessPartnerLocation.setC_Location_ID(newLocation.getC_Location_ID());
            newLinkedBusinessPartnerLocation.saveEx(this.get_TrxName());
            this.addLog("@AD_OrgBP_ID@: " + newLinkedBusinessPartner.getValue() + " - " + newLinkedBusinessPartner.getName());
        }
    }

    private void copyPointOfSales() {
    }

    private void copyCashAccounts() {
        new Query(this.getCtx(), "C_BankAccount", "AD_Org_ID = ? AND EXISTS(SELECT 1 FROM C_Bank b WHERE b.C_Bank_ID = C_BankAccount.C_Bank_ID AND b.BankType = 'C')", this.get_TrxName()).setParameters(new Object[]{this.getOrgId()}).getIDsAsList().forEach(currentCashAccountId -> this.createAndCashAccount((int)currentCashAccountId));
    }

    private void copyWarehouses() {
        new Query(this.getCtx(), "M_Warehouse", "AD_Org_ID = ?", this.get_TrxName()).setParameters(new Object[]{this.getOrgId()}).getIDsAsList().forEach(currentWareId -> this.createAndGetWarehouse((int)currentWareId));
    }

    private void copyAccesses() {
        new Query(this.getCtx(), "AD_Role_OrgAccess", "AD_Org_ID = ? AND NOT EXISTS(SELECT 1 FROM AD_Role_OrgAccess ra WHERE ra.AD_Role_ID = AD_Role_OrgAccess.AD_Role_ID AND ra.AD_Org_ID = ?)", this.get_TrxName()).setParameters(new Object[]{this.getOrgId(), this.newOrganization.getAD_Org_ID()}).list().stream().forEach(currentOrganizationAccess -> {
            MRoleOrgAccess newOrganizationAccess = new MRoleOrgAccess((MRole)currentOrganizationAccess.getAD_Role(), this.newOrganization.getAD_Org_ID());
            newOrganizationAccess.setIsActive(currentOrganizationAccess.isActive());
            newOrganizationAccess.setIsReadOnly(currentOrganizationAccess.isReadOnly());
            newOrganizationAccess.saveEx(this.get_TrxName());
            this.addLog("@AD_Role_ID@ @Added@: " + newOrganizationAccess.getAD_Role().getName());
        });
        new Query(this.getCtx(), "AD_User_OrgAccess", "AD_Org_ID = ? AND NOT EXISTS(SELECT 1 FROM AD_User_OrgAccess ra WHERE ra.AD_User_ID = AD_User_OrgAccess.AD_User_ID AND ra.AD_Org_ID = ?)", this.get_TrxName()).setParameters(new Object[]{this.getOrgId(), this.newOrganization.getAD_Org_ID()}).list().stream().forEach(currentOrganizationAccess -> {
            MUserOrgAccess newOrganizationAccess = new MUserOrgAccess(this.getCtx(), 0, this.get_TrxName());
            newOrganizationAccess.setAD_Org_ID(this.newOrganization.getAD_Org_ID());
            newOrganizationAccess.setAD_User_ID(currentOrganizationAccess.getAD_User_ID());
            newOrganizationAccess.setIsActive(currentOrganizationAccess.isActive());
            newOrganizationAccess.setIsReadOnly(currentOrganizationAccess.isReadOnly());
            newOrganizationAccess.saveEx(this.get_TrxName());
            this.addLog("@AD_User_ID@ @Added@: " + newOrganizationAccess.getAD_User().getName());
        });
    }

    private int createAndGetDocumentTypeId(int currentDocumentTypeId) {
        if (currentDocumentTypeId <= 0) {
            return -1;
        }
        MDocType currentDocumentType = new MDocType(this.getCtx(), currentDocumentTypeId, this.get_TrxName());
        int newDocumentTypeId = this.copy.getReferenceId("C_DocType", currentDocumentTypeId);
        if (newDocumentTypeId > 0) {
            return newDocumentTypeId;
        }
        MDocType newDocumentType = new MDocType(this.getCtx(), 0, this.get_TrxName());
        PO.copyValues((PO)currentDocumentType, (PO)newDocumentType);
        newDocumentType.setDocNoSequence_ID(this.createAndGetSequenceId(currentDocumentType.getDocNoSequence_ID()));
        newDocumentType.setDefiniteSequence_ID(this.createAndGetSequenceId(currentDocumentType.getDefiniteSequence_ID()));
        int sequenceId = this.createAndGetSequenceId(currentDocumentType.get_ValueAsInt("ControlNoSequence_ID"));
        if (sequenceId > 0) {
            newDocumentType.set_ValueOfColumn("ControlNoSequence_ID", (Object)sequenceId);
        }
        newDocumentType.setC_DocTypeShipment_ID(this.createAndGetDocumentTypeId(currentDocumentType.getC_DocTypeShipment_ID()));
        newDocumentType.setC_DocTypeProforma_ID(this.createAndGetDocumentTypeId(currentDocumentType.getC_DocTypeProforma_ID()));
        newDocumentType.setC_DocTypePayment_ID(this.createAndGetDocumentTypeId(currentDocumentType.getC_DocTypePayment_ID()));
        newDocumentType.setC_DocTypeInvoice_ID(this.createAndGetDocumentTypeId(currentDocumentType.getC_DocTypeInvoice_ID()));
        newDocumentType.setC_DocTypeDifference_ID(this.createAndGetDocumentTypeId(currentDocumentType.getC_DocTypeDifference_ID()));
        newDocumentType.setIsActive(currentDocumentType.isActive());
        newDocumentType.setAD_Org_ID(this.newOrganization.getAD_Org_ID());
        newDocumentType.setName(this.getName(currentDocumentType.getName()));
        newDocumentType.saveEx(this.get_TrxName());
        this.copyDocumentTypeAccess(currentDocumentType.getC_DocType_ID(), newDocumentType.getC_DocType_ID());
        this.copyDocumentTypeWithholding(currentDocumentType.getC_DocType_ID(), newDocumentType.getC_DocType_ID());
        this.copyDocumentTypeRecordAccess(currentDocumentType.getC_DocType_ID(), newDocumentType.getC_DocType_ID());
        this.addLog("@C_DocType_ID@: " + newDocumentType.getName());
        newDocumentTypeId = newDocumentType.getC_DocType_ID();
        this.copy.putReferenceId("C_DocType", currentDocumentTypeId, newDocumentTypeId);
        return newDocumentTypeId;
    }

    private void copyDocumentTypeAccess(int currentDocumentTypeId, int newDocumentTypeId) {
        new Query(this.getCtx(), "AD_Document_Action_Access", "C_DocType_ID = ? AND NOT EXISTS(SELECT 1 FROM AD_Document_Action_Access ra WHERE ra.C_DocType_ID = ? AND ra.AD_Role_ID = AD_Document_Action_Access.AD_Role_ID AND ra.AD_Ref_List_ID = AD_Document_Action_Access.AD_Ref_List_ID)", this.get_TrxName()).setParameters(new Object[]{currentDocumentTypeId, newDocumentTypeId}).list().stream().forEach(currentDocumentActionAccess -> {
            X_AD_Document_Action_Access documentAccionAccess = new X_AD_Document_Action_Access(this.getCtx(), 0, this.get_TrxName());
            documentAccionAccess.setAD_Role_ID(currentDocumentActionAccess.getAD_Role_ID());
            documentAccionAccess.setC_DocType_ID(newDocumentTypeId);
            documentAccionAccess.setAD_Ref_List_ID(currentDocumentActionAccess.getAD_Ref_List_ID());
            documentAccionAccess.saveEx();
            this.addLog("@C_DocType_ID@ @Added@: " + documentAccionAccess.getC_DocType().getName());
        });
    }

    private void copyDocumentTypeRecordAccess(int currentDocumentTypeId, int newDocumentTypeId) {
        new Query(this.getCtx(), "AD_Record_Access", "Record_ID = ?", this.get_TrxName()).setParameters(new Object[]{currentDocumentTypeId}).list().stream().forEach(currentDocumentActionAccess -> {
            MRecordAccess documentAccionAccess = (MRecordAccess)new Query(this.getCtx(), "AD_Record_Access", "AD_Record_Access.AD_Table_ID = ? AND AD_Record_Access.Record_ID = ? ", this.get_TrxName()).setParameters(new Object[]{MDocType.Table_ID, newDocumentTypeId}).first();
            if (documentAccionAccess == null || documentAccionAccess.getAD_Table_ID() <= 0) {
                documentAccionAccess = new MRecordAccess(this.getCtx(), currentDocumentActionAccess.getAD_Role_ID(), MDocType.Table_ID, newDocumentTypeId, this.get_TrxName());
                documentAccionAccess.setIsActive(currentDocumentActionAccess.isActive());
                documentAccionAccess.setIsDependentEntities(currentDocumentActionAccess.isDependentEntities());
                documentAccionAccess.setIsReadOnly(currentDocumentActionAccess.isReadOnly());
                documentAccionAccess.setIsExclude(currentDocumentActionAccess.isExclude());
                documentAccionAccess.saveEx();
                MDocType documentType = new MDocType(this.getCtx(), newDocumentTypeId, this.get_TrxName());
                this.addLog("@Access@ @Added@: " + documentType.getName());
            }
        });
    }

    private void copyDocumentTypeWithholding(int currentDocumentTypeId, int newDocumentTypeId) {
        new Query(this.getCtx(), "WH_DefinitionLine", "C_DocType_ID = ?", this.get_TrxName()).setParameters(new Object[]{currentDocumentTypeId}).list().stream().forEach(currentWithholdingDefinitionLine -> {
            MWHDefinitionLine newWithholdingDefinitionLine = new MWHDefinitionLine(this.getCtx(), 0, this.get_TrxName());
            newWithholdingDefinitionLine.setC_DocType_ID(newDocumentTypeId);
            newWithholdingDefinitionLine.setWH_Definition_ID(currentWithholdingDefinitionLine.getWH_Definition_ID());
            newWithholdingDefinitionLine.setIsActive(currentWithholdingDefinitionLine.isActive());
            newWithholdingDefinitionLine.saveEx();
            this.addLog("@WH_DefinitionLine_ID@ @Added@: " + newWithholdingDefinitionLine.getC_DocType().getName());
        });
    }

    private int createAndGetSequenceId(int currentSequenceId) {
        if (currentSequenceId <= 0) {
            return -1;
        }
        MSequence currentSequence = new MSequence(this.getCtx(), currentSequenceId, this.get_TrxName());
        String newName = this.getName(currentSequence.getName());
        int newSequenceId = this.copy.getReferenceId("AD_Sequence", currentSequenceId);
        if (newSequenceId > 0) {
            return newSequenceId;
        }
        MSequence newSequence = new MSequence(this.getCtx(), 0, this.get_TrxName());
        PO.copyValues((PO)currentSequence, (PO)newSequence);
        newSequence.setAD_Org_ID(this.newOrganization.getAD_Org_ID());
        newSequence.setName(newName);
        newSequence.setCurrentNext(1);
        newSequence.setCurrentNextSys(1);
        newSequence.setIncrementNo(currentSequence.getIncrementNo());
        newSequence.setStartNo(currentSequence.getStartNo());
        newSequence.setPrefix(this.getValue() + "-" + currentSequence.getPrefix());
        newSequence.setIsActive(currentSequence.isActive());
        newSequence.saveEx(this.get_TrxName());
        this.addLog("@AD_Sequence_ID@: " + newSequence.getName());
        newSequenceId = newSequence.getAD_Sequence_ID();
        this.copy.putReferenceId("AD_Sequence", currentSequenceId, newSequenceId);
        return newSequenceId;
    }

    private int createAndCashAccount(int currentCashAccountId) {
        if (currentCashAccountId <= 0) {
            return -1;
        }
        MBankAccount currentCashAccount = new MBankAccount(this.getCtx(), currentCashAccountId, this.get_TrxName());
        String newName = this.getName(currentCashAccount.getAccountNo());
        int newCashAccountId = this.copy.getReferenceId("C_BankAccount", currentCashAccountId);
        if (newCashAccountId > 0) {
            return newCashAccountId;
        }
        MBankAccount newCashAccount = new MBankAccount(this.getCtx(), 0, this.get_TrxName());
        PO.copyValues((PO)currentCashAccount, (PO)newCashAccount);
        newCashAccount.setAD_Org_ID(this.newOrganization.getAD_Org_ID());
        newCashAccount.setIsActive(currentCashAccount.isActive());
        newCashAccount.setAccountNo(newName);
        newCashAccount.setDescription(newName);
        newCashAccount.setCurrentBalance(Env.ZERO);
        newCashAccount.setC_Bank_ID(this.copy.getReferenceId("C_Bank", currentCashAccount.getC_Bank_ID()));
        newCashAccount.saveEx(this.get_TrxName());
        this.copyCashAccountDocument(currentCashAccount.getC_BankAccount_ID(), newCashAccount.getC_BankAccount_ID());
        this.addLog("@C_BankAccount_ID@: " + newCashAccount.getAccountNo());
        newCashAccountId = newCashAccount.getC_BankAccount_ID();
        this.copy.putReferenceId("C_BankAccount", currentCashAccountId, newCashAccountId);
        return newCashAccountId;
    }

    private void copyCashAccountDocument(int currentCashAccountId, int newCashAccountId) {
        new Query(this.getCtx(), "C_BankAccountDoc", "C_BankAccount_ID = ?", this.get_TrxName()).setParameters(new Object[]{currentCashAccountId}).list().stream().forEach(currentBankAccountDocument -> {
            X_C_BankAccountDoc bankAccountDocument = new X_C_BankAccountDoc(this.getCtx(), 0, this.get_TrxName());
            PO.copyValues((PO)currentBankAccountDocument, (PO)bankAccountDocument, (boolean)true);
            bankAccountDocument.setC_BankAccount_ID(newCashAccountId);
            bankAccountDocument.setIsActive(currentBankAccountDocument.isActive());
            bankAccountDocument.setCurrentNext(0);
            bankAccountDocument.saveEx();
            this.addLog("@C_BankAccountDoc_ID@ @Added@: " + bankAccountDocument.getName());
        });
    }

    private int createAndGetWarehouse(int currentWarehouseId) {
        if (currentWarehouseId <= 0) {
            return -1;
        }
        MWarehouse currentWarehouse = new MWarehouse(this.getCtx(), currentWarehouseId, this.get_TrxName());
        String newName = this.getName(currentWarehouse.getName());
        int newWarehousetId = this.copy.getReferenceId("M_Warehouse", currentWarehouseId);
        if (newWarehousetId > 0) {
            return newWarehousetId;
        }
        MWarehouse newWarehouse = new MWarehouse(this.getCtx(), 0, this.get_TrxName());
        PO.copyValues((PO)currentWarehouse, (PO)newWarehouse);
        newWarehouse.setAD_Org_ID(this.newOrganization.getAD_Org_ID());
        newWarehouse.setIsActive(currentWarehouse.isActive());
        newWarehouse.setValue(this.getName(currentWarehouse.getValue()));
        newWarehouse.setName(newName);
        newWarehouse.setC_Location_ID(this.newOrganizationInfo.getC_Location_ID());
        newWarehouse.saveEx(this.get_TrxName());
        this.copyLocators(currentWarehouse, newWarehouse);
        this.addLog("@M_Warehouse_ID@: " + newWarehouse.getName());
        newWarehousetId = newWarehouse.getM_Warehouse_ID();
        this.copy.putReferenceId("M_Warehouse", currentWarehouseId, newWarehousetId);
        return newWarehousetId;
    }

    private void copyLocators(MWarehouse currentWarehouse, MWarehouse newWarehouse) {
        Arrays.asList(currentWarehouse.getLocators(true)).forEach(locator -> {
            MLocator newLocator = new MLocator(this.getCtx(), 0, this.get_TrxName());
            PO.copyValues((PO)locator, (PO)newLocator);
            newLocator.setM_Warehouse_ID(newWarehouse.getM_Warehouse_ID());
            newLocator.setIsActive(locator.isActive());
            newLocator.setAD_Org_ID(this.newOrganization.getAD_Org_ID());
            newLocator.saveEx(this.get_TrxName());
        });
    }

    private String getName(String name) {
        return name + " (" + this.getValue() + ")";
    }
}

