/*
 * Decompiled with CFR 0.152.
 */
package org.spin.tools.process;

import java.util.ArrayList;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MAcctSchemaDefault;
import org.compiere.model.MAcctSchemaElement;
import org.compiere.model.MAcctSchemaGL;
import org.compiere.model.MClient;
import org.compiere.model.MClientInfo;
import org.compiere.model.MCurrency;
import org.compiere.model.MElement;
import org.compiere.model.MElementValue;
import org.compiere.model.MRefList;
import org.compiere.model.MTable;
import org.compiere.model.MTree;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.spin.tools.process.CopyGLDefinitionsAbstract;
import org.spin.tools.util.CopyContextUtil;
import org.spin.tools.util.CopyUtil;

public class CopyGLDefinitions
extends CopyGLDefinitionsAbstract {
    private CopyUtil copy;
    private MClient newClient;
    private MClientInfo newClientInfo;
    private MClientInfo currentClientInfo;

    @Override
    protected void prepare() {
        super.prepare();
        if (this.getTemplateClientId() <= 0) {
            throw new AdempiereException("@ECA25_TemplateClient_ID@ @IsMandatory@");
        }
        int targetClientId = this.getTargetClientId();
        if (targetClientId == 0) {
            targetClientId = this.getAD_Client_ID();
        }
        if (targetClientId == 0) {
            throw new AdempiereException("@ECA25_TargetClient_ID@ @NotFound@");
        }
        this.newClient = new MClient(this.getCtx(), targetClientId, this.get_TrxName());
        this.newClientInfo = MClientInfo.get((Properties)this.getCtx(), (int)this.newClient.getAD_Client_ID(), (String)this.get_TrxName());
        this.currentClientInfo = MClientInfo.get((Properties)this.getCtx(), (int)this.getTemplateClientId(), (String)this.get_TrxName());
        this.copy = CopyUtil.newInstance().withTeplateClientId(this.getTemplateClientId()).withTargetClientId(targetClientId).withContext(this.getCtx()).withTransactionName(this.get_TrxName());
    }

    protected String doIt() throws Exception {
        try {
            CopyContextUtil.newInstance().updateContextToNewClient(this.getCtx(), this.copy.getTargetClientId(), this.getProcessInfo().isBatch());
            this.copyAccountSchema();
        }
        catch (Exception e) {
            throw new AdempiereException((Throwable)e);
        }
        finally {
            CopyContextUtil.newInstance().revertContextToCurrentClient(this.getCtx(), this.getProcessInfo().isBatch());
        }
        return "Ok";
    }

    private void copyAccountSchema() {
        this.copy.getTemplateReferencesOnlyNewIds("C_AcctSchema").forEach(currentAccountSchemaId -> {
            MAcctSchema currentAccountSchema = new MAcctSchema(this.getCtx(), currentAccountSchemaId.intValue(), this.get_TrxName());
            MCurrency currency = MCurrency.get((Properties)this.getCtx(), (int)currentAccountSchema.getC_Currency_ID());
            MAcctSchema newAccountSchema = new MAcctSchema(this.getCtx(), 0, this.get_TrxName());
            this.copy.copyCurrentValues((PO)currentAccountSchema, (PO)newAccountSchema);
            newAccountSchema.setName(this.newClient.getName() + " " + newAccountSchema.getGAAP() + "/" + currency.getISO_Code());
            newAccountSchema.set_ValueOfColumn("C_Period_ID", null);
            newAccountSchema.saveEx();
            this.copy.putReferenceId("C_AcctSchema", (int)currentAccountSchemaId, newAccountSchema.getC_AcctSchema_ID());
        });
        this.newClientInfo.setC_AcctSchema1_ID(this.copy.getReferenceId("C_AcctSchema", this.currentClientInfo.getC_AcctSchema1_ID()));
        this.newClientInfo.saveEx(this.get_TrxName());
        this.copyAccountElements();
        this.copyElementValues();
        ArrayList accountSchemaElement = new ArrayList();
        this.copy.getTemplateReferencesOnlyNewIds("C_AcctSchema_Element").forEach(currentAccountSchemaEmentId -> {
            MAcctSchemaElement currentAccountSchemaElement = new MAcctSchemaElement(this.getCtx(), currentAccountSchemaEmentId.intValue(), this.get_TrxName());
            MAcctSchemaElement newAccountSchemaElement = new MAcctSchemaElement(this.getCtx(), 0, this.get_TrxName());
            this.copy.copyCurrentValues((PO)currentAccountSchemaElement, (PO)newAccountSchemaElement);
            newAccountSchemaElement.setC_AcctSchema_ID(this.copy.getReferenceId("C_AcctSchema", currentAccountSchemaElement.getC_AcctSchema_ID()));
            int id = -1;
            if (currentAccountSchemaElement.getC_Activity_ID() > 0 && (id = this.copy.getReferenceId("C_Activity", currentAccountSchemaElement.getC_Activity_ID())) > 0) {
                newAccountSchemaElement.setC_Activity_ID(id);
            }
            if (currentAccountSchemaElement.getC_Location_ID() > 0 && (id = this.copy.getReferenceId("C_Location", currentAccountSchemaElement.getC_Location_ID())) > 0) {
                newAccountSchemaElement.setC_Location_ID(id);
            }
            if (currentAccountSchemaElement.getC_Project_ID() > 0 && (id = this.copy.getReferenceId("C_Project", currentAccountSchemaElement.getC_Project_ID())) > 0) {
                newAccountSchemaElement.setC_Project_ID(id);
            }
            if (currentAccountSchemaElement.getC_SalesRegion_ID() > 0 && (id = this.copy.getReferenceId("C_SalesRegion", currentAccountSchemaElement.getC_SalesRegion_ID())) > 0) {
                newAccountSchemaElement.setC_SalesRegion_ID(id);
            }
            if (currentAccountSchemaElement.getM_Product_ID() > 0 && (id = this.copy.getReferenceId("M_Product", currentAccountSchemaElement.getM_Product_ID())) > 0) {
                newAccountSchemaElement.setM_Product_ID(id);
            }
            if (currentAccountSchemaElement.getC_BPartner_ID() > 0 && (id = this.copy.getReferenceId("C_BPartner", currentAccountSchemaElement.getC_BPartner_ID())) > 0) {
                newAccountSchemaElement.setC_BPartner_ID(id);
            }
            if (currentAccountSchemaElement.getC_Campaign_ID() > 0 && (id = this.copy.getReferenceId("C_Campaign", currentAccountSchemaElement.getC_Campaign_ID())) > 0) {
                newAccountSchemaElement.setC_Campaign_ID(id);
            }
            if (currentAccountSchemaElement.getC_Element_ID() > 0 && (id = this.copy.getReferenceId("C_Element", currentAccountSchemaElement.getC_Element_ID())) > 0) {
                newAccountSchemaElement.setC_Element_ID(id);
            }
            if (currentAccountSchemaElement.getC_Activity_ID() > 0 && (id = this.copy.getReferenceId("AD_Org", currentAccountSchemaElement.getOrg_ID())) > 0) {
                newAccountSchemaElement.setOrg_ID(id);
            }
            newAccountSchemaElement.saveEx();
            this.copy.saveReference((PO)currentAccountSchemaElement, (PO)newAccountSchemaElement);
            if (currentAccountSchemaElement.getC_ElementValue_ID() > 0) {
                accountSchemaElement.add(newAccountSchemaElement.getC_AcctSchema_Element_ID());
            }
            this.copy.putReferenceId("C_AcctSchema_Element", (int)currentAccountSchemaEmentId, newAccountSchemaElement.getC_AcctSchema_Element_ID());
        });
        this.copyValidCombinations();
        accountSchemaElement.stream().map(schemaElementId -> new MAcctSchemaElement(this.getCtx(), schemaElementId.intValue(), this.get_TrxName())).forEach(schemaElement -> {
            int id = this.copy.getReferenceId("C_ElementValue", schemaElement.getC_ElementValue_ID());
            if (id > 0) {
                schemaElement.setC_ElementValue_ID(id);
                schemaElement.saveEx();
            }
        });
        this.copy.getTemplateReferencesOnlyNewIds("C_AcctSchema_GL").forEach(currentSchemaGLId -> {
            MAcctSchemaGL currentSchemaGL = new MAcctSchemaGL(this.getCtx(), currentSchemaGLId.intValue(), this.get_TrxName());
            MAcctSchemaGL newSchemaGL = new MAcctSchemaGL(this.getCtx(), 0, this.get_TrxName());
            this.copy.copyCurrentValues((PO)currentSchemaGL, (PO)newSchemaGL);
            newSchemaGL.setC_AcctSchema_ID(this.copy.getReferenceId("C_AcctSchema", currentSchemaGL.getC_AcctSchema_ID()));
            MTable.get((Properties)this.getCtx(), (String)"C_AcctSchema_GL").getColumnsAsList().stream().filter(column -> column.getAD_Reference_ID() == 25).map(column -> column.getColumnName()).forEach(columnName -> {
                if (currentSchemaGL.get_ValueAsInt(columnName) > 0) {
                    int id = this.copy.getReferenceId("C_ValidCombination", currentSchemaGL.get_ValueAsInt(columnName));
                    newSchemaGL.set_ValueOfColumn(columnName, (Object)id);
                }
            });
            newSchemaGL.saveEx();
            this.copy.saveReference((PO)currentSchemaGL, (PO)newSchemaGL);
        });
        this.copy.getTemplateReferencesOnlyNewIds("C_AcctSchema_Default").forEach(currentSchemaDefaultId -> {
            MAcctSchemaDefault currentSchemaDefault = new MAcctSchemaDefault(this.getCtx(), currentSchemaDefaultId.intValue(), this.get_TrxName());
            MAcctSchemaDefault newSchemaDefault = new MAcctSchemaDefault(this.getCtx(), 0, this.get_TrxName());
            this.copy.copyCurrentValues((PO)currentSchemaDefault, (PO)newSchemaDefault);
            newSchemaDefault.setC_AcctSchema_ID(this.copy.getReferenceId("C_AcctSchema", currentSchemaDefault.getC_AcctSchema_ID()));
            MTable.get((Properties)this.getCtx(), (String)"C_AcctSchema_Default").getColumnsAsList().stream().filter(column -> column.getAD_Reference_ID() == 25).map(column -> column.getColumnName()).forEach(columnName -> {
                if (currentSchemaDefault.get_ValueAsInt(columnName) > 0) {
                    int id = this.copy.getReferenceId("C_ValidCombination", currentSchemaDefault.get_ValueAsInt(columnName));
                    newSchemaDefault.set_ValueOfColumn(columnName, (Object)id);
                }
            });
            newSchemaDefault.saveEx();
            this.copy.saveReference((PO)currentSchemaDefault, (PO)newSchemaDefault);
        });
    }

    private void copyAccountElements() {
        this.copy.getTemplateReferencesOnlyNewIds("C_Element").forEach(currentElementId -> {
            MElement currentElement = new MElement(this.getCtx(), currentElementId.intValue(), this.get_TrxName());
            MElement newElement = new MElement(this.getCtx(), 0, this.get_TrxName());
            this.copy.copyCurrentValues((PO)currentElement, (PO)newElement);
            newElement.setElementType(currentElement.getElementType());
            newElement.setName(this.newClient.getName() + " " + MRefList.getListName((Properties)this.getCtx(), (int)116, (String)currentElement.getElementType()));
            newElement.setAD_Tree_ID(this.copy.getReferenceId("AD_Tree", currentElement.getAD_Tree_ID()));
            newElement.saveEx();
            this.copy.saveReference((PO)currentElement, (PO)newElement);
            this.copy.putReferenceId("C_Element", (int)currentElementId, newElement.getC_Element_ID());
        });
    }

    private void copyElementValues() {
        ArrayList elementValuesToUpdateIds = new ArrayList();
        this.copy.getTemplateReferencesOnlyNewIds("C_ElementValue").forEach(currentElementValueId -> {
            MElementValue currentElementValue = new MElementValue(this.getCtx(), currentElementValueId.intValue(), this.get_TrxName());
            MElementValue newElementValue = new MElementValue(this.getCtx(), 0, this.get_TrxName());
            this.copy.copyCurrentValues((PO)currentElementValue, (PO)newElementValue);
            newElementValue.setC_Element_ID(this.copy.getReferenceId("C_Element", currentElementValue.getC_Element_ID()));
            newElementValue.setIsDirectLoad(true);
            this.copy.saveReference((PO)currentElementValue, (PO)newElementValue);
            if (currentElementValue.getParentElementValue_ID() > 0) {
                elementValuesToUpdateIds.add(newElementValue.getC_ElementValue_ID());
            }
            this.copy.putReferenceId("C_ElementValue", (int)currentElementValueId, newElementValue.getC_ElementValue_ID());
        });
        elementValuesToUpdateIds.stream().map(elementValueId -> new MElementValue(this.getCtx(), elementValueId.intValue(), this.get_TrxName())).forEach(elementValue -> {
            elementValue.setParentElementValue_ID(this.copy.getReferenceId("C_ElementValue", elementValue.getParentElementValue_ID()));
            elementValue.setIsDirectLoad(true);
            elementValue.saveEx();
        });
        this.copy.getTemplateReferencesIds("C_Element").forEach(currentElementId -> {
            MElement currentElement = new MElement(this.getCtx(), currentElementId.intValue(), this.get_TrxName());
            MTree currentTree = MTree.get((Properties)this.getCtx(), (int)currentElement.getAD_Tree_ID(), (String)this.get_TrxName());
            AtomicReference<MTable> treeNodeTable = new AtomicReference<MTable>();
            treeNodeTable.set(MTable.get((Properties)this.getCtx(), (String)MTree.getNodeTableName((String)currentTree.getTreeType())));
            if (treeNodeTable.get() != null) {
                new Query(this.getCtx(), ((MTable)treeNodeTable.get()).getTableName(), "AD_Tree_ID = ?", this.get_TrxName()).setParameters(new Object[]{currentTree.getAD_Tree_ID()}).list().forEach(currentTreeNode -> {
                    int nodeId = this.copy.getReferenceId("C_ElementValue", currentTreeNode.get_ValueAsInt("Node_ID"));
                    if (nodeId > 0) {
                        PO newTreeNode = ((MTable)treeNodeTable.get()).getPO(0, this.get_TrxName());
                        newTreeNode.setAD_Org_ID(0);
                        newTreeNode.setIsActive(currentTreeNode.isActive());
                        newTreeNode.set_ValueOfColumn("AD_Tree_ID", (Object)this.copy.getReferenceId("AD_Tree", currentTree.getAD_Tree_ID()));
                        newTreeNode.set_ValueOfColumn("Node_ID", (Object)this.copy.getReferenceId("C_ElementValue", currentTreeNode.get_ValueAsInt("Node_ID")));
                        int parentId = this.copy.getReferenceId("C_ElementValue", currentTreeNode.get_ValueAsInt("Parent_ID"));
                        if (parentId < 0) {
                            parentId = 0;
                        }
                        newTreeNode.set_ValueOfColumn("Parent_ID", (Object)parentId);
                        newTreeNode.set_ValueOfColumn("SeqNo", (Object)currentTreeNode.get_ValueAsInt("SeqNo"));
                        this.copy.saveReference((PO)currentTreeNode, newTreeNode);
                        newTreeNode.saveEx();
                    }
                });
            }
        });
    }

    private void copyValidCombinations() {
        this.copy.getTemplateReferencesOnlyNewIds("C_ValidCombination").forEach(currentValidCombinationId -> {
            MAccount currentAccount = new MAccount(this.getCtx(), currentValidCombinationId.intValue(), this.get_TrxName());
            MAccount newAccount = new MAccount(this.getCtx(), 0, this.get_TrxName());
            this.copy.copyCurrentValues((PO)currentAccount, (PO)newAccount);
            newAccount.setAccount_ID(this.copy.getReferenceId("C_ElementValue", currentAccount.getAccount_ID()));
            newAccount.setC_AcctSchema_ID(this.copy.getReferenceId("C_AcctSchema", currentAccount.getC_AcctSchema_ID()));
            newAccount.saveEx();
            this.copy.saveReference((PO)currentAccount, (PO)newAccount);
            this.copy.putReferenceId("C_ValidCombination", (int)currentValidCombinationId, newAccount.getC_ValidCombination_ID());
        });
    }
}

