/*
 * Decompiled with CFR 0.152.
 */
package org.spin.tools.process;

import java.util.ArrayList;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.PO;
import org.erpya.lve.model.MLVEList;
import org.erpya.lve.model.MLVEListLine;
import org.erpya.lve.model.MLVEListType;
import org.erpya.lve.model.MLVEListVersion;
import org.erpya.lve.model.MLVEWithholdingTax;
import org.spin.model.MWHDefinition;
import org.spin.model.MWHDefinitionLine;
import org.spin.model.MWHSetting;
import org.spin.model.MWHType;
import org.spin.tools.process.CopyFiscalDefinitionsAbstract;
import org.spin.tools.util.CopyContextUtil;
import org.spin.tools.util.CopyUtil;

public class CopyFiscalDefinitions
extends CopyFiscalDefinitionsAbstract {
    private CopyUtil copy;

    @Override
    protected void prepare() {
        super.prepare();
        if (this.getTemplateClientId() <= 0) {
            throw new AdempiereException("@ECA25_TemplateClient_ID@ @IsMandatory@");
        }
        int targetClientId = this.getTargetClientId();
        if (targetClientId == 0) {
            targetClientId = this.getAD_Client_ID();
        }
        if (targetClientId == 0) {
            throw new AdempiereException("@ECA25_TargetClient_ID@ @NotFound@");
        }
        this.copy = CopyUtil.newInstance().withTeplateClientId(this.getTemplateClientId()).withTargetClientId(targetClientId).withContext(this.getCtx()).withTransactionName(this.get_TrxName());
    }

    protected String doIt() throws Exception {
        try {
            CopyContextUtil.newInstance().updateContextToNewClient(this.getCtx(), this.copy.getTargetClientId(), this.getProcessInfo().isBatch());
            this.copy.getTemplateReferencesOnlyNewIds("WH_Type").forEach(currentWihholdingTypeId -> {
                MWHType currentWithholdingType = new MWHType(this.getCtx(), currentWihholdingTypeId.intValue(), this.get_TrxName());
                MWHType newWithholdingType = new MWHType(this.getCtx(), 0, this.get_TrxName());
                this.copy.copyCurrentValues((PO)currentWithholdingType, (PO)newWithholdingType);
                newWithholdingType.setAD_Org_ID(0);
                int newReferenceId = this.copy.getReferenceId("C_DocType", currentWithholdingType.getWithholdingDebitDocType_ID());
                newWithholdingType.setWithholdingDebitDocType_ID(newReferenceId);
                newReferenceId = this.copy.getReferenceId("C_DocType", currentWithholdingType.getWithholdingCreditDocType_ID());
                newWithholdingType.setWithholdingCreditDocType_ID(newReferenceId);
                newReferenceId = this.copy.getReferenceId("C_DocType", currentWithholdingType.getDeclarationDebitDocType_ID());
                newWithholdingType.setDeclarationDebitDocType_ID(newReferenceId);
                newReferenceId = this.copy.getReferenceId("C_DocType", currentWithholdingType.getDeclarationCreditDocType_ID());
                newWithholdingType.setDeclarationCreditDocType_ID(newReferenceId);
                newWithholdingType.saveEx();
                this.copy.saveReference((PO)currentWithholdingType, (PO)newWithholdingType);
            });
            this.copy.getTemplateReferencesOnlyNewIds("WH_Setting").forEach(currentWihholdingSettingId -> {
                MWHSetting currentWithholdingSetting = new MWHSetting(this.getCtx(), currentWihholdingSettingId.intValue(), this.get_TrxName());
                MWHSetting newWithholdingSetting = new MWHSetting(this.getCtx(), 0, this.get_TrxName());
                this.copy.copyCurrentValues((PO)currentWithholdingSetting, (PO)newWithholdingSetting);
                newWithholdingSetting.setAD_Org_ID(0);
                int newReferenceId = this.copy.getReferenceId("WH_Type", currentWithholdingSetting.getWH_Type_ID());
                newWithholdingSetting.setWH_Type_ID(newReferenceId);
                newReferenceId = this.copy.getReferenceId("C_DocType", currentWithholdingSetting.getWithholdingDebitDocType_ID());
                newWithholdingSetting.setWithholdingDebitDocType_ID(newReferenceId);
                newReferenceId = this.copy.getReferenceId("C_DocType", currentWithholdingSetting.getWithholdingCreditDocType_ID());
                newWithholdingSetting.setWithholdingCreditDocType_ID(newReferenceId);
                newReferenceId = this.copy.getReferenceId("C_Charge", currentWithholdingSetting.getC_Charge_ID());
                newWithholdingSetting.setC_Charge_ID(newReferenceId);
                newWithholdingSetting.saveEx();
                this.copy.saveReference((PO)currentWithholdingSetting, (PO)newWithholdingSetting);
            });
            this.copy.getTemplateReferencesOnlyNewIds("WH_Definition").forEach(currentWihholdingDefinitionId -> {
                MWHDefinition currentWithholdingDefinition = new MWHDefinition(this.getCtx(), currentWihholdingDefinitionId.intValue(), this.get_TrxName());
                MWHDefinition newWithholdingDefinition = new MWHDefinition(this.getCtx(), 0, this.get_TrxName());
                this.copy.copyCurrentValues((PO)currentWithholdingDefinition, (PO)newWithholdingDefinition);
                newWithholdingDefinition.setAD_Org_ID(0);
                int newReferenceId = this.copy.getReferenceId("WH_Type", currentWithholdingDefinition.getWH_Type_ID());
                newWithholdingDefinition.setWH_Type_ID(newReferenceId);
                newReferenceId = this.copy.getReferenceId("C_Charge", currentWithholdingDefinition.getC_Charge_ID());
                if (newReferenceId > 0) {
                    newWithholdingDefinition.setC_Charge_ID(newReferenceId);
                } else {
                    newWithholdingDefinition.setC_Charge_ID(-1);
                }
                newReferenceId = this.copy.getReferenceId("C_BPartner", currentWithholdingDefinition.getC_BPartner_ID());
                if (newReferenceId > 0) {
                    newWithholdingDefinition.setC_BPartner_ID(newReferenceId);
                } else {
                    newWithholdingDefinition.setC_BPartner_ID(-1);
                }
                newReferenceId = this.copy.getReferenceId("C_DocType", currentWithholdingDefinition.getWithholdingDebitDocType_ID());
                newWithholdingDefinition.setWithholdingDebitDocType_ID(newReferenceId);
                newReferenceId = this.copy.getReferenceId("C_DocType", currentWithholdingDefinition.getWithholdingCreditDocType_ID());
                newWithholdingDefinition.setWithholdingCreditDocType_ID(newReferenceId);
                newReferenceId = this.copy.getReferenceId("C_DocType", currentWithholdingDefinition.getDeclarationDebitDocType_ID());
                newWithholdingDefinition.setDeclarationDebitDocType_ID(newReferenceId);
                newReferenceId = this.copy.getReferenceId("C_DocType", currentWithholdingDefinition.getDeclarationCreditDocType_ID());
                newWithholdingDefinition.setDeclarationCreditDocType_ID(newReferenceId);
                newWithholdingDefinition.saveEx();
                this.copy.saveReference((PO)currentWithholdingDefinition, (PO)newWithholdingDefinition);
            });
            this.copy.getTemplateReferencesOnlyNewIds("WH_DefinitionLine").forEach(currentWihholdingDefinitionLineId -> {
                MWHDefinitionLine currentWithholdingDefinitionLine = new MWHDefinitionLine(this.getCtx(), currentWihholdingDefinitionLineId.intValue(), this.get_TrxName());
                MWHDefinitionLine newWithholdingDefinitionLine = new MWHDefinitionLine(this.getCtx(), 0, this.get_TrxName());
                this.copy.copyCurrentValues((PO)currentWithholdingDefinitionLine, (PO)newWithholdingDefinitionLine);
                int newReferenceId = this.copy.getReferenceId("AD_Org", currentWithholdingDefinitionLine.getAD_Org_ID());
                if (newReferenceId < 0) {
                    newWithholdingDefinitionLine.setAD_Org_ID(0);
                } else {
                    newWithholdingDefinitionLine.setAD_Org_ID(newReferenceId);
                }
                newReferenceId = this.copy.getReferenceId("WH_Definition", currentWithholdingDefinitionLine.getWH_Definition_ID());
                newWithholdingDefinitionLine.setWH_Definition_ID(newReferenceId);
                newReferenceId = this.copy.getReferenceId("C_DocType", currentWithholdingDefinitionLine.getC_DocType_ID());
                newWithholdingDefinitionLine.setC_DocType_ID(newReferenceId);
                newWithholdingDefinitionLine.saveEx();
                this.copy.saveReference((PO)currentWithholdingDefinitionLine, (PO)newWithholdingDefinitionLine);
            });
            this.copy.getTemplateReferencesOnlyNewIds("LVE_ListType").forEach(currentListTypeId -> {
                MLVEListType currentListType = new MLVEListType(this.getCtx(), currentListTypeId.intValue(), this.get_TrxName());
                MLVEListType newListType = new MLVEListType(this.getCtx(), 0, this.get_TrxName());
                this.copy.copyCurrentValues((PO)currentListType, (PO)newListType);
                newListType.setAD_Org_ID(0);
                newListType.saveEx();
                this.copy.saveReference((PO)currentListType, (PO)newListType);
            });
            ArrayList newWihholdingTaxes = new ArrayList();
            this.copy.getTemplateReferencesOnlyNewIds("LVE_WithholdingTax").forEach(currentWithholdingTaxId -> {
                MLVEWithholdingTax currentWithholdingTax = new MLVEWithholdingTax(this.getCtx(), currentWithholdingTaxId.intValue(), this.get_TrxName());
                MLVEWithholdingTax newWithholdingTax = new MLVEWithholdingTax(this.getCtx(), 0, this.get_TrxName());
                this.copy.copyCurrentValues((PO)currentWithholdingTax, (PO)newWithholdingTax);
                newWithholdingTax.setAD_Org_ID(0);
                int newReferenceId = this.copy.getReferenceId("LVE_ListType", currentWithholdingTax.getWithholdingRateType_ID());
                newWithholdingTax.setWithholdingRateType_ID(newReferenceId);
                newWithholdingTax.saveEx();
                this.copy.saveReference((PO)currentWithholdingTax, (PO)newWithholdingTax);
                newWihholdingTaxes.add(newWithholdingTax.getLVE_WithholdingTax_ID());
            });
            this.copy.getTemplateReferencesOnlyNewIds("LVE_List").forEach(currentListId -> {
                MLVEList currentList = new MLVEList(this.getCtx(), currentListId.intValue(), this.get_TrxName());
                MLVEList newList = new MLVEList(this.getCtx(), 0, this.get_TrxName());
                this.copy.copyCurrentValues((PO)currentList, (PO)newList);
                newList.setAD_Org_ID(0);
                int newReferenceId = this.copy.getReferenceId("LVE_WithholdingTax", currentList.get_ValueAsInt("LVE_WithholdingTax_ID"));
                newList.set_ValueOfColumn("LVE_WithholdingTax_ID", (Object)newReferenceId);
                newReferenceId = this.copy.getReferenceId("LVE_ListType", currentList.getLVE_ListType_ID());
                newList.setLVE_ListType_ID(newReferenceId);
                newList.saveEx();
                this.copy.saveReference((PO)currentList, (PO)newList);
            });
            this.copy.getTemplateReferencesOnlyNewIds("LVE_ListVersion").forEach(currentListVersionId -> {
                MLVEListVersion currentListVersion = new MLVEListVersion(this.getCtx(), currentListVersionId.intValue(), this.get_TrxName());
                MLVEListVersion newListVersion = new MLVEListVersion(this.getCtx(), 0, this.get_TrxName());
                this.copy.copyCurrentValues((PO)currentListVersion, (PO)newListVersion);
                newListVersion.setAD_Org_ID(0);
                int newReferenceId = this.copy.getReferenceId("LVE_List", currentListVersion.getLVE_List_ID());
                newListVersion.setLVE_List_ID(newReferenceId);
                newListVersion.saveEx();
                this.copy.saveReference((PO)currentListVersion, (PO)newListVersion);
            });
            this.copy.getTemplateReferencesOnlyNewIds("LVE_ListLine").forEach(currentListLineId -> {
                MLVEListLine currentListLine = new MLVEListLine(this.getCtx(), currentListLineId.intValue(), this.get_TrxName());
                MLVEListLine newListLine = new MLVEListLine(this.getCtx(), 0, this.get_TrxName());
                this.copy.copyCurrentValues((PO)currentListLine, (PO)newListLine);
                newListLine.setAD_Org_ID(0);
                int newReferenceId = this.copy.getReferenceId("LVE_ListVersion", currentListLine.getLVE_ListVersion_ID());
                newListLine.setLVE_ListVersion_ID(newReferenceId);
                newListLine.saveEx();
                this.copy.saveReference((PO)currentListLine, (PO)newListLine);
            });
            newWihholdingTaxes.forEach(wihholdingTaxId -> {
                MLVEWithholdingTax currentWithholdingTax = new MLVEWithholdingTax(this.getCtx(), wihholdingTaxId.intValue(), this.get_TrxName());
                int newReferenceId = this.copy.getReferenceId("LVE_List", currentWithholdingTax.getDefaultWithholdingRate_ID());
                if (newReferenceId > 0) {
                    currentWithholdingTax.setDefaultWithholdingRate_ID(newReferenceId);
                } else {
                    currentWithholdingTax.setDefaultWithholdingRate_ID(-1);
                }
                currentWithholdingTax.saveEx();
            });
        }
        catch (Exception e) {
            throw new AdempiereException((Throwable)e);
        }
        finally {
            CopyContextUtil.newInstance().revertContextToCurrentClient(this.getCtx(), this.getProcessInfo().isBatch());
        }
        return "Ok";
    }
}

