/*
 * Decompiled with CFR 0.152.
 */
package org.spin.tools.process;

import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MBank;
import org.compiere.model.MBankStatementMatcher;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.spin.model.MCBankMatcher;
import org.spin.tools.process.CopyFIDefinitionAbstract;
import org.spin.tools.util.CopyContextUtil;
import org.spin.tools.util.CopyUtil;

public class CopyFIDefinition
extends CopyFIDefinitionAbstract {
    private CopyUtil copy;

    @Override
    protected void prepare() {
        super.prepare();
        if (this.getTemplateClientId() <= 0) {
            throw new AdempiereException("@ECA25_TemplateClient_ID@ @IsMandatory@");
        }
        int targetClientId = this.getTargetClientId();
        if (targetClientId == 0) {
            targetClientId = this.getAD_Client_ID();
        }
        if (targetClientId == 0) {
            throw new AdempiereException("@ECA25_TargetClient_ID@ @NotFound@");
        }
        this.copy = CopyUtil.newInstance().withTeplateClientId(this.getTemplateClientId()).withTargetClientId(targetClientId).withContext(this.getCtx()).withTransactionName(this.get_TrxName());
    }

    protected String doIt() throws Exception {
        try {
            CopyContextUtil.newInstance().updateContextToNewClient(this.getCtx(), this.copy.getTargetClientId(), this.getProcessInfo().isBatch());
            this.copy.getTemplateReferencesOnlyNewIds("C_Bank").forEach(currentBankId -> {
                MBank currentBank = new MBank(this.getCtx(), currentBankId.intValue(), this.get_TrxName());
                MBank newBank = new MBank(this.getCtx(), 0, this.get_TrxName());
                this.copy.copyCurrentValues((PO)currentBank, (PO)newBank);
                newBank.setAD_Org_ID(0);
                newBank.saveEx();
                this.copy.saveReference((PO)currentBank, (PO)newBank);
            });
            this.copy.getTemplateReferencesOnlyNewIds("C_BankStatementMatcher").forEach(currentBankId -> {
                MBankStatementMatcher currentReference = new MBankStatementMatcher(this.getCtx(), currentBankId.intValue(), this.get_TrxName());
                MBankStatementMatcher newReference = new MBankStatementMatcher(this.getCtx(), 0, this.get_TrxName());
                this.copy.copyCurrentValues((PO)currentReference, (PO)newReference);
                newReference.setAD_Org_ID(0);
                newReference.saveEx();
                this.copy.saveReference((PO)currentReference, (PO)newReference);
                new Query(this.getCtx(), "C_BankMatcher", "C_BankStatementMatcher_ID = ?", this.get_TrxName()).setParameters(new Object[]{currentReference.getC_BankStatementMatcher_ID()}).getIDsAsList().forEach(currentLineId -> {
                    MCBankMatcher currentMatcher = new MCBankMatcher(this.getCtx(), currentLineId.intValue(), this.get_TrxName());
                    MCBankMatcher newMatcher = new MCBankMatcher(this.getCtx(), 0, this.get_TrxName());
                    this.copy.copyCurrentValues((PO)currentMatcher, (PO)newMatcher);
                    newMatcher.setAD_Org_ID(0);
                    newMatcher.setC_BankStatementMatcher_ID(currentReference.getC_BankStatementMatcher_ID());
                    int newBankReferenceId = this.copy.getReferenceId("C_Bank", currentMatcher.getC_Bank_ID());
                    if (newBankReferenceId > 0) {
                        newMatcher.setC_Bank_ID(newBankReferenceId);
                    }
                    newMatcher.saveEx();
                    this.copy.saveReference((PO)currentMatcher, (PO)newMatcher);
                });
            });
        }
        catch (Exception e) {
            throw new AdempiereException((Throwable)e);
        }
        finally {
            CopyContextUtil.newInstance().revertContextToCurrentClient(this.getCtx(), this.getProcessInfo().isBatch());
        }
        return "Ok";
    }
}

