/*
 * Decompiled with CFR 0.152.
 */
package org.spin.tools.process;

import java.math.BigDecimal;
import java.math.MathContext;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.exceptions.DocTypeNotFoundException;
import org.adempiere.model.GenericPO;
import org.compiere.model.I_C_BankAccount;
import org.compiere.model.I_C_CashBook;
import org.compiere.model.I_M_PriceList;
import org.compiere.model.MBPartner;
import org.compiere.model.MBankAccount;
import org.compiere.model.MBankStatement;
import org.compiere.model.MBankStatementLine;
import org.compiere.model.MCashBook;
import org.compiere.model.MClientInfo;
import org.compiere.model.MCommission;
import org.compiere.model.MCommissionLine;
import org.compiere.model.MConversionRate;
import org.compiere.model.MCountry;
import org.compiere.model.MCurrency;
import org.compiere.model.MDocType;
import org.compiere.model.MFreight;
import org.compiere.model.MPOS;
import org.compiere.model.MPayment;
import org.compiere.model.MPriceList;
import org.compiere.model.MPriceListVersion;
import org.compiere.model.MProductPO;
import org.compiere.model.MProject;
import org.compiere.model.MRecordAccess;
import org.compiere.model.MRole;
import org.compiere.model.MSysConfig;
import org.compiere.model.MTable;
import org.compiere.model.M_Element;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_C_BankAccountDoc;
import org.compiere.model.X_C_BankAccount_Acct;
import org.compiere.model.X_C_CashBook_Acct;
import org.compiere.model.X_C_CommissionSalesRep;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.eevolution.model.MCashFlow;
import org.eevolution.model.MHRAttribute;
import org.eevolution.model.MHRConcept;
import org.eevolution.model.MHREmployee;
import org.eevolution.model.MHRMovement;
import org.eevolution.model.MHRPayroll;
import org.eevolution.model.MHRPayrollConcept;
import org.eevolution.model.MHRProcess;
import org.eevolution.model.X_HR_Attribute;
import org.erpya.lve.model.MLVEList;
import org.erpya.lve.model.MLVEListVersion;
import org.spin.tools.process.CopyEntitiesWithNewCurrencyAbstract;

public class CopyEntitiesWithNewCurrency
extends CopyEntitiesWithNewCurrencyAbstract {
    private final String DEFAULT_WHERE_CLAUSE = "UUID IS NOT NULL AND LENGTH(UUID) > 7";
    private final String PRODUCT_PRICE_INSERT = "INSERT INTO M_ProductPrice (AD_Client_ID, AD_Org_ID, IsActive, Created, CreatedBy, Updated, UpdatedBy, M_ProductPrice_ID, UUID, M_PriceList_Version_ID, M_Product_ID, PriceList, PriceStd, PriceLimit, PublicMaxPrice) SELECT AD_Client_ID, AD_Org_ID, IsActive, Created, CreatedBy, Updated, UpdatedBy, Sequence AS M_ProductPrice_ID, ('' || M_ProductPrice_ID) AS UUID, ?, M_Product_ID, (PriceList * ?), (PriceStd * ?), (PriceLimit * ?), (PublicMaxPrice * ?) FROM M_ProductPrice WHERE M_PriceList_Version_ID = ?";
    private final String NATIVE_SEQUENCE = "nextval('m_productprice_seq') AS M_ProductPrice_ID";
    private final String ADEMPIERE_SEQUENCE = "nextidfunc(165, 'N') AS M_ProductPrice_ID";
    private Map<Integer, Integer> priceListToReplace = new HashMap<Integer, Integer>();
    private Map<Integer, Integer> bankAccountsToReplace = new HashMap<Integer, Integer>();
    private BigDecimal multiplyRate = Env.ZERO;
    private List<Integer> pointOfSales = new ArrayList<Integer>();
    private int precision = 0;

    @Override
    protected void prepare() {
        super.prepare();
        this.multiplyRate = MConversionRate.getRate((int)this.getCurrencyId(), (int)this.getCurrencyToId(), (Timestamp)this.getDateTrx(), (int)this.getConversionTypeId(), (int)this.getAD_Client_ID(), (int)Env.getAD_Org_ID((Properties)this.getCtx()));
        if (Optional.ofNullable(this.multiplyRate).orElse(Env.ZERO).compareTo(Env.ZERO) == 0) {
            throw new AdempiereException("@C_ConversionRate_ID@ @NotFound@");
        }
        this.precision = MCurrency.getStdPrecision((Properties)this.getCtx(), (int)this.getCurrencyToId());
    }

    protected String doIt() throws Exception {
        this.copyPriceList();
        this.copyBankAccountsAndCashAccounts();
        this.copyCashBooks();
        this.copyCashFlows();
        this.copyPointOfSales();
        this.copyCommissions();
        this.copyFreights();
        this.copyPayrollConcepts();
        this.copyProductsPO();
        this.convertPayrollProcess();
        this.changeDefaultValuesForEntities();
        return "Ok";
    }

    private void changeDefaultValuesForEntities() {
        List recordIdsList = new ArrayList();
        if (this.priceListToReplace.size() > 0) {
            ArrayList pricesListIds = new ArrayList();
            this.priceListToReplace.keySet().forEach(key -> pricesListIds.add(key));
            recordIdsList = new Query(this.getCtx(), "C_BPartner", "(M_PriceList_ID IN " + ((Object)pricesListIds).toString().replace('[', '(').replace(']', ')') + " OR PO_PriceList_ID IN " + ((Object)pricesListIds).toString().replace('[', '(').replace(']', ')') + ")", this.get_TrxName()).setClient_ID().getIDsAsList();
            recordIdsList.forEach(businessPartnerId -> {
                MBPartner businessPartner = new MBPartner(this.getCtx(), businessPartnerId.intValue(), this.get_TrxName());
                if (businessPartner.getM_PriceList_ID() > 0) {
                    Optional.ofNullable(this.priceListToReplace.get(businessPartner.getM_PriceList_ID())).ifPresent(priceListId -> businessPartner.setM_PriceList_ID(priceListId.intValue()));
                }
                if (businessPartner.getPO_PriceList_ID() > 0) {
                    Optional.ofNullable(this.priceListToReplace.get(businessPartner.getPO_PriceList_ID())).ifPresent(priceListId -> businessPartner.setPO_PriceList_ID(priceListId.intValue()));
                }
                businessPartner.saveEx();
            });
            this.addLog("@M_PriceList_ID@ => @C_BPartner_ID@ @Changed@: " + recordIdsList.size());
            this.pointOfSales.forEach(pointOfSalesId -> {
                MPOS pointOfSales = new MPOS(this.getCtx(), pointOfSalesId.intValue(), this.get_TrxName());
                if (pointOfSales.getM_PriceList_ID() > 0) {
                    Optional.ofNullable(this.priceListToReplace.get(pointOfSales.getM_PriceList_ID())).ifPresent(priceListId -> pointOfSales.setM_PriceList_ID(priceListId.intValue()));
                }
                pointOfSales.saveEx();
            });
            this.addLog("@M_PriceList_ID@ => @C_POS_ID@ @Changed@: " + this.pointOfSales.size());
        }
        if (this.bankAccountsToReplace.size() > 0) {
            ArrayList bankAccountIds = new ArrayList();
            this.bankAccountsToReplace.keySet().forEach(key -> bankAccountIds.add(key));
            this.pointOfSales.forEach(pointOfSalesId -> {
                MPOS pointOfSales = new MPOS(this.getCtx(), pointOfSalesId.intValue(), this.get_TrxName());
                if (pointOfSales.getC_BankAccount_ID() > 0) {
                    Optional.ofNullable(this.bankAccountsToReplace.get(pointOfSales.getC_BankAccount_ID())).ifPresent(bankAccountId -> pointOfSales.setC_BankAccount_ID(bankAccountId.intValue()));
                }
                if (pointOfSales.getCashTransferBankAccount_ID() > 0) {
                    Optional.ofNullable(this.bankAccountsToReplace.get(pointOfSales.getCashTransferBankAccount_ID())).ifPresent(bankAccountId -> pointOfSales.setCashTransferBankAccount_ID(bankAccountId.intValue()));
                }
                pointOfSales.saveEx();
            });
            this.addLog("@C_BankAccount_ID@ => @C_POS_ID@ @Changed@: " + this.pointOfSales.size());
        }
        if (Optional.ofNullable(this.getIsManageClosing()).orElse("N").equals("Y") && this.isReconvertClosePayrolls()) {
            recordIdsList = new Query(this.getCtx(), "HR_Process", "DocStatus NOT IN('VO', 'RE')", this.get_TrxName()).setClient_ID().getIDsAsList();
            recordIdsList.forEach(payrollProcessId -> {
                MHRProcess payrollProcess = new MHRProcess(this.getCtx(), payrollProcessId.intValue(), this.get_TrxName());
                if (payrollProcess.getAD_Org_ID() == 0) {
                    payrollProcess.setAD_Org_ID(Env.getAD_Org_ID((Properties)this.getCtx()));
                }
                payrollProcess.setDocStatus("CL");
                payrollProcess.setDocAction("--");
                payrollProcess.setProcessed(true);
                payrollProcess.saveEx();
            });
            this.addLog("@HR_Process_ID@ => @Changed@: " + recordIdsList.size());
        }
        if (this.isReconvertSetupCurrency()) {
            MLVEListVersion currentTributeUnitVersion;
            MLVEList tributeUnitDefinition = (MLVEList)new Query(this.getCtx(), "LVE_List", "LVE_ListType_ID = ?", this.get_TrxName()).setClient_ID().setParameters(new Object[]{MClientInfo.get((Properties)this.getCtx()).get_ValueAsInt("TributeUnitType_ID")}).setOnlyActiveRecords(true).first();
            if (tributeUnitDefinition != null && tributeUnitDefinition.getLVE_List_ID() > 0 && (currentTributeUnitVersion = tributeUnitDefinition.getValidVersionInstance(this.getDateTrx())) != null) {
                MLVEListVersion newTributeUnitVersion = new MLVEListVersion(this.getCtx(), 0, this.get_TrxName());
                PO.copyValues((PO)currentTributeUnitVersion, (PO)newTributeUnitVersion, (boolean)true);
                this.setCopyValues((PO)currentTributeUnitVersion, (PO)newTributeUnitVersion);
                newTributeUnitVersion.setValidFrom(this.getDateTrx());
                newTributeUnitVersion.saveEx();
                this.saveUuidReference((PO)currentTributeUnitVersion, (PO)newTributeUnitVersion);
                currentTributeUnitVersion.setIsActive(false);
                currentTributeUnitVersion.saveEx();
            }
            recordIdsList = new Query(this.getCtx(), "AD_Role", "UUID IS NOT NULL AND LENGTH(UUID) > 7 AND C_Currency_ID = ?", this.get_TrxName()).setParameters(new Object[]{this.getCurrencyId()}).setClient_ID().getIDsAsList();
            recordIdsList.forEach(roleId -> {
                MRole role = new MRole(this.getCtx(), roleId.intValue(), this.get_TrxName());
                role.setC_Currency_ID(this.getCurrencyToId());
                role.saveEx();
            });
            this.addLog("@AD_Role_ID@ @Changed@: " + recordIdsList.size());
            recordIdsList = new Query(this.getCtx(), "C_Country", "UUID IS NOT NULL AND LENGTH(UUID) > 7 AND C_Currency_ID = ?", this.get_TrxName()).setParameters(new Object[]{this.getCurrencyId()}).getIDsAsList();
            recordIdsList.forEach(countryId -> {
                MCountry country = new MCountry(this.getCtx(), countryId.intValue(), this.get_TrxName());
                country.setC_Currency_ID(this.getCurrencyToId());
                country.saveEx();
            });
            this.addLog("@C_Country_ID@ @Changed@: " + recordIdsList.size());
            recordIdsList = new Query(this.getCtx(), "C_Project", "UUID IS NOT NULL AND LENGTH(UUID) > 7 AND C_Currency_ID = ?", this.get_TrxName()).setParameters(new Object[]{this.getCurrencyId()}).getIDsAsList();
            recordIdsList.forEach(projectId -> {
                MProject project = new MProject(this.getCtx(), projectId.intValue(), this.get_TrxName());
                project.setC_Currency_ID(this.getCurrencyToId());
                project.saveEx();
            });
            this.addLog("@C_Project_ID@ @Changed@: " + recordIdsList.size());
            int businessPartnerUpdated = DB.executeUpdateEx((String)"UPDATE C_BPartner SET SO_CreditLimit = ROUND(COALESCE(SO_CreditLimit, 0) * ?, ?), SO_CreditUsed = ROUND(COALESCE(SO_CreditUsed, 0) * ?, ?), TotalOpenBalance = ROUND(COALESCE(TotalOpenBalance, 0) * ?, ?), ActualLifeTimeValue = ROUND(COALESCE(ActualLifeTimeValue, 0) * ?, ?) WHERE AD_Client_ID = ?", (Object[])new Object[]{this.multiplyRate, this.precision, this.multiplyRate, this.precision, this.multiplyRate, this.precision, this.multiplyRate, this.precision, this.getAD_Client_ID()}, (String)this.get_TrxName());
            this.addLog("@TotalOpenBalances@ => @C_BPartner_ID@ @Changed@: " + businessPartnerUpdated);
            try {
                MCurrency oldCurrency = new MCurrency(this.getCtx(), this.getCurrencyId(), this.get_TrxName());
                String oldISOCode = oldCurrency.getISO_Code();
                String changeValue = oldISOCode.substring(0, 2) + "~";
                oldCurrency.setISO_Code(changeValue);
                oldCurrency.saveEx();
                MCurrency newCurrency = new MCurrency(this.getCtx(), this.getCurrencyToId(), this.get_TrxName());
                newCurrency.setISO_Code(oldISOCode);
                newCurrency.saveEx();
                this.addLog("@C_Currency_ID@ => " + oldISOCode + " @Changed@ @To@ " + changeValue);
            }
            catch (Exception e) {
                this.addLog("@C_Currency_ID@ => @Error@ " + e.getLocalizedMessage());
            }
            recordIdsList = new Query(this.getCtx(), "HR_Employee", null, this.get_TrxName()).setClient_ID().setOnlyActiveRecords(true).getIDsAsList();
            recordIdsList.forEach(employeeId -> {
                MHREmployee employee = new MHREmployee(this.getCtx(), employeeId.intValue(), this.get_TrxName());
                Optional.ofNullable(employee.getDailySalary()).ifPresent(dailySalary -> employee.setDailySalary(dailySalary.multiply(this.multiplyRate, MathContext.DECIMAL128)));
                Optional.ofNullable(employee.getMonthlySalary()).ifPresent(montlySalary -> employee.setMonthlySalary(montlySalary.multiply(this.multiplyRate, MathContext.DECIMAL128)));
                employee.saveEx();
            });
            this.addLog("@HR_Employee_ID@ => @Changed@: " + recordIdsList.size());
        }
    }

    private void convertPayrollProcess() {
        if (Optional.ofNullable(this.getIsManageClosing()).orElse("N").equals("N") || !this.isReconvertClosePayrolls()) {
            return;
        }
        if (Optional.ofNullable(this.getIsManageClosing()).orElse("N").equals("N")) {
            return;
        }
        List recordIdsList = new Query(this.getCtx(), "HR_Payroll", null, this.get_TrxName()).setClient_ID().setOnlyActiveRecords(true).getIDsAsList();
        recordIdsList.forEach(payrollId -> this.copyPayrollProcess((int)payrollId));
        this.addLog("@HR_Payroll_ID@: " + recordIdsList.size());
    }

    private void copyPriceList() {
        if (!this.isReconvertPriceLists()) {
            return;
        }
        List recordIdsList = new Query(this.getCtx(), "M_PriceList", "UUID IS NOT NULL AND LENGTH(UUID) > 7 AND C_Currency_ID = ? AND NOT EXISTS(SELECT 1 FROM M_PriceList r WHERE r.UUID ~ '^\\d+$' AND CAST(r.UUID AS NUMERIC) = M_PriceList.M_PriceList_ID)", this.get_TrxName()).setParameters(new Object[]{this.getCurrencyId()}).setClient_ID().getIDsAsList();
        recordIdsList.forEach(priceListId -> this.copyPriceListById((int)priceListId));
        this.addLog("@M_PriceList_ID@: " + recordIdsList.size());
    }

    private void copyProductsPO() {
        if (!this.isReconvertProductPOs()) {
            return;
        }
        List recordList = new Query(this.getCtx(), "M_Product_PO", "UUID IS NOT NULL AND LENGTH(UUID) > 7 AND C_Currency_ID = ? AND NOT EXISTS(SELECT 1 FROM M_Product_PO r WHERE r.UUID ~ '^\\d+$' AND CAST(r.UUID AS NUMERIC) = M_Product_PO.M_Product_ID AND r.C_Currency_ID = ?)", this.get_TrxName()).setParameters(new Object[]{this.getCurrencyId(), this.getCurrencyToId()}).setClient_ID().list();
        recordList.forEach(productPO -> this.copyProductPO((MProductPO)productPO));
        this.addLog("@M_Product_ID@ @IsPurchased@: " + recordList.size());
    }

    private void copyCommissions() {
        if (!this.isReconvertCommissions()) {
            return;
        }
        List recordIdsList = new Query(this.getCtx(), "C_Commission", "UUID IS NOT NULL AND LENGTH(UUID) > 7 AND C_Currency_ID = ? AND NOT EXISTS(SELECT 1 FROM C_Commission r WHERE r.UUID ~ '^\\d+$' AND CAST(r.UUID AS NUMERIC) = C_Commission.C_Commission_ID)", this.get_TrxName()).setParameters(new Object[]{this.getCurrencyId()}).setClient_ID().getIDsAsList();
        recordIdsList.forEach(recordId -> this.copyCommisionById((int)recordId));
        this.addLog("@C_Commission_ID@: " + recordIdsList.size());
    }

    private void copyFreights() {
        if (!this.isReconvertFreights()) {
            return;
        }
        List recordIdsList = new Query(this.getCtx(), "M_Freight", "UUID IS NOT NULL AND LENGTH(UUID) > 7 AND C_Currency_ID = ? AND NOT EXISTS(SELECT 1 FROM M_Freight r WHERE r.UUID ~ '^\\d+$' AND CAST(r.UUID AS NUMERIC) = M_Freight.M_Freight_ID)", this.get_TrxName()).setParameters(new Object[]{this.getCurrencyId()}).setClient_ID().getIDsAsList();
        recordIdsList.forEach(recordId -> this.copyFreight((int)recordId));
        this.addLog("@M_Freight_ID@: " + recordIdsList.size());
    }

    private void copyPayrollConcepts() {
        if (!this.isReconvertPayrollConcepts()) {
            return;
        }
        if (M_Element.get((Properties)Env.getCtx(), (String)"IsManageReconversion") == null) {
            return;
        }
        List conceptsIds = new Query(this.getCtx(), "HR_Concept", "IsManageReconversion = 'Y'", this.get_TrxName()).setClient_ID().setOnlyActiveRecords(true).getIDsAsList();
        conceptsIds.forEach(conceptId -> {
            MHRConcept concept = MHRConcept.getById((Properties)this.getCtx(), (int)conceptId, (String)this.get_TrxName());
            List currentAttributes = new Query(this.getCtx(), "HR_Attribute", "UUID IS NOT NULL AND LENGTH(UUID) > 7 AND HR_Concept_ID = ?", this.get_TrxName()).setParameters(new Object[]{concept.getHR_Concept_ID()}).setOnlyActiveRecords(true).list();
            if (concept.isEmployee()) {
                HashMap validAttribute = new HashMap();
                currentAttributes.forEach(attribute -> {
                    if (!validAttribute.containsKey(attribute.getC_BPartner_ID())) {
                        Optional<MHRAttribute> maybeAttribute = currentAttributes.stream().filter(attributeToFind -> attributeToFind.getC_BPartner_ID() == attribute.getC_BPartner_ID()).sorted(Comparator.comparing(X_HR_Attribute::getValidFrom).reversed()).findFirst();
                        maybeAttribute.ifPresent(attributeFinded -> validAttribute.put(attribute.getC_BPartner_ID(), attributeFinded.getHR_Attribute_ID()));
                    }
                });
                if (validAttribute.size() > 0) {
                    validAttribute.values().forEach(attributeId -> this.copyAttribute((int)attributeId));
                }
            } else {
                Optional<MHRAttribute> maybeAttribute = currentAttributes.stream().sorted(Comparator.comparing(X_HR_Attribute::getValidFrom).reversed()).findFirst();
                maybeAttribute.ifPresent(attribute -> this.copyAttribute(attribute.getHR_Attribute_ID()));
            }
            currentAttributes.stream().filter(attribute -> attribute.get_ValueAsInt("C_Currency_ID") <= 0 || attribute.get_ValueAsInt("C_Currency_ID") == this.getCurrencyId()).forEach(attribute -> {
                attribute.setIsActive(false);
                attribute.saveEx();
            });
        });
        this.addLog("@HR_Concept_ID@: " + conceptsIds.size());
    }

    private void copyPayrollProcess(int payrollId) {
        if (payrollId <= 0) {
            return;
        }
        MHRPayroll payroll = MHRPayroll.getById((Properties)this.getCtx(), (int)payrollId, (String)this.get_TrxName());
        MHRProcess process = new MHRProcess(this.getCtx(), 0, this.get_TrxName());
        Optional defaultDocumentType = Arrays.asList(MDocType.getOfDocBaseType((Properties)Env.getCtx(), (String)"HRP")).stream().findFirst();
        if (!defaultDocumentType.isPresent()) {
            throw new DocTypeNotFoundException("HRP", "");
        }
        process.setHR_Payroll_ID(payroll.getHR_Payroll_ID());
        process.setDateAcct(this.getDateTrx());
        process.setC_DocTypeTarget_ID(((MDocType)defaultDocumentType.get()).getC_DocType_ID());
        process.setC_DocType_ID(((MDocType)defaultDocumentType.get()).getC_DocType_ID());
        process.setDocumentNo(Msg.parseTranslation((Properties)this.getCtx(), (String)"@closed@") + this.getSuffix());
        process.setC_Currency_ID(this.getCurrencyToId());
        process.setC_ConversionType_ID(this.getConversionTypeId());
        process.setName(Msg.parseTranslation((Properties)this.getCtx(), (String)"@closed@") + this.getSuffix());
        process.setProcessed(true);
        process.setDocStatus("CL");
        process.setDocAction("--");
        process.saveEx();
        this.saveUuidReference((PO)payroll, (PO)process);
        List concepts = Arrays.asList(MHRPayrollConcept.getPayrollConcepts((MHRProcess)process)).stream().map(payrollConcept -> MHRConcept.getById((Properties)this.getCtx(), (int)payrollConcept.getHR_Concept_ID(), (String)this.get_TrxName())).filter(concept -> concept.get_ValueAsBoolean("IsAccumulatedConcept")).collect(Collectors.toList());
        Arrays.asList(MHREmployee.getEmployees((MHRProcess)process)).forEach(employee -> concepts.forEach(concept -> {
            MHRMovement lastMovement = MHRMovement.getLastMovement((Properties)this.getCtx(), (String)concept.getValue(), (int)payroll.getHR_Payroll_ID(), (int)employee.getC_BPartner_ID(), (Timestamp)this.getDateTrx(), (String)this.get_TrxName());
            if (lastMovement != null) {
                MHRMovement newMovement = new MHRMovement(this.getCtx(), 0, this.get_TrxName());
                PO.copyValues((PO)lastMovement, (PO)newMovement, (boolean)true);
                this.setCopyValues((PO)lastMovement, (PO)lastMovement);
                newMovement.setHR_Process_ID(process.getHR_Process_ID());
                newMovement.setValidFrom(process.getDateAcct());
                newMovement.setValidTo(process.getDateAcct());
                newMovement.setAmount(Optional.ofNullable(newMovement.getAmount()).orElse(Env.ZERO).multiply(this.multiplyRate, MathContext.DECIMAL128));
                newMovement.setQty(Optional.ofNullable(newMovement.getQty()).orElse(Env.ZERO).multiply(this.multiplyRate, MathContext.DECIMAL128));
                newMovement.setProcessed(true);
                newMovement.saveEx();
                this.saveUuidReference((PO)lastMovement, (PO)newMovement);
            }
        }));
    }

    private void copyProductPO(MProductPO currentProductPO) {
        MProductPO newProductPO = new MProductPO(this.getCtx(), currentProductPO.getM_Product_ID(), currentProductPO.getC_BPartner_ID(), this.getCurrencyToId(), this.get_TrxName());
        PO.copyValues((PO)currentProductPO, (PO)newProductPO, (boolean)true);
        this.setCopyValues((PO)currentProductPO, (PO)newProductPO);
        newProductPO.setC_Currency_ID(this.getCurrencyToId());
        newProductPO.saveEx(this.get_TrxName());
        newProductPO.setUUID(String.valueOf(currentProductPO.getM_Product_ID()));
        Optional.ofNullable(newProductPO.getPricePO()).ifPresent(price -> newProductPO.setPricePO(price.multiply(this.multiplyRate, MathContext.DECIMAL128)));
        Optional.ofNullable(newProductPO.getPriceLastInv()).ifPresent(price -> newProductPO.setPriceLastInv(price.multiply(this.multiplyRate, MathContext.DECIMAL128)));
        Optional.ofNullable(newProductPO.getPriceLastPO()).ifPresent(price -> newProductPO.setPriceLastPO(price.multiply(this.multiplyRate, MathContext.DECIMAL128)));
        Optional.ofNullable(newProductPO.getPriceList()).ifPresent(price -> newProductPO.setPriceList(price.multiply(this.multiplyRate, MathContext.DECIMAL128)));
        Optional.ofNullable(newProductPO.getRoyaltyAmt()).ifPresent(price -> newProductPO.setRoyaltyAmt(price.multiply(this.multiplyRate, MathContext.DECIMAL128)));
        newProductPO.saveEx(this.get_TrxName());
        currentProductPO.setIsCurrentVendor(false);
        currentProductPO.setIsActive(false);
        currentProductPO.saveEx(this.get_TrxName());
    }

    private void copyFreight(int currentFreightId) {
        if (currentFreightId <= 0) {
            return;
        }
        MFreight currentFreight = new MFreight(this.getCtx(), currentFreightId, this.get_TrxName());
        MFreight newFreight = new MFreight(this.getCtx(), 0, this.get_TrxName());
        PO.copyValues((PO)currentFreight, (PO)newFreight, (boolean)true);
        this.setCopyValues((PO)currentFreight, (PO)newFreight);
        Optional.ofNullable(currentFreight.getFreightAmt()).ifPresent(price -> currentFreight.setFreightAmt(price.multiply(this.multiplyRate, MathContext.DECIMAL128)));
        newFreight.saveEx(this.get_TrxName());
        newFreight.setC_Currency_ID(this.getCurrencyToId());
        this.saveUuidReference((PO)currentFreight, (PO)newFreight);
    }

    private void copyAttribute(int currentAttributeId) {
        if (currentAttributeId <= 0) {
            return;
        }
        MHRAttribute currentAttribute = new MHRAttribute(this.getCtx(), currentAttributeId, this.get_TrxName());
        MHRAttribute newAttributes = new MHRAttribute(this.getCtx(), 0, this.get_TrxName());
        PO.copyValues((PO)currentAttribute, (PO)newAttributes, (boolean)true);
        this.setCopyValues((PO)currentAttribute, (PO)newAttributes);
        newAttributes.setValidFrom(this.getDateTrx());
        newAttributes.saveEx(this.get_TrxName());
        if (currentAttribute.get_ValueAsInt("C_Currency_ID") > 0) {
            newAttributes.set_ValueOfColumn("C_Currency_ID", (Object)this.getCurrencyToId());
        }
        if (currentAttribute.get_ValueAsInt("C_Currency_ID") <= 0 || currentAttribute.get_ValueAsInt("C_Currency_ID") == this.getCurrencyId()) {
            Optional.ofNullable(newAttributes.getAmount()).ifPresent(price -> newAttributes.setAmount(price.multiply(this.multiplyRate, MathContext.DECIMAL128)));
        }
        this.saveUuidReference((PO)currentAttribute, (PO)newAttributes);
    }

    private void copyCommisionById(int currentCommissionId) {
        if (currentCommissionId <= 0) {
            return;
        }
        MCommission currentCommission = new MCommission(this.getCtx(), currentCommissionId, this.get_TrxName());
        String newName = this.getName(currentCommission.getName());
        MCommission newCommission = new MCommission(this.getCtx(), 0, this.get_TrxName());
        PO.copyValues((PO)currentCommission, (PO)newCommission, (boolean)true);
        this.setCopyValues((PO)currentCommission, (PO)newCommission);
        currentCommission.setName(newName);
        currentCommission.setIsActive(false);
        currentCommission.saveEx();
        newCommission.setC_Currency_ID(this.getCurrencyToId());
        newCommission.saveEx(this.get_TrxName());
        this.saveUuidReference((PO)currentCommission, (PO)newCommission);
        new Query(this.getCtx(), "C_CommissionLine", "C_Commission_ID = ?", this.get_TrxName()).setParameters(new Object[]{currentCommission.getC_Commission_ID()}).getIDsAsList().forEach(commissionLineId -> {
            MCommissionLine currentCommissionLine = new MCommissionLine(this.getCtx(), commissionLineId.intValue(), this.get_TrxName());
            MCommissionLine newCommissionLine = new MCommissionLine(this.getCtx(), 0, this.get_TrxName());
            PO.copyValues((PO)currentCommissionLine, (PO)newCommissionLine, (boolean)true);
            this.setCopyValues((PO)currentCommissionLine, (PO)newCommissionLine);
            newCommissionLine.setC_Commission_ID(newCommission.getC_Commission_ID());
            newCommissionLine.saveEx();
            this.saveUuidReference((PO)currentCommissionLine, (PO)newCommissionLine);
        });
        new Query(this.getCtx(), "C_CommissionSalesRep", "C_Commission_ID = ?", this.get_TrxName()).setParameters(new Object[]{currentCommission.getC_Commission_ID()}).getIDsAsList().forEach(commissionSalesRepId -> {
            X_C_CommissionSalesRep currentCommissionLine = new X_C_CommissionSalesRep(this.getCtx(), commissionSalesRepId.intValue(), this.get_TrxName());
            X_C_CommissionSalesRep newCommissionLine = new X_C_CommissionSalesRep(this.getCtx(), 0, this.get_TrxName());
            PO.copyValues((PO)currentCommissionLine, (PO)newCommissionLine, (boolean)true);
            this.setCopyValues((PO)currentCommissionLine, (PO)newCommissionLine);
            newCommissionLine.setC_Commission_ID(newCommission.getC_Commission_ID());
            newCommissionLine.saveEx();
            this.saveUuidReference((PO)currentCommissionLine, (PO)newCommissionLine);
        });
    }

    private void copyPriceListById(int currentPriceListId) {
        if (currentPriceListId <= 0) {
            return;
        }
        boolean SYSTEM_NATIVE_SEQUENCE = MSysConfig.getBooleanValue((String)"SYSTEM_NATIVE_SEQUENCE", (boolean)false);
        String sqlInsert = "INSERT INTO M_ProductPrice (AD_Client_ID, AD_Org_ID, IsActive, Created, CreatedBy, Updated, UpdatedBy, M_ProductPrice_ID, UUID, M_PriceList_Version_ID, M_Product_ID, PriceList, PriceStd, PriceLimit, PublicMaxPrice) SELECT AD_Client_ID, AD_Org_ID, IsActive, Created, CreatedBy, Updated, UpdatedBy, Sequence AS M_ProductPrice_ID, ('' || M_ProductPrice_ID) AS UUID, ?, M_Product_ID, (PriceList * ?), (PriceStd * ?), (PriceLimit * ?), (PublicMaxPrice * ?) FROM M_ProductPrice WHERE M_PriceList_Version_ID = ?".replace("Sequence AS M_ProductPrice_ID", SYSTEM_NATIVE_SEQUENCE ? "nextval('m_productprice_seq') AS M_ProductPrice_ID" : "nextidfunc(165, 'N') AS M_ProductPrice_ID");
        MPriceList currentPriceList = new MPriceList(this.getCtx(), currentPriceListId, this.get_TrxName());
        String newName = this.getName(currentPriceList.getName());
        MPriceList newPriceList = new MPriceList(this.getCtx(), 0, this.get_TrxName());
        PO.copyValues((PO)currentPriceList, (PO)newPriceList, (boolean)true);
        this.setCopyValues((PO)currentPriceList, (PO)newPriceList);
        currentPriceList.setName(newName);
        currentPriceList.setIsDefault(false);
        currentPriceList.setIsActive(false);
        currentPriceList.saveEx();
        newPriceList.setC_Currency_ID(this.getCurrencyToId());
        newPriceList.saveEx(this.get_TrxName());
        this.saveUuidReference((PO)currentPriceList, (PO)newPriceList);
        this.copyRecordAccess(currentPriceList.getM_PriceList_ID(), newPriceList.getM_PriceList_ID(), I_M_PriceList.Table_ID);
        this.priceListToReplace.put(currentPriceList.getM_PriceList_ID(), newPriceList.getM_PriceList_ID());
        MPriceListVersion currentVersion = currentPriceList.getPriceListVersion(this.getDateTrx());
        if (currentVersion != null) {
            AtomicInteger counter = new AtomicInteger();
            MPriceListVersion newVersion = new MPriceListVersion(this.getCtx(), 0, this.get_TrxName());
            PO.copyValues((PO)currentVersion, (PO)newVersion, (boolean)true);
            this.setCopyValues((PO)currentVersion, (PO)newVersion);
            currentVersion.setName(this.getName(currentVersion.getName()));
            currentVersion.saveEx();
            newVersion.setM_PriceList_ID(newPriceList.getM_PriceList_ID());
            newVersion.setValidFrom(this.getDateTrx());
            newVersion.saveEx();
            this.saveUuidReference((PO)currentVersion, (PO)newVersion);
            counter.addAndGet(DB.executeUpdateEx((String)sqlInsert, (Object[])new Object[]{newVersion.getM_PriceList_Version_ID(), this.multiplyRate, this.multiplyRate, this.multiplyRate, this.multiplyRate, currentVersion.getM_PriceList_Version_ID()}, (String)this.get_TrxName()));
            new Query(this.getCtx(), "M_PriceList_Version", "M_PriceList_ID = ?", this.get_TrxName()).setParameters(new Object[]{currentPriceList.getM_PriceList_ID()}).getIDsAsList().forEach(currentPriceListVersionId -> {
                MPriceListVersion currentPriceListVersion = new MPriceListVersion(this.getCtx(), currentPriceListVersionId.intValue(), this.get_TrxName());
                currentPriceListVersion.setIsActive(false);
                currentPriceListVersion.saveEx();
            });
            this.addLog("@M_ProductPrice_ID@ " + currentPriceList.getName() + " => @Copied@: " + counter);
        }
    }

    private void setCopyValues(PO source, PO target) {
        target.setAD_Org_ID(source.getAD_Org_ID());
        target.setIsActive(source.isActive());
    }

    private void saveUuidReference(PO source, PO target) {
        target.set_ValueOfColumn("UUID", (Object)String.valueOf(source.get_ID()));
        target.saveEx();
    }

    private void copyBankAccountsAndCashAccounts() {
        if (!this.isReconvertBankAccounts()) {
            return;
        }
        List recordIdsList = new Query(this.getCtx(), "C_BankAccount", "UUID IS NOT NULL AND LENGTH(UUID) > 7 AND C_Currency_ID = ? AND NOT EXISTS(SELECT 1 FROM C_BankAccount r WHERE r.UUID ~ '^\\d+$' AND CAST(r.UUID AS NUMERIC) = C_BankAccount.C_BankAccount_ID)", this.get_TrxName()).setParameters(new Object[]{this.getCurrencyId()}).setClient_ID().getIDsAsList();
        recordIdsList.forEach(currentCashAccountId -> this.copyBankAccountAndCashAccount((int)currentCashAccountId));
        this.addLog("@C_BankAccount_ID@: " + recordIdsList.size());
    }

    private void copyCashBooks() {
        if (!this.isReconvertCashBooks()) {
            return;
        }
        List recordIdsList = new Query(this.getCtx(), "C_CashBook", "UUID IS NOT NULL AND LENGTH(UUID) > 7 AND C_Currency_ID = ? AND NOT EXISTS(SELECT 1 FROM C_CashBook r WHERE r.UUID ~ '^\\d+$' AND CAST(r.UUID AS NUMERIC) = C_CashBook.C_CashBook_ID)", this.get_TrxName()).setParameters(new Object[]{this.getCurrencyId()}).setClient_ID().getIDsAsList();
        recordIdsList.forEach(currentCashId -> this.copyCashBook((int)currentCashId));
        this.addLog("@C_Cash_ID@: " + recordIdsList.size());
    }

    private void copyCashFlows() {
        if (!this.isReconvertCashFlows()) {
            return;
        }
        List recordIdsList = new Query(this.getCtx(), "C_CashFlow", "UUID IS NOT NULL AND LENGTH(UUID) > 7 AND C_Currency_ID = ? AND NOT EXISTS(SELECT 1 FROM C_CashFlow r WHERE r.UUID ~ '^\\d+$' AND CAST(r.UUID AS NUMERIC) = C_CashFlow.C_CashFlow_ID)", this.get_TrxName()).setParameters(new Object[]{this.getCurrencyId()}).setClient_ID().getIDsAsList();
        recordIdsList.forEach(currentCashFlowId -> this.copyCashFlow((int)currentCashFlowId));
        this.addLog("@C_CashFlow_ID@: " + recordIdsList.size());
    }

    private void copyPointOfSales() {
        if (!this.isReconvertPOS()) {
            return;
        }
        List recordIdsList = new Query(this.getCtx(), "C_POS", "UUID IS NOT NULL AND LENGTH(UUID) > 7 AND EXISTS(SELECT 1 FROM M_PriceList pl WHERE pl.M_PriceList_ID = C_POS.M_PriceList_ID AND pl.C_Currency_ID = ?) AND NOT EXISTS(SELECT 1 FROM C_POS r WHERE r.UUID ~ '^\\d+$' AND CAST(r.UUID AS NUMERIC) = C_POS.C_POS_ID)", this.get_TrxName()).setParameters(new Object[]{this.getCurrencyId()}).setClient_ID().getIDsAsList();
        recordIdsList.forEach(currentPointOfSalesId -> this.copyPointOfSales((int)currentPointOfSalesId));
        this.addLog("@C_POS_ID@: " + recordIdsList.size());
    }

    private void copyPointOfSales(int currentPointOfSalesId) {
        if (currentPointOfSalesId <= 0) {
            return;
        }
        MPOS currentPointOfSales = new MPOS(this.getCtx(), currentPointOfSalesId, this.get_TrxName());
        String newName = this.getName(currentPointOfSales.getName());
        MPOS newPointOfSales = new MPOS(this.getCtx(), 0, this.get_TrxName());
        PO.copyValues((PO)currentPointOfSales, (PO)newPointOfSales, (boolean)true);
        this.setCopyValues((PO)currentPointOfSales, (PO)newPointOfSales);
        currentPointOfSales.setName(newName);
        currentPointOfSales.saveEx();
        newPointOfSales.saveEx(this.get_TrxName());
        this.saveUuidReference((PO)currentPointOfSales, (PO)newPointOfSales);
        currentPointOfSales.setIsActive(false);
        currentPointOfSales.saveEx();
        this.pointOfSales.add(newPointOfSales.getC_POS_ID());
    }

    private void copyCashBook(int currentCashBookId) {
        if (currentCashBookId <= 0) {
            return;
        }
        MCashBook currentCashBook = new MCashBook(this.getCtx(), currentCashBookId, this.get_TrxName());
        String newName = this.getName(currentCashBook.getName());
        MCashBook newCashBook = new MCashBook(this.getCtx(), 0, this.get_TrxName());
        PO.copyValues((PO)currentCashBook, (PO)newCashBook, (boolean)true);
        this.setCopyValues((PO)currentCashBook, (PO)newCashBook);
        newCashBook.setName(newName);
        newCashBook.setC_Currency_ID(this.getCurrencyToId());
        newCashBook.saveEx(this.get_TrxName());
        this.saveUuidReference((PO)currentCashBook, (PO)newCashBook);
        currentCashBook.setIsActive(false);
        currentCashBook.saveEx();
        this.copyRecordAccess(currentCashBook.getC_CashBook_ID(), newCashBook.getC_CashBook_ID(), I_C_CashBook.Table_ID);
        this.copyCashBookAcct(currentCashBook.getC_CashBook_ID(), newCashBook.getC_CashBook_ID());
    }

    private void copyCashFlow(int currentCashFlowId) {
        if (currentCashFlowId <= 0) {
            return;
        }
        MCashFlow currentCashFlow = new MCashFlow(this.getCtx(), currentCashFlowId, this.get_TrxName());
        String newName = this.getName(currentCashFlow.getDocumentNo());
        MCashFlow newCashFlow = new MCashFlow(this.getCtx(), 0, this.get_TrxName());
        PO.copyValues((PO)currentCashFlow, (PO)newCashFlow, (boolean)true);
        this.setCopyValues((PO)currentCashFlow, (PO)newCashFlow);
        currentCashFlow.setDocumentNo(newName);
        currentCashFlow.saveEx();
        newCashFlow.setC_Currency_ID(this.getCurrencyToId());
        newCashFlow.saveEx(this.get_TrxName());
        this.saveUuidReference((PO)currentCashFlow, (PO)newCashFlow);
    }

    private void copyBankAccountAndCashAccount(int currentCashAccountId) {
        if (currentCashAccountId <= 0) {
            return;
        }
        MBankAccount currentCashAccount = new MBankAccount(this.getCtx(), currentCashAccountId, this.get_TrxName());
        String newName = this.getName(currentCashAccount.getAccountNo());
        MBankAccount newCashAccount = new MBankAccount(this.getCtx(), 0, this.get_TrxName());
        PO.copyValues((PO)currentCashAccount, (PO)newCashAccount, (boolean)true);
        this.setCopyValues((PO)currentCashAccount, (PO)newCashAccount);
        newCashAccount.setAccountNo(currentCashAccount.getAccountNo());
        newCashAccount.setCurrentBalance(Env.ZERO);
        newCashAccount.setC_Currency_ID(this.getCurrencyToId());
        newCashAccount.saveEx(this.get_TrxName());
        this.saveUuidReference((PO)currentCashAccount, (PO)newCashAccount);
        this.bankAccountsToReplace.put(currentCashAccount.getC_BankAccount_ID(), newCashAccount.getC_BankAccount_ID());
        this.copyBankAccountDocument(currentCashAccount.getC_BankAccount_ID(), newCashAccount.getC_BankAccount_ID());
        this.copyBankAccountWithdrawal(currentCashAccount.getC_BankAccount_ID(), newCashAccount.getC_BankAccount_ID());
        this.copyBankAccountAcct(currentCashAccount.getC_BankAccount_ID(), newCashAccount.getC_BankAccount_ID());
        currentCashAccount.setAccountNo(newName);
        currentCashAccount.setIsActive(!this.isDisableOldBankAccounts());
        currentCashAccount.setIsDirectLoad(true);
        currentCashAccount.saveEx();
        this.copyRecordAccess(currentCashAccount.getC_BankAccount_ID(), newCashAccount.getC_BankAccount_ID(), I_C_BankAccount.Table_ID);
        this.closeBankCashAccount(currentCashAccount, newCashAccount);
    }

    private void copyBankAccountDocument(int currentCashAccountId, int newCashAccountId) {
        new Query(this.getCtx(), "C_BankAccountDoc", "C_BankAccount_ID = ?", this.get_TrxName()).setParameters(new Object[]{currentCashAccountId}).list().stream().forEach(currentBankAccountDocument -> {
            X_C_BankAccountDoc bankAccountDocument = new X_C_BankAccountDoc(this.getCtx(), 0, this.get_TrxName());
            PO.copyValues((PO)currentBankAccountDocument, (PO)bankAccountDocument, (boolean)true);
            bankAccountDocument.setC_BankAccount_ID(newCashAccountId);
            this.setCopyValues((PO)currentBankAccountDocument, (PO)bankAccountDocument);
            bankAccountDocument.setCurrentNext(currentBankAccountDocument.getCurrentNext());
            bankAccountDocument.saveEx();
            this.saveUuidReference((PO)currentBankAccountDocument, (PO)bankAccountDocument);
        });
    }

    private void copyBankAccountWithdrawal(int currentCashAccountId, int newCashAccountId) {
        String tableName = "C_BankAccountWithdrawal";
        if (MTable.getTable_ID((String)tableName) <= 0) {
            return;
        }
        new Query(this.getCtx(), tableName, "C_BankAccount_ID = ?", this.get_TrxName()).setParameters(new Object[]{currentCashAccountId}).list().stream().forEach(currentBankAccountWithdrawal -> {
            GenericPO newBankAccountWithdrawal = new GenericPO(tableName, this.getCtx(), 0, this.get_TrxName());
            String newName = this.getName(currentBankAccountWithdrawal.get_ValueAsString("Name"));
            PO.copyValues((PO)currentBankAccountWithdrawal, (PO)newBankAccountWithdrawal, (boolean)true);
            newBankAccountWithdrawal.set_ValueOfColumn("C_BankAccount_ID", (Object)newCashAccountId);
            this.setCopyValues((PO)currentBankAccountWithdrawal, (PO)newBankAccountWithdrawal);
            if (currentBankAccountWithdrawal.get_ValueAsInt("C_Currency_ID") > 0) {
                newBankAccountWithdrawal.set_ValueOfColumn("C_Currency_ID", (Object)this.getCurrencyToId());
            }
            newBankAccountWithdrawal.set_ValueOfColumn("Name", (Object)newName);
            newBankAccountWithdrawal.saveEx();
            this.saveUuidReference((PO)currentBankAccountWithdrawal, (PO)newBankAccountWithdrawal);
            this.addLog("@C_BankAccountWithdrawal_ID@ @Added@: " + newBankAccountWithdrawal.get_ValueAsString("Name"));
        });
    }

    private void copyBankAccountAcct(int currentCashAccountId, int newCashAccountId) {
        List currentBankAccountsAcct = new Query(this.getCtx(), "C_BankAccount_Acct", "C_BankAccount_ID = ?", this.get_TrxName()).setParameters(new Object[]{currentCashAccountId}).list();
        List newBankAccountsAcct = new Query(this.getCtx(), "C_BankAccount_Acct", "C_BankAccount_ID = ?", this.get_TrxName()).setParameters(new Object[]{newCashAccountId}).list();
        newBankAccountsAcct.forEach(newBankAccountAcct -> {
            Optional<X_C_BankAccount_Acct> maybeBankAccountAcct = currentBankAccountsAcct.stream().filter(currentBankAccountAcct -> currentBankAccountAcct.getC_AcctSchema_ID() == newBankAccountAcct.getC_AcctSchema_ID()).findFirst();
            maybeBankAccountAcct.ifPresent(currentBankAccountAcct -> {
                PO.copyValues((PO)currentBankAccountAcct, (PO)newBankAccountAcct, (boolean)true);
                newBankAccountAcct.setC_BankAccount_ID(newCashAccountId);
                this.saveUuidReference((PO)currentBankAccountAcct, (PO)newBankAccountAcct);
            });
        });
    }

    private void copyCashBookAcct(int currentCashId, int newCashAId) {
        List currentBankAccountsAcct = new Query(this.getCtx(), "C_CashBook_Acct", "C_CashBook_ID = ?", this.get_TrxName()).setParameters(new Object[]{currentCashId}).list();
        List newBankAccountsAcct = new Query(this.getCtx(), "C_CashBook_Acct", "C_CashBook_ID = ?", this.get_TrxName()).setParameters(new Object[]{newCashAId}).list();
        newBankAccountsAcct.forEach(newBankAccountAcct -> {
            Optional<X_C_CashBook_Acct> maybeBankAccountAcct = currentBankAccountsAcct.stream().filter(currentBankAccountAcct -> currentBankAccountAcct.getC_AcctSchema_ID() == newBankAccountAcct.getC_AcctSchema_ID()).findFirst();
            maybeBankAccountAcct.ifPresent(currentBankAccountAcct -> {
                PO.copyValues((PO)currentBankAccountAcct, (PO)newBankAccountAcct, (boolean)true);
                newBankAccountAcct.setC_CashBook_ID(newCashAId);
                this.saveUuidReference((PO)currentBankAccountAcct, (PO)newBankAccountAcct);
            });
        });
    }

    private String getName(String name) {
        return name + this.getSuffix();
    }

    private void closeBankCashAccount(MBankAccount sourceBankAccount, MBankAccount targetBankAccount) {
        if (Optional.ofNullable(this.getIsManageClosing()).orElse("N").equals("N") || !this.isReconvertCloseBankAccounts()) {
            return;
        }
        AtomicReference<Integer> lineNo = new AtomicReference<Integer>(10);
        String whereClause = "C_BankAccount_ID = ? AND DocStatus IN (?,?) AND IsReconciled = 'N'";
        List unReconciledPayments = new Query(this.getCtx(), "C_Payment", whereClause, this.get_TrxName()).setParameters(new Object[]{sourceBankAccount.get_ID(), "CO", "CL"}).list();
        MBankStatement closeBankStatement = new MBankStatement(sourceBankAccount);
        closeBankStatement.setStatementDate(this.getDateTrx());
        MBankStatement openBankStatement = new MBankStatement(targetBankAccount);
        openBankStatement.setStatementDate(this.getDateTrx());
        String closeDescription = Msg.parseTranslation((Properties)this.getCtx(), (String)"@closed@ @C_BankAccount_ID@ :".concat(sourceBankAccount.getAccountNo().concat(" @C_Currency_ID@ : ".concat(MCurrency.getISO_Code((Properties)this.getCtx(), (int)sourceBankAccount.getC_Currency_ID())))));
        String openDescription = Msg.parseTranslation((Properties)this.getCtx(), (String)"@Open@ @C_BankAccount_ID@ :".concat(targetBankAccount.getAccountNo().concat(" @C_Currency_ID@ : ".concat(MCurrency.getISO_Code((Properties)this.getCtx(), (int)targetBankAccount.getC_Currency_ID())))));
        MPayment paymentTargetOpen = null;
        AtomicReference<BigDecimal> unallocateAmount = new AtomicReference<BigDecimal>(Env.ZERO);
        unReconciledPayments.forEach(sourcePayment -> {
            MPayment targetPayment = new MPayment(this.getCtx(), 0, this.get_TrxName());
            PO.copyValues((PO)sourcePayment, (PO)targetPayment, (boolean)true);
            targetPayment.setC_BankAccount_ID(targetBankAccount.get_ID());
            targetPayment.setDescription(openDescription);
            targetPayment.setDocStatus("CL");
            targetPayment.setDocAction("--");
            targetPayment.setC_Currency_ID(targetBankAccount.getC_Currency_ID());
            targetPayment.setProcessed(true);
            targetPayment.setPayAmt(targetPayment.getPayAmt().multiply(this.multiplyRate).setScale(MCurrency.getStdPrecision((Properties)this.getCtx(), (int)targetBankAccount.getC_Currency_ID()), 4));
            targetPayment.setPosted(true);
            targetPayment.setIsDirectLoad(true);
            targetPayment.saveEx();
            if (closeBankStatement.get_ID() == 0) {
                closeBankStatement.saveEx();
            }
            MBankStatementLine bankStatementLine = new MBankStatementLine(closeBankStatement, ((Integer)lineNo.get()).intValue());
            this.setPayment((MPayment)sourcePayment, sourceBankAccount, bankStatementLine);
            bankStatementLine.saveEx();
            unallocateAmount.set(((BigDecimal)unallocateAmount.get()).add(bankStatementLine.getTrxAmt()));
            lineNo.set((Integer)lineNo.get() + 10);
        });
        BigDecimal currentBalanace = sourceBankAccount.getCurrentBalance().negate();
        currentBalanace = currentBalanace.add(unallocateAmount.get().negate());
        if (currentBalanace.compareTo(Env.ZERO) != 0) {
            MPayment paymentSourceClose = new MPayment(this.getCtx(), 0, this.get_TrxName());
            paymentSourceClose.setC_BankAccount_ID(sourceBankAccount.getC_BankAccount_ID());
            paymentSourceClose.setDocStatus("CL");
            paymentSourceClose.setDocAction("--");
            paymentSourceClose.setC_Currency_ID(sourceBankAccount.getC_Currency_ID());
            paymentSourceClose.setC_BPartner_ID(this.getBPartnerId());
            paymentSourceClose.setDescription(closeDescription);
            paymentSourceClose.setProcessed(true);
            paymentSourceClose.setPosted(true);
            paymentSourceClose.setPayAmt(currentBalanace.abs());
            if (currentBalanace.compareTo(Env.ZERO) > 0) {
                paymentSourceClose.setC_DocType_ID(true);
            } else {
                paymentSourceClose.setC_DocType_ID(false);
            }
            paymentSourceClose.setIsDirectLoad(true);
            paymentSourceClose.saveEx();
            if (closeBankStatement.get_ID() == 0) {
                closeBankStatement.saveEx();
            }
            MBankStatementLine bankStatementLine = new MBankStatementLine(closeBankStatement, lineNo.get().intValue());
            this.setPayment(paymentSourceClose, sourceBankAccount, bankStatementLine);
            bankStatementLine.saveEx();
            currentBalanace = sourceBankAccount.getCurrentBalance();
            paymentTargetOpen = new MPayment(this.getCtx(), 0, this.get_TrxName());
            PO.copyValues((PO)paymentSourceClose, (PO)paymentSourceClose, (boolean)true);
            paymentTargetOpen.setC_BankAccount_ID(targetBankAccount.get_ID());
            paymentTargetOpen.setC_Currency_ID(targetBankAccount.getC_Currency_ID());
            paymentTargetOpen.setC_BPartner_ID(this.getBPartnerId());
            paymentTargetOpen.setPayAmt(currentBalanace.abs());
            if (currentBalanace.compareTo(Env.ZERO) > 0) {
                paymentTargetOpen.setC_DocType_ID(true);
            } else {
                paymentTargetOpen.setC_DocType_ID(false);
            }
            paymentTargetOpen.setPayAmt(currentBalanace.abs().multiply(this.multiplyRate).setScale(MCurrency.getStdPrecision((Properties)this.getCtx(), (int)targetBankAccount.getC_Currency_ID()), 4));
            paymentTargetOpen.setDescription(openDescription);
            paymentTargetOpen.setIsDirectLoad(true);
            paymentTargetOpen.saveEx();
            openBankStatement.saveEx();
            MBankStatementLine openBankStatementLine = new MBankStatementLine(openBankStatement, 10);
            this.setPayment(paymentTargetOpen, targetBankAccount, openBankStatementLine);
            openBankStatementLine.saveEx();
            if (openBankStatement.get_ID() > 0) {
                openBankStatement.setName(openDescription);
                openBankStatement.setDocStatus("CL");
                openBankStatement.setDocAction("--");
                openBankStatement.setProcessed(true);
                openBankStatement.setPosted(true);
                openBankStatement.saveEx();
                DB.executeUpdate((String)"UPDATE C_BankStatement SET EndingBalance = COALESCE(BeginningBalance,0) + COALESCE(StatementDifference,0) WHERE C_BankStatement_ID = ? ", (int)openBankStatement.get_ID(), (String)this.get_TrxName());
                DB.executeUpdate((String)"UPDATE C_BankAccount SET CurrentBalance = COALESCE(bs.EndingBalance,0) FROM C_BankStatement bs WHERE bs.C_BankAccount_ID = C_BankAccount.C_BankAccount_ID AND bs.C_BankStatement_ID = ? ", (int)openBankStatement.get_ID(), (String)this.get_TrxName());
            }
        }
        if (closeBankStatement.get_ID() > 0) {
            closeBankStatement.setName(closeDescription);
            closeBankStatement.setDocStatus("CL");
            closeBankStatement.setDocAction("--");
            closeBankStatement.setProcessed(true);
            closeBankStatement.setPosted(true);
            closeBankStatement.saveEx();
            DB.executeUpdate((String)"UPDATE C_BankStatement SET EndingBalance = COALESCE(BeginningBalance,0) + COALESCE(StatementDifference,0) WHERE C_BankStatement_ID = ? ", (int)closeBankStatement.get_ID(), (String)this.get_TrxName());
            DB.executeUpdate((String)"UPDATE C_BankAccount SET CurrentBalance = COALESCE(bs.EndingBalance,0) FROM C_BankStatement bs WHERE bs.C_BankAccount_ID = C_BankAccount.C_BankAccount_ID AND bs.C_BankStatement_ID = ? ", (int)closeBankStatement.get_ID(), (String)this.get_TrxName());
        }
        DB.executeUpdate((String)"UPDATE C_Payment SET DocStatus = '".concat("CL").concat("', ").concat("DocAction = '").concat("--").concat("' ").concat("WHERE C_BankAccount_ID = ? AND ").concat("DocStatus ='".concat("CO").concat("'")), (int)sourceBankAccount.get_ID(), (String)this.get_TrxName());
        DB.executeUpdate((String)"UPDATE C_BankStatement SET DocStatus = '".concat("CL").concat("', ").concat("DocAction = '").concat("--").concat("' ").concat("WHERE C_BankAccount_ID = ? AND ").concat("DocStatus ='".concat("CO").concat("'")), (int)sourceBankAccount.get_ID(), (String)this.get_TrxName());
    }

    private void setPayment(MPayment payment, MBankAccount bankAccount, MBankStatementLine bankStatementLine) {
        BigDecimal interestAmt;
        AtomicReference<BigDecimal> paymentAmount = new AtomicReference<BigDecimal>(payment.getPayAmt(true));
        if (bankAccount.getC_Currency_ID() != payment.getC_Currency_ID()) {
            MCurrency currency = MCurrency.get((Properties)this.getCtx(), (int)payment.getC_Currency_ID());
            MCurrency currencyTo = MCurrency.get((Properties)this.getCtx(), (int)bankAccount.getC_Currency_ID());
            Timestamp conversionDate = payment.getDateAcct();
            StringBuffer errorMassage = new StringBuffer().append("@C_Payment_ID@ = " + payment.getDocumentNo()).append(" @C_Conversion_Rate_ID@ @From@ @C_Currency_ID@ ").append(currency.getISO_Code()).append(" @to@ @C_Currency_ID@ ").append(currencyTo.getISO_Code()).append(" @StatementDate@ ").append(DisplayType.getDateFormat((int)15).format(conversionDate)).append(" @NotFound@");
            BigDecimal currencyRate = Optional.ofNullable(MConversionRate.getRate((int)payment.getC_Currency_ID(), (int)bankAccount.getC_Currency_ID(), (Timestamp)conversionDate, (int)payment.getC_ConversionType_ID(), (int)payment.getAD_Client_ID(), (int)payment.getAD_Org_ID())).orElseThrow(() -> new AdempiereException(errorMassage.toString()));
            paymentAmount.updateAndGet(payAmount -> payAmount.multiply(currencyRate).setScale(currencyTo.getStdPrecision(), 4));
        }
        bankStatementLine.setC_Payment_ID(payment.getC_Payment_ID());
        bankStatementLine.setC_Currency_ID(bankAccount.getC_Currency_ID());
        BigDecimal chargeAmt = bankStatementLine.getChargeAmt();
        if (chargeAmt == null) {
            chargeAmt = Env.ZERO;
        }
        if ((interestAmt = bankStatementLine.getInterestAmt()) == null) {
            interestAmt = Env.ZERO;
        }
        bankStatementLine.setTrxAmt(paymentAmount.get());
        bankStatementLine.setStmtAmt(paymentAmount.get().add(chargeAmt).add(interestAmt));
        bankStatementLine.setDescription(payment.getDescription());
    }

    private void copyRecordAccess(int currentEntityId, int newEntityId, int tableId) {
        new Query(this.getCtx(), "AD_Record_Access", "Record_ID = ? AND AD_Table_ID = ?", this.get_TrxName()).setParameters(new Object[]{currentEntityId, tableId}).list().forEach(currentRecordAccess -> {
            MRecordAccess documentAccionAccess = (MRecordAccess)new Query(this.getCtx(), "AD_Record_Access", "AD_Record_Access.AD_Table_ID = ? AND AD_Record_Access.Record_ID = ? ", this.get_TrxName()).setParameters(new Object[]{tableId, newEntityId}).first();
            if (documentAccionAccess == null || documentAccionAccess.getAD_Table_ID() <= 0) {
                documentAccionAccess = new MRecordAccess(this.getCtx(), currentRecordAccess.getAD_Role_ID(), tableId, newEntityId, this.get_TrxName());
                documentAccionAccess.setIsActive(currentRecordAccess.isActive());
                documentAccionAccess.setIsDependentEntities(currentRecordAccess.isDependentEntities());
                documentAccionAccess.setIsReadOnly(currentRecordAccess.isReadOnly());
                documentAccionAccess.setIsExclude(currentRecordAccess.isExclude());
                documentAccionAccess.saveEx();
            }
        });
    }
}

