/*
 * Decompiled with CFR 0.152.
 */
package org.spin.tools.process;

import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MDocType;
import org.compiere.model.MSequence;
import org.compiere.model.PO;
import org.compiere.util.Env;
import org.spin.tools.process.CopyDocumentTypesAbstract;
import org.spin.tools.util.CopyUtil;

public class CopyDocumentTypes
extends CopyDocumentTypesAbstract {
    private CopyUtil copy;
    public static final int WINDOW_THIS_PROCESS = 9999;

    @Override
    protected void prepare() {
        super.prepare();
        if (this.getTemplateClientId() <= 0) {
            throw new AdempiereException("@ECA25_TemplateClient_ID@ @IsMandatory@");
        }
        int targetClientId = this.getTargetClientId();
        if (targetClientId == 0) {
            targetClientId = this.getAD_Client_ID();
        }
        if (targetClientId == 0) {
            throw new AdempiereException("@ECA25_TargetClient_ID@ @NotFound@");
        }
        this.copy = CopyUtil.newInstance().withTeplateClientId(this.getTemplateClientId()).withTargetClientId(targetClientId).withContext(this.getCtx()).withTransactionName(this.get_TrxName());
    }

    protected String doIt() throws Exception {
        try {
            Env.setContext((Properties)this.getCtx(), (int)9999, (String)"AD_Client_ID", (int)this.copy.getTargetClientId());
            Env.setContext((Properties)this.getCtx(), (String)"#AD_Client_ID", (int)this.copy.getTargetClientId());
            this.copy.getTemplateReferencesOnlyNewIds("C_DocType").forEach(currentDocumentTypeId -> {
                MSequence sequence;
                int sequenceId;
                MDocType currentDocumentType = new MDocType(this.getCtx(), currentDocumentTypeId.intValue(), this.get_TrxName());
                MDocType newDocumentType = new MDocType(this.getCtx(), 0, this.get_TrxName());
                this.copy.copyCurrentValues((PO)currentDocumentType, (PO)newDocumentType);
                newDocumentType.setAD_Org_ID(0);
                newDocumentType.saveEx();
                this.copy.saveReference((PO)currentDocumentType, (PO)newDocumentType);
                if (currentDocumentType.getDocNoSequence_ID() > 0) {
                    sequenceId = this.copy.getReferenceId("AD_Sequence", currentDocumentType.getDocNoSequence_ID());
                    if (sequenceId <= 0) {
                        sequence = this.createSequence(currentDocumentType.getDocNoSequence_ID());
                        sequenceId = sequence.getAD_Sequence_ID();
                    }
                    newDocumentType.setDocNoSequence_ID(sequenceId);
                }
                if (currentDocumentType.getDefiniteSequence_ID() > 0) {
                    sequenceId = this.copy.getReferenceId("AD_Sequence", currentDocumentType.getDefiniteSequence_ID());
                    if (sequenceId <= 0) {
                        sequence = this.createSequence(currentDocumentType.getDefiniteSequence_ID());
                        sequenceId = sequence.getAD_Sequence_ID();
                    }
                    newDocumentType.setDefiniteSequence_ID(sequenceId);
                }
                if (currentDocumentType.get_ValueAsInt("ControlNoSequence_ID") > 0) {
                    sequenceId = this.copy.getReferenceId("AD_Sequence", currentDocumentType.get_ValueAsInt("ControlNoSequence_ID"));
                    if (sequenceId <= 0) {
                        sequence = this.createSequence(currentDocumentType.get_ValueAsInt("ControlNoSequence_ID"));
                        sequenceId = sequence.getAD_Sequence_ID();
                    }
                    newDocumentType.set_ValueOfColumn("ControlNoSequence_ID", (Object)sequenceId);
                }
                newDocumentType.saveEx();
            });
        }
        catch (Exception e) {
            throw new AdempiereException((Throwable)e);
        }
        finally {
            Env.setContext((Properties)this.getCtx(), (int)9999, (String)"AD_Client_ID", (int)this.copy.getTemplateClientId());
            Env.setContext((Properties)this.getCtx(), (String)"#AD_Client_ID", (int)this.copy.getTemplateClientId());
        }
        return "Ok";
    }

    private MSequence createSequence(int currentSequenceId) {
        MSequence currentSequence = new MSequence(this.getCtx(), currentSequenceId, this.get_TrxName());
        MSequence newSequence = new MSequence(this.getCtx(), 0, this.get_TrxName());
        this.copy.copyCurrentValues((PO)currentSequence, (PO)newSequence);
        newSequence.setCurrentNext(currentSequence.getIncrementNo());
        this.copy.saveReference((PO)currentSequence, (PO)newSequence);
        return newSequence;
    }
}

