/*
 * Decompiled with CFR 0.152.
 */
package org.spin.tools.process;

import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.IntStream;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MCalendar;
import org.compiere.model.MCity;
import org.compiere.model.MClient;
import org.compiere.model.MClientInfo;
import org.compiere.model.MLocation;
import org.compiere.model.MOrg;
import org.compiere.model.MRegion;
import org.compiere.model.MSequence;
import org.compiere.model.MTree;
import org.compiere.model.MYear;
import org.compiere.model.PO;
import org.compiere.model.X_AD_ModelValidator;
import org.eevolution.service.dsl.ProcessBuilder;
import org.spin.tools.process.CopyASP;
import org.spin.tools.process.CopyClientSetupAbstract;
import org.spin.tools.process.CopyDocumentTypes;
import org.spin.tools.process.CopyFIDefinition;
import org.spin.tools.process.CopyFiscalDefinitions;
import org.spin.tools.process.CopyGLDefinitions;
import org.spin.tools.process.CopyOrganizationDefinition;
import org.spin.tools.process.CopyPODefinitions;
import org.spin.tools.process.CopyRoleDefinition;
import org.spin.tools.process.CopySODefinitions;
import org.spin.tools.util.CopyContextUtil;
import org.spin.tools.util.CopyUtil;

public class CopyClientSetup
extends CopyClientSetupAbstract {
    private MClient currentClient;
    private MClient newClient;
    private MClientInfo newClientInfo;
    private MLocation newLocation;
    private CopyUtil copy;

    @Override
    protected void prepare() {
        super.prepare();
        if (this.getTemplateClientId() <= 0) {
            throw new AdempiereException("@ECA25_TemplateClient_ID@ @IsMandatory@");
        }
        this.currentClient = new MClient(this.getCtx(), this.getTemplateClientId(), this.get_TrxName());
        this.copy = CopyUtil.newInstance().withTeplateClientId(this.getTemplateClientId()).withContext(this.getCtx()).withTransactionName(this.get_TrxName());
    }

    protected String doIt() throws Exception {
        try {
            this.copyClient();
            this.copyClientInfo();
            this.createCalendar();
            this.copy.runCopyProcess(CopyGLDefinitions.class);
            this.copy.runCopyProcess(CopyFIDefinition.class);
            this.copyOrganizations();
            this.copy.runCopyProcess(CopyRoleDefinition.class);
            this.copyModelValidators();
            this.copy.runCopyProcess(CopyDocumentTypes.class);
            this.copy.runCopyProcess(CopySODefinitions.class);
            this.copy.runCopyProcess(CopyPODefinitions.class);
            this.copy.runCopyProcess(CopyFiscalDefinitions.class);
            this.copy.runCopyProcess(CopyASP.class);
        }
        catch (Exception e) {
            throw new AdempiereException((Throwable)e);
        }
        finally {
            CopyContextUtil.newInstance().revertContextToCurrentClient(this.getCtx(), this.getProcessInfo().isBatch());
        }
        return this.newClient.getValue() + " - " + this.newClient.getName();
    }

    private void copyModelValidators() {
        this.copy.getTemplateReferencesOnlyNewIds("AD_ModelValidator").forEach(currentModelValidatorId -> {
            X_AD_ModelValidator currentModelValidator = new X_AD_ModelValidator(this.getCtx(), currentModelValidatorId.intValue(), this.get_TrxName());
            X_AD_ModelValidator newModelValidator = new X_AD_ModelValidator(this.getCtx(), 0, this.get_TrxName());
            this.copy.copyCurrentValues((PO)currentModelValidator, (PO)newModelValidator);
            newModelValidator.setAD_Org_ID(0);
            newModelValidator.saveEx();
            this.copy.saveReference((PO)currentModelValidator, (PO)newModelValidator);
        });
    }

    private void copyClient() {
        this.newClient = new MClient(this.getCtx(), 0, true, this.get_TrxName());
        this.copy.copyCurrentValues((PO)this.currentClient, (PO)this.newClient);
        this.newClient.setValue(this.getValue());
        this.newClient.setName(this.getName());
        this.newClient.setIsUseBetaFunctions(this.currentClient.isUseBetaFunctions());
        this.newClient.setIsCostImmediate(this.currentClient.isCostImmediate());
        this.newClient.setAutoArchive(this.currentClient.getAutoArchive());
        this.newClient.saveEx(this.get_TrxName());
        this.copy.withTargetClientId(this.newClient.getAD_Client_ID());
        this.copy.saveReference((PO)this.currentClient, (PO)this.newClient);
        CopyContextUtil.newInstance().updateContextToNewClient(this.getCtx(), this.newClient.getAD_Client_ID(), this.getProcessInfo().isBatch());
        if (!MSequence.checkClientSequences((Properties)this.getCtx(), (int)this.newClient.getAD_Client_ID(), (String)this.get_TrxName())) {
            throw new AdempiereException("@CreateSequenceError@");
        }
        int currentCountryId = MRegion.get((Properties)this.getCtx(), (int)this.getRegionId()).getC_Country_ID();
        MCity city = MCity.get((Properties)this.getCtx(), (int)this.getCityId());
        this.newLocation = new MLocation(this.getCtx(), currentCountryId, this.getRegionId(), city.getName(), this.get_TrxName());
        this.newLocation.setC_City_ID(this.getCityId());
        Optional.ofNullable(this.getAddress1()).ifPresent(address -> this.newLocation.setAddress1(address));
        Optional.ofNullable(this.getAddress2()).ifPresent(address -> this.newLocation.setAddress2(address));
        Optional.ofNullable(this.getAddress3()).ifPresent(address -> this.newLocation.setAddress3(address));
        Optional.ofNullable(this.getAddress4()).ifPresent(address -> this.newLocation.setAddress4(address));
        this.newLocation.saveEx(this.get_TrxName());
        this.addLog("@AD_Client_ID@: " + this.newClient.getValue() + " - " + this.newClient.getName());
    }

    private void copyOrganizations() {
        AtomicInteger counter = new AtomicInteger(1);
        this.copy.getTemplateReferencesOnlyNewIds("AD_Org").forEach(currentRoleId -> {
            MOrg sourceOrganization = new MOrg(this.getCtx(), currentRoleId.intValue(), this.get_TrxName());
            ProcessBuilder.create((Properties)this.getCtx()).process(CopyOrganizationDefinition.class).withParameter("ECA25_TemplateClient_ID", (Object)this.getTemplateClientId()).withParameter("ECA25_TargetClient_ID", (Object)this.newClient.getAD_Client_ID()).withParameter("AD_Org_ID", (Object)sourceOrganization.getAD_Org_ID()).withParameter("Value", (Object)(this.getValue() + "-" + counter.get())).withParameter("Name", (Object)(this.getName() + "-" + counter.get())).withParameter("TaxID", (Object)this.getTaxID()).withParameter("C_Region_ID", (Object)this.getRegionId()).withParameter("C_City_ID", (Object)this.getCityId()).withParameter("Address1", (Object)this.getAddress1()).withParameter("Address2", (Object)this.getAddress2()).withParameter("Address3", (Object)this.getAddress3()).withParameter("Address4", (Object)this.getAddress4()).withBatchMode().withoutTransactionClose().execute(this.get_TrxName());
            counter.incrementAndGet();
        });
    }

    public void copyClientInfo() {
        AtomicInteger treeOrgId = new AtomicInteger();
        AtomicInteger treeBPartnerId = new AtomicInteger();
        AtomicInteger treeProjectId = new AtomicInteger();
        AtomicInteger treeSalesRegionId = new AtomicInteger();
        AtomicInteger treeProductId = new AtomicInteger();
        AtomicInteger treeCampaignId = new AtomicInteger();
        AtomicInteger treeActivityId = new AtomicInteger();
        AtomicInteger treeAccountId = new AtomicInteger();
        this.copy.getTemplateReferencesOnlyNewIds("AD_Tree").forEach(currentTreeId -> {
            MTree currentTree = MTree.get((Properties)this.getCtx(), (int)currentTreeId, (String)this.get_TrxName());
            MTree newTree = new MTree(this.newClient, currentTree.getName(), currentTree.getTreeType());
            newTree.setParent_Column_ID(currentTree.getParent_Column_ID());
            newTree.setAD_ColumnSortOrder_ID(newTree.getAD_ColumnSortOrder_ID());
            newTree.saveEx();
            this.copy.saveReference((PO)currentTree, (PO)newTree);
            if (currentTree.getTreeType().equals("OO")) {
                treeOrgId.set(newTree.getAD_Tree_ID());
            } else if (currentTree.getTreeType().equals("BP")) {
                treeBPartnerId.set(newTree.getAD_Tree_ID());
            } else if (currentTree.getTreeType().equals("PJ")) {
                treeProjectId.set(newTree.getAD_Tree_ID());
            } else if (currentTree.getTreeType().equals("SR")) {
                treeSalesRegionId.set(newTree.getAD_Tree_ID());
            } else if (currentTree.getTreeType().equals("PR")) {
                treeProductId.set(newTree.getAD_Tree_ID());
            } else if (currentTree.getTreeType().equals("EV")) {
                treeAccountId.set(newTree.getAD_Tree_ID());
            } else if (currentTree.getTreeType().equals("MC")) {
                treeCampaignId.set(newTree.getAD_Tree_ID());
            } else if (currentTree.getTreeType().equals("AY")) {
                treeActivityId.set(newTree.getAD_Tree_ID());
            }
            this.copy.putReferenceId("AD_Tree", (int)currentTreeId, newTree.getAD_Tree_ID());
        });
        this.newClientInfo = new MClientInfo(this.newClient, treeOrgId.get(), treeBPartnerId.get(), treeProjectId.get(), treeSalesRegionId.get(), treeProductId.get(), treeCampaignId.get(), treeActivityId.get(), this.get_TrxName());
        this.newClientInfo.saveEx();
    }

    private void createCalendar() {
        MCalendar newCalendar = new MCalendar(this.newClient);
        newCalendar.saveEx();
        this.newClientInfo.setC_Calendar_ID(newCalendar.getC_Calendar_ID());
        this.newClientInfo.saveEx();
        Calendar cal = Calendar.getInstance(this.newClient.getLocale());
        cal.set(5, 1);
        cal.set(2, 0);
        Calendar lastday = Calendar.getInstance();
        lastday.setTime(cal.getTime());
        lastday.add(1, 1);
        lastday.add(5, -1);
        IntStream.range(0, 5).forEach(page -> {
            MYear year = new MYear(newCalendar);
            String Year = String.valueOf(lastday.get(1));
            year.setFiscalYear(Year);
            year.saveEx();
            year.createStdPeriods(this.newClient.getLocale(), new Timestamp(cal.getTimeInMillis()), "yyyy-MM");
            cal.add(1, 1);
            lastday.add(1, 1);
        });
    }
}

