/*
 * Decompiled with CFR 0.152.
 */
package org.spin.tools.process;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MConversionRate;
import org.compiere.model.MConversionType;
import org.compiere.model.MCurrency;
import org.compiere.model.MSequence;
import org.compiere.model.MSysConfig;
import org.compiere.model.MTable;
import org.compiere.util.DB;
import org.spin.tools.process.CopyAccountingFactAbstract;

public class CopyAccountingFact
extends CopyAccountingFactAbstract {
    boolean converBasedOnDocumentDateAcct = false;

    @Override
    protected void prepare() {
        super.prepare();
        this.converBasedOnDocumentDateAcct = this.getConversionRateId() == 0;
    }

    protected String doIt() throws Exception {
        if (this.getAcctSchemaId() == 0) {
            throw new AdempiereException("@Invalid@ @C_AcctSchema_ID@ @From@");
        }
        if (this.getAcctSchemaIdTo() == 0) {
            throw new AdempiereException("@Invalid@ @C_AcctSchema_ID@ @To@");
        }
        if (this.getConvertAcct() == 0) {
            throw new AdempiereException("@Invalid@ @Currency_Convert_Acct@");
        }
        this.copyFactAccounting();
        return "@OK@";
    }

    private void copyFactAccounting() {
        ArrayList<Comparable<Integer>> paramsDelete = new ArrayList<Comparable<Integer>>();
        ArrayList<Comparable<Integer>> paramsInsert = new ArrayList<Comparable<Integer>>();
        LinkedHashMap columnsSQL = new LinkedHashMap();
        AtomicReference<String> sqlInsert = new AtomicReference<String>("");
        AtomicReference<String> sqlSelect = new AtomicReference<String>("");
        boolean nativeSequence = MSysConfig.getBooleanValue((String)"SYSTEM_NATIVE_SEQUENCE", (boolean)false);
        Optional<MSequence> maybeSequence = Optional.ofNullable(MSequence.get((Properties)this.getCtx(), (String)"Fact_Acct", (String)this.get_TrxName()));
        AtomicReference<String> sequenceId = new AtomicReference<String>("0");
        maybeSequence.ifPresent(sequence -> sequenceId.set(Integer.valueOf(sequence.get_ID()).toString()));
        String whereClause = "C_AcctSchema_ID = ?";
        paramsInsert.add(Integer.valueOf(this.getAcctSchemaId()));
        paramsDelete.add(Integer.valueOf(this.getAcctSchemaIdTo()));
        if (this.getDateAcct() != null) {
            whereClause = whereClause + " AND DateAcct >= ?";
            paramsInsert.add(this.getDateAcct());
            paramsDelete.add(this.getDateAcct());
        }
        if (this.getDateAcctTo() != null) {
            whereClause = whereClause + " AND DateAcct <= ?";
            paramsInsert.add(this.getDateAcctTo());
            paramsDelete.add(this.getDateAcctTo());
        }
        Optional<MTable> maybeFactAcct = Optional.ofNullable(MTable.get((Properties)this.getCtx(), (String)"Fact_Acct"));
        maybeFactAcct.ifPresent(factAcct -> factAcct.getColumnsAsList().forEach(column -> {
            String key;
            String value = key = column.getColumnName();
            if (column.getColumnName().equals("C_AcctSchema_ID")) {
                value = Integer.valueOf(this.getAcctSchemaIdTo()).toString();
            }
            if (column.getColumnName().equals("Fact_Acct_ID")) {
                value = nativeSequence ? "NEXTVAL('fact_acct_seq')" : "NEXTID(".concat((String)sequenceId.get()).concat(", 'N')");
            }
            if (column.getColumnName().equals("AmtAcctCr")) {
                value = this.convertedAmount("AmtAcctCr", "DateAcct");
            }
            if (column.getColumnName().equals("AmtAcctDr")) {
                value = this.convertedAmount("AmtAcctDr", "DateAcct");
            }
            columnsSQL.put(key, value);
        }));
        if (!columnsSQL.isEmpty()) {
            columnsSQL.entrySet().forEach(item -> {
                if (((String)sqlInsert.get()).isEmpty()) {
                    sqlInsert.set((String)item.getKey());
                    sqlSelect.set((String)item.getValue());
                } else {
                    sqlInsert.set(((String)sqlInsert.get()).concat(", ").concat((String)item.getKey()));
                    sqlSelect.set(((String)sqlSelect.get()).concat(", ").concat((String)item.getValue()));
                }
            });
            String deleteFact = "DELETE FROM ".concat("Fact_Acct").concat(" WHERE ").concat(whereClause);
            String insertFact = "INSERT INTO ".concat("Fact_Acct").concat("(").concat(sqlInsert.get()).concat(")").concat("SELECT ").concat(sqlSelect.get()).concat(" ").concat("FROM ").concat("Fact_Acct").concat(" ").concat("WHERE ").concat(whereClause);
            int deleteRecords = DB.executeUpdate((String)deleteFact, (Object[])paramsDelete.toArray(), (boolean)false, (String)this.get_TrxName());
            this.addLog("@Records@ @Deleted@ " + deleteRecords);
            int insertedRecords = DB.executeUpdate((String)insertFact, (Object[])paramsInsert.toArray(), (boolean)false, (String)this.get_TrxName());
            this.addLog("@Records@ @Inserted@ " + insertedRecords);
            columnsSQL.clear();
            sqlInsert.set("");
            sqlSelect.set("");
            paramsInsert.clear();
            whereClause = "fa.C_AcctSchema_ID = ?";
            paramsInsert.add(Integer.valueOf(this.getAcctSchemaIdTo()));
            insertFact = "CREATE TABLE Fact_Acct_Diff AS SELECT AD_Table_ID,Record_ID,MIN(Fact_Acct_ID) Fact_Acct_ID,sum(AmtAcctDR- AmtAcctCr) AmtDiff FROM Fact_Acct WHERE C_AcctSchema_ID= ? GROUP BY AD_Table_ID,Record_ID HAVING SUM(AmtAcctDR- AmtAcctCr) !=0";
            insertedRecords = DB.executeUpdate((String)insertFact, (int)this.getAcctSchemaIdTo(), (boolean)false, (String)this.get_TrxName());
            this.addLog("@Records@ @Inserted@ @Adjustment@ " + insertedRecords);
            maybeFactAcct.ifPresent(factAcct -> factAcct.getColumnsAsList().forEach(column -> {
                String key = column.getColumnName();
                String value = "fa.".concat(key);
                if (column.getColumnName().equals("C_AcctSchema_ID")) {
                    value = Integer.valueOf(this.getAcctSchemaIdTo()).toString();
                }
                if (column.getColumnName().equals("Fact_Acct_ID")) {
                    value = nativeSequence ? "NEXTVAL('fact_acct_seq')" : "NEXTID(".concat((String)sequenceId.get()).concat(", 'N')");
                }
                if (column.getColumnName().equals("AmtAcctCr")) {
                    value = "CASE WHEN fad.AmtDiff > 0 THEN fad.AmtDiff ELSE 0 END AmtAcctCr";
                }
                if (column.getColumnName().equals("AmtAcctDr")) {
                    value = "CASE WHEN fad.AmtDiff < 0 THEN ABS(fad.AmtDiff) ELSE 0 END AmtAcctDr";
                }
                if (column.getColumnName().equals("AmtSourceCr")) {
                    value = "CASE WHEN fad.AmtDiff > 0 THEN fad.AmtDiff ELSE 0 END AmtSourceCr";
                }
                if (column.getColumnName().equals("AmtSourceDr")) {
                    value = "CASE WHEN fad.AmtDiff < 0 THEN ABS(fad.AmtDiff) ELSE 0 END AmtSourceDr";
                }
                if (column.getColumnName().equals("C_Currency_ID")) {
                    MAcctSchema targetSchema = MAcctSchema.get((Properties)this.getCtx(), (int)this.getAcctSchemaIdTo());
                    value = Integer.valueOf(targetSchema.getC_Currency_ID()).toString();
                }
                if (column.getColumnName().equals("Account_ID")) {
                    value = Integer.valueOf(MAccount.get((Properties)this.getCtx(), (int)this.getConvertAcct()).getAccount_ID()).toString();
                }
                columnsSQL.put(key, value);
            }));
            columnsSQL.entrySet().forEach(item -> {
                if (((String)sqlInsert.get()).isEmpty()) {
                    sqlInsert.set((String)item.getKey());
                    sqlSelect.set((String)item.getValue());
                } else {
                    sqlInsert.set(((String)sqlInsert.get()).concat(", ").concat((String)item.getKey()));
                    sqlSelect.set(((String)sqlSelect.get()).concat(", ").concat((String)item.getValue()));
                }
            });
            insertFact = "INSERT INTO ".concat("Fact_Acct").concat("(").concat(sqlInsert.get()).concat(")").concat("SELECT ").concat(sqlSelect.get()).concat(" ").concat("FROM ").concat("Fact_Acct").concat(" fa ").concat("INNER JOIN Fact_Acct_Diff fad ON (fa.Fact_Acct_ID = fad.Fact_Acct_ID) ").concat("WHERE ").concat(whereClause);
            insertedRecords = DB.executeUpdate((String)insertFact, (Object[])paramsInsert.toArray(), (boolean)false, (String)this.get_TrxName());
            this.addLog("@Records@ @Inserted@ " + insertedRecords);
            DB.executeUpdate((String)"DROP TABLE Fact_Acct_Diff", (boolean)false, (String)this.get_TrxName());
        }
    }

    private String convertedAmount(String columnName, String columnDate) {
        String columnResult = columnName;
        MAcctSchema sourceSchema = MAcctSchema.get((Properties)this.getCtx(), (int)this.getAcctSchemaId());
        MAcctSchema targetSchema = MAcctSchema.get((Properties)this.getCtx(), (int)this.getAcctSchemaIdTo());
        Integer conversionTypeID = this.getConversionTypeId();
        Integer targetPrecision = MCurrency.getStdPrecision((Properties)this.getCtx(), (int)targetSchema.getC_Currency_ID());
        if (conversionTypeID == 0) {
            conversionTypeID = MConversionType.getDefault((int)this.getAD_Client_ID());
        }
        if (this.converBasedOnDocumentDateAcct) {
            columnResult = "COALESCE(CurrencyConvert(".concat(columnName).concat(", ").concat(Integer.valueOf(sourceSchema.getC_Currency_ID()).toString()).concat(", ").concat(Integer.valueOf(targetSchema.getC_Currency_ID()).toString()).concat(", ").concat(columnDate).concat(", ").concat(conversionTypeID.toString()).concat(", ").concat("AD_Client_ID").concat(", ").concat("AD_Org_ID").concat("),0)");
        } else {
            MConversionRate conversionRate = MConversionRate.get((Properties)this.getCtx(), (int)this.getConversionRateId());
            columnResult = "ROUND(COALESCE(".concat(columnName).concat(" * ").concat(conversionRate.getMultiplyRate().toString()).concat(",0) , ").concat(targetPrecision.toString()).concat(")");
        }
        return columnResult;
    }
}

