/*
 * Decompiled with CFR 0.152.
 */
package org.spin.tools.process;

import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.PO;
import org.compiere.model.X_ASP_ClientLevel;
import org.spin.tools.process.CopyASPAbstract;
import org.spin.tools.util.CopyContextUtil;
import org.spin.tools.util.CopyUtil;

public class CopyASP
extends CopyASPAbstract {
    private CopyUtil copy;

    @Override
    protected void prepare() {
        super.prepare();
        if (this.getTemplateClientId() <= 0) {
            throw new AdempiereException("@ECA25_TemplateClient_ID@ @IsMandatory@");
        }
        int targetClientId = this.getTargetClientId();
        if (targetClientId == 0) {
            targetClientId = this.getAD_Client_ID();
        }
        if (targetClientId == 0) {
            throw new AdempiereException("@ECA25_TargetClient_ID@ @NotFound@");
        }
        this.copy = CopyUtil.newInstance().withTeplateClientId(this.getTemplateClientId()).withTargetClientId(targetClientId).withContext(this.getCtx()).withTransactionName(this.get_TrxName());
    }

    protected String doIt() throws Exception {
        try {
            CopyContextUtil.newInstance().updateContextToNewClient(this.getCtx(), this.copy.getTargetClientId(), this.getProcessInfo().isBatch());
            this.copy.getTemplateReferencesOnlyNewIds("ASP_ClientLevel").forEach(currentASPClientLevelId -> {
                X_ASP_ClientLevel currentClientLevel = new X_ASP_ClientLevel(this.getCtx(), currentASPClientLevelId.intValue(), this.get_TrxName());
                X_ASP_ClientLevel newClientLevel = new X_ASP_ClientLevel(this.getCtx(), 0, this.get_TrxName());
                this.copy.copyCurrentValues((PO)currentClientLevel, (PO)newClientLevel);
                this.copy.saveReference((PO)currentClientLevel, (PO)newClientLevel);
            });
        }
        catch (Exception e) {
            throw new AdempiereException((Throwable)e);
        }
        finally {
            CopyContextUtil.newInstance().revertContextToCurrentClient(this.getCtx(), this.getProcessInfo().isBatch());
        }
        return "Ok";
    }
}

