/*
 * Decompiled with CFR 0.152.
 */
package org.spin.tools.process;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MOrder;
import org.compiere.util.Env;
import org.compiere.util.Trx;
import org.compiere.util.Util;
import org.spin.tools.process.ChangeWarehouseForOrderAbstract;

public class ChangeWarehouseForOrder
extends ChangeWarehouseForOrderAbstract {
    private AtomicInteger updated = new AtomicInteger();
    private AtomicInteger errors = new AtomicInteger();
    private StringBuffer errorsMessage = new StringBuffer();

    protected String doIt() throws Exception {
        this.getSelectionKeys().forEach(orderId -> {
            try {
                Trx.run(transactionName -> {
                    MOrder order = new MOrder(this.getCtx(), orderId.intValue(), transactionName);
                    String previousDocumentStatus = order.getDocStatus();
                    if (order.getDocStatus().equals("IP")) {
                        this.changeWarehouse(order);
                    } else if (order.getDocStatus().equals("CO")) {
                        if (!order.processIt("RE")) {
                            this.addLog(order.getC_Order_ID(), order.getDateOrdered(), null, order.getProcessMsg());
                            throw new AdempiereException(order.getProcessMsg());
                        }
                        order.saveEx();
                        String errorMessage = this.changeWarehouse(order);
                        if (!Util.isEmpty((String)errorMessage)) {
                            this.addLog(order.getC_Order_ID(), order.getDateOrdered(), null, errorMessage);
                            throw new AdempiereException(order.getProcessMsg());
                        }
                    }
                    if (order.getDocStatus().equals("IN")) {
                        this.addLog(order.getC_Order_ID(), order.getDateOrdered(), null, order.getProcessMsg());
                        throw new AdempiereException(order.getProcessMsg());
                    }
                    if (!order.processIt(previousDocumentStatus)) {
                        this.addLog(order.getC_Order_ID(), order.getDateOrdered(), null, order.getProcessMsg());
                        throw new AdempiereException(order.getProcessMsg());
                    }
                    order.saveEx();
                    this.updated.getAndIncrement();
                });
            }
            catch (Exception e) {
                this.errors.getAndIncrement();
                this.addMessage(e.getLocalizedMessage());
            }
        });
        return "@Updated@ " + this.updated + (this.errors.get() > 0 ? " @Error@" + this.errors + " - " + this.errorsMessage.toString() : "");
    }

    private void addMessage(String message) {
        if (Util.isEmpty((String)message)) {
            return;
        }
        if (this.errorsMessage.length() > 0) {
            this.errorsMessage.append(Env.NL);
        }
        this.errorsMessage.append(message);
    }

    private String changeWarehouse(MOrder order) {
        HashMap quantities = new HashMap();
        Arrays.asList(order.getLines(true, "Line")).forEach(orderLine -> {
            quantities.put(orderLine.getC_OrderLine_ID(), orderLine.getQtyEntered());
            orderLine.setQty(Env.ZERO);
            orderLine.saveEx();
        });
        if (!order.processIt("PR")) {
            return order.getProcessMsg();
        }
        order.setM_Warehouse_ID(this.getWarehouseId());
        order.saveEx();
        Arrays.asList(order.getLines(true, "Line")).forEach(orderLine -> {
            orderLine.setM_Warehouse_ID(this.getWarehouseId());
            orderLine.setQty((BigDecimal)quantities.get(orderLine.getC_OrderLine_ID()));
            orderLine.saveEx();
        });
        if (!order.processIt("PR")) {
            return order.getProcessMsg();
        }
        order.saveEx();
        return null;
    }
}

