/*
 * Decompiled with CFR 0.152.
 */
package org.spin.tools.model.validator;

import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import org.compiere.model.MClient;
import org.compiere.model.MUser;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.Env;

public class LoginValidator
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(LoginValidator.class);
    private int clientId = -1;
    private Properties ctx = Env.getCtx();

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.clientId = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
    }

    public int getAD_Client_ID() {
        return this.clientId;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        AtomicReference<String> errorMessage = new AtomicReference<String>("");
        String interfaceType = Optional.ofNullable(Env.getContext((Properties)this.ctx, (String)"#InterfaceType")).orElse("");
        Optional<MUser> maybeUser = Optional.ofNullable(MUser.get((Properties)this.ctx, (int)AD_User_ID));
        maybeUser.ifPresent(user -> {
            String userInterface = Optional.ofNullable(user.get_ValueAsString("ECA25_InterfaceType")).orElse("");
            if (!(userInterface == null || userInterface.isEmpty() || userInterface.equals("A") || userInterface.equals(interfaceType))) {
                errorMessage.set("@Invalid@ @".concat("ECA25_InterfaceType").concat("@"));
            }
        });
        return errorMessage.get();
    }

    public String modelChange(PO po, int type) throws Exception {
        return null;
    }

    public String docValidate(PO po, int timing) {
        return null;
    }
}

