/*
 * Decompiled with CFR 0.152.
 */
package org.spin.util.support.rpl.imp;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.process.rpl.ITestImportProcessor;
import org.adempiere.process.rpl.exp.WrapperUtil;
import org.adempiere.server.rpl.IImportProcessor;
import org.adempiere.util.rpl.EntityWrapper;
import org.compiere.model.MIMPProcessor;
import org.compiere.model.MIMPProcessorLog;
import org.compiere.server.ReplicationProcessor;
import org.compiere.util.CLogger;
import org.compiere.util.DisplayType;
import org.compiere.util.Msg;
import org.compiere.util.TimeUtil;
import org.compiere.util.Util;
import org.spin.database.DatabaseManager;

public class RethinkDBImportProcessor
implements IImportProcessor,
ITestImportProcessor {
    protected CLogger log = CLogger.getCLogger(this.getClass());
    private final String DB_NAME_KEY = "DATABASE_NAME";
    private final String RECORD_BATCH_TABLE = "record_batch";

    public void test(Properties ctx, MIMPProcessor importProcessor, String trxName) throws Exception {
        String host = importProcessor.getHost();
        if (Util.isEmpty((String)host)) {
            throw new AdempiereException("@Host@ @NotFound@");
        }
        String database = importProcessor.getParameterAsString("DATABASE_NAME");
        if (Util.isEmpty((String)database)) {
            throw new AdempiereException("@DB_NAME_KEY@ @NotFound@");
        }
        int port = importProcessor.getPort();
        if (port == 0) {
            throw new AdempiereException("@Port@ @NotFound@");
        }
        DatabaseManager.getInstance().validate(host, database, port);
        DatabaseManager.getInstance().createTable("record_batch", 1, 1);
        int recordBatchNo = DatabaseManager.getInstance().getRecordBatchNo();
        List<EntityWrapper> wrapperList = DatabaseManager.getInstance().getDocumentsByBatchNo(++recordBatchNo);
        String errorMessage = Msg.parseTranslation((Properties)ctx, (String)"@Error@");
        String errorSummary = Msg.parseTranslation((Properties)ctx, (String)"@SaveError@");
        long startTime = System.currentTimeMillis();
        AtomicInteger errors = new AtomicInteger();
        AtomicInteger imported = new AtomicInteger();
        wrapperList.forEach(wrapper -> {
            try {
                WrapperUtil.importWrapper((Properties)ctx, (EntityWrapper)wrapper, (String)trxName);
            }
            catch (Exception e) {
                errors.addAndGet(1);
                this.addLog(importProcessor, errorMessage, errorSummary, e.getLocalizedMessage(), true);
            }
        });
        if (!wrapperList.isEmpty()) {
            DatabaseManager.getInstance().setRecordBatchNo(recordBatchNo);
        }
        long endTime = System.currentTimeMillis();
        SimpleDateFormat format = DisplayType.getDateFormat((int)16);
        String message = Msg.parseTranslation((Properties)ctx, (String)("@I_IsImported@: " + imported.get() + " @Errors@: " + errors.get() + " @StartTime@: " + format.format(new Timestamp(startTime)) + " @EndTime@: " + format.format(new Timestamp(startTime)) + " @BatchDocumentNo@: " + recordBatchNo + " @Duration@" + TimeUtil.formatElapsed((long)(startTime - endTime))));
        this.addLog(importProcessor, Msg.getMsg((Properties)ctx, (String)"Process"), Msg.getMsg((Properties)ctx, (String)"Summary"), message, false);
    }

    public void process(Properties ctx, ReplicationProcessor replicationProcessor, String trxName) throws Exception {
        if (replicationProcessor == null) {
            return;
        }
        MIMPProcessor importProcessor = replicationProcessor.getMImportProcessor();
        String host = importProcessor.getHost();
        if (Util.isEmpty((String)host)) {
            throw new AdempiereException("@Host@ @NotFound@");
        }
        String database = importProcessor.getParameterAsString("DATABASE_NAME");
        if (Util.isEmpty((String)database)) {
            throw new AdempiereException("@DB_NAME_KEY@ @NotFound@");
        }
        int port = importProcessor.getPort();
        if (port == 0) {
            throw new AdempiereException("@Port@ @NotFound@");
        }
        String errorMessage = Msg.parseTranslation((Properties)ctx, (String)"@Error@");
        String errorSummary = Msg.parseTranslation((Properties)ctx, (String)"@SaveError@");
        long startTime = System.currentTimeMillis();
        AtomicInteger errors = new AtomicInteger();
        AtomicInteger imported = new AtomicInteger();
        DatabaseManager.getInstance().createTable("record_batch", 1, 1);
        int recordBatchNo = DatabaseManager.getInstance().getRecordBatchNo();
        List<EntityWrapper> wrapperList = DatabaseManager.getInstance().validate(host, database, port).getDocumentsByBatchNo(++recordBatchNo);
        wrapperList.forEach(wrapper -> {
            try {
                WrapperUtil.importWrapper((Properties)ctx, (EntityWrapper)wrapper, (String)trxName);
                imported.addAndGet(1);
            }
            catch (Exception e) {
                errors.addAndGet(1);
                this.addLog(importProcessor, errorMessage, errorSummary, e.getLocalizedMessage(), true);
            }
        });
        if (!wrapperList.isEmpty()) {
            DatabaseManager.getInstance().setRecordBatchNo(recordBatchNo);
        }
        long endTime = System.currentTimeMillis();
        SimpleDateFormat format = DisplayType.getDateFormat((int)16);
        String message = Msg.parseTranslation((Properties)ctx, (String)("@I_IsImported@: " + imported.get() + " @Errors@: " + errors.get() + " @StartTime@: " + format.format(new Timestamp(startTime)) + " @EndTime@: " + format.format(new Timestamp(startTime)) + " @Duration@" + TimeUtil.formatElapsed((long)(startTime - endTime))));
        this.addLog(importProcessor, Msg.getMsg((Properties)ctx, (String)"Process"), Msg.getMsg((Properties)ctx, (String)"Summary"), message, false);
    }

    private void addLog(MIMPProcessor importProcessor, String header, String summary, String textMessage, boolean isError) {
        MIMPProcessorLog log = new MIMPProcessorLog(importProcessor, summary);
        log.setReference(header);
        log.setTextMsg(textMessage);
        log.setIsError(isError);
        log.save();
    }

    public void stop() throws Exception {
    }
}

