/*
 * Decompiled with CFR 0.152.
 */
package org.spin.util.support.rpl.exp;

import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.process.rpl.IExportProcessorAsWrapper;
import org.adempiere.util.rpl.EntityWrapper;
import org.compiere.model.MEXPProcessor;
import org.compiere.model.MOrg;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.spin.database.DatabaseManager;

public class RethinkDBExportProcessor
implements IExportProcessorAsWrapper {
    protected CLogger log = CLogger.getCLogger(this.getClass());
    private final String DATABASE_PREFIX_KEY = "DATABASE_PREFIX";
    private final String TABLE_SHARDS_KEY = "TABLE_SHARDS";
    private final String TABLE_REPLICAS_KEY = "TABLE_REPLICAS";
    private final String RECORD_BATCH_TABLE = "record_batch";

    public void process(Properties ctx, MEXPProcessor exportProcessor, EntityWrapper wrapper, String transactionName) throws Exception {
        int port;
        String host = exportProcessor.getHost();
        if (Util.isEmpty((String)host)) {
            throw new AdempiereException("@Host@ @NotFound@");
        }
        String database = exportProcessor.getParameterAsString("DATABASE_PREFIX");
        if (Util.isEmpty((String)database)) {
            database = "";
        }
        if ((port = exportProcessor.getPort()) == 0) {
            throw new AdempiereException("@Port@ @NotFound@");
        }
        int shards = exportProcessor.getParameterAsInt("TABLE_SHARDS");
        int replicas = exportProcessor.getParameterAsInt("TABLE_REPLICAS");
        database = database + MOrg.get((Properties)ctx, (int)Env.getAD_Org_ID((Properties)ctx)).getValue();
        database = database.replaceAll("[+^:,.&\u00e1\u00e0\u00e4\u00e9\u00e8\u00eb\u00ed\u00ec\u00ef\u00f3\u00f2\u00f6\u00fa\u00f9\u00f1\u00c1\u00c0\u00c4\u00c9\u00c8\u00cb\u00cd\u00cc\u00cf\u00d3\u00d2\u00d6\u00da\u00d9\u00dc\u00d1\u00e7\u00c7$() ]", "").toLowerCase();
        DatabaseManager.getInstance().validate(host, database, port);
        DatabaseManager.getInstance().createTable("record_batch", shards, replicas);
        int recordBatchNo = DatabaseManager.getInstance().getRecordBatchNo();
        if (recordBatchNo <= 0) {
            recordBatchNo = 1;
            DatabaseManager.getInstance().setRecordBatchNo(recordBatchNo);
        }
        wrapper.setValue("BatchNo", (Object)recordBatchNo);
        DatabaseManager.getInstance().createTable(wrapper.getTableName(), shards, replicas);
        DatabaseManager.getInstance().saveDocument(wrapper);
    }
}

