/*
 * Decompiled with CFR 0.152.
 */
package org.spin.setup;

import java.sql.Timestamp;
import java.util.Properties;
import org.compiere.model.MProcess;
import org.compiere.model.MScheduler;
import org.compiere.model.MSchedulerPara;
import org.compiere.model.Query;
import org.compiere.model.X_AD_ModelValidator;
import org.compiere.util.TimeUtil;
import org.spin.model.validator.ReplicationQueue;
import org.spin.process.FlushReplicationQueue;
import org.spin.util.ISetupDefinition;

public class ReplicationQueueSetup
implements ISetupDefinition {
    private static final String SETUP_DESCRIPTION = "(*Created from Setup Automatically*)";

    public String doIt(Properties context, String transactionName) {
        this.createModelValidator(context, transactionName);
        this.createSchedule(context, transactionName);
        return "@AD_SetupDefinition_ID@ @Ok@";
    }

    private X_AD_ModelValidator createModelValidator(Properties context, String transactionName) {
        X_AD_ModelValidator modelValidator = (X_AD_ModelValidator)new Query(context, "AD_ModelValidator", "ModelValidationClass = ?", transactionName).setParameters(new Object[]{ReplicationQueue.class.getName()}).setClient_ID().first();
        if (modelValidator != null && modelValidator.getAD_ModelValidator_ID() > 0) {
            return modelValidator;
        }
        modelValidator = new X_AD_ModelValidator(context, 0, transactionName);
        modelValidator.setName("Replication Queue Validator");
        modelValidator.setEntityType("ECA02");
        modelValidator.setDescription(SETUP_DESCRIPTION);
        modelValidator.setSeqNo(200);
        modelValidator.setModelValidationClass(ReplicationQueue.class.getName());
        modelValidator.saveEx();
        return modelValidator;
    }

    private void createSchedule(Properties context, String transactionName) {
        new Query(context, "AD_Scheduler", "AD_Process_ID = ?", transactionName).setParameters(new Object[]{FlushReplicationQueue.getProcessId()}).setClient_ID().list().forEach(scheduler -> scheduler.delete(true));
        MScheduler scheduler2 = new MScheduler(context, 0, transactionName);
        scheduler2.setAD_Org_ID(0);
        scheduler2.setName(FlushReplicationQueue.getProcessName());
        scheduler2.setDescription(SETUP_DESCRIPTION);
        scheduler2.setAD_Process_ID(FlushReplicationQueue.getProcessId());
        scheduler2.setSupervisor_ID(100);
        scheduler2.setFrequencyType("M");
        scheduler2.setFrequency(5);
        scheduler2.setKeepLogDays(7);
        scheduler2.setDateNextRun(TimeUtil.addMinutess((Timestamp)TimeUtil.getDay((long)System.currentTimeMillis()), (int)scheduler2.getFrequency()));
        scheduler2.saveEx();
        MProcess process = MProcess.get((Properties)context, (int)FlushReplicationQueue.getProcessId());
        process.getParametersAsList().stream().filter(parameter -> parameter.getColumnName().equals("RecordsBatchQuantity")).findFirst().ifPresent(parameter -> {
            MSchedulerPara schedulerParameter = new MSchedulerPara(context, 0, transactionName);
            schedulerParameter.setAD_Org_ID(0);
            schedulerParameter.setAD_Scheduler_ID(scheduler2.getAD_Scheduler_ID());
            schedulerParameter.setAD_Process_Para_ID(parameter.getAD_Process_Para_ID());
            schedulerParameter.setParameterDefault("100");
            schedulerParameter.saveEx();
        });
        process.getParametersAsList().stream().filter(parameter -> parameter.getColumnName().equals("BatchQuantity")).findFirst().ifPresent(parameter -> {
            MSchedulerPara schedulerParameter = new MSchedulerPara(context, 0, transactionName);
            schedulerParameter.setAD_Org_ID(0);
            schedulerParameter.setAD_Scheduler_ID(scheduler2.getAD_Scheduler_ID());
            schedulerParameter.setAD_Process_Para_ID(parameter.getAD_Process_Para_ID());
            schedulerParameter.setParameterDefault("10");
            schedulerParameter.saveEx();
        });
    }
}

