/*
 * Decompiled with CFR 0.152.
 */
package org.spin.process;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.process.rpl.exp.ExportHelper;
import org.compiere.model.MClient;
import org.compiere.model.MEXPProcessor;
import org.compiere.model.MOrg;
import org.compiere.model.MReplicationDocument;
import org.compiere.model.MReplicationStrategy;
import org.compiere.model.MReplicationTable;
import org.compiere.model.MTable;
import org.compiere.model.ModelValidator;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.compiere.util.Trx;
import org.compiere.util.Util;
import org.spin.database.DatabaseManager;
import org.spin.model.MADReplicationQueue;
import org.spin.process.FlushReplicationQueueAbstract;

public class FlushReplicationQueue
extends FlushReplicationQueueAbstract {
    private AtomicInteger counter = new AtomicInteger();
    private AtomicInteger errors = new AtomicInteger();
    Map<Integer, MReplicationStrategy> replicationStrategyMap = new HashMap<Integer, MReplicationStrategy>();
    private final String DATABASE_PREFIX_KEY = "DATABASE_PREFIX";
    private final String RECORD_BATCH_TABLE = "record_batch";

    protected String doIt() throws Exception {
        if (this.getBatchQuantity() > 0 && this.getRecordsBatchQuantity() > 0) {
            Trx.run(transactionName -> {
                MADReplicationQueue replicationQueue = (MADReplicationQueue)new Query(this.getCtx(), "AD_ReplicationQueue", null, transactionName).setClient_ID().setLimit(this.getRecordsBatchQuantity()).first();
                if (replicationQueue != null) {
                    int port;
                    MEXPProcessor exportProcessor = new MEXPProcessor(this.getCtx(), replicationQueue.getAD_ReplicationStrategy().getEXP_Processor_ID(), transactionName);
                    String host = exportProcessor.getHost();
                    if (Util.isEmpty((String)host)) {
                        throw new AdempiereException("@Host@ @NotFound@");
                    }
                    String database = exportProcessor.getParameterAsString("DATABASE_PREFIX");
                    if (Util.isEmpty((String)database)) {
                        database = "";
                    }
                    if ((port = exportProcessor.getPort()) == 0) {
                        throw new AdempiereException("@Port@ @NotFound@");
                    }
                    database = database + MOrg.get((Properties)this.getCtx(), (int)Env.getAD_Org_ID((Properties)this.getCtx())).getValue();
                    database = database.replaceAll("[+^:,.&\u00e1\u00e0\u00e4\u00e9\u00e8\u00eb\u00ed\u00ec\u00ef\u00f3\u00f2\u00f6\u00fa\u00f9\u00f1\u00c1\u00c0\u00c4\u00c9\u00c8\u00cb\u00cd\u00cc\u00cf\u00d3\u00d2\u00d6\u00da\u00d9\u00dc\u00d1\u00e7\u00c7$() ]", "").toLowerCase();
                    try {
                        DatabaseManager.getInstance().validate(host, database, port);
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                    DatabaseManager.getInstance().createTable("record_batch", 1, 1);
                    int recordBatchNo = DatabaseManager.getInstance().getRecordBatchNo();
                    DatabaseManager.getInstance().deleteDocuments(recordBatchNo);
                    DatabaseManager.getInstance().setRecordBatchNo(++recordBatchNo);
                    for (int i = 0; i < this.getBatchQuantity(); ++i) {
                        new Query(this.getCtx(), "AD_ReplicationQueue", null, transactionName).setClient_ID().setLimit(this.getRecordsBatchQuantity()).getIDsAsList().forEach(queueId -> {
                            MADReplicationQueue queue = new MADReplicationQueue(this.getCtx(), (int)queueId, transactionName);
                            try {
                                this.processQueueRecord(queue, transactionName);
                                queue.delete(true);
                                this.counter.incrementAndGet();
                            }
                            catch (Exception e) {
                                this.errors.incrementAndGet();
                                this.addLog("@AD_Table_ID@: " + MTable.get((Properties)this.getCtx(), (int)queue.getAD_Table_ID()).getTableName() + " - @Record_ID@: " + queue.getRecord_ID() + ": " + e.getLocalizedMessage());
                                this.log.severe(queue + ": " + e.getLocalizedMessage());
                            }
                        });
                    }
                }
            });
        }
        return "@Processed@: " + this.counter + " @Errors@: " + this.errors;
    }

    private void processQueueRecord(MADReplicationQueue queue, String transactionName) {
        MTable tableToReplicate = MTable.get((Properties)this.getCtx(), (int)queue.getAD_Table_ID());
        MClient client = MClient.get((Properties)this.getCtx(), (int)queue.getAD_Client_ID());
        Optional.ofNullable(tableToReplicate.getPO(queue.getRecord_ID(), transactionName)).ifPresent(record -> {
            MReplicationStrategy replicationStrategy = this.getReplicationStrategy(queue.getAD_ReplicationStrategy_ID());
            ExportHelper exportHelper = new ExportHelper(client, replicationStrategy);
            if (this.isDocument(queue.getEventModelValidator())) {
                replicationStrategy.getReplicationDocuments().stream().filter(document -> document.getAD_Table_ID() == tableToReplicate.getAD_Table_ID()).findFirst().ifPresent(document -> {
                    try {
                        exportHelper.exportRecord(record, (MReplicationDocument)document, Integer.valueOf(this.getDocumentPosition(queue.getEventModelValidator())));
                    }
                    catch (Exception e) {
                        throw new AdempiereException((Throwable)e);
                    }
                });
            } else {
                replicationStrategy.getReplicationTables().stream().filter(table -> table.getAD_Table_ID() == tableToReplicate.getAD_Table_ID()).findFirst().ifPresent(table -> {
                    try {
                        exportHelper.exportRecord(record, (MReplicationTable)table, Integer.valueOf(this.getTablePosition(queue.getEventModelValidator())));
                    }
                    catch (Exception e) {
                        throw new AdempiereException((Throwable)e);
                    }
                });
            }
        });
    }

    private MReplicationStrategy getReplicationStrategy(int replicationStrategyId) {
        MReplicationStrategy replicationStrategy = this.replicationStrategyMap.get(replicationStrategyId);
        if (Optional.ofNullable(replicationStrategy).isPresent()) {
            return replicationStrategy;
        }
        replicationStrategy = new MReplicationStrategy(this.getCtx(), replicationStrategyId, this.get_TrxName());
        this.replicationStrategyMap.put(replicationStrategyId, replicationStrategy);
        return replicationStrategy;
    }

    private boolean isDocument(String eventModelValidator) {
        return Arrays.asList(ModelValidator.documentEventValidators).stream().filter(documentEvent -> documentEvent.equals(eventModelValidator)).findAny().isPresent();
    }

    private int getDocumentPosition(String eventModelValidator) {
        for (int eventPosition = 0; eventPosition < ModelValidator.documentEventValidators.length; ++eventPosition) {
            if (!ModelValidator.documentEventValidators[eventPosition].equals(eventModelValidator)) continue;
            return eventPosition;
        }
        return 0;
    }

    private int getTablePosition(String eventModelValidator) {
        for (int eventPosition = 0; eventPosition < ModelValidator.tableEventValidators.length; ++eventPosition) {
            if (!ModelValidator.tableEventValidators[eventPosition].equals(eventModelValidator)) continue;
            return eventPosition;
        }
        return 0;
    }
}

