/*
 * Decompiled with CFR 0.152.
 */
package org.spin.model.validator;

import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MClient;
import org.compiere.model.MReplicationDocument;
import org.compiere.model.MReplicationStrategy;
import org.compiere.model.MReplicationTable;
import org.compiere.model.MTable;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.model.X_AD_ReplicationDocument;
import org.compiere.model.X_AD_ReplicationTable;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.spin.model.MADReplicationQueue;

public class ReplicationQueue
implements ModelValidator {
    public static final String CTX_IsReplicationEnabled = "#IsReplicationEnabled";
    private static CLogger log = CLogger.getCLogger(ReplicationQueue.class);
    private int clientId = -1;
    private int orgId = -1;
    private int roleId = -1;
    private int userId = -1;
    MClient client = null;
    ModelValidationEngine modelValidationEngine = null;

    public void initialize(ModelValidationEngine modelValidationEngine, MClient client) {
        this.modelValidationEngine = modelValidationEngine;
        this.client = client;
        if (client == null) {
            log.warning("Export Model Validator cannot be used as a global validator, it needs to be defined in a per-client (tenant) basis");
            return;
        }
        this.clientId = client.getAD_Client_ID();
        log.info(client.toString());
    }

    public String modelChange(PO po, int type) throws Exception {
        log.info("po.get_TableName() = " + po.get_TableName());
        if (type == 5 || type == 4 || type == 3) {
            MReplicationStrategy.getByOrgAndRole((Properties)po.getCtx(), (int)this.orgId, (int)this.roleId, (String)po.get_TrxName()).stream().forEach(replicationStrategy -> {
                MReplicationTable replicationTable = MReplicationStrategy.getReplicationTable((Properties)po.getCtx(), (int)replicationStrategy.get_ID(), (int)po.get_Table_ID());
                if (replicationTable != null) {
                    try {
                        MADReplicationQueue.addToQueue(po, replicationStrategy.getAD_ReplicationStrategy_ID(), tableEventValidators[type]);
                    }
                    catch (Exception exeption) {
                        if (replicationStrategy.isValidateError()) {
                            throw new AdempiereException((Throwable)exeption);
                        }
                        log.warning(exeption.getLocalizedMessage());
                    }
                }
            });
        }
        return null;
    }

    public String docValidate(PO po, int type) {
        log.info("Replicate the Document = " + po.get_TableName() + " with Type = " + type);
        String result = null;
        if (type == 9 || type == 11 || type == 13 || type == 10 || type == 12) {
            MReplicationStrategy.getByOrgAndRole((Properties)po.getCtx(), (int)this.orgId, (int)this.roleId, (String)po.get_TrxName()).stream().forEach(replicationStrategy -> {
                MReplicationDocument replicationDocument = null;
                int C_DocType_ID = po.get_ValueAsInt("C_DocType_ID");
                replicationDocument = C_DocType_ID > 0 ? MReplicationStrategy.getReplicationDocument((Properties)po.getCtx(), (int)replicationStrategy.get_ID(), (int)po.get_Table_ID(), (int)C_DocType_ID) : MReplicationStrategy.getReplicationDocument((Properties)po.getCtx(), (int)replicationStrategy.get_ID(), (int)po.get_Table_ID());
                if (replicationDocument != null) {
                    try {
                        MADReplicationQueue.addToQueue(po, replicationStrategy.getAD_ReplicationStrategy_ID(), documentEventValidators[type]);
                    }
                    catch (Exception exeption) {
                        if (replicationStrategy.isValidateError()) {
                            throw new AdempiereException((Throwable)exeption);
                        }
                        log.warning(exeption.getLocalizedMessage());
                    }
                }
            });
        }
        return result;
    }

    public String login(int orgId, int roleId, int userId) {
        Env.setContext((Properties)Env.getCtx(), (String)CTX_IsReplicationEnabled, (boolean)true);
        this.orgId = orgId;
        this.roleId = roleId;
        this.userId = userId;
        log.info("AD_Org_ID  =" + this.orgId);
        log.info("AD_Role_ID =" + this.roleId);
        log.info("AD_User_ID =" + this.userId);
        this.loadReplicationStrategy(Env.getCtx());
        return null;
    }

    public int getAD_Client_ID() {
        return this.clientId;
    }

    public void loadReplicationStrategy(Properties ctx) {
        MReplicationStrategy.getByOrgAndRole((Properties)ctx, (int)this.orgId, (int)this.roleId, null).stream().filter(replicationStrategy -> replicationStrategy != null).forEach(replicationStrategy -> {
            String tableName;
            for (X_AD_ReplicationTable rplTable : replicationStrategy.getReplicationTables()) {
                if (!"M".equals(rplTable.getReplicationType()) && !"B".equals(rplTable.getReplicationType()) && !"R".equals(rplTable.getReplicationType())) continue;
                tableName = MTable.getTableName((Properties)replicationStrategy.getCtx(), (int)rplTable.getAD_Table_ID());
                this.modelValidationEngine.addModelChange(tableName, (ModelValidator)this);
            }
            for (X_AD_ReplicationDocument rplDocument : replicationStrategy.getReplicationDocuments()) {
                if (!"M".equals(rplDocument.getReplicationType()) && !"R".equals(rplDocument.getReplicationType())) continue;
                tableName = MTable.getTableName((Properties)replicationStrategy.getCtx(), (int)rplDocument.getAD_Table_ID());
                this.modelValidationEngine.addDocValidate(tableName, (ModelValidator)this);
            }
        });
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(ReplicationQueue.class.getName());
        return stringBuffer.toString();
    }
}

