/*
 * Decompiled with CFR 0.152.
 */
package org.spin.database;

import com.rethinkdb.RethinkDB;
import com.rethinkdb.model.MapObject;
import com.rethinkdb.net.Connection;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Logger;
import org.adempiere.util.rpl.EntityWrapper;

public class DatabaseManager {
    private static DatabaseManager instance;
    private boolean isEnabledDatabase = false;
    private static final Logger logger;
    public static final String DATABASE_FORMAT = "yyyy-MM-dd-hh:mm:ss";
    public static final RethinkDB handler;
    private Connection connection = null;
    private String DEFAULT_DATABASE = "test";
    private String DEFAULT_TABLE = "issue";
    private String UPDATE_COLUMN = "Updated";
    private String RECORD_BATCH_TABLE = "record_batch";
    private String BATCHNO = "BatchNo";
    private String database;
    private final String TABLE_LIST = "table";
    private final String TABLE_NAME = "TableName";
    private final String PRIORITYNO = "PriorityNo";

    public static DatabaseManager getInstance() {
        if (instance == null) {
            instance = new DatabaseManager();
        }
        return instance;
    }

    public DatabaseManager validate(String host, String database, int port) throws Exception {
        if (host == null || host.trim().length() == 0) {
            throw new Exception("Host not found");
        }
        if (database == null || database.trim().length() == 0) {
            throw new Exception("Database not found");
        }
        if (port == 0) {
            throw new Exception("Port not found");
        }
        this.database = database;
        this.connection = handler.connection().hostname(host).port(Integer.valueOf(port)).db(this.DEFAULT_DATABASE).connect();
        this.isEnabledDatabase = this.connection.isOpen();
        this.createDatabase();
        return this;
    }

    private void createDatabase() {
        List databaseList = (List)handler.dbList().run(this.getConnection()).single();
        if (!databaseList.stream().filter(databaseToFind -> databaseToFind.equals(this.database)).findFirst().isPresent()) {
            handler.dbCreate((Object)this.database).run(this.getConnection());
        }
        this.connection.use(this.database);
        this.isEnabledDatabase = this.connection.isOpen();
        this.createDefaultTables();
    }

    private void createDefaultTables() {
        List tablesList;
        if (this.isEnabledDatabase && !(tablesList = (List)handler.tableList().run(this.getConnection()).single()).stream().filter(table -> table.equals(this.DEFAULT_TABLE)).findFirst().isPresent()) {
            handler.tableCreate((Object)this.DEFAULT_TABLE).run(this.getConnection());
        }
    }

    public void createTable(String table) {
        this.createTable(table, 0, 0);
    }

    public void createTable(String table, int shards, int replicas) {
        if (table == null || table.trim().length() == 0) {
            return;
        }
        ArrayList<String> tables = new ArrayList<String>();
        tables.add(table);
        this.createTables(tables, shards, replicas);
    }

    public void createTables(List<String> tablesToCreate) {
        this.createTables(tablesToCreate, 0, 0);
    }

    public void createTables(List<String> tablesToCreate, int shards, int replicas) {
        int internalReplicas;
        if (tablesToCreate == null || tablesToCreate.size() == 0) {
            return;
        }
        int internalShards = shards <= 0 ? 1 : shards;
        int n = internalReplicas = replicas <= 0 ? 1 : replicas;
        if (this.isEnabledDatabase) {
            List tablesList = (List)handler.tableList().run(this.getConnection()).single();
            tablesToCreate.forEach(currentTable -> {
                Optional<String> maybeTable = tablesList.stream().filter(table -> table.toLowerCase().equals(currentTable.toLowerCase())).findFirst();
                if (!maybeTable.isPresent()) {
                    handler.tableCreate((Object)currentTable.toLowerCase()).optArg("shards", (Object)internalShards).optArg("replicas", (Object)internalReplicas).run(this.getConnection());
                }
            });
        }
    }

    private Connection getConnection() {
        try {
            if (!this.connection.isOpen()) {
                this.connection.connect();
            }
        }
        catch (Exception e) {
            this.isEnabledDatabase = false;
        }
        return this.connection;
    }

    private OffsetDateTime getConvertedDate(long longDate) {
        return OffsetDateTime.ofInstant(Instant.ofEpochMilli(longDate), ZoneId.systemDefault());
    }

    public void saveDocument(EntityWrapper wrapper) {
        if (!this.isEnabledDatabase) {
            return;
        }
        String tableName = wrapper.getTableName().toLowerCase();
        Object document = handler.table((Object)tableName).get((Object)wrapper.getUuid()).run(this.getConnection()).first();
        if (document == null) {
            handler.table((Object)tableName).insert(this.populateMap(wrapper, true)).run(this.getConnection());
        } else {
            handler.table((Object)tableName).get((Object)wrapper.getUuid()).update(documentToUpdate -> this.populateMap(wrapper, false)).run(this.getConnection());
        }
        logger.info("Document: " + wrapper.getUuid() + " saved");
    }

    public List<EntityWrapper> getDocuments() {
        ArrayList<EntityWrapper> wrapperList = new ArrayList<EntityWrapper>();
        if (!this.isEnabledDatabase) {
            return wrapperList;
        }
        List tablesList = (List)handler.tableList().run(this.getConnection()).single();
        tablesList.stream().filter(table -> !table.toLowerCase().equals(this.DEFAULT_TABLE)).forEach(table -> handler.table(table).run(this.getConnection()).forEach(document -> wrapperList.add(this.populateWrapper((HashMap)document))));
        logger.info("Retrieved Documents: " + wrapperList.size());
        return wrapperList;
    }

    public List<EntityWrapper> getDocumentsByDate(Timestamp date) {
        ArrayList<EntityWrapper> wrapperList = new ArrayList<EntityWrapper>();
        if (!this.isEnabledDatabase) {
            return wrapperList;
        }
        List tablesList = (List)handler.tableList().run(this.getConnection()).single();
        tablesList.stream().filter(table -> !table.toLowerCase().equals(this.DEFAULT_TABLE)).forEach(table -> handler.table(table).filter(data -> data.g((Object)this.UPDATE_COLUMN).date().gt((Object)this.getConvertedDate(date.getTime()), new Object[0])).run(this.getConnection()).forEach(document -> wrapperList.add(this.populateWrapper((HashMap)document))));
        logger.info("Retrieved Documents: " + wrapperList.size());
        return wrapperList;
    }

    public List<EntityWrapper> getDocumentsByBatchNo(int batchNo) {
        ArrayList<EntityWrapper> wrapperList = new ArrayList<EntityWrapper>();
        if (!this.isEnabledDatabase) {
            return wrapperList;
        }
        List tablesList = (List)handler.tableList().run(this.getConnection()).single();
        tablesList.stream().filter(table -> !table.toLowerCase().equals(this.DEFAULT_TABLE)).forEach(table -> handler.table(table).filter(data -> data.g((Object)this.BATCHNO).eq((Object)batchNo, new Object[0])).run(this.getConnection()).forEach(document -> wrapperList.add(this.populateWrapper((HashMap)document))));
        logger.info("Retrieved Documents: " + wrapperList.size());
        return wrapperList;
    }

    public void deleteDocuments(int batchNo) {
        List tablesList = (List)handler.tableList().run(this.getConnection()).single();
        tablesList.stream().filter(table -> !table.toLowerCase().equals(this.DEFAULT_TABLE)).forEach(table -> handler.table(table).filter(data -> data.g((Object)this.BATCHNO).eq((Object)batchNo, new Object[0])).delete().run(this.getConnection()));
    }

    public List<Object> getTableList() {
        List tablesList = handler.table((Object)"table").run(this.getConnection()).toList();
        return tablesList;
    }

    public int getRecordBatchNo() {
        Map result;
        Integer batchNo = null;
        if (((Boolean)handler.table((Object)this.RECORD_BATCH_TABLE).isEmpty().run(this.getConnection()).first()).booleanValue()) {
            handler.table((Object)this.RECORD_BATCH_TABLE).insert((Object)handler.hashMap((Object)this.BATCHNO, (Object)0)).run(this.getConnection());
        }
        if ((result = (Map)handler.table((Object)this.RECORD_BATCH_TABLE).run(this.getConnection()).first()) != null && (batchNo = Integer.valueOf(result.get(this.BATCHNO).toString())) != null) {
            return batchNo;
        }
        return 0;
    }

    public void setRecordBatchNo(int value) {
        handler.table((Object)this.RECORD_BATCH_TABLE).update((Object)handler.hashMap((Object)this.BATCHNO, (Object)value)).run(this.getConnection());
        logger.info("BatchNo Updated: " + value);
    }

    public void setPriorityNo(String tableName, int priorityNo) {
        if (((Boolean)handler.table((Object)"table").filter(data -> data.g((Object)"TableName").eq((Object)tableName, new Object[0])).isEmpty().run(this.getConnection()).first()).booleanValue()) {
            handler.table((Object)"table").insert((Object)handler.hashMap((Object)"TableName", (Object)tableName).with((Object)"PriorityNo", (Object)priorityNo)).run(this.getConnection());
            logger.info("Insert Table Name: " + tableName + "PriorityNo: " + priorityNo);
        } else {
            handler.table((Object)"table").filter(data -> data.g((Object)"TableName").eq((Object)tableName, new Object[0])).update((Object)handler.hashMap((Object)"TableName", (Object)tableName).with((Object)"PriorityNo", (Object)priorityNo)).run(this.getConnection());
            logger.info("Update Table Name: " + tableName + "PriorityNo: " + priorityNo);
        }
    }

    public int getPriorityNo(String tableName) {
        Integer priorityNo = 0;
        Map result = (Map)handler.table((Object)"TableName").filter(data -> data.g((Object)"TableName").eq((Object)tableName, new Object[0])).run(this.getConnection()).first();
        if (result != null && (priorityNo = Integer.valueOf(result.get("PriorityNo").toString())) != null) {
            return priorityNo;
        }
        return priorityNo;
    }

    private boolean isSameValue(Object value, Object previousValue) {
        if (value == null && previousValue != null || value != null && previousValue == null) {
            return false;
        }
        if (value == null && previousValue == null) {
            return true;
        }
        if (value.toString().equals(previousValue.toString())) {
            return true;
        }
        return true;
    }

    private MapObject<Object, Object> populateMap(EntityWrapper wrapper, boolean isNew) {
        MapObject map = handler.hashMap((Object)"id", (Object)wrapper.getUuid()).with((Object)"Created", (Object)this.getConvertedDate(System.currentTimeMillis()));
        wrapper.getMap().keySet().forEach(key -> {
            Object value = wrapper.getValueAsObject(key);
            Object convertedValue = null;
            if (value != null) {
                convertedValue = value instanceof Timestamp ? this.getConvertedDate(((Timestamp)value).getTime()) : (value instanceof List ? this.getChildren((List)value, isNew) : (value instanceof EntityWrapper ? this.populateMap((EntityWrapper)value, isNew) : value));
            }
            if (convertedValue != null || !isNew) {
                map.with(key, convertedValue);
            }
        });
        return map;
    }

    private EntityWrapper populateWrapper(HashMap<String, Object> entity) {
        EntityWrapper wrapper = new EntityWrapper();
        entity.keySet().forEach(key -> {
            Object value = entity.get(key);
            if (value instanceof HashMap) {
                value = this.populateWrapper((HashMap)value);
            } else if (value instanceof List) {
                List children = (List)value;
                ArrayList wrapperList = new ArrayList();
                children.forEach(child -> wrapperList.add(this.populateWrapper((HashMap<String, Object>)child)));
                value = wrapperList;
            } else if (value instanceof OffsetDateTime) {
                long millis = ((OffsetDateTime)value).toInstant().toEpochMilli();
                value = new Timestamp(millis);
            }
            wrapper.setValue(key, value);
        });
        return wrapper;
    }

    private List<Object> getChildren(List<EntityWrapper> wrapperList, boolean isNew) {
        List list = handler.array();
        wrapperList.forEach(wrapper -> list.add(this.populateMap((EntityWrapper)wrapper, isNew)));
        return list;
    }

    static {
        logger = Logger.getLogger(DatabaseManager.class.getName());
        handler = RethinkDB.r;
    }
}

