/*
 * Decompiled with CFR 0.152.
 */
package com.rethinkdb.net;

import com.rethinkdb.ErrorBuilder;
import com.rethinkdb.ast.Query;
import com.rethinkdb.gen.exc.ReqlError;
import com.rethinkdb.gen.proto.ErrorType;
import com.rethinkdb.gen.proto.ResponseNote;
import com.rethinkdb.gen.proto.ResponseType;
import com.rethinkdb.model.Backtrace;
import com.rethinkdb.model.Profile;
import com.rethinkdb.net.ConnectionSocket;
import com.rethinkdb.utils.Internals;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Response {
    private static final Logger LOGGER = LoggerFactory.getLogger(Query.class);
    public final long token;
    public final ResponseType type;
    public final List<ResponseNote> notes;
    public final List<Object> data;
    @Nullable
    public final Profile profile;
    @Nullable
    public final Backtrace backtrace;
    @Nullable
    public final ErrorType errorType;

    public Response(long token, ResponseType responseType, List<Object> data, List<ResponseNote> responseNotes, @Nullable Profile profile, @Nullable Backtrace backtrace, @Nullable ErrorType errorType) {
        this.token = token;
        this.type = responseType;
        this.data = data;
        this.notes = responseNotes;
        this.profile = profile;
        this.backtrace = backtrace;
        this.errorType = errorType;
    }

    public Response(long token, ResponseType responseType) {
        this(token, responseType, Collections.emptyList(), Collections.emptyList(), null, null, null);
    }

    public ReqlError makeError(Query query) {
        String msg = this.data.size() > 0 ? (String)this.data.get(0) : "Unknown error message";
        return new ErrorBuilder(msg, this.type).setBacktrace(this.backtrace).setErrorType(this.errorType).setTerm(query).build();
    }

    public boolean isFeed() {
        return this.notes.stream().anyMatch(ResponseNote::isFeed);
    }

    public String toString() {
        return "Response{token=" + this.token + ", type=" + (Object)((Object)this.type) + ", notes=" + this.notes + ", data=" + this.data + ", profile=" + this.profile + ", backtrace=" + this.backtrace + '}';
    }

    public static Supplier<Response> readFromSocket(ConnectionSocket socket) {
        ByteBuffer header = socket.read(12);
        long token = header.getLong();
        int responseLength = header.getInt();
        ByteBuffer buffer = socket.read(responseLength).order(ByteOrder.LITTLE_ENDIAN);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("JSON Recv: Token: {} {}", (Object)token, (Object)new String(buffer.array(), buffer.arrayOffset() + buffer.position(), buffer.remaining(), StandardCharsets.UTF_8));
        }
        return () -> {
            Map<String, Object> json = Internals.readJson(buffer);
            return new Response(token, ResponseType.fromValue(((Long)json.get("t")).intValue()), json.getOrDefault("r", Collections.emptyList()), json.getOrDefault("n", Collections.emptyList()).stream().map(Long::intValue).map(ResponseNote::maybeFromValue).filter(Objects::nonNull).collect(Collectors.toList()), Profile.fromList((List)json.get("p")), Backtrace.fromList(json.getOrDefault("b", null)), json.containsKey("e") ? ErrorType.maybeFromValue(((Long)json.get("e")).intValue()) : null);
        };
    }
}

