/*
 * Decompiled with CFR 0.152.
 */
package com.rethinkdb.net;

import com.fasterxml.jackson.core.type.TypeReference;
import com.rethinkdb.ast.Query;
import com.rethinkdb.ast.ReqlAst;
import com.rethinkdb.gen.ast.Db;
import com.rethinkdb.gen.exc.ReqlDriverError;
import com.rethinkdb.gen.exc.ReqlError;
import com.rethinkdb.gen.proto.ResponseType;
import com.rethinkdb.model.OptArgs;
import com.rethinkdb.model.Server;
import com.rethinkdb.net.ConnectionSocket;
import com.rethinkdb.net.DefaultConnectionFactory;
import com.rethinkdb.net.HandshakeProtocol;
import com.rethinkdb.net.Response;
import com.rethinkdb.net.ResponsePump;
import com.rethinkdb.net.Result;
import com.rethinkdb.utils.Internals;
import com.rethinkdb.utils.Types;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URI;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.ssl.SSLContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Connection
implements Closeable {
    @NotNull
    private static final Logger LOGGER = LoggerFactory.getLogger(Connection.class);
    @NotNull
    protected final String hostname;
    protected final int port;
    @Nullable
    protected final String user;
    @Nullable
    protected final String password;
    @Nullable
    protected final Long timeout;
    @Nullable
    protected final SSLContext sslContext;
    @NotNull
    protected final ConnectionSocket.Factory socketFactory;
    @NotNull
    protected final ResponsePump.Factory pumpFactory;
    @NotNull
    protected final Result.FetchMode defaultFetchMode;
    protected final boolean unwrapLists;
    protected final boolean persistentThreads;
    @NotNull
    protected final AtomicLong nextToken = new AtomicLong();
    @NotNull
    protected final Set<Result<?>> tracked = ConcurrentHashMap.newKeySet();
    @NotNull
    protected final Lock writeLock = new ReentrantLock();
    @Nullable
    protected String dbname;
    @Nullable
    protected ConnectionSocket socket;
    @Nullable
    protected ResponsePump pump;

    public Connection(@NotNull Builder b) {
        this.hostname = b.hostname != null ? b.hostname : "127.0.0.1";
        this.port = b.port != null ? b.port : 28015;
        this.user = b.user != null ? b.user : "admin";
        this.password = b.password != null ? b.password : "";
        this.dbname = b.dbname;
        this.timeout = b.timeout;
        this.sslContext = b.sslContext;
        this.socketFactory = b.socketFactory != null ? b.socketFactory : DefaultConnectionFactory.INSTANCE;
        this.pumpFactory = b.pumpFactory != null ? b.pumpFactory : DefaultConnectionFactory.INSTANCE;
        this.unwrapLists = b.unwrapLists;
        this.defaultFetchMode = b.defaultFetchMode != null ? b.defaultFetchMode : Result.FetchMode.LAZY;
        this.persistentThreads = b.persistentThreads;
    }

    @Nullable
    public String db() {
        return this.dbname;
    }

    @NotNull
    public Connection use(@Nullable String db) {
        this.dbname = db;
        return this;
    }

    public boolean isOpen() {
        return this.socket != null && this.socket.isOpen() && this.pump != null && this.pump.isAlive();
    }

    @NotNull
    public CompletableFuture<Connection> connectAsync() {
        if (this.socket != null) {
            throw new ReqlDriverError("Client already connected!");
        }
        return this.createSocketAsync().thenApply(socket -> {
            this.socket = socket;
            HandshakeProtocol.doHandshake(socket, this.user, this.password, this.timeout);
            this.pump = this.pumpFactory.newPump((ConnectionSocket)socket, !this.persistentThreads);
            return this;
        });
    }

    @NotNull
    public Connection connect() {
        try {
            return this.connectAsync().join();
        }
        catch (CompletionException ce) {
            Throwable t = ce.getCause();
            if (t instanceof ReqlError) {
                throw (ReqlError)t;
            }
            throw new ReqlDriverError(t);
        }
    }

    @NotNull
    public CompletableFuture<Connection> reconnectAsync() {
        return this.reconnectAsync(true);
    }

    @NotNull
    public CompletableFuture<Connection> reconnectAsync(boolean noreplyWait) {
        return this.closeAsync(noreplyWait).thenCompose(v -> this.connectAsync());
    }

    @NotNull
    public Connection reconnect() {
        return this.reconnect(true);
    }

    @NotNull
    public Connection reconnect(boolean noreplyWait) {
        try {
            return this.reconnectAsync(noreplyWait).join();
        }
        catch (CompletionException ce) {
            Throwable t = ce.getCause();
            if (t instanceof ReqlError) {
                throw (ReqlError)t;
            }
            throw new ReqlDriverError(t);
        }
    }

    @NotNull
    public <T> CompletableFuture<Result<T>> runAsync(@NotNull ReqlAst term, @NotNull OptArgs optArgs, @Nullable Result.FetchMode fetchMode, @Nullable Boolean unwrap, @Nullable TypeReference<T> typeRef) {
        this.handleOptArgs(optArgs);
        Query q = Query.createStart(this.nextToken.incrementAndGet(), term, optArgs);
        if (optArgs.containsKey("noreply")) {
            throw new ReqlDriverError("Don't provide the noreply option as an optarg. Use `.runNoReply` instead of `.run`");
        }
        return this.runQuery(q, fetchMode, unwrap, typeRef);
    }

    @NotNull
    public <T> Result<T> run(@NotNull ReqlAst term, @NotNull OptArgs optArgs, @Nullable Result.FetchMode fetchMode, @Nullable Boolean unwrap, @Nullable TypeReference<T> typeRef) {
        try {
            return this.runAsync(term, optArgs, fetchMode, unwrap, typeRef).join();
        }
        catch (CompletionException ce) {
            Throwable t = ce.getCause();
            if (t instanceof ReqlError) {
                throw (ReqlError)t;
            }
            throw new ReqlDriverError(t);
        }
    }

    @NotNull
    public CompletableFuture<Server> serverAsync() {
        return this.sendQuery(Query.createServerInfo(this.nextToken.incrementAndGet())).thenApply(res -> {
            if (res.type.equals((Object)ResponseType.SERVER_INFO)) {
                return Internals.toPojo(res.data.get(0), Types.of(Server.class));
            }
            throw new ReqlDriverError("Did not receive a SERVER_INFO response.");
        });
    }

    @NotNull
    public Server server() {
        try {
            return this.serverAsync().join();
        }
        catch (CompletionException ce) {
            Throwable t = ce.getCause();
            if (t instanceof ReqlError) {
                throw (ReqlError)t;
            }
            throw new ReqlDriverError(t);
        }
    }

    @NotNull
    public CompletableFuture<Void> noreplyWaitAsync() {
        return this.runQuery(Query.createNoreplyWait(this.nextToken.incrementAndGet()), null, null, null).thenApply(ignored -> null);
    }

    public void noreplyWait() {
        try {
            this.noreplyWaitAsync().join();
        }
        catch (CompletionException ce) {
            Throwable t = ce.getCause();
            if (t instanceof ReqlError) {
                throw (ReqlError)t;
            }
            throw new ReqlDriverError(t);
        }
    }

    public void runNoReply(@NotNull ReqlAst term, @NotNull OptArgs optArgs) {
        this.handleOptArgs(optArgs);
        optArgs.with("noreply", true);
        this.runQueryNoreply(Query.createStart(this.nextToken.incrementAndGet(), term, optArgs));
    }

    @NotNull
    public CompletableFuture<Void> closeAsync() {
        return this.closeAsync(true);
    }

    @NotNull
    public CompletableFuture<Void> closeAsync(boolean shouldNoreplyWait) {
        return CompletableFuture.runAsync(() -> this.close(shouldNoreplyWait));
    }

    @Override
    public void close() {
        this.close(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(boolean shouldNoreplyWait) {
        try {
            if (shouldNoreplyWait) {
                this.noreplyWait();
            }
        }
        finally {
            this.nextToken.set(0L);
            for (Result<?> handler : this.tracked) {
                handler.onConnectionClosed();
            }
            if (this.pump != null) {
                this.pump.shutdownPump();
            }
            if (this.socket != null) {
                this.socket.close();
            }
        }
    }

    public void closeResults() {
        for (Result<?> handler : this.tracked) {
            handler.close();
        }
    }

    public boolean hasOngoingQueries() {
        return !this.tracked.isEmpty();
    }

    protected void sendStop(long token) {
        this.runQueryNoreply(Query.createStop(token));
    }

    @NotNull
    protected CompletableFuture<Response> sendContinue(long token) {
        return this.sendQuery(Query.createContinue(token));
    }

    protected void keepTrackOf(@NotNull Result<?> r) {
        this.tracked.add(r);
    }

    protected void loseTrackOf(@NotNull Result<?> r) {
        this.tracked.remove(r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected CompletableFuture<Response> sendQuery(@NotNull Query query) {
        if (this.socket == null || !this.socket.isOpen()) {
            throw new ReqlDriverError("Client not connected.");
        }
        if (this.pump == null) {
            throw new ReqlDriverError("Response pump is not running.");
        }
        CompletableFuture<Response> response = this.pump.await(query.token);
        try {
            this.writeLock.lock();
            this.socket.write(query.serialize());
            CompletableFuture<Response> completableFuture = response;
            return completableFuture;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected void runQueryNoreply(@NotNull Query query) {
        if (this.socket == null || !this.socket.isOpen()) {
            throw new ReqlDriverError("Client not connected.");
        }
        if (this.pump == null) {
            throw new ReqlDriverError("Response pump is not running.");
        }
        try {
            this.writeLock.lock();
            this.socket.write(query.serialize());
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @NotNull
    protected <T> CompletableFuture<Result<T>> runQuery(@NotNull Query query, @Nullable Result.FetchMode fetchMode, @Nullable Boolean unwrap, @Nullable TypeReference<T> typeRef) {
        return this.sendQuery(query).thenApply(res -> new Result(this, query, (Response)res, fetchMode == null ? this.defaultFetchMode : fetchMode, unwrap == null ? this.unwrapLists : unwrap, typeRef));
    }

    protected void handleOptArgs(@NotNull OptArgs optArgs) {
        if (optArgs.containsKey("db")) {
            optArgs.with("db", new Db(optArgs.get("db")));
        } else if (this.dbname != null) {
            optArgs.with("db", new Db(this.dbname));
        }
    }

    @NotNull
    protected CompletableFuture<ConnectionSocket> createSocketAsync() {
        if (this.socketFactory instanceof ConnectionSocket.AsyncFactory) {
            return ((ConnectionSocket.AsyncFactory)this.socketFactory).newSocketAsync(this.hostname, this.port, this.sslContext, this.timeout);
        }
        return CompletableFuture.supplyAsync(() -> this.socketFactory.newSocket(this.hostname, this.port, this.sslContext, this.timeout));
    }

    public static class Builder {
        @Nullable
        private String hostname;
        @Nullable
        private Integer port;
        @Nullable
        private String user;
        @Nullable
        private String password;
        @Nullable
        private String dbname;
        @Nullable
        private Long timeout;
        @Nullable
        private SSLContext sslContext;
        @Nullable
        private ConnectionSocket.Factory socketFactory;
        @Nullable
        private ResponsePump.Factory pumpFactory;
        @Nullable
        private Result.FetchMode defaultFetchMode;
        private boolean unwrapLists = false;
        private boolean persistentThreads = false;

        public Builder() {
        }

        public Builder(@NotNull URI uri) {
            Objects.requireNonNull(uri, "URI can't be null. Use the default constructor instead.");
            if (!"rethinkdb".equals(uri.getScheme())) {
                throw new IllegalArgumentException("Schema of the URL is not 'rethinkdb'.");
            }
            String userInfo = uri.getUserInfo();
            String host = uri.getHost();
            int port = uri.getPort();
            String path = uri.getPath();
            String query = uri.getQuery();
            if (userInfo != null && !userInfo.isEmpty()) {
                String[] split = userInfo.split(":");
                if (split.length > 2) {
                    throw new IllegalArgumentException("Invalid user info: '" + userInfo + "'");
                }
                if (split.length > 0) {
                    this.user = split[0];
                }
                if (split.length > 1) {
                    this.password = split[1];
                }
            }
            if (host != null && !host.isEmpty()) {
                this.hostname = host.trim();
            }
            if (port != -1) {
                this.port = port;
            }
            if (path != null && !path.isEmpty()) {
                if (path.charAt(0) == '/') {
                    path = path.substring(1);
                }
                if (!path.isEmpty()) {
                    this.dbname = path;
                }
            }
            if (query != null) {
                String[] kvs;
                block15: for (String kv : kvs = query.split("&")) {
                    int i = kv.indexOf(61);
                    String k = i != -1 ? kv.substring(0, i) : kv;
                    String v = i != -1 ? kv.substring(i + 1) : "";
                    boolean booleanValue = v.isEmpty() || "true".equals(v) || "enabled".equals(v);
                    switch (k) {
                        case "timeout": {
                            this.timeout = Long.parseLong(v);
                            continue block15;
                        }
                        case "java.default_fetch_mode": 
                        case "java.defaultFetchMode": {
                            this.defaultFetchMode = Result.FetchMode.fromString(v);
                            continue block15;
                        }
                        case "java.unwrap_lists": 
                        case "java.unwrapLists": {
                            this.unwrapLists = booleanValue;
                            continue block15;
                        }
                        case "java.persistent_threads": 
                        case "java.persistentThreads": {
                            this.persistentThreads = booleanValue;
                            continue block15;
                        }
                        default: {
                            LOGGER.debug("Invalid query parameter '{}', skipping", (Object)k);
                        }
                    }
                }
            }
        }

        @Deprecated
        @NotNull
        public Builder copyOf() {
            return new Builder(this);
        }

        public Builder(@NotNull Builder b) {
            this.hostname = b.hostname;
            this.port = b.port;
            this.user = b.user;
            this.password = b.password;
            this.dbname = b.dbname;
            this.timeout = b.timeout;
            this.sslContext = b.sslContext;
            this.socketFactory = b.socketFactory;
            this.pumpFactory = b.pumpFactory;
            this.unwrapLists = b.unwrapLists;
            this.defaultFetchMode = b.defaultFetchMode;
            this.persistentThreads = b.persistentThreads;
        }

        @NotNull
        public Builder hostname(@Nullable String hostname) {
            this.hostname = hostname;
            return this;
        }

        @NotNull
        public Builder port(@Nullable Integer port) {
            this.port = port;
            return this;
        }

        @NotNull
        public Builder user(@Nullable String user) {
            this.user = user;
            return this;
        }

        @NotNull
        public Builder user(@Nullable String user, @Nullable String password) {
            this.user = user;
            this.password = password;
            return this;
        }

        @NotNull
        public Builder db(@Nullable String dbname) {
            this.dbname = dbname;
            return this;
        }

        @NotNull
        public Builder timeout(@Nullable Long timeout) {
            this.timeout = timeout;
            return this;
        }

        @Deprecated
        @NotNull
        public Builder authKey(@Nullable String authKey) {
            return this.user(null, authKey);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @NotNull
        public Builder certFile(@NotNull Callable<InputStream> source) {
            try (InputStream stream = source.call();){
                Builder builder = this.sslContext(Internals.readCertFile(stream));
                return builder;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @NotNull
        public Builder certFile(@NotNull InputStream source) {
            return this.certFile(() -> source);
        }

        @NotNull
        public Builder certFile(@NotNull File file) {
            return this.certFile(() -> new FileInputStream(file));
        }

        @NotNull
        public Builder sslContext(@Nullable SSLContext sslContext) {
            this.sslContext = sslContext;
            return this;
        }

        @NotNull
        public Builder socketFactory(@Nullable ConnectionSocket.Factory socketFactory) {
            this.socketFactory = socketFactory;
            return this;
        }

        @NotNull
        public Builder pumpFactory(@Nullable ResponsePump.Factory pumpFactory) {
            this.pumpFactory = pumpFactory;
            return this;
        }

        @NotNull
        public Builder defaultFetchMode(@Nullable Result.FetchMode defaultFetchMode) {
            this.defaultFetchMode = defaultFetchMode;
            return this;
        }

        @NotNull
        public Builder unwrapLists(boolean enabled) {
            this.unwrapLists = enabled;
            return this;
        }

        @NotNull
        public Builder persistentThreads(boolean enabled) {
            this.persistentThreads = enabled;
            return this;
        }

        @NotNull
        public CompletableFuture<Connection> connectAsync() {
            return new Connection(this).connectAsync();
        }

        @NotNull
        public Connection connect() {
            return new Connection(this).connect();
        }

        @NotNull
        public URI dbUrl() {
            return URI.create(this.dbUrlString());
        }

        @NotNull
        public String dbUrlString() {
            StringBuilder b = new StringBuilder("rethinkdb://");
            if (this.user != null) {
                b.append(this.user);
                if (this.password != null) {
                    b.append(':').append(this.password);
                }
                b.append('@');
            }
            b.append(this.hostname != null ? this.hostname : "127.0.0.1");
            if (this.port != null) {
                b.append(':').append(this.port);
            }
            if (this.dbname != null) {
                b.append('/').append(this.dbname);
            }
            boolean first = true;
            if (this.timeout != null) {
                b.append('?');
                first = false;
                b.append("timeout=").append(this.timeout);
            }
            if (this.defaultFetchMode != null) {
                b.append(first ? Character.valueOf('?') : "&");
                first = false;
                b.append("java.default_fetch_mode=").append(this.defaultFetchMode.name().toLowerCase());
            }
            if (this.unwrapLists) {
                b.append(first ? Character.valueOf('?') : "&");
                first = false;
                b.append("java.unwrap_lists=true");
            }
            if (this.persistentThreads) {
                b.append(first ? Character.valueOf('?') : "&");
                first = false;
                b.append("java.persistent_threads=true");
            }
            return b.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Builder builder = (Builder)o;
            return Objects.equals(this.hostname, builder.hostname) && Objects.equals(this.port, builder.port) && Objects.equals(this.user, builder.user) && Objects.equals(this.password, builder.password) && Objects.equals(this.dbname, builder.dbname) && Objects.equals(this.timeout, builder.timeout) && Objects.equals(this.sslContext, builder.sslContext) && Objects.equals(this.socketFactory, builder.socketFactory) && Objects.equals(this.pumpFactory, builder.pumpFactory) && Objects.equals((Object)this.defaultFetchMode, (Object)builder.defaultFetchMode) && this.unwrapLists == builder.unwrapLists && this.persistentThreads == builder.persistentThreads;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.hostname, this.port, this.user, this.password, this.dbname, this.timeout, this.sslContext, this.socketFactory, this.pumpFactory, this.defaultFetchMode, this.unwrapLists, this.persistentThreads});
        }

        public String toString() {
            return "Builder{" + this.dbUrlString() + '}';
        }
    }
}

